<?php
class order extends FE_Controller {
	function __Construct() {
        parent::__construct();
		$this->load->model('order_model');
		$this->load->model('goods_model');
    }
	public function index()
	{
	$rules = $this->order_model->rules;
		$this->form_validation->set_rules($rules);
	
		if ($this->form_validation->run() == TRUE) {
			
			$data = $this->order_model->array_from_post(array('email','count','type','fund','coupon'));
			$item = $this->goods_model->get($data['type']);
			
			//Проверка ID товара
			if(!count($item)){
				$resp['error'] =  'Такого товара не существует!';
				echo json_encode($resp);
				return false;
			}
			
			//Проверка кол-ва товара, если товар - файл, то не проверяем!
			if($item->sell_method == 0)
			{
				$filename = preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$item->name));
				$uppath = './assets/uploads/'.preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$filename.$item->name)).'/';
				$encdata = file($uppath.$filename);
				if(empty($encdata)) 
				{
					$item->count = '0';
				}
				else
				{
					$item->count = count($encdata);
					$item->goods = "";
				}
				if($item->count < $data['count'])
				{
					$resp['error'] =  'Такого количества товара нет!';
					echo json_encode($resp);
					return false;
				}
				if($item->min_order > $data['count'])
				{
					$resp['error'] = 'Мин. кол-во для заказа: '.$item->min_order;
					echo json_encode($resp);
					return false;
				}
			}
			elseif($item->sell_method == 1)
			{
				$item->count = 'Файл';
				$data['count'] = 'Файл';
				$item->goods = "";
			}

			//Проверка метода оплаты
			if($data['fund'] == 1){
				$pay = 'PC';
				$fund = $this->config->item('yad_wallet');
				if($item->sell_method == 0 or $item->sell_method == 2){
				$pricet = ($data['count']) * $item->price_rub;
			    $price = $pricet+($pricet*(0.5/100));
				}else{
				$pricet = $item->price_rub;
			    $price = $pricet+($pricet*(0.5/100));
				}
			}elseif($data['fund'] == 2){
				$pay = 'AC';
				$fund = $this->config->item('yad_wallet');
				if($item->sell_method == 0 or $item->sell_method == 2){
				$pricet = ($data['count']) * $item->price_rub;
			    $price = $pricet+($pricet*(2/100));
				}else{
				$pricet = $item->price_rub;
			    $price = $pricet+($pricet*(2/100));
				}
			}elseif($data['fund'] == 3){
				$pay = 'QIWI_RUB';
				$fund = $this->config->item('qiwi_num');
				if($item->sell_method == 0 or $item->sell_method == 2)
				$price = $data['count'] * $item->price_rub;
				else
				$price = $item->price_rub;
			}elseif($data['fund'] == 4){
				$pay = 'QIWI_USD';
				$fund = $this->config->item('qiwi_num');
				if($item->sell_method == 0 or $item->sell_method == 2)
				$price = ($data['count']) * $item->price_dlr;
				else
				$price = $item->price_dlr;
			}else{
				echo 'Выбран неверный метод оплаты!';
				return false;
			}
			$rand = random_string('alnum',15);
			if($data['fund'] == 3 or $data['fund'] == 4){
			$this->load->helper('qiwi_helper');
			$degit = check_qiwi();
			if($degit == true){}else{
			echo 'Выбран неверный метод оплаты!';
			return false;	
			 }
			}
			//Купон
			$coupon = $data['coupon'];
			//Проверяем длину купона
			if(strlen($coupon) == 10) {
				//Проверяем существование купона
				$cpnquery = $this->db->query("SELECT * FROM coupons WHERE coupon LIKE ".$this->db->escape('%'.$coupon.'%'));
				$row = $cpnquery->row();

				$cpngoods = explode(',', $row->goods);
				//Проверяем купон-товар
				if(!in_array($item->id, $cpngoods)) {
					$resp['error'] =  'Неверный промо-код!';
					echo json_encode($resp);
					return false;
				}
				//Проверяем дату
				$curdate = time();
				$timeto = $row->timeto;
				$timefrom = $row->timefrom;
				if($curdate > $timeto || $curdate < $timefrom) {
					$resp['error'] =  'Неверный промо-код!';
					echo json_encode($resp);
					return false;
				}
				//Проверяем кол-во использований
				if($row->mayused == 0) {
					$cpnused = $this->db->query("SELECT * FROM used_coupons WHERE coupon LIKE ".$this->db->escape('%'.$coupon.'%'))->num_rows();
					if($cpnused > 0) {
						$resp['error'] =  'Неверный промо-код!';
						echo json_encode($resp);
						return false;
					}
				}
				//Пересчитываем цену
				$price = $price-($price*$row->percent/100);
				$price = number_format($price, 2, '.', '');
				$this->db->query("INSERT INTO used_coupons VALUES(NULL,$row->id,".$this->db->escape($coupon).")");
			} elseif(strlen($coupon) > 0 && strlen($coupon) != 10) {
				$resp['error'] =  'Неверный промо-код!';
				echo json_encode($resp);
				return false;
			}
			$price = number_format($price, 2, '.', '');
			//Если все данные верные, то собираем запрос к БД
			$order['bill'] = 'FEE['.$rand.']';
			$order['name'] = $item->name;
			$order['email'] = $data['email'];
			$order['date'] = microtime(true);
			$order['item_id'] = $item->id; 
			$order['count'] = $data['count']; 
			$order['price'] = $price;
			$order['session_key'] = $this->session->userdata('session_id');
			$order['ip_address'] = $this->session->userdata('ip_address');
			$order['fund'] = $pay;
			$order['redeemed'] = FALSE;
			$order['paid'] = FALSE;
			$this->order_model->save($order);
			$rat['id'] = $this->db->insert_id();
			$inv['bill'] = 'FEE'.$rat['id'];
			$this->order_model->save($inv, $rat['id']);

			if($pay == 'PC' or $pay == 'AC'){
			session_start();
			$_SESSION['id'] = $rat['id'];
			$_SESSION['check_url'] = site_url('/order/'.$rat['id']);
			$form['ok'] = 'TRUE';
			$form['yad'] = 'TRUE';
            $form['url'] = "https://money.yandex.ru/quickpay/confirm.xml?receiver=$fund&quickpay-form=shop&is-inner-form=true&targets=".$inv['bill']."&sum=$price&paymentType=$pay&label=".$rat['id']."&successURL=http://".$_SERVER['HTTP_HOST']."/check";		
            $_SESSION['op'] = $form['url'];			
			}else{
			if($pay == 'QIWI_RUB'){ $pay = 'RUB'; }elseif($pay == 'QIWI_USD'){$pay = 'USD';}	
			$form['ok'] = 'TRUE';
			$form['yad'] = 'FALSE';
			$form['bill'] = $inv['bill'];
			$form['name'] = $item->name;
			$form['count'] = $data['count']; 
			$form['pay'] = $pay; 
			$form['price'] = $price;
			$form['fund'] = $fund;
			$form['check_url'] = site_url('/order/'.$rat['id']);
			}
			echo json_encode($form);
		}
		else {
			$res['error'] = validation_errors('<div>', '</div>');
			print_r($res);
		}			
	}
	
	public function checkpay() {
		    $bill = $this->uri->segment(2);	
			$resp['status'] = 'false';
			$retname = $bill.'.txt';
			$savebill = $bill;
			$bill = 'FEE'.$bill;
			$order = $this->order_model->get_by(array('bill' => $bill),TRUE);
			if(count($order)) {
				$item = $this->goods_model->get($order->item_id);
				if(count($item)) {
					$this->load->helper('qiwi_helper');
					$this->load->helper('download');
					
					
					
					$mailview['sitename'] = $this->config->item('site_name');
					$mailview['siteurl'] = site_url();
					$mailview['savebill'] = $savebill;
					$mailview['name'] = $item->name;
					
					if($order->count == 0)
						$mailview['count'] = 'Файл';
					else
						$mailview['count'] = $order->count;
					$mailview['paytype'] = $order->fund;
					$mailview['price'] = $order->price;
 					$mailtemp = $this->load->view('mail',$mailview,true);

					
					if($order->paid == FALSE) {
                        if($order->fund == "QIWI_RUB"){
							$price = $order->price;
							$chkpay = qiwi_pay($bill,$price, '1');
						}elseif($order->fund == "QIWI_USD"){
							$price = $order->price;
							$chkpay = qiwi_pay($bill,$price, '2');
						}
						if($chkpay == TRUE) 
						{	
							if($item->sell_method == 0)
							{
								$count = $order->count;
								$filename = preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$item->name));
								$uppath = './assets/uploads/'.preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$filename.$item->name)).'/';
								$goods = file($uppath.$filename,FILE_IGNORE_NEW_LINES);
								$paidgoods = implode("\r\n",array_splice($goods, 0, $count));
								$goods = implode("\r\n",$goods);
								$smbill = md5(config_item('encryption_key').$savebill).'.txt';
								file_put_contents($uppath.$filename,$goods);
								file_put_contents('./assets/uploads/orders/'.$smbill,$paidgoods);
								$saveord['goods'] = $smbill;
							}
							elseif($item->sell_method == 1) 
							{
								$uppath = './assets/uploads/'.preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$item->goods.$item->name)).'/'.$item->goods;
								$retname = $item->goods;
								$paidgoods = file_get_contents($uppath);
							}
							$saveord['paid'] = TRUE;
							$this->order_model->save($saveord,$order->id);
							///mail
							$from = parse_url(site_url());
							$from = 'notify@'.$from['host'];
							$this->load->library('email');
							$this->email->from($from, 'notify');
							$this->email->to($order->email);  
							$this->email->subject('Покупка на сайте '.$this->config->item('site_name'));
							$this->email->message($mailtemp);	
							$this->email->send();
							
							if (!$this->input->is_ajax_request()) {
								force_download($retname, $paidgoods);
							}
							$resp['status'] = 'ok';
							$resp['chkurl'] = site_url('order/'.$savebill);
						}
						else {
							$resp['status'] = 'false';
						}
					}
					elseif($order->paid == TRUE)
					{
						if($item->sell_method == 0)
						{
							$smbill = md5(config_item('encryption_key').$savebill).'.txt';
							$uppath = './assets/uploads/orders/';
							
							if (!$this->input->is_ajax_request()) {
								force_download($savebill.'.txt', file_get_contents($uppath.$smbill));
							}
						}
						elseif($item->sell_method == 1) 
						{
							$uppath = './assets/uploads/'.preg_replace('/[^\p{L}\p{N}\s]/u','', md5(config_item('encryption_key').$item->goods.$item->name)).'/'.$item->goods;
							if (!$this->input->is_ajax_request()) {
								force_download($item->goods, file_get_contents($uppath));
							}
						}						
						$resp['status'] = 'ok';
						$resp['chkurl'] = site_url('order/'.$savebill);
					}
					else
					{
						$resp['status'] = 'false';
					}
					
				}
				echo json_encode($resp);
			
			}
	}
		
}
	
?>