function countdownAnimate(markElId, minutes, millis, btnElId, classActive) {
    var mark, btn, endTime;

    mark = document.getElementById( markElId );
    btn = btnElId != null ? document.getElementById( btnElId ) : null;
    endTime = (+new Date) + (1000 * (60 * minutes) + millis + 100);

    updateTimer(btn, mark, endTime, classActive);
}

function updateTimer(btn, mark, endTime, classActive) {
    var msLeft = endTime - (+new Date);

    if ( msLeft < 1000 ) {
        mark.style.display = "none";

        if (btn != null && classActive != null) {
            btn.className = classActive;
        }

        if (msLeft > 0) {
            setTimeout( function (i) {
                updateTimer(btn, mark, endTime, classActive);
            }, 500 );
        }
    } else {
        var time = new Date( msLeft );
        var hours = time.getUTCHours();
        var mins = time.getUTCMinutes();

        mark.innerHTML = (hours ? (hours + 'ч.' + twoDigits( mins )) : mins) + ':' + twoDigits( time.getUTCSeconds() );

        setTimeout( function(i) {
            updateTimer(btn, mark, endTime, classActive);
        }, time.getUTCMilliseconds() + 500 );
    }
}

function twoDigits( n ) {
    return (n <= 9 ? "0" + n : n);
}
