<?php

/*
---------------------------------------------
Подгрузка функций из папки /system/functions/
---------------------------------------------
*/

$dir_func_data = OPENDIR(ROOT.'/system/functions');

WHILE ($dir_func = READDIR($dir_func_data))
{
  
  IF (PREG_MATCH('#\.php$#i',$dir_func))
  {
    
    INCLUDE_ONCE(ROOT.'/system/functions/'.$dir_func);
  
  }

}

/*
------------------------
Автозагрузка PHP классов
------------------------
*/

SPL_AUTOLOAD_REGISTER(FUNCTION($class_name) {
  
  IF (IS_FILE(ROOT.'/system/PHP-classes/'.$class_name.'.class.php')){
    
    INCLUDE (ROOT.'/system/PHP-classes/'.$class_name.'.class.php');
    
  }

});

/*
--------------------
Текущая версия сайта
--------------------
*/

$device_type = DEVICE_TYPE();

//Версия Touch
IF ($device_type){
  
  //Версия Touch
  
  $them_prioritet_touch = DB::GET_STRING("SELECT `DIR` FROM `PANEL_THEMES` WHERE `PRIORITET_TOUCH` = '1' AND `ACT` >= '1' LIMIT 1");
  
  IF (ISSET($them_prioritet_touch['DIR'])){
    
    DEFINE('SET_VERSION', $them_prioritet_touch['DIR']);
    
  }ELSE{
    
    DEFINE('SET_VERSION', 'touch');
    
  }

//Версия WEB
}ELSE{
  
  $them_prioritet_web = DB::GET_STRING("SELECT `DIR` FROM `PANEL_THEMES` WHERE `PRIORITET_WEB` = '1' AND `ACT` >= '1' LIMIT 1");

  IF (ISSET($them_prioritet_web['DIR'])){
    
    DEFINE('SET_VERSION', $them_prioritet_web['DIR']);
    
  }ELSE{
    
    DEFINE('SET_VERSION', 'web');
    
  }

}

$them_cookie = CLEARSPECIALCHARS(COOKIE('VERSION'));

IF (IS_DIR(ROOT.'/style/version/'.$them_cookie.'/') && DB::GET_COLUMN("SELECT COUNT(`DIR`) FROM `PANEL_THEMES` WHERE `DIR` = '".$them_cookie."' AND `ACT` >= '1' LIMIT 1") == 1){
  
  DEFINE('VERSION', $them_cookie);
 
}ELSE{
  
  DEFINE('VERSION', SET_VERSION);

}

/*
-------------------------------
Функция текущего языка на сайте
-------------------------------
*/

REQUIRE (ROOT.'/system/languages/lg.php');

/*
-----------
Вывод капчи
-----------
*/

REQUIRE (ROOT.'/system/connections/captcha.php');

?>