<?php

/*
-------------------------------
Константы и псевдофункции для 
сокращения переменных и функций
-------------------------------
*/
  
//Путь к корневой директории сервера
DEFINE('ROOT', ''.$_SERVER['DOCUMENT_ROOT'].'');

//Время
DEFINE('TIME', ''.TIME().'');

//Имя файла, к которому выполняется обращение
DEFINE('PHP_SELF', ''.$_SERVER['PHP_SELF'].'');

//Домен сайта
DEFINE('HTTP_HOST', ''.$_SERVER['HTTP_HOST'].'');

//Браузер пользователя
DEFINE('USER_BROWSER', ''.$_SERVER["HTTP_USER_AGENT"].'');

//IP пользователя
DEFINE('IP', ''.$_SERVER["REMOTE_ADDR"].'');

//Опознавание AJAX запроса
DEFINE('HTTP_X_REQUESTED_WITH', ''.$_SERVER['HTTP_X_REQUESTED_WITH'].'');

//Определение протокола
IF (ISSET($_SERVER['HTTPS'])){
  
  DEFINE('SCHEME', 'https://');
  $scheme = $_SERVER['HTTPS'];
  
}ELSE{
  
  $scheme = NULL;
  
  IF (($scheme) && ($scheme != 'off')){
    
    DEFINE('SCHEME', 'https://');
    
  }ELSE{ 
    
    DEFINE('SCHEME', 'http://');
        
  }
  
}

//Полный URL адрес запрашиваемой страницы
IF (ISSET($_SERVER["REQUEST_URI"])){ //Не всегда стабилен
  
  DEFINE('REQUEST_URI', ''.$_SERVER["REQUEST_URI"].'');

}ELSE{
  
  DEFINE('REQUEST_URI', '/index');
  
}

//Переменная GET
FUNCTION GET($data){
  
  IF (!ISSET($_GET[$data])){
    
    RETURN ISSET($_GET[$data]);
    
  }ELSE{
    
    $result = $_GET[$data];
    
    $dir_data = OPENDIR(ROOT.'/system/connections/method/get/');
    
    WHILE ($file = READDIR($dir_data)){
      
      IF (PREG_MATCH('#\.php$#i', $file)){
        
        INCLUDE_ONCE(ROOT.'/system/connections/method/get/'.$file);
      
      }
    
    }
    
    RETURN $result;
    
  }
  
}

//Переменная POST
FUNCTION POST($data){
  
  IF (!ISSET($_POST[$data])){
    
    RETURN ISSET($_POST[$data]);
    
  }ELSE{
    
    $result = $_POST[$data];
    
    $dir_data = OPENDIR(ROOT.'/system/connections/method/post/');
    
    WHILE ($file = READDIR($dir_data)){
      
      IF (PREG_MATCH('#\.php$#i', $file)){
        
        INCLUDE_ONCE(ROOT.'/system/connections/method/post/'.$file);
      
      }
    
    }
    
    RETURN $result;
    
  }
  
}

//Переменная COOKIE
FUNCTION COOKIE($data){
  
  IF (!ISSET($_COOKIE[$data])){
    
    RETURN ISSET($_COOKIE[$data]);
    
  }ELSE{
    
    RETURN $_COOKIE[$data];
    
  }
  
}

//Параметры настроек
FUNCTION CONFIG($data, $param = NULL){
  
  GLOBAL $config;
  
  IF ($param == NULL){
    
    RETURN $config[$data];
    
  }ELSE{
    
    RETURN $config[$data] = $param; 
  
  }
  
}

//Определение версии сайта
FUNCTION DEVICE_TYPE() { 
  
  $mobile_agent_array = ARRAY('ipad', 'iphone', 'android', 'pocket', 'palm', 'windows ce', 'windowsce', 'cellphone', 'opera mobi', 'ipod', 'small', 'sharp', 'sonyericsson', 'symbian', 'opera mini', 'nokia', 'htc_', 'samsung', 'motorola', 'smartphone', 'blackberry', 'playstation portable', 'tablet browser');
  
  $agent = STRTOLOWER(USER_BROWSER);    
  
  FOREACH ($mobile_agent_array AS $value) {    
    
    IF (STRPOS($agent, $value) !== FALSE){ RETURN TRUE; }   
  
  }       
  
  RETURN FALSE; 

}
  
?>