
var appPhotosViewer = (function(){  
    var inited = false, $popup, $w = $(window), e = {}, o = {}, itemID = 0;
    var pData = {}, pIndex = 0, pCurrent, pCurPhoto, pShown = false;
    var pTimer, pTimerPassed, pLastFrom, pLastDirection;
    function init(opts)
    {
        if(inited) return;
        inited = true;
        o = opts;
        itemID = o.item_id;
        
        $popup = $('body').append('<div class="photoGalleryView displaynone" id="item_photoview_popup">\
            <div class="container">\
                <div class="content">\
                    <div class="topcontrols"><h3 id="item_photoview_itemtitle">' + (o.title) + '</h3><div class="close"><span>х</span> <a class="close" rel="close" href="javascript:void(0);">закрыть</a></div></div>\
                    <div class="photo pointer" id="item_photoview_photo" onclick="return appPhotosViewer.next();"><img src="'+app.root+'/img/progressBig.gif" style="padding-top: 250px;" /></div>\
                    <div class="photodescr">\
                        <div class="title left">\
                            <div id="item_photoview_comment"></div>\
                            <span class="f11 grey"><span id="item_photoview_created"></span><br /></span>\
                        </div>\
                        <div class="info right f11">\
                            <span class="left f11 grey">Фотография <span id="item_photoview_counter">1 из 1</span></span>\
                            <div class="sidecontrols right">\
                                <div class="prev" id="item_photoview_prev"><a href="javascript:void(0);" onclick="return appPhotosViewer.prev();"></a></div>\
                                <div class="next" id="item_photoview_next"><a href="javascript:void(0);" onclick="return appPhotosViewer.next();"></a></div>\
                            </div>\
                            <div class="clear margBot6"></div>\
                            <span id="item_photoview_acts"></span>\
                        </div>\
                        <div class="clear"></div>\
                    </div>\
                </div>\
            </div>\
        </div>').find('#item_photoview_popup');
        
        $.each(['itemtitle', 'photo', 'comment', 'created', 'counter', 'prev', 'next', 'acts'], function(i,key){
            e[key] = $('#item_photoview_'+key, $popup);
        });
                 
        $('a.close', $popup).click(function(){
            hide();
        });
    }
    
    function newImg() { return window.Image ? (new Image()) : document.createElement('img'); /* ie8 bug */ }
    
    function view(photoID)
    {
        if(showPhoto(photoID) === false) 
        {
            bff.ajax(document.location, {act: 'photo_view', item_id: itemID, photo_id: photoID}, function(data){
                if(data && data.res) {          
                    loaded(intval(data.total), intval(data.offset), data.photos);
                    showPhoto(photoID);
                }
            });
        }
        
        return false;
    }

    function loaded(total, offset, data)
    {
        if (!pData[itemID]) {
          pData[itemID] = new Array( total );
        } else if (pData[itemID].length < total) {
          for (var i = pData[itemID].length; i < total; ++i) {
            pData[itemID].push(undefined);
          }
        } else if (pData[itemID].length > total) {
          pData[itemID] = pData[itemID].slice(0, total);
        }
        for (var i = 0, len = data.length; i < len; ++i) {
          pData[itemID][data[i].i] = data[i];
        }
    }
    
    function preload(from, direction)
    {
        var total = (pData[itemID] || {}).length;
        if (!total) return;

        pLastFrom = from;
        pLastDirection = direction;

          var index = from + 3 * direction, key = 'x';
          while (index >= total) index -= total;
          while (index < 0) index += total;

          do
          {
              var p = pData[itemID][index];
              if (!p || !p.id) {
                if (!p || ((+new Date) - p > 3000)) 
                {
                    pData[itemID][index] = (+new Date);
                    setTimeout(function() {
                        bff.ajax(document.location, {act: 'photo_view', item_id: itemID, offset: index, dir: direction}, function(data){
                            if(data && data.res) {
                                loaded(intval(data.total), intval(data.offset), data.photos);
                            }
                        });
                    }, 10);
                }
                break;
              }
              
          } while(false);
    }
    
    function showPhoto(photoID)
    {
        if(!pData[itemID]) return false;
        var data = pData[itemID];
        for(var i = 0, len = data.length; i < len; ++i) {
          if(data[i] && data[i].id == photoID) {
              show(i); return true;
            }
        } return false;
    }
    
    function show(index)
    {
        var total = (pData[itemID] || {}).length;
        if(!total) return;
        
        var direction = (pIndex > index ? -1 : 1);
        index += (index < 0 ? total : (index >= total ? (-total) : 0));
        
        var ph = pData[itemID][index]; if(!ph) return;

        pIndex = index;
        pShown = true;

        delete pCurrent;
        pCurrent = newImg();
        pCurrent.onload = function(){ preload(index, direction); }
        pCurrent.src = ph.src;

        e.counter.html(  (total > 1 ? (pIndex + 1) +' из '+ total : '1 из 1' ) );
        
        pTimerPassed = 0;
        clearTimeout(pTimer);
        pCurPhoto = ph;
        pTimer = setTimeout(doShow, 0);
        
        app.busylayer().unbind().bind('click', function(e){
            if($popup.is(':visible')) {  
                 nothing(e);
                 hide();
            }                   
        });

        //escape-hide
        $(document).unbind().keydown(function(e) {
            if (e.keyCode == 27 && $popup.is(':visible')) { 
                nothing(e);
                hide();
            }
        }); 
    }
    
    function doShow()
    {
        var img = pCurrent;
        if ((!img.width || !img.height) && pTimerPassed < 5000) {
          clearTimeout(pTimer);
          pTimerPassed += 100;
          pTimer = setTimeout(doShow, 100);
          return;
        }
        if (!pShown) return;

        var ph = pCurPhoto;
        
        /*
            <!-- Максимальная высота 550px -->
            <!-- Максимальная ширина 862px -> 822px -->
            <!--style="padding-top: (550-высота)/2 px;" -->
        */
        e.photo.html( '<img style="width: ' + img.width + 'px; height: ' + img.height + 'px; padding-top: ' + ((550 - img.height)/2) + 'px;" src="' + img.src + '" />' );
        e.comment.html( ph.comment );
        e.created.html( ph.created );
        e.acts.html( '' );

        $popup.css({top: 35, left: ($w.width()/2-$popup.width()/2) }) 
              .fadeIn(450, function(){  });
    }    
    
    function hide()
    {
        if (!pShown) return;
        setTimeout(doHide, 0);
    }
    
    function doHide()
    {
        // remove preloaded
        var total = (pData[itemID] || {}).length;
        if (pLastDirection && total) {
          pLastDirection = pLastFrom = false;
        }
        
        pShown = false;
    
        $popup.fadeOut('fast', function(){ 
            app.busylayer(true).unbind();
            e.photo.html( '<img src="'+app.root+'/img/progressBig.gif" style="padding-top: 250px;" />' );
        });
    }
    
    function add()
    {
        return false;        
    }
    
    return {init: init, view: view, add: add, 
        next: function(){ show( pIndex+1 ); return false; },
        prev: function(){ show( pIndex-1 ); return false; }};
}());
