
var bffCalendar = (function()
{ 
    var e = new Array(0), e_loaded = {}, o = {}, building = false;
    var date_today, date_selected = 0, c_y, c_m, c_d;
    var mdays = new Array(0,31, 28, 31, 30, 31, 30,  31, 31, 30, 31, 30, 31);
    var months = new Array(0,'январь','февраль','март','апрель','май','июнь','июль','август','сентябрь','октябрь','ноябрь','декабрь');
    var mevents = {};
    var $block, $prev, $next, $title;
    
    function init( block, selectedDate, events, options )
    {   
        $block = $(block);
        if(!$block.length) return false;

        o = options; 
        e = events || [0];
        $prev = $('.control .l', $block).click(function(){ navigate(-1); return false; });
        $next = $('.control .r', $block).click(function(){ navigate(1); return false; });
        $days = $('.days', $block);
        $title = $('.title', $block);
                        
        var today = new Date();
        c_y = today.getFullYear();
        c_m = today.getMonth() + 1;
        c_d = today.getDate();
        date_today = d(c_y, c_m, c_d);
        if (selectedDate!=0 && (selectedDate instanceof Date)) {     
            c_y = selectedDate.getFullYear();
            c_m = selectedDate.getMonth() + 1;
            c_d = selectedDate.getDate();
            date_selected = d(c_y, c_m, c_d);
            eLoaded(c_y, c_m, true);
        } else {
            eLoaded(c_y, c_m, true);
            today.setMonth(c_m); eLoaded(today.getFullYear(), today.getMonth() + 1, true);
            today.setMonth(c_m-2); eLoaded(today.getFullYear(), today.getMonth() + 1, true);
        }
        build();
    }

    function eLoaded(y, m, loaded)
    {
        var key = y+'-'+m;
        return ( !loaded ? (e_loaded[key] === true) : (e_loaded[key] = true) );
    }
    
    function navigate(dir)
    {
        if(building) return;
        building = true;
        
        if(dir==-1) { c_m--; if(!c_m) { c_m = 12; c_y--; } } 
        else { c_m++; if(c_m>12) { c_m = 1; c_y++; } }

        if(!eLoaded(c_y, c_m)) {
            bff.ajax(o.url_ajax, {date: c_y+'-'+(c_m<10?'0'+c_m:c_m)+'-01', dir: dir}, function(data){
                if(data && data.res) {
                    if(data.events && data.events.length) {
                        for(var i in data.events) {
                            var ev = intval(data.events[i]);
                            if(ev>0) e.push( ev );
                        }
                    }
                    eLoaded(c_y, c_m, true);
                }
                build();    
            }, function(show){
                if(show) $block.addClass('disabled');
                else  $block.removeClass('disabled');
            });
        } else {
            build();
        }
    }
    
    function d(year,month,day)
    {
        return day + month * 100 + year * 10000;
    }
            
    function build()
    {   
        var cs = -(new Date(c_y,c_m-1,1)).getDay() + 2; if(cs>1) cs-=7; 
        var totalDays = mdays[c_m]; if(c_y%4 == 0 && c_m == 2) totalDays = 29; //feb.
        var date_part = d(c_y, c_m, 0);
        var date_part_url = c_y + '-' + (c_m < 10 ? '0' + c_m : c_m) + '-';
        var daysLines = new Array(), line = '';
        
        for(var i=cs; i<=totalDays; i+=7) 
        {
            for(var day=i; day<i+7; day++)
            {
                var date_this = day + date_part, d_link = '', a = false; 
                if(day<1 || day>totalDays) {
                   d_link = '&nbsp;';
                } else {
                    if( $.inArray(date_this, e)!=-1 ) { //has event
                        if(date_this != date_selected) {
                            d_link = '<a href="' + o.url_date + date_part_url + (day < 10 ? '0' + day : day) + '/">' + day + '</a>';
                        } else {
                            d_link = day; a = true;
                        }
                    } else {
                        d_link = day;
                    }
                }
                line += '<td class="'+(day>i+4?'ends':'')+(date_this == date_today?' active':'')+'"><span'+(a?' class="red"':'')+'>'+d_link+'</span></td>';
            }    
            daysLines.push(line); line = '';
        }   
        
        $days.html( '<tr>' + daysLines.join('</tr><tr>') + '</tr>' );
        $title.text( months[c_m]+ ' '+c_y );
        building = false;
    }
    
    return {init: init};
}());