<?php

/**
 * Права доступа группы:
 *  - voting: Голосование
 *      - manage: Управление голосованием
 */

class Voting extends VotingBase
{
    function listing()
    {
        if( ! $this->haveAccessTo('manage'))
            return $this->showAccessDenied();

        $sAction = $this->input->postget('act', TYPE_STR);
        if(Request::isAJAX()){
            switch ($sAction){
                case 'edit':
                {
                    $nVotingID = $this->input->get('id', TYPE_UINT);
                    if( ! $nVotingID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_VOTING.' WHERE id = '.$nVotingID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langFieldsSelect($aData, $this->model->langVoting);

                    $aData['answers'] = $this->db->select('SELECT * FROM '.TABLE_VOTING_ANSWERS.' WHERE voting_id = '.$nVotingID.' ORDER BY num');
                    foreach($aData['answers'] as $k => $v){
                        $this->db->langFieldsSelect($aData['answers'][$k], $this->model->langAnswers);
                    }

                    $aData['form'] = $this->viewPHP($aData, 'admin.form');
                                                                                                                                                       
                    $this->ajaxResponse( $aData ); 
                } break;
                case 'delete':
                {
                    $nVotingID = $this->input->get('id', TYPE_UINT);
                    if(!$nVotingID) $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    
                    $res = $this->db->exec('DELETE FROM '.TABLE_VOTING.' WHERE id = '.$nVotingID);
                    if($res) {
                        $this->db->exec('DELETE FROM '.TABLE_VOTING_ANSWERS.' WHERE voting_id = '.$nVotingID);
                        $this->db->exec('DELETE FROM '.TABLE_VOTING_VOTES.' WHERE voting_id = '.$nVotingID);
                        $this->ajaxResponse( Errors::SUCCESS );
                    } else {
                        $this->ajaxResponse( Errors::IMPOSSIBLE );
                    }
                } break;
                case 'add-finish':
                {
                    $aData = $this->votingProcessData();
                    
                    if($this->errors->no()) {
                        $aInsert = array(
                            'status'        => self::STATUS_NEW,
                            'title'         => $aData['title'],
                            'created'       => $this->db->now(),
                            'created_uid'   => User::id(),
                            'start'         => $aData['start'],
                            'finish'        => $aData['finish'],

                        );
                        $this->db->langFieldsModify($aInsert, $this->model->langVoting, $aInsert);

                        $nVotingID = $this->db->insert(TABLE_VOTING, $aInsert);
                        if($nVotingID) {
                            $this->votingProcessAnswers($nVotingID);
                        }
                    }
                    $this->ajaxResponseForm();
                } break;
                case 'edit-finish':
                {
                    $nVotingID = $this->input->post('id', TYPE_UINT);
                    if(!$nVotingID) $this->errors->unknownRecord();

                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_VOTING.' WHERE id = '.$nVotingID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();
                    
                    $aData = $this->votingProcessData();

                    if($this->errors->no()) 
                    {
                        if($aDataCur['status']!=$aData['status'])
                        {
                            switch ($aData['status'])
                            {
                                case self::STATUS_OPENED:
                                {
                                    $aData['opened'] = $this->db->now();
                                    $aData['opened_uid'] = User::id();
                                } break;
                                case self::STATUS_CLOSED:
                                {
                                    $aData['closed'] = $this->db->now();
                                    $aData['closed_uid'] = User::id();
                                } break;
                            }
                        }
                        $this->db->langFieldsModify($aData, $this->model->langVoting, $aData);
                        $this->db->update(TABLE_VOTING, $aData, array('id'=>$nVotingID));
                        $this->votingProcessAnswers($nVotingID);
                    }
                    $this->ajaxResponseForm();
                } break;
            }
        }

        $aData = array();
        $aData['answers'] = array();
        $aData['id'] = 0;
        $aData['votings'] = $this->db->select('SELECT *, title_'.LNG.' AS title FROM '.TABLE_VOTING.' ORDER BY created DESC');
        $aData['list'] = $this->viewPHP($aData, 'admin.listing.ajax');

        if(Request::isAJAX()){
            $this->ajaxResponseForm(array('list' => $aData['list']));
        }

        $aData += $this->votingProcessData();
        $aData['form'] = $this->viewPHP($aData, 'admin.form');
        return $this->viewPHP($aData, 'admin.listing');
    }
    
    /**
     * Обрабатываем параметры голосования
     */
    private function votingProcessData()
    {
        $aParams = array(              
            'status' => TYPE_UINT,   // статус
            'start'     => TYPE_NOTAGS, # начало голосования
            'finish'    => TYPE_NOTAGS, # конец голосования
        );
        $aData = $this->input->postm($aParams);
        $this->input->postm_lang($this->model->langVoting, $aData);

        if (Request::isPOST()){
            foreach ($aData['title'] as $k => $t){
                if ($t == '') {
                    $this->errors->set( _t('voting', 'Название указано некорректно ('.$k.')'));
                }
            }
            $aData['start']  = date('Y-m-d H:i:s', strtotime($aData['start']));
            $aData['finish'] = date('Y-m-d H:i:s', strtotime($aData['finish']));
        }

        return $aData;
    }
    
    private function votingProcessAnswers($nVotingID)
    {
        $aAnswers = $this->input->post('answers', TYPE_ARRAY);
        if( ! $nVotingID || empty($aAnswers)) return;

        $aMultiInsert = array();
        $sqlDelete = array();
        $num = 1;
        foreach($aAnswers as $v) 
        {
            $this->input->clean_array($v, array(
                'id'  => TYPE_UINT,   // id ответа, 0 - если новый
                'del' => TYPE_BOOL,   // удаляем?
            ));

            $aLocales = array_fill_keys($this->locale->getLanguages(), TYPE_STR);
            $this->input->clean_array($v['t'], $aLocales);

            if($v['id'] > 0)
            {
                if($v['del']) {
                    $sqlDelete[] = $v['id'];
                    continue;
                } else {
                    $aUpdate = array(
                        'title' => $v['t'],
                        'num' => $num,
                    );
                    $this->db->langFieldsModify($aUpdate, $this->model->langAnswers, $aUpdate);
                    $this->db->update(TABLE_VOTING_ANSWERS, $aUpdate, array('id' => $v['id']));
                }
            } else {
                $bSkip = true;
                foreach($v['t'] as $lngv){
                    if($lngv != '') $bSkip = false;
                }
                if($bSkip) continue;
                $aInsert = array('voting_id' => $nVotingID, 'title' => $v['t'], 'num' => $num);
                $this->db->langFieldsModify($aInsert, $this->model->langAnswers, $aInsert);
                $aMultiInsert[] = $aInsert;
            }
            $num++;
        }
        
        if( ! empty($aMultiInsert)) {
            $this->db->multiInsert(TABLE_VOTING_ANSWERS, $aMultiInsert);
        }
        if( ! empty($sqlDelete)) {
            $this->db->delete(TABLE_VOTING_ANSWERS, array('id'=>$sqlDelete));
            $this->db->delete(TABLE_VOTING_VOTES, array('voting_id' => $nVotingID, 'answer_id' => $sqlDelete));
        }
    }
}
