<?php

class UsersModel extends UsersModelBase
{
    public function init()
    {
        parent::init();

        $this->userSessionDataKeys = array('user_id as id', 'login',
            'password', 'password_salt', 'email', 'name', 'surname', 'phone',
            'avatar', 'sex', 'birthdate', 'activated', 'blocked', 'blocked_reason',
            'admin', 'member', 'last_login', 'city_id');

        $this->userStatCounters = array('internalmail_newmsg', 'narod',
            'items', 'items_requests',
            'realty', 'realty_fav',
            'auto', 'auto_fav',
            'job_vacancy', 'job_resume', 'job_fav',
            'bbs', 'bbs_fav',);
    }

    function getUsers($aCond, $aFields = '*', $sOrder = '', $mLimit = 0, $nOffset = 0)
    {
        if(is_array($aFields)) $aFields = join(', ', $aFields);
        return $this->ar(TABLE_USERS)->find($aCond, $aFields, $sOrder, $mLimit, $nOffset);
    }

    function getUsersCount($aCond)
    {
        return $this->ar(TABLE_USERS)->count($aCond);
    }

    function userData($nUserID, $aDataKeys = array(), $bEdit = false)
    {
        $aData = $this->userDataByFilter( array('user_id'=>$nUserID), $aDataKeys );
        if($bEdit) {
            $aData['phones'] = ( ! empty($aData['phones']) ? explode(';', $aData['phones']) : array() );
        }

        if( isset($aData['city_id']) ) {
            $aData['city_title'] = Geo::regionTitle($aData['city_id']);
        }
        return $aData;
    }

    function agentCompanies($nUserID)
    {
        return $this->db->select_key('
            SELECT I.id, IL.title
            FROM '.TABLE_ITEMS.' I,
                 '.TABLE_ITEMS_LANG.' IL
            WHERE I.agent_id = '.$nUserID.' AND I.moderated != 0 AND I.enabled = 1
                '.$this->db->langAnd(true, 'I','IL'), 'id');
    }

    function companyInfo($nUserID, $nCompanyID)
    {
        $aData = $this->db->one_array('
            SELECT I.id, I.agent_info, A.address as addr, A.city_id as city, I.link, IL.title, A.phones, A.emails
            FROM '.TABLE_ITEMS.' I, '.TABLE_ITEMS_LANG.' IL, '.TABLE_ITEMS_ADDR.' A
            WHERE I.id = :company_id
              AND I.id = A.item_id
              AND I.agent_id = :agent_id
              AND I.moderated!=0 '.$this->db->langAnd(true, 'I','IL'), array(
                ':company_id' => $nCompanyID,
                ':agent_id'   => $nUserID,
            ));
        if (empty($aData)) {
            return false;
        }
        if ( ! empty($aData['agent_info'])) {
            $aData = array_merge($aData, unserialize($aData['agent_info']));
        }
        unset($aData['agent_info']);

        if (empty($aData['email']) && ! empty($aData['emails'])) {
            $aEmails = unserialize($aData['emails']);
            if ( ! empty($aEmails)) {
                $aEmails = reset($aEmails);
                if ( ! empty($aEmails['v'])) {
                    $aData['email'] = $aEmails['v'];
                }
            }
        }
        unset($aData['emails']);

        if (empty($aData['phone']) && ! empty($aData['phones'])) {
            $aPhones = unserialize($aData['phones']);
            if ( ! empty($aPhones)) {
                $aPhones = reset($aPhones);
                if ( ! empty($aPhones['v'])) {
                    $aData['phone'] = $aPhones['v'];
                }
            }
        }
        unset($aData['phones']);

        return $aData;
    }

    function autocomplete($sQ)
    {
        # получаем список подходящих по логину пользователей, исключая:
        # - заблокированных пользователей
        $aData = $this->db->select('SELECT U.user_id, U.login, U.email FROM ' . TABLE_USERS . ' U
                                  WHERE ( U.login LIKE (:q) OR U.email LIKE (:q) OR U.user_id = :q ) AND U.blocked = 0
                                  ORDER BY U.login'.$this->db->prepareLimit(0,10), array(':q'=>$sQ.'%'));
        foreach($aData as $k => $v){
            $aData[$k]['title'] = '#'.$v['user_id'].' '.$v['login'].' ('.$v['email'].')';
        }
        return $aData;

    }

}