<?php

?>

<div class="h1-wrap">
    <h1><?= _t('users', 'Настройки'); ?></h1>
    <?= _t('users', 'Вы зарегистрированы на [title].', array('title' => config::sys('site.title'))); ?><br />
    <?= _t('users', 'Теперь вы можете заполнить личную информацию и в полном объеме пользоваться сервисами сайта.'); ?>
</div>                                                                               
<div class="form-box" id="user-settings-block">
   
        <div class="error" <? if($this->errors->no()){ ?>style="display: none;"<? } ?>><?= join('<br />', $this->errors->get(true)); ?></div>
        <br/>
        <table width="100%">        
        <tr>
            <td colspan="2"><h3><?= _t('users', 'Личная информация'); ?></h3></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Ваше фото'); ?></td>
            <td>

                <iframe name="user_settings_avatar_iframe" class="displaynone"></iframe>
                <form target="user_settings_avatar_iframe" action="/user/avatar_upload" method="post" enctype="multipart/form-data" id="user-settings-avatar-form">
                    <img width="50" height="50" src="<?= UsersAvatar::url($id, $avatar, UsersAvatar::szNormal, $sex) ?>" id="user-settings-avatar" align="left" style="margin-right: 15px;" />
                    <br />
                    <div class="upload-file left">
                        <div class="upload-btn alignCenter">
                            <span class="upload-mask" style="height: 41px;">
                                <input type="file" onchange="jUsersSettings.imgUploadStart(this, 'pub-item-img-selected');" name="avatar" />
                            </span>
                            <a href="#" onclick="nothing(event);"><?= _t('users', 'Изменить фотографию'); ?></a>
                            <div class="progress" style="display: none;" id="user-settings-avatar-progress"></div>
                            <div class="clear"></div>
                        </div>
                    </div>
                </form>
            </td>
        </tr>
        </table>
   <form method="post" id="user-settings-form">
        <input type="hidden" name="hash" value="<?= $this->security->getToken() ?>" />
        <table width="100%">
        <tr>
            <td class="td1"><?= _t('users', 'Логин'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="login" value="<?= $login ?>" maxlength="30" /><i></i></div></td>
        </tr>                                 
        <tr>
            <td class="td1"><?= _t('users', 'Имя'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="name" value="<?= $name ?>" maxlength="30" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Фамилия'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="surname" value="<?= $surname ?>" maxlength="30" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Дата рождения'); ?></td>
            <td>
                <select name="birthdate[day]" style="width: 55px;"><?= $bdate['days'] ?></select>
                <select name="birthdate[month]" style="width: 112px;"><?= $bdate['months'] ?></select>
                <select name="birthdate[year]" style="width: 75px;"><?= $bdate['years'] ?></select>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Ваш город'); ?></td>
            <td>
                <select class="inp-w3" name="city_id" onchange="jUsersSettings.onCity(this);"><?= $cities ?></select>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Кто вы?'); ?></td>
            <td><label><input type="radio" name="sex" value="<?= Users::SEX_MALE ?>" <? if($sex == Users::SEX_MALE){ ?>checked="checked"<? } ?> /> <?= _t('users', 'Мужчина'); ?></label>&nbsp;&nbsp;&nbsp;<label><input type="radio" name="sex" value="<?= Users::SEX_FEMALE ?>" <? if($sex == Users::SEX_FEMALE){ ?>checked="checked"<? } ?> /> <?= _t('users', 'Женщина'); ?></label></td>
        </tr>
        <tr>
            <td colspan="2">
            <br />
            <div class="separator"></div>
            <h3><?= _t('users', 'Контакты'); ?></h3></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Телефон'); ?></td>
            <td><div class="inp inp-w3"><input type="tel" name="phone" value="<?= $phone ?>" maxlength="50" /><i></i></div></td>
        </tr>        
        <tr>
            <td class="td1"><?= _t('users', 'ICQ'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="icq" value="<?= $icq ?>" maxlength="50" pattern="[0-9]*" /><i></i></div></td>
        </tr>        
        <tr>
            <td class="td1"><?= _t('users', 'Skype'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="skype" value="<?= $skype ?>" maxlength="50" /><i></i></div></td>
        </tr>        
        <tr>
            <td colspan="2">
            <br />
            <div class="separator"></div>
            </td>
        </tr>
        <tr>
            <td><h3><?= _t('users', 'Подписка и уведомления'); ?></h3></td>
            <td>
                <? foreach($enotify as $k=>$v){ ?>
                <label><input type="checkbox" name="enotify[]" value="<?= $k ?>" <? if($v['a']){ ?>checked="checked"<? } ?> /> <?= $v['title'] ?></label>
                <? } ?>
            </td>
        </tr>          
        <tr>
            <td></td>
            <td colspan="2">
                <div class="btn mr10 left"><input type="submit" class="submit" value="<?= _t('users', 'сохранить настройки'); ?>" /><i></i></div>
            </td>
        </tr>       
        </table>
    </form>
    <div class="separator"></div>       
</div>

<script type="text/javascript">
<? js::start(); ?>
var jUsersSettings = (function(){
    var $block = $('#user-settings-block'), process = false, $err = $('div.error', $block), $btn = $('.submit', $block), f = $('#user-settings-form', $block).get(0);
    var city_id = <?= intval($city_id) ?>;
    var img = {inited:false, processing:false}; 

    $(f).submit(function(){
        if(process) return false;
        app.fieldError([f.login, f.name], false);
        bff.ajax('/user/settings?start=1', $(f).serialize(), function(data, errors){
            if(data.success) {
                bff.redirect('/');
            } else {
                app.showError($err, errors, false, true);
                if(data.fields) app.fieldErrorForm(data.fields, f);
            }
        }, function(p){ process = p;
            if(p) $btn.val('<?= _t('', 'подождите...'); ?>');
            else $btn.val('<?= _t('users', 'сохранить настройки'); ?>');
        });
        return false; 
    });
    
    return {
        imgUploadStart: function(input)
        {                  
            if(img.processing) return false; 
            img.processing = true;
            if(!img.inited) { 
                document.domain = app.host;
                img.form = $('#user-settings-avatar-form', $block);
                img.avatar = $('#user-settings-avatar', $block);
                img.progress = $('#user-settings-avatar-progress', $block);
                img.inited = true;
            }
            img.progress.show();
            img.form.submit();
        },
        imgUploadFinish: function(success, data)
        {
            if(success) {
                img.avatar.attr('src', data.preview);
            } else {
                app.showError( $err, data.errors );
            }
            img.progress.hide();
            img.processing = false;
        },        
        onCity: function(e)
        {
            city_id = intval(e.value);
        }
    };
}());
<? js::stop(); ?>
</script>