<?php
/**
 * @var $this Users
 */
?>
<div class="h1-wrap">
    <h1><?= _t('users', 'Настройки'); ?></h1>
</div>
<div class="form-box" id="user-settings-block">
<div class="error" <? if($this->errors->no()){ ?>style="display: none;"<? } ?>><?= join('<br />', $this->errors->get(true)); ?></div>
<br/>
<h3><a class="active us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('main', this);"><?= _t('users', 'Личная информация'); ?></a></h3>
<div id="us-block-main" class="us-block">
    <table width="100%">        
    <tr>
        <td class="td1"><?= _t('users', 'Ваше фото'); ?></td>
        <td>
                <iframe name="user_settings_avatar_iframe" class="displaynone"></iframe>
                <form target="user_settings_avatar_iframe" action="/user/avatar_upload" method="post" enctype="multipart/form-data" id="user-settings-avatar-form">
                    <div class="avaBig">
                        <img src="<?= UsersAvatar::url($user_id, $avatar, UsersAvatar::szNormal, $sex) ?>" id="user-settings-avatar" style="margin-right: 15px;" align="left" />
                        <i class="mask">&nbsp;</i>
                    </div>
                    <br />
                    <div class="upload-file left">
                        <div class="upload-btn alignCenter">
                            <span class="upload-mask" style="height: 41px;">
                                <input type="file" onchange="jUsersSettings.imgUploadStart(this, 'pub-item-img-selected');" name="avatar" />
                            </span>
                            <a href="#" onclick="nothing(event);" class="ajax f12"><?= _t('users', 'Изменить фотографию'); ?></a>
                            <div class="progress" style="display: none;" id="user-settings-avatar-progress"></div>
                            <div class="clear"></div>
                        </div>
                    </div>
                </form>
        </td>
    </tr>
    </table>
    <form>
    <input type="hidden" name="act" value="main" />
    <table width="100%">
        <tr>
            <td class="td1"><?= _t('users', 'Логин'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="login" value="<?= $login ?>" maxlength="30" /><i></i></div></td>
        </tr>                                 
        <tr>
            <td class="td1"><?= _t('users', 'Имя'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="name" value="<?= $name ?>" maxlength="30" /><i></i></div></td>
        </tr>                 
        <tr>
            <td class="td1"><?= _t('users', 'Фамилия'); ?></td>
            <td><div class="inp inp-w3"><input type="text" name="surname" value="<?= $surname ?>" maxlength="30" /><i></i></div></td>
        </tr>
        <? if(Users::profileBirthdate()): ?>
        <tr>
            <td class="td1"><?= _t('users', 'Дата рождения'); ?></td>
            <td>
                <select name="birthdate[day]" style="width: 55px;"><?= $bdate['days'] ?></select>
                <select name="birthdate[month]" style="width: 112px;"><?= $bdate['months'] ?></select>
                <select name="birthdate[year]" style="width: 75px;"><?= $bdate['years'] ?></select>
            </td>
        </tr>
        <? endif; ?>
        <tr>
            <td class="td1"><?= _t('users', 'Ваш город'); ?></td>
            <td>
                <select class="inp-w3" name="city_id" onchange="jUsersSettings.onCity(this);"><?= $cities ?></select>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('users', 'Кто вы?'); ?></td>
            <td><label><input type="radio" name="sex" value="<?= Users::SEX_MALE ?>" <? if($sex == Users::SEX_MALE){ ?>checked="checked"<? } ?> /> <?= _t('users', 'Мужчина'); ?></label>&nbsp;&nbsp;&nbsp;<label><input type="radio" name="sex" value="<?= Users::SEX_FEMALE ?>" <? if($sex == Users::SEX_FEMALE){ ?>checked="checked"<? } ?> /> <?= _t('users', 'Женщина'); ?></label></td>
        </tr>
        <tr>
            <td></td>
            <td colspan="2">
                <div class="btn mr10 left"><input type="button" onclick="jUsersSettings.onSubmit('main', this.form, this);" value="<?= _t('users', 'сохранить изменения'); ?>" /><i></i></div>
            </td>
        </tr>       
    </table>        
    </form> 
    <div class="separator"></div>       
</div>
<h3><a class="ajax us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('contacts', this);"><?= _t('users', 'Контакты'); ?></a></h3>
<div id="us-block-contacts" class="displaynone us-block">
    <form class="">
    <input type="hidden" name="act" value="contacts" />
    <div class="error" style="display: none; margin: 10px 0;"></div>
    <table width="100%">
    <tr>
        <td class="td1"><?= _t('users', 'Ваш e-mail'); ?><br /><span class="f11"><a href="#" onclick="return jUsersSettings.toggleBlock('email', false, true);" class="ajax"><?= _t('users', 'Изменить e-mail'); ?></a></span></td>
        <td>
            <span><?= $email ?></span>
            <div style="display: none;">
            <br />
            <span class="f11"><label class="disabled"><input type="checkbox" class="checkbox" name="email_show" /> <?= _t('users', 'Показывать другим пользователям'); ?></label></span>
            </div>
        </td>
    </tr>
    <tr>
        <td class="td1"><?= _t('users', 'Телефон'); ?></td>
        <td><div class="inp inp-w3"><input type="tel" name="phone" value="<?= $phone ?>" maxlength="50" /><i></i></div></td>
    </tr>        
    <tr>
        <td class="td1"><?= _t('users', 'ICQ'); ?></td>
        <td><div class="inp inp-w3"><input type="text" name="icq" value="<?= $icq ?>" maxlength="50" pattern="[0-9]*" /><i></i></div></td>
    </tr>        
    <tr>
        <td class="td1"><?= _t('users', 'Skype'); ?></td>
        <td><div class="inp inp-w3"><input type="text" name="skype" value="<?= $skype ?>" maxlength="50" /><i></i></div></td>
    </tr>  
    <tr>
        <td></td>
        <td colspan="2">
            <div class="btn mr10 left"><input type="button" onclick="jUsersSettings.onSubmit('contacts', this.form, this);" value="<?= _t('users', 'сохранить контакты'); ?>" /><i></i></div>
        </td>
    </tr>       
    </table>
    </form>
    <div class="separator"></div>       
</div>
<h3><a class="ajax us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('social', this);"><?= _t('users', 'Социальные сети'); ?></a></h3>
<div id="us-block-social" class="displaynone us-block">
    <table width="100%">
        <tr>
            <td class="td1"></td>
            <td class="f11">
                <?= _t('', 'Вы сможете входить на [title] используя любой из привязанных аккаунтов.', array('title' => config::sys('site.title'))); ?>
            </td>
        </tr>
        <? foreach($social as $v): ?>
        <tr>        
            <td class="td1"><b><?= $v['title'] ?></b></td>
            <td class="f11">
               <? if( ! empty($v['user'])): $soc = $v['user']; ?>
               <div class="left">
                <span class="ava-small left relative"><a href="<?= $soc['profileURL'] ?>" target="_blank"><img src="<?= $soc['photoURL'] ?>" /><i class="social facebook"></i></a></span>
                <a href="<?= $soc['profileURL'] ?>" class="f14" target="_blank"><?= $soc['displayName'] ?></a>
               </div>
               <div class="right"><span><b>x</b></span> <a href="#" class="ajax" onclick="return jUsersSettings.unlinkSocial('<?= $v['key'] ?>');"><?= _t('', 'Удалить'); ?></a></div>
               <? endif; ?>
               <a href="#" class="soc1 j-u-login-social-btn <? if( ! empty($v['user'])) { ?>displaynone<? } ?>" style="background:none;" onclick="return false;" data="{provider:'<?= $v['key'] ?>',w:<?= $v['w'] ?>,h:<?= $v['h'] ?>}" ><img src="/img/fb-connect.gif" /></a>
            </td>
        </tr>
        <? endforeach; ?>
    </table>
    <div class="separator"></div>       
</div>
<h3><a class="ajax us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('enotify', this);"><?= _t('users', 'Уведомления и подписка'); ?></a></h3>
<div id="us-block-enotify" class="displaynone us-block">
    <form>
    <input type="hidden" name="act" value="enotify" />
    <div class="error" style="display: none; margin: 10px 0;"></div>
       <table width="100%">
        <tr>
            <td class="td1"></td>
            <td>                        
                <? foreach($enotify as $k=>$v){ ?>
                    <label><input type="checkbox" name="enotify[]" value="<?= $k ?>" <? if($v['a']){ ?>checked="checked"<? } ?> /> <?= $v['title'] ?></label>
                <? } ?>
            </td>  
        </tr>
        <tr>
            <td></td>
            <td colspan="2">
                <div class="btn mr10 left"><input type="button" onclick="jUsersSettings.onSubmit('enotify', this.form, this);" value="<?= _t('', 'сохранить'); ?>" /><i></i></div>
            </td>
        </tr>                  
       </table>
    </form>
    <div class="separator"></div>       
</div>
<h3><a class="ajax us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('pass', this);"><?= _t('users', 'Изменить пароль'); ?></a></h3>
<div id="us-block-pass" class="displaynone us-block">
    <form>
    <input type="hidden" name="act" value="pass" />
    <div class="error" style="display: none; margin: 10px 0;"></div>
    <table width="100%">
    <tr>
        <td class="td1"><?= _t('users', 'Новый пароль'); ?></td>
        <td><div class="inp inp-w3"><input type="password" autocomplete="off" name="pass1" maxlength="50" /><i></i></div></td>
    </tr>
    <tr>
        <td class="td1"><?= _t('users', 'Новый пароль еще раз'); ?></td>
        <td><div class="inp inp-w3"><input type="password" autocomplete="off" name="pass2" maxlength="50" /><i></i></div></td>
    </tr>
    <tr>
        <td></td>
        <td colspan="2">
            <div class="btn mr10 left"><input type="button" onclick="jUsersSettings.onSubmit('pass', this.form, this);" value="<?= _t('users', 'изменить'); ?>"><i></i></div>
        </td>
    </tr>
    </table>
    </form>
    <div class="separator"></div>             
</div>
<h3><a class="ajax us-block-link" href="#" onclick="return jUsersSettings.toggleBlock('email', this);"><?= _t('users', 'Изменить email'); ?></a></h3>
<div id="us-block-email" class="displaynone us-block">
    <form>
    <input type="hidden" name="act" value="email" />
    <div class="error" style="display: none; margin: 10px 0;"></div>
    <table width="100%">
    <tr>
        <td class="td1"><?= _t('users', 'Ваш e-mail'); ?></td>
        <td><span class="email-current"><?= $email ?></span></td>
    </tr>        
    <tr>
        <td class="td1"><?= _t('users', 'Новый e-mail'); ?></td>
        <td><div class="inp inp-w3"><input type="text" name="email" autocomplete="off" class="email" /><i></i></div></td>
    </tr>        
    <tr>
        <td></td>
        <td colspan="2">
            <div class="btn mr10 left"><input type="button" onclick="jUsersSettings.onSubmit('email', this.form, this);" value="<?= _t('users', 'изменить'); ?>"><i></i></div>
        </td>
    </tr>       
    </table>
    </form>
    <div class="separator"></div>       
</div>
</div>

<script type="text/javascript">
<? js::start(); ?>
var jUsersSettings = (function(){
    var $block, $err, process = false, us_blocks, us_links, blocks = {};
    var city_id = <?= intval($city_id) ?>, urlAjax = '/user/settings?hash=<?= $this->security->getToken() ?>&act=';
    var img = {inited:false, processing:false};

    $(function(){
        $block = $('#user-settings-block');
        $err = $('div.error:first', $block);
        us_blocks = $('div.us-block', $block);
        us_links = $('a.us-block-link', $block);
        app.socialAuthButtons('#us-block-social', '<?= Users::url('login.social') ?>', '<?= Users::url('my.settings') ?>');
    });

    return {
        imgUploadStart: function(input)
        {                  
            if(img.processing) return false; 
            img.processing = true;
            if(!img.inited) { 
                document.domain = app.host;
                img.form = $('#user-settings-avatar-form', $block);
                img.avatar = $('#user-settings-avatar', $block);
                img.progress = $('#user-settings-avatar-progress', $block);
                img.inited = true;
            }               
            img.progress.show();
            img.form.submit();
        },
        imgUploadFinish: function(success, data)
        {
            if(success) {
                img.avatar.attr('src', data.preview);
                $('.header-user-avatar').attr('src', data.preview);
            } else {
                app.showError( $err, data.errors );
            }
            img.progress.hide();
            img.processing = false;
        },        
        onCity: function(e)
        {
            city_id = intval(e.value);
        },
        toggleBlock: function(key, link, scroll)
        {
            us_blocks.addClass('displaynone');
            us_links.removeClass('active').addClass('ajax');
            var block = $('#us-block-'+key, $block);
            block.toggleClass('displaynone');
            if(block.is(':visible')) {
                if(key == 'social') {
                    //app.social.init(block);
                }
                if(scroll===true) {
                    $.scrollTo(block, {offset: -25, duration: 400});
                }
            }
            if(link) $(link).toggleClass('active ajax');
            return false;
        },
        onSubmit: function(key, f, btn)
        {
            if(process) return false; 
             
            if(!blocks[key]) {
                var $e = $('div.error', f);
                blocks[key] = {e:$e};
            } else {
                $e = blocks[key].e;
            }
            var url = urlAjax+key, btn_title = $(btn).val();
            switch(key)
            {
                case 'main': {
                    $e = $err;
                    app.fieldError([f.name], false);
                    break;
                    if($.trim(f.name.value)=='') {
                        app.showError($e, '<?= _t('users', 'Укажите имя'); ?>');
                        return app.fieldError(f.name);
                    }
                } break;
                case 'contacts': {

                } break;
                case 'enotify': {
                    
                } break;
                case 'pass': 
                {
                    app.fieldError([f.pass1,f.pass2], false);
                    var p1 = $.trim(f.pass1.value);
                    if(p1=='') {
                        app.showError($e, '<?= _t('users', 'Укажите новый пароль'); ?>');
                        return app.fieldError(f.pass1);
                    } else if(p1.length<6) {
                        app.showError($e, '<?= _t('users', 'Пароль не должен быть короче 6-ти символов'); ?>');
                        return app.fieldError(f.pass1);
                    }
                    if($.trim(f.pass2.value)=='' || p1 != f.pass2.value) {
                        app.showError($e, '<?= _t('users', 'Ошибка подтверждения пароля'); ?>');
                        return app.fieldError(f.pass2);
                    }
                } break;
                case 'email': 
                {
                    app.fieldError([f.email], false);
                    var em = $.trim(f.email.value);
                    if(!em.length || !bff.isEmail(em)) {
                        app.showError($e, '<?= _t('users', 'E-mail адрес указан некорректно'); ?>');
                        return app.fieldError(f.email);
                    }
                } break;                
            }
            $(btn).val('<?= _t('', 'сохранение...'); ?>');
            process = true;
            bff.ajax(url, $(f).serialize(), function(data, errors){
                if(data.res) {
                    if(key == 'email') {
                        app.showError($e, '<?= _t('users', 'E-mail адрес был успешно изменен, письмо для его автивации было отправлено'); ?>', true);
                        $('.email-current', f).text( data.email );
                        f.email.value = '';
                    } else {
                        app.showError($e, '<?= _t('users', 'Настройки успешно сохранены'); ?>', true);
                    }
                } else {
                    app.showError($e, errors);
                    if(data.fields) app.fieldErrorForm(data.fields, f);
                }
                $(btn).val(btn_title);
                process = false;
            });            
        },
        unlinkSocial: function(key)
        {
            if(process) return false;
            process = true;
            bff.ajax(urlAjax+'social-unlink', {provider:key}, function(data, errors){
                if(data.res) {
                    location.reload();
                } else {
                    app.showError($err, errors, false, true);
                }
                process = false;
            });
            return false; 
        }
    };
}());
<? js::stop(); ?>
</script>