<?php
    if( ! empty($social_data)){
        extract($social_data, EXTR_REFS);
    }
?>
<h1><?= _t('users', 'Авторизация'); ?></h1>
<div class="user" id="user-reg-social">
    <div class="left ava" style="width: 54px; height: 54px; overflow: hidden;"><img width="50" src="<?= $avatar ?>" /></div>
    <div class="left hello">
        <span class="f14"><?= _t('users', 'Здравствуйте,'); ?> <b><?= $name ?></b>.</span>
        <br />
        <div class="step0 step">
            <br />
            <h4><?= _t('users', 'У вас раньше был профиль на [title]?', array('title' => config::sys('site.title'))); ?></h4>
            <?= _t('users', 'Если вы были когда-то зарегистрированы на [title],[br] вы можете объединить созданную учетную запись со старой.', array(
                'title' => config::sys('site.title'),
                'br' => '<br />',
            )); ?>
            <br />
            <br />
            <div class="btn"><input type="button" value="<?= _t('', 'да'); ?>" class="btn-step1" /><i></i></div>
            <div class="btn"><input type="button" value="<?= _t('', 'нет, я новый пользователь'); ?>" class="btn-step2" /><i></i></div>
        </div>
        <div class="displaynone step1 step">
            <br />
            <h4><?= _t('users', 'У вас раньше был профиль на [title]?', array('title' => config::sys('site.title'))); ?></h4>
            <br />
            <form method="get">
            <input type="hidden" name="social" value="1" />
            <input type="hidden" name="act" value="login" />
            <div class="error" style="display: none;"></div>
            <table style="width:100%;">
                <tr>
                    <td width="90"><?= _t('users', 'Email или логин'); ?></td>
                    <td colspan="2"><div class="inp inp-w3"><input type="text" value="" tabindex="1" name="login" autocomplete="off" /><i></i></div></td>
                </tr>
                <tr>     
                    <td><?= _t('users', 'Пароль'); ?></td>
                    <td width="200">                                                 
                        <div class="inp inp-w3"><input type="password" name="pass" tabindex="2" autocomplete="off" /><i></i></div>
                        <label class="f11"><input type="checkbox" class="checkbox" name="remember" tabindex="3" /> <?= _t('users', 'Запомнить меня'); ?></label>
                    </td>
                    <td width="100"><span class="f11"><a href="<?= Users::url('forgot', array('social'=>1)) ?>" target="_blank"><?= _t('users', 'Забыли пароль?'); ?></a></span> </td>
                </tr>   
                <tr>
                    <td></td>
                    <td colspan="2">
                        <div class="btn mr10 left"><input type="submit" class="submit" tabindex="4" value="<?= _t('users', 'объединить профили'); ?>" /><i></i></div>
                        <div class="clear"></div>
                        <br />
                        <?= _t('users', 'У вас еще нет логина на [title]?', array('title' => config::sys('site.title'))); ?><br /><a href="#" class="btn-step2" onclick="return false;"><?= _t('users', 'Создайте новый профиль.'); ?></a>
                    </td>
                </tr>
            </table>
            </form>
        </div>
        <div class="displaynone step2 step">
            <br/>
            <h4><?= _t('users', 'Быстрая регистрация'); ?></h4>
            <?= _t('users', 'Укажите Ваш e-mail. E-mail понадобится, например, для восстановления пароля.'); ?>
            <br />
            <br />
            <form method="get">
            <input type="hidden" name="social" value="1" />
            <input type="hidden" name="act" value="register" />
            <div class="error" style="display: none;"></div>
            <table>
                <tr>
                    <td><?= _t('', 'Email'); ?></td>
                    <td>
                        <div class="inp inp-w3"><input type="email" name="email" tabindex="2" autocomplete="off" /><i></i></div>
                        <? if(config::sys('users.register.agreement', true)): ?>
                        <label><input type="checkbox" class="checkbox" name="agree" tabindex="3" /> <span class="f11"><?= _t('users', 'Я согласен с [a:start]пользовательским соглашением[a:stop]', array('a:start' => '<a href="#">', 'a:stop' => '</a>')); ?></span></label>
                        <? endif; ?>
                    </td>
                </tr>   
                <tr>
                    <td></td>
                    <td>
                        <div class="btn mr10 left"><input type="submit" class="submit" tabindex="4" value="<?= _t('users', 'завершить регистрацию'); ?>" /><i></i></div>
                        <div class="clear"></div>
                        <br />
                        <a href="#" class="btn-step1" onclick="return false;"><?= _t('users', 'Я вспомнил! У меня есть профиль на [title]!', array('title' => config::sys('site.title'))); ?></a>
                    </td>
                </tr>
            </table>
            </form>        
        </div>        
    </div> 
    <div class="clear"></div>
</div>

<script type="text/javascript">
<? js::start(); ?>
$(function(){
    var block = $('#user-reg-social'), steps = $('.step', block);
    var urlRegister = '<?= bff::urlAjax('users', '') ?>';
    
    //init step 1 - link
    $('.step1 form:first', block).submit(function(){
        var f = this, $err = $('.error', f), $btn = $('.submit', f), 
            lgn = $.trim(f.login.value);
        //email|login, pass
        app.fieldError([f.login,f.pass], false);
        if(lgn=='') { return app.fieldError(f.login); }
        if(lgn.indexOf('@')!==-1 && !bff.isEmail(lgn)) {
            app.showError($err, '<?= _t('users', 'E-mail указан некорректно'); ?>');
            return app.fieldError(f.login);
        }
        if($.trim(f.pass.value)=='') {
            app.showError($err, '<?= _t('users', 'Укажите пароль'); ?>');
            return app.fieldError(f.pass);
        }
        $btn.prop('disabled', true).val('<?= _t('', 'Подождите...'); ?>');
        bff.ajax(urlRegister + 'login', $(f).serialize(), function(data, errors){
            if(data.success) {
                data.status = intval(data.status);
                if(data.status==2) { bff.redirect('/'); }
                if(data.status==1) {
                    var p = app.popup('reg-confirm');
                    if(!p.isInited()) { p.getPopup().html(data.confirm_popup); }
                    p.show();
                }
            } else {
                app.showError($err, errors);
                $btn.prop('disabled', false).val('<?= _t('users', 'объединить профили'); ?>');
            }
        });
        return false;
    });

    //init step 2 - reg
    $('.step2 form:first', block).submit(function(){
        var f = this, $err = $('.error', f), $btn = $('.submit', f);
        //name, email
        app.fieldError([f.name,f.email], false);
        var em = $.trim(f.email.value);
        if(!em.length || !bff.isEmail(em)) {
            app.showError($err, '<?= _t('users', 'E-mail указан некорректно'); ?>');
            return app.fieldError(f.email);
        }
        <? if(config::sys('users.register.agreement', true)): ?>
        if(!f.agree.checked) {
            app.showError($err, '<?= _t('users', 'Ознакомтесь с пользовательским соглашением'); ?>');
            f.agree.focus(); return false;
        }
        <? endif; ?>
        $btn.prop('disabled', true).val('<?= _t('', 'Подождите...'); ?>');
        bff.ajax(urlRegister + 'register', $(f).serialize(), function(data,errors){
            if(data.success) {
                bff.redirect('<?= Users::url('register', array('success'=>1)) ?>');
            } else {
                app.showError($err, errors);
                $btn.prop('disabled', false).val('<?= _t('users', 'завершить регистрацию'); ?>');
            }
        });
        return false;
    });
    
    $('.btn-step1', block).click(function(e){
        steps.addClass('displaynone').filter('.step1').removeClass('displaynone');
        nothing(e); return false;
    });
    $('.btn-step2', block).click(function(e){
        steps.addClass('displaynone').filter('.step2').removeClass('displaynone');
        nothing(e); return false;
    });    
});
<? js::stop(); ?>
</script>