<?php
/**
 * Главная: содержание
 * @var $this Site
 * @var $pub array Публикации
 */
 tpl::includeJS('owl.carousel', false);
 tpl::includeCSS('owl.carousel');
?>
<div class="leftblock">
    <!-- News -->
    <div class="news-last news-last-index mt20">
        <h2><a href="<?= $pub['url_news_list'] ?>"><?= _t('pub', 'Новости'); ?></a> <a class="rss" href="<?= Services::url('news') ?>"></a></h2>
        <div class="main left mt5" id="j-index-news-rotation">
            <? $newsA = current($pub['news']); ?>
            <div class="item-main left j-current">
                <div class="picCont">
                    <a href="<?= $newsA['url'] ?>" class="j-image"><img src="<?= $newsA['img'] ?>" alt="<?= $newsA['title_alt'] ?>" /></a>
                    <div class="nums">
                        <a href="<?= $newsA['url'] ?>" class="numLight j-comments"><?= $newsA['comments'] ?></a>
                        <a href="<?= $newsA['url'] ?>" class="numDark j-ct<? if( ! $newsA['ct']) { ?> displaynone<? } ?>">
                            <i class="ico-photo j-ct-p" style="margin-right:2px;<? if($newsA['photos']<2) { ?> display:none;<? } ?>">&nbsp;</i>
                            <i class="ico-video j-ct-v" style="<? if(!$newsA['video']) { ?>display:none;<? } ?>">&nbsp;</i>
                        </a>
                        <div class="clear"></div>
                    </div>
                </div>
                <p class="s-date"><span class="j-publicated"><?= $newsA['publicated'] ?></span><span class="grey"> / <a href="<?= $newsA['category']['url'] ?>" class="j-category"><?= $newsA['category']['title'] ?></a></span></p>
                <p class="f20 j-title"><?= $newsA['title'] ?></p>
                <p class="j-content"><?= $newsA['content_short'] ?></p>
            </div>
            <div class="list left">
                <ul style="background:none;" class="b-hp-news-list j-list">
                    <? foreach($pub['news'] as &$v){ ?>
                    <li class="j-list-item<? if($v['id'] == $newsA['id']) { ?> selected<? } if($v['last']){ ?> last<? } ?>" data-id="<?= $v['id'] ?>">
                        <span class="s-date"><?= $v['publicated'] ?><span class="grey"> / <a href="<?= $v['category']['url'] ?>"><?= $v['category']['title'] ?></a></span></span>
                        <span><?= $v['title'] ?></span>
                    </li>
                    <? } unset($v); ?>
                </ul>
                <script type="text/javascript">
                <? js::start() ?>
                    $(function(){
                        var data = <?= func::php2js($pub['news']) ?>;
                        var $block = $('#j-index-news-rotation');
                        var $c = $block.find('.j-current');
                        var c = {image: $c.find('.j-image'), comments: $c.find('.j-comments'),
                            publicated: $c.find('.j-publicated'), category: $c.find('.j-category'),
                            title: $c.find('.j-title'), content: $c.find('.j-content'), ct: $c.find('.j-ct')};
                        var $list = $block.find('.j-list'), $listItems = $list.find('.j-list-item');
                        var timer, timerDelay = 4000, current = intval(<?= ( ! empty($newsA['id']) ? $newsA['id'] : 0 ) ?>);

                        function viewItem($item)
                        {
                            var id = intval($item.data('id'));
                            if ( ! data.hasOwnProperty(id)) return;
                            current = id;
                            var d = data[id];
                            c.image.attr({href:d.url}).find('img').attr({src: d.img, alt: d.title_alt});
                            c.comments.attr({href:d.url}).text(d.comments);
                            c.publicated.text(d.publicated);
                            c.category.attr({href:d.category.url}).text(d.category.title);
                            c.title.html(d.title);
                            c.content.html(d.content_short);
                            c.ct.toggle(d.ct>0).attr({href:d.url});
                            c.ct.find('.j-ct-p').toggle(intval(d.photos)>1);
                            c.ct.find('.j-ct-v').toggle(d.video);
                            $item.addClass('selected').siblings().removeClass('selected');
                        }

                        function timerAction()
                        {
                            var $n = $listItems.filter('[data-id="'+current+'"]').next();
                            if ( ! $n || ! $n.length) $n = $listItems.eq(0);
                            viewItem($n);
                        }

                        $listItems.on('mouseenter', function(){
                            viewItem($(this));
                            clearInterval(timer);
                        }).on('mouseleave', function(){
                            timer = setInterval(timerAction, timerDelay);
                        });

                        $c.on('mouseenter', function(){
                            clearInterval(timer);
                        }).on('mouseleave', function(){
                            timer = setInterval(timerAction, timerDelay);
                        });

                       timer = setInterval(timerAction, timerDelay);

                    });
                <? js::stop() ?>
                </script>
            </div>
            <div class="clear"></div>
        </div>
        <div class="right" style="width: 105px">
            <h3><?= _t('pub', 'Рубрики'); ?></h3>
            <ul class="listpad">
                <? if( ! empty($aData['pub']['cats']) ) {
                    foreach($aData['pub']['cats'] as $v) { ?>
                    <li><a href="<?= $v['url'] ?>"><?= $v['title']; ?></a></li>
                    <? }
                } ?>
            </ul>
        </div>
        <div class="clear"></div>
    </div>
    <!-- Reports -->
    <div class="photoreports mt20" id="j-index-reports-block">
        <h2 class="left"><a href="<?= $pub['url_reports_list'] ?>"><?= _t('pub', 'Фоторепортажи'); ?></a></h2>
        <? if($pub['reports_rotation']) { ?>
            <span class="arrs"><a href="#" class="j-prev disabled"><i class="arrowLeft">&nbsp;</i></a> <a href="#" class="j-next"><i class="arrowRight">&nbsp;</i></a></span>
        <? } ?>
        <div class="clear"></div>
        <div class="b-main-news mt5">
            <div class="<? if($pub['reports_rotation']) { ?>owl-carousel<? } ?>">
                <? foreach($pub['reports'] as $k=>$v){ ?>
                     <div class="main-news-in main-news-in-index">
                        <div class="picCont">
                            <a href="<?= $v['url'] ?>"><img src="<?= $v['img'] ?>" alt="<?= $v['title_alt'] ?>" /></a>
                            <div class="nums">
                                <a href="<?= $v['url'] ?>" class="numLight"><?= $v['comments'] ?></a>
                                <? if($v['photos'] > 1){ ?><a href="<?= $v['url'] ?>" class="numDark"><i class="ico-photo">&nbsp;</i>&nbsp;<?= $v['photos'] ?></a><? } ?>
                                <div class="clear"></div>
                            </div>
                        </div>
                        <p class="s-date"><?= $v['publicated'] ?></p>
                        <?= $v['title'] ?>
                    </div>
                <? } ?>
                <? if($pub['reports_all']) { ?>
                <div class="main-news-in main-news-in-index photoreports-other">
                    <a href="<?= $pub['url_reports_list'] ?>"><?= _t('pub', 'Все фоторепортажи') ?></a>
                </div>
                <? } ?>
            </div>
            <? if($pub['reports_rotation']) { ?>
                <script type="text/javascript">
                <? js::start() ?>
                    $(function(){
                        var $block = $('#j-index-reports-block'), $owl = $block.find('.owl-carousel');
                        var $prev = $block.find('.j-prev'), $next = $block.find('.j-next');
                        $owl.owlCarousel({
                            items: 3, scrollPerPage: true, pagination: false, responsive: false, slideSpeed: 500,
                            afterInit: function(){
                                $block.on('click', '.j-prev, .j-next', function(e){ nothing(e);
                                    var $arr = $(this); if($arr.is('.disabled')) return;
                                    $owl.trigger('owl.'+($arr.is('.j-next') ? 'next' : 'prev'));
                                });
                            },
                            afterMove: function(){
                                $prev.add($next).removeClass('disabled');
                                if (this.currentItem == 0) {
                                    $prev.addClass('disabled');
                                } else if(this.currentItem == this.maximumItem) {
                                    $next.addClass('disabled');
                                }
                            }
                        });
                    });
                <? js::stop() ?>
                </script>
            <? } ?>
            <div class="clear"></div>
            <div class="photoreports-corner">&nbsp;</div>
        </div>
    </div>
</div>
<!--end leftblock-->

<div class="rightblock">
    <?= Banners::view('teaser_right') ?>
    <? if ($bannersRight = Banners::view('right')) {  ?><div class="banner mt20"><?= $bannersRight ?></div><? } ?>
    <div class="mt20 mb10"><?= $voting ?></div>
</div>
<div class="clear"></div>
<!--end rightblock -->

<? if ($bannersIndex1 = Banners::view('index1')) { ?><div class="bannerTop100 mb20"><?= $bannersIndex1; ?></div><? } else { ?> <div class="separator mt10"></div><? } ?>

<!-- Video -->
<?= ( ! empty($video) ? $video : '' ) ?>

<div class="separator mt20"></div>

<div class="mt20">
    <!-- Articles -->
    <div class="left w510 mr30">
        <h2><a href="<?= $pub['url_articles_list'] ?>"><?= _t('pub', 'Статьи') ?></a></h2>
        <table class="v-week left w240" style="margin-bottom: 10px;">
            <tbody>
            <? foreach($pub['articles'][0] as $v){ ?>
            <tr>
                <td<? if($v['last']){ ?> class="noBord"<? } ?>><p class="s-date"><?= $v['publicated'] ?> <span class="grey">/ <a href="<?= $v['cat']['url'] ?>"><?= $v['cat']['title'] ?></a></span></p><?= $v['title'] ?></td>
            </tr>
            <? } ?>
            </tbody>
        </table>
        <table class="v-week right w240" style="margin-bottom: 10px;">
            <tbody>
            <? foreach($pub['articles'][1] as $v){ ?>
                <tr>
                    <td<? if($v['last']){ ?> class="noBord"<? } ?>><p class="s-date"><?= $v['publicated'] ?> <span class="grey">/ <a href="<?= $v['cat']['url'] ?>"><?= $v['cat']['title'] ?></a></span></p><?= $v['title'] ?></td>
                </tr>
            <? } ?>
            </tbody>
        </table>
        <div class="clear"></div>
        <a href="<?= $pub['url_articles_list'] ?>" class="f12 grey"><?= _t('pub', 'Все статьи') ?></a> <span class="grey">&rarr;</span>
    </div>
    <? if( ! empty($pub['articles'][2])): ?>
    <div class="left w510">
        <h2>&nbsp;</h2>
        <table class="v-week left w240" style="margin-bottom: 10px;">
            <tbody>
            <? foreach($pub['articles'][2] as $v){ ?>
                <tr>
                    <td<? if($v['last']){ ?> class="noBord"<? } ?>><p class="s-date"><?= $v['publicated'] ?> <span class="grey">/ <a href="<?= $v['cat']['url'] ?>"><?= $v['cat']['title'] ?></a></span></p><?= $v['title'] ?></td>
                </tr>
            <? } ?>
            </tbody>
        </table>
        <table class="v-week right w240" style="margin-bottom: 10px;">
            <tbody>
            <? if(!empty($pub['articles'][3])) { foreach($pub['articles'][3] as $v){ ?>
                <tr>
                    <td<? if($v['last']){ ?> class="noBord"<? } ?>><p class="s-date"><?= $v['publicated'] ?> <span class="grey">/ <a href="<?= $v['cat']['url'] ?>"><?= $v['cat']['title'] ?></a></span></p><?= $v['title'] ?></td>
                </tr>
            <? } } ?>
            </tbody>
        </table>
        <div class="clear"></div>
    </div>
    <? endif; ?>
    <?

    ?>
    <? if( ! empty($forum)): ?>
        <div class="left relative w510">
            <h2 class="mb20"><a href="<?= Users::url('forum'); ?>"><?= _t('users', 'Форум') ?></a></h2>
            <ul class="forumlist w240 left">
                <? $cnt = 0; foreach($forum as $v): ?>
                <? if( $cnt && ! ($cnt % 4 )): ?>
                    </ul>
                    <ul class="forumlist w240 right">
                <? endif; $cnt++; ?>
                <li>
                    <div class="ava"><a href="<?= $v['link'] ?>" title=""><img src="<?= $v['avatar'] ?>" alt="" width="40" height="40"><i class="mask">&nbsp;</i></a></div>
                    <a href="<?= $v['link'] ?>"><?= $v['post_subject'] ?></a><br>
                    <?= $v['name'] ?> <?= $v['surname'] ?> - <span class="grey"><?= $v['publicated'] ?></span>
                </li>
                <? endforeach; ?>
            </ul>
            <div class="clear"></div>
            <a href="<?= Users::url('forum'); ?>" class="f12 grey"><?= _t('users', 'Все темы') ?></a> <span class="grey">&rarr;</span>
        </div>
    <? endif; ?>

    <div class="right w240" style="display: none;">
        <h2><a href="#"><?= _t('qa', 'Вопрос ответ') ?></a></h2>
        <table class="v-week w240" style="margin-bottom: 10px;">
            <tbody>
            <tr>
                <td>
                    <a href="#">Правдив ли бриф бах большом пальце и ядерном взрыве?</a>
                    <p class="grey f12">Thomas Angel в "Естественные науки",</p>
                    <p>27 минут назад, <a href="#">5 ответов</a></p>
                </td>
            </tr>
            <tr>
                <td>
                    <a href="#">Моль идеального газа?</a>
                    <p class="grey f12">Thomas Angel в "Естественные науки",</p>
                    <p>Вчера в 9:45, <a href="#">29 ответов</a></p>
                </td>
            </tr>
            <tr>
                <td class="noBord">
                    <a href="#">Зачем моему мужу большой черный нос?</a>
                    <p class="grey f12">Thomas Angel в "Естественные науки",</p>
                    <p>25 января в 11:29, <a href="#">17 ответов</a></p>
                </td>
            </tr>
            </tbody>
        </table>
        <a href="#" class="f12 grey"><?= _t('qa', 'Все вопросы') ?></a> <span class="grey">&rarr;</span>
    </div>
    <div class="clear"></div>
</div>

<? if ($bannersIndex2 = Banners::view('index2')) { ?><div class="banner mb20 mt20"><?= $bannersIndex2; ?></div><? } else { ?><div class="separator mt20"></div><? } ?>

<?= ( ! empty($afisha) ? $afisha : '' ) ?>

<? if( ! empty($auto) || ! empty($realty) ) { ?>
<div class="separator mt20"></div>
<div class="bbs-index mb30">
    <div class="left w510">
        <?= ( ! empty($auto) ? $auto : '' ) ?>
    </div>
    <div class="right w510">
        <?= ( ! empty($realty) ? $realty : '' ) ?>
    </div>
    <div class="clear"></div>
</div>
<? } ?>

<? if( ! empty($bbs) || ! empty($aData['job']) ) { ?>
<div class="separator mt20"></div>
<div class="catalog-index mb20">
    <div class="left w510">
        <?= ( ! empty($bbs) ? $bbs : '' ) ?>
    </div>
    <div class="right w510">
        <?= ( ! empty($aData['job']) ? $aData['job'] : '' ) ?>
    </div>
    <div class="clear"></div>
</div>
<? } ?>
<? if( ! empty($aData['items_block']) ) { ?>
<div class="separator mt20"></div>
<div class="catalog-index mb20">
    <?= $aData['items_block'] ?>
</div>
<? } ?>
<? if($bannersIndex3 = Banners::view('index3')) { ?><div class="banner mb30"><?= $bannersIndex3; ?></div><? } ?>