<?php

class Site extends SiteBase
{
    /**
     * Главная страница
     */
    public function index()
    {
        $aData = array();
        do {
            # кешируем на Х секунд
            $cacheOn = false;

            if ($cacheOn) {
                $cache = Cache::singleton('site', 'file', array('lifeTime'=>180));
                $cacheKey = 'index-blocks-'.LNG.( Geo::regionsFilter() ? '-'.Geo::cityID() : '' );
                if(($aData = $cache->get($cacheKey)) !== false) break;
            }

            $aData = array();
            if(config::sys('forum.type')) $aData['forum'] = Users::i()->forum()->getLastIndexPosts();
            $aData['pub'] = Publications::i()->indexBlock( ! empty($aData['forum']));
            $aData['video'] = Publications::i()->indexBlockVideo();

            if(bff::moduleExists('items')) $aData['items_block'] = Items::i()->indexBlock();
            if(bff::moduleExists('afisha')) $aData['afisha'] = Afisha::i()->indexBlock();
            if(bff::moduleExists('auto')) $aData['auto'] = Auto::i()->indexBlock();
            if(bff::moduleExists('realty')) $aData['realty'] = Realty::i()->indexBlock();
            if(bff::moduleExists('bbs')) $aData['bbs'] = BBS::i()->indexBlock();
            if(bff::moduleExists('job')) $aData['job'] = Job::i()->indexBlock();
            if(bff::moduleExists('voting')) $aData['voting'] = Voting::i()->getRightBlockVoting();

            if($cacheOn) $cache->set($cacheKey, $aData);
        } while(false);

        # seo
        $region = Geo::filterUrl();
        if ($region['id'] > 0) {
            # seo: Главная страница (регион)
            $this->seo()->canonicalUrl(Geo::urlBase(LNG, true, array('city'=>$region['id'])));
            $this->setMeta('index-region', array(
                    'region' => ($region['city'] ? $region['city']['title_' . LNG] : '')
                ), $aData
            );
        } else {
            # seo: Главная страница
            $this->seo()->canonicalUrl(static::urlBase(LNG, true));
            $this->setMeta('index', array(), $aData);
        }

        return $this->viewPHP($aData, 'index');
    }

    /**
     * Обработчик перехода по внешним ссылкам
     */
    public function away()
    {
        $sURL = $this->input->get('url', TYPE_STR);
        if (empty($sURL)) $sURL = bff::urlBase();
        else $sURL = 'http://'.$sURL;
        $this->redirect($sURL);
    }

    /**
     * Статические страницы
     */
    public function pageView()
    {
        $sFilename = $this->input->get('page', TYPE_NOTAGS);
        $aData = $this->model->pageDataView($sFilename);
        if (empty($aData)) {
            $this->errors->error404();
        }

        # seo: Статические страницы
        $this->urlCorrection(static::url('page', array('filename' => $sFilename)));
        $this->seo()->canonicalUrl(static::url('page', array('filename' => $sFilename), true));
        $this->setMeta('page-view', array('title' => $aData['title']), $aData);

        return $this->viewPHP($aData, 'page.view');
    }

    /**
     * Поиск по сайту Yandex
     */
    public function search_yandex()
    {
        $aData = array();
        config::set('search_text', $this->input->cleanSearchString($this->input->get('text', TYPE_NOTAGS)));

        # seo: Поиск по сайту
        $this->urlCorrection(static::url('search'));
        $this->seo()->robotsIndex(false);
        $this->setMeta('search', array(), $aData);

        return $this->viewPHP($aData, 'search.yandex');
    }

    public function ajax()
    {
        $aResponse = array();

        switch ($this->input->getpost('act', TYPE_STR))
        {
            case 'fav': # добавление в "Избранные"
            {
                $p = $this->input->postm(array(
                    'type' => TYPE_STR,
                    'id'   => TYPE_UINT,
                ));
                
                if ( ! $this->security->isLogined()) {
                    $this->errors->impossible(); break;
                }

                if ( ! $p['id'] || empty($p['type']) ||
                    ! in_array($p['type'], array('items'))) {
                    $this->errors->impossible();
                } else {
                    //
                }
                
            } break;
            default: {
                $this->errors->impossible();
            }
        }

        $aResponse['res'] = $this->errors->no();

        $this->ajaxResponse($aResponse);
    }

    /**
     * Главная страница: mobile
     */
    public function pda_index()
    {
        $aData = array();
        $aData['pub'] = Publications::i()->pda_index();

        # seo: Главная страница (mobile)
        $this->seo()->canonicalUrl(bff::urlBaseMobile(true, LNG));
        $this->setMeta('index-mobile', array(), $aData);

        return View::renderTemplate($aData, 'index.block');
    }

}