<?php

# Погода
define('TABLE_WEATHER', DB_PREFIX.'weather');

# ТВ-программа
define('TABLE_TV_CHANNELS',                 DB_PREFIX.'tv_channels');
define('TABLE_TV_EVENTS',                   DB_PREFIX.'tv_events');
define('TABLE_TV_EVENTS_TYPES',             DB_PREFIX.'tv_events_types');

abstract class ServicesBase extends Module
{
    /** @var ServicesModel */
    public $model = null;
    protected $securityKey = '727773e8de5306e77cc8bd3dafe2ef3c';

    public function init()
    {
        parent::init();

        $this->module_title = 'Сервисы';
    }

    /**
     * Shortcut
     * @return Services
     */
    public static function i()
    {
        return bff::module('services');
    }

    /**
     * Shortcut
     * @return ServicesModel
     */
    public static function model()
    {
        return bff::model('services');
    }

    /**
     * Формирование URL
     * @param string $key ключ
     * @param mixed $opts параметры
     * @param boolean $dynamic динамическая ссылка
     * @return string
     */
    public static function url($key = '', $opts = array(), $dynamic = false)
    {
        $base = static::urlBase(LNG, $dynamic);
        switch ($key)
        {
            # Погода
            case 'weather':
                return Geo::url().'/weather'.static::urlQuery($opts);
                break;
            # Новости (RSS)
            case 'news':
                return $base.'/services/news/';
                break;
            # ТВ программа
            case 'tv':
                return $base.'/tv'.static::urlQuery($opts);
                break;
            # ТВ программа - просмотр
            case 'tv.view':
                return $base.'/tv/'.( ! empty($opts['id']) ? $opts['id'] : '').'.html'.
                    static::urlQuery($opts, array('id'));
                break;
            # Карта сайта
            case 'sitemap':
                return $base.'/services/sitemap/';
                break;
        }
        return $base;
    }

    /**
     * Формирование списка директорий/файлов требующих проверки на наличие прав записи
     * @return array
     */
    public function writableCheck()
    {
        return array_merge(parent::writableCheck(), array(
            bff::path('tv', 'images') => 'dir', # изображения
        ));
    }
}