<?php
/**
 * @var $this Realty
 */
    $aPriceParams = $this->getPriceParams();
    tpl::includeJS(array('qquploader', 'fancybox'), true);
    Geo::mapsAPI(true);
    Geo::mapsDefaultCoordsCorrect($lat, $lng);
?>
    <script type="text/javascript">
    <? js::start(); ?>
        var realtyForm = (function(){
            var $form, $err, $progress, $priceCurr, $priceCurrSel;
            var addr = {i:false,addr:0,lat:0,lng:0, progress:0, ycoords:0, dist:{}, block:false, mapBlock:false}, $district, city = {id:<?= $city_id ?>,title:'<?= $city_title ?>',ycoords:'<?= $city_ycoords ?>',$sel:false},
                hasMap = <?= ($cat['address']==2?'true':'false') ?>;
            var company = {}, $user_type, $company;

            function init() {
                $form = $('#realty-form');
                $err = $('#realty-error'); 
                $progress = $('#realty-progress', $form);
                
                $form.submit(function(){
                    app.fieldError([this.price, this.city_id, this.user_name, this.user_email, this.user_phone], false);
                    var error = false;
                    var namesOut = {}; 
                    var inputs = $('input.req:visible, select.req:visible', this);
                    inputs.each(function() {
                        var i = $(this);
                        if(i.is(':radio,:checkbox')) {
                            var name = i.attr('name');
                            if(namesOut[name]) return;
                            namesOut[name] = 1;
                            if( !inputs.filter('[name="'+name+'"]:checked').length ) {
                                error = true; return false;
                            }
                            return;
                        }
                        var val = i.val();
                        if( val == 0 || val === undefined || $.trim(val) == '' || val == i.attr('placeholder')) {
                            error = true; return false;
                        }
                    });     
                    
                    $err.prev().hide();
                    if(error) {
                        app.showError($err, '<?= _t('', 'Заполните все необходимые поля'); ?>', false, true);
                    } else {
                        bff.ajax('<?= Realty::url('edit') ?>', $form.serialize(), function(data, errors) {
                            if(data && data.success) {
                                bff.redirect('<?= Realty::url('edit', array('id'=>$id, 'success'=>1)) ?>');
                            } else {
                                app.showError( $err, errors, false, true);
                                if(data.fields) app.fieldErrorForm(data.fields, $form.get(0));
                            }
                        }, $progress); 
                    }
                    
                    return false;
                });
                
                $priceCurr    = $('#realty-price-curr', $form);
                $priceCurrSel = $('#realty-price-curr-sel li', $form);
                addr.block   = $('#realty-addr-block', $form);
                addr.ycoords = $('#realty-addr-ycoords', $form);
                $district    = $('#realty-addr-district', $form);
                city.$sel    = $('#realty-addr-city', $form);
                addr.mapBlock   = $('#realty-addr-map-block', $form);

                $user_type = $form.find('[name="user_type"]:first').closest('tr');
                $company = $form.find('[name="company_id"]').closest('tr');

                addr.block.show();
                switch(<?= $cat['address'] ?>) 
                {
                    case 0: addr.block.hide(); break;
                    case 1: addr.mapBlock.hide(); break;
                    case 2: initAddr(); addr.mapBlock.show(); break;
                }                
            }

            function initAddr()
            {
                if (addr.i === true) {
                    addr.map.refresh();
                    return;
                }

                addr.addr = $form.find('#realty-addr-addr');
                addr.lat  = $form.find('#realty-addr_lat');
                addr.lng  = $form.find('#realty-addr_lng');
                addr.i    = true;

                addr.map = app.map('realty-addr-map', [addr.lat.val(), addr.lng.val()], function(map){
                    addr.mapEditor = bff.map.editor();
                    addr.mapEditor.init({
                        map: map, version: '2.1',
                        coords: [addr.lat, addr.lng],
                        address: addr.addr,
                        addressKind: 'house',
                        updateAddressIgnoreClass: 'typed',
                        onUpdate: function(marker){
                            if (addr.map.isYandex()) {
                                selectDistrictByPoint(marker.geometry.getCoordinates());
                            }
                        }
                    });

                    addr.addr.bind('change keyup input', $.debounce(function(){
                        if( ! $.trim(addr.addr.val()).length ) {
                            addr.addr.removeClass('typed');
                        } else {
                            addr.addr.addClass('typed');
                            realtyForm.onMapSearch();
                        }
                    }, 700));
                    realtyForm.onCity(city.$sel.val());
                }, {zoom: 12});
            }

            function selectDistrictByPoint(point)
            {
                $district.val(0);
                if(city.id > 0 && addr.dist[city.id]) {
                    var d = addr.dist[city.id];
                    for(var i in d) {
                        if (addr.map.isYandex()) {
                            if( d[i].ypoly.contains(point) ){
                                $district.val(i);
                            }
                        }
                    }
                }
            }
            
            function buildDistrictSelect(districts, cityID, ycoords)
            {
                var html = '<option value="0"><?= _t('', 'Не указан'); ?></option>';
                for(var i in districts) {
                    html += '<option value="'+i+'">'+districts[i].t+'</option>';
                }
                $district.html( html ).prop('disabled', false);
                
                if(hasMap) 
                {
                    var point = false;
                    if(cityID>0 && cityID!=city.id) {
                        // change city, set map center to city center
                        if(ycoords.length) {
                            point = bff.map.coordsFromString(ycoords);
                            addr.map.panTo(point, {duration: 800});
                        }
                    } else {
                        ycoords = addr.ycoords.val();
                        if(ycoords.length > 5) {
                            point = bff.map.coordsFromString(ycoords);
                        }
                    }
                    
                    if(point!==false) {
                        selectDistrictByPoint(point);
                    }
                }
            }

            function prepareDistricts(districts, cityID)
            {               
                if(hasMap && districts) {
                    $.each(districts, function(j,d){
                        if (addr.map.isYandex()) {
                            d.ypoly = ymaps.geometry.Polygon.fromEncodedCoordinates(d.ypoly);
                            d.ypoly.options.setParent(addr.map.getMap().options);
                            d.ypoly.setMap(addr.map.getMap());
                        }
                    });
                }
                buildDistrictSelect( ( addr.dist[cityID] = districts ), cityID, city.ycoords );
                city.id = cityID;                
            }

            function setCompanyContacts(id)
            {
                var form = $form.get(0);
                var c = ( id === 0 ? {addr:'',phone:'<?= $user_phone ?>',email:'<?= $user_email ?>',city:0} : company[id]);
                form.user_phone.value = c.phone;
                form.user_email.value = c.email;
            }

            $(function(){ init(); });
            return { 
                onCurr: function(id, a)
                {
                    id = intval(id);
                    if(id<=0) return false;
                    var activeClass = 'active';
                    $priceCurr.val(id);
                    $priceCurrSel.removeClass( activeClass );
                    $priceCurrSel.find(a).parent().addClass( activeClass );
                    return false;
                },
                onCity: function(cityID)
                {
                    cityID = intval(cityID);
                    if( ! cityID){ buildDistrictSelect([], 0, ''); return; }
                    var opt = city.$sel.find('option:selected');
                    city.title = opt.text(); 
                    city.ycoords = opt.data('ycoords');
                    if(addr.dist[cityID]) {
                        buildDistrictSelect( addr.dist[cityID], cityID, city.ycoords );
                        city.id = cityID;
                        return;
                    }
                    bff.ajax('<?= bff::urlAjax('geo','districts-list') ?>', {city: cityID}, function(data){
                        if(data && data.success) {
                            prepareDistricts(data.districts, cityID);
                        }
                    });
                },
                onMapSearch: function()
                {
                    var q = [city.title];
                    q.push( $.trim( addr.addr.val() ) );
                    addr.mapEditor.search( q.join(', ') );
                    return false;
                },
                userType: function(id)
                {
                    id = intval(id);
                    if(id == 2){
                        $company.show();
                        $form.find('[name="company_id"]').trigger('change');
                        $user_type.hide();
                        $user_type.find('[value="<?= Realty::USERTYPE_AGENT ?>"]').prop('checked', true);
                    }else{
                        $company.hide();
                        setCompanyContacts(0);
                        $user_type.find(':input').prop('checked', false);
                        $user_type.show();
                    }
                },
                onCompany: function(sel)
                {
                    sel = $(sel);
                    var id = intval(sel.val());
                    if( ! id) setCompanyContacts(0);

                    if(company.hasOwnProperty(id)) {
                        setCompanyContacts( id );
                    }else{
                        bff.ajax('<?= bff::urlAjax('users','company_contacts') ?>', {company_id: id}, function(data){
                            if(data && data.res) {
                                company[ id ] = data.contacts;
                                setCompanyContacts( id );
                            }
                        });
                    }
                }
            };
        }());

        var realtyPhotos = (function()
        {
            var uploader, url = '<?= bff::urlAjax('realty','') ?>', path = '<?= $this->initImages()->getUrl() ?>';
            var $form, $block, $progress;
            var itemID = <?= $id ?>;
            $(function(){

                $form     = $('#realty-form');
                $block    = $('#realty-photos-list', $form);
                $progress = $('#realty-photos-progress', $form);

                // init uploader
                uploader = new qq.FileUploaderBasic({
                    button: $('#realty-photos-upload', $form).get(0),
                    action: url+'item-img-upload&id='+itemID,
                    limit: <?= Realty::imagesLimit() ?>,
                    uploaded: <?= $imgcnt ?>,
                    multiple: true,
                    onSubmit: function(id, fileName) {
                        $progress.show();
                    },
                    onComplete: function(id, fileName, data) {
                        if(data && data.success) {
                            $block.append('<div class="item">\
                                    <input type="hidden" name="filename[]" value="'+data.filename+'" />\
                                    <a href="'+path+itemID+data.filename+'" target="_blank" rel="realty_photos"><img src="'+path+itemID+'s'+data.filename+'" alt=""></a>\
                                    <a href="#" class="del" rel="'+data.filename+'"><?= _t('', 'Удалить'); ?></a>\
                                </div>');
                            $('a[rel="realty_photos"]', $block).fancybox();
                        } else {
                            if(data.errors) {
                                app.showError($('#realty-error'), data.errors, false);
                            }
                        }
                        if( ! uploader.getInProgress()) {
                            $progress.hide();
                        }
                        return true;
                    }
                });

                $block.delegate('div a.del', 'click', function(e){
                    nothing(e);
                    var lnk = $(this);
                    if(confirm('<?= _t('', 'Удалить фото?'); ?>')) {
                        var fn = lnk.attr('rel');
                        bff.ajax(url+'item-img-delete', {filename: [fn], id: itemID}, function(data) {
                            if(data) {
                                lnk.parent().remove();
                                uploader.decrementUploaded();
                            }
                        });
                    } return false;
                });

                $('a[rel="realty_photos"]', $block).fancybox();
            });

            return {};
        }());
    <? js::stop(); ?>
    </script>
<div class="h1-wrap">
    <h1><?= _t('realty', 'Редактирование объявления'); ?></h1>
</div>
<div class="realty mt20">
    <ul class="form-ch">
        <li><?= _t('', 'Поля, отмеченные звездочкой[span], обязательны к заполнению.', array(
                'span' => '<span class="z-att">*</span>',
            )); ?></li>
     </ul>
     <? if( ! empty($_GET['success'])) { ?>
        <div style="margin-bottom:20px;" id="realty-success-block" class="success"><?= _t('', 'Информация об объявлении успешно сохранена'); ?></div>
        <script type="text/javascript">
        <? js::start(); ?>
            $(function(){
                setTimeout(function(){ $('#realty-success-block').slideUp(function(){ $(this).remove(); }); }, 3000);
            });
        <? js::stop(); ?>
        </script>
     <? } ?>
     <div style="margin-bottom:20px; display: none;" id="realty-error" class="error"></div>
     <div class="form-box">
        <form id="realty-form" action="">
        <input type="hidden" name="id" value="<?= $id ?>" />
        <input type="hidden" name="hash" value="<?= $hash ?>" />
        <input type="hidden" name="ch" value="<?= $ch; ?>" />
        <input type="hidden" name="ycoords" id="realty-addr-ycoords" value="<?= $lat.','.$lng; ?>" />
        <input type="hidden" name="lat" id="realty-addr_lat" value="<?= $lat ?>" />
        <input type="hidden" name="lng" id="realty-addr_lng" value="<?= $lng ?>" />

        <table width="100%">
        <tr><td colspan="2"><h3><?= _t('', 'Общая информация'); ?></h3></td></tr>
        <tr>
            <td class="td1"><?= _t('realty', 'Тип недвижимости'); ?><span class="z-att">*</span></td>
            <td>
                <div class="form-ch-sp2"><p><?= $cat['title'] ?></p></div>
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('realty', 'Тип сделки'); ?><span class="z-att">*</span></td>
            <td>
                <div class="form-ch-sp2" id="realty-types"><p><?= $type_title ?></p></div>
            </td>
        </tr>
        <tr id="realty-price-block">
            <td class="td1"><?= _t('', 'Цена'); ?><span class="z-att">*</span></td>
            <td>
                 <p class="inform-att f12 mb20"><?= _t('', 'Укажите только цифры, без сокращений. Например: 2000000'); ?><i></i></p>
                 <br />
                 <div class="inp inp-w2"><input type="text" name="price" class="req" id="realty-price" value="<?= $price ?>" pattern="[0-9]*" /><i></i></div>
                 <span id="realty-price-params">
                     <?
                        foreach($aPriceParams as $ppKey=>$ppTitle) {
                            if($cat_prices & $ppKey) { ?><label class="f12" data-pparam="<?= $ppKey ?>"><input type="checkbox" name="price_params[]" <?= ($price_params & $ppKey ? ' checked="checked"' : '') ?> value="<?= $ppKey ?>" class="checkbox" /> <?= $ppTitle ?></label><? }
                        }
                     ?>
                 </span>
                 <input type="hidden" name="price_curr" id="realty-price-curr" value="<?= $price_curr ?>" />
                 <ul class="val-sp" id="realty-price-curr-sel">
                    <? foreach($curr as $v){ ?>
                        <li <?= ($v['a']?' class="active"':'') ?>><a href="#" onclick="return realtyForm.onCurr(<?= $v['id'] ?>, this);"><?= $v['title_short'] ?></a></li>
                    <? } ?>
                 </ul>
            </td>
        </tr>
        <tr>
            <td colspan="2"><div class="separatornobr"></div></td>
        </tr>
        <? if($cat['address']){ ?>
        <tbody id="realty-addr-block">
            <tr><td colspan="2"><br /><h3><?= _t('', 'Адрес'); ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('', 'Город'); ?></td>
                <td><?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('id'=>'realty-addr-city', 'class'=>'inp-w3', 'onchange'=>'realtyForm.onCity(this.value);')); ?></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Район'); ?></td>
                <td><select class="inp-w3" name="district_id" disabled="disabled" id="realty-addr-district"></select></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Улица и дом'); ?></td>
                <td>
                    <div class="inp inp-w3 left mr10"><input type="text" name="address" value="<?= $address ?>" id="realty-addr-addr" /><i></i></div><a href="#" class="ajax f12" id="realty-addr-map-link" onclick="return realtyForm.onMapSearch();"><?= _t('', 'Найти на карте'); ?></a>
                </td>
            </tr>
            <? if($cat['address'] == 2){ ?>
            <tr id="realty-addr-map-block">
                <td class="td1"><?= _t('', 'Расположение'); ?></td>
                <td>
                    <div id="realty-addr-map" style="width:466px; height: 300px;"></div>
                    <p class="f12 grey"><?= _t('', 'Переместите маркер на карте чтобы указать точное местоположение'); ?></p>
                </td>
            </tr>
            <? } ?>
            <tr>
                <td colspan="2"><div class="separatornobr"></div></td>
            </tr>
        </tbody>
        <? } ?>
        <tr><td colspan="2"><br /><h3><?= _t('', 'Дополнительная информация'); ?></h3></td></tr>
        <tbody id="realty-dynprops"><?= ( ! empty($dp) ? $dp : ''); ?></tbody>
        <tr>
            <td class="td1"><?= _t('', 'Фотографии'); ?></td>
            <td>
                <p class="inform-att f12"><?= _t('', 'Вы можете загрузить не более 8ми фотографий в формате JPG или PNG, объемом не более 3MB'); ?> &nbsp;<span class="progress" id="realty-photos-progress" style="display:none;"></span><i></i></p>
                <div class="photos-edit mt15">
                    <div id="realty-photos-list">
                    <? if($imgcnt > 0) {
                        $img = explode(',', $img);
                        $img_url = $this->initImages()->getUrl();
                        foreach($img as $filename) { ?>
                            <div class="item">
                                <input type="hidden" name="filename[]" value="<?= $filename ?>" />
                                <a href="<?= $img_url.$id.$filename ?>" target="_blank" rel="realty_photos"><img src="<?= $img_url.$id.'s'.$filename ?>" alt=""></a>
                                <a href="#" class="del" rel="<?= $filename ?>"><?= _t('', 'Удалить'); ?></a>
                            </div> <?
                        }
                    } ?>
                    </div>
                    <br class="clear" />
                    <div id="realty-photos-upload" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии'); ?></a></div>
                </div>
                <br />
            </td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Дополнительная информация'); ?></td>
            <td>
                <div class="textarea"><textarea rows="7" cols="25" name="info"><?= $info ?></textarea><i></i></div>
            </td>
        </tr>
        <tr>
            <td colspan="2"><div class="separatornobr"></div></td>
        </tr>
        <tr><td colspan="2"><br /><h3><?= _t('', 'Контакты'); ?></h3><div style="margin-bottom:20px; display: none;" id="realty-error-user" class="error"></div></td></tr>
        <tr>
            <td class="td1"><?= _t('', 'Кто вы?'); ?><span class="z-att">*</span></td>
            <td>
                <? if( ! empty($agentCompanies)): ?>
                    <div class="f12">
                        <label><input type="radio" name="user_type_c" value="1" <? if($user_type_c == 1){ ?>checked="checked"<? } ?> onchange="realtyForm.userType(1);"/> <?= _t('', 'Частное лицо'); ?></label>&nbsp;&nbsp;&nbsp;
                        <label><input type="radio" name="user_type_c" value="2" <? if($user_type_c == 2){ ?>checked="checked"<? } ?> onchange="realtyForm.userType(2);"/> <?= _t('', 'Компания'); ?></label>
                    </div>
                <? endif; ?>
            </td>
        </tr>
        <tr<?= $user_type_c == 1 ? ' class="displaynone"' : '' ?>>
            <td class="td1"><?= _t('', 'Компания:'); ?></td>
            <td>
                <select class="inp-w3" name="company_id" onchange="realtyForm.onCompany(this);"><? foreach($agentCompanies as $c):?><option value="<?= $c['id'] ?>" <?= $company_id == $c['id'] ? ' selected="selected" ' : '' ?>><?= $c['title'] ?></option><? endforeach; ?></select>
            </td>
        </tr>
        <tr<?= $user_type_c == 2 ? ' class="displaynone"' : '' ?>>
            <td class="td1"></td>
            <td><div class="f12"><label><input type="radio" name="user_type" value="<?= Realty::USERTYPE_OWNER ?>" <? if($user_type == Realty::USERTYPE_OWNER){ ?>checked="checked"<? } ?> /> <?= _t('', 'Владелец'); ?></label>&nbsp;&nbsp;&nbsp;<label><input type="radio" name="user_type" value="<?= Realty::USERTYPE_AGENT ?>" <? if($user_type == Realty::USERTYPE_AGENT){ ?>checked="checked"<? } ?> /> <?= _t('', 'Агент'); ?></label></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Ваше имя'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w3"><input type="text" name="user_name" value="<?= $user_name ?>" maxlength="90" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Телефон'); ?><span class="z-att">*</span></td>
            <td><div class="inp inp-w3"><input type="tel" name="user_phone" value="<?= $user_phone ?>" maxlength="90" /><i></i></div></td>
        </tr>
        <tr>
            <td class="td1"><?= _t('', 'Email'); ?><? if( ! User::id() ){ ?><span class="z-att">*</span><? } ?></td>
            <td><div class="inp inp-w3"><input type="text" name="user_email" value="<?= $user_email ?>" maxlength="90" /><i></i></div></td>
        </tr>
        <tr>
            <td></td>
            <td colspan="2">
                <div class="btn mr10 left"><input type="submit" value="<?= _t('', 'сохранить'); ?>" /><i></i></div>
                <div class="progress" id="realty-progress" style="display: none; margin-top: 9px;"></div>
            </td>
        </tr>
        </table>
        <div class="separator"></div>
        </form>
     </div>
 </div>