<?php

?>
<?
    $fordevActions = array(
        array('title'=>'обновление ссылок всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-links-rebuild')."'})", 'icon'=>'icon-check'),
    );
    if (BFF_LOCALHOST) {
        $fordevActions[] = array('title'=>'удаление всех записей', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-delete-all')."'})", 'icon'=>'icon-remove');
    }
?>
<?= tplAdmin::blockStart('Недвижимость / Список объявлений', true, array(), array(), $fordevActions) ?>
<div class="tabsBar" id="realty-status-tabs">
    <span class="tab <? if($f['status']==1) { ?>tab-active<? } ?>"><a href="#" onclick="return realtyItems.onStatus(1, this);">Опубликованные</a></span>
    <span class="tab <? if($f['status']==3) { ?>tab-active<? } ?>"><a href="#" onclick="return realtyItems.onStatus(3, this);">На модерацию</a></span>
    <span class="tab <? if($f['status']==2) { ?>tab-active<? } ?>"><a href="#" onclick="return realtyItems.onStatus(2, this);">Заблокированные</a></span>
    <span class="tab <? if($f['status']==4) { ?>tab-active<? } ?>"><a href="#" onclick="return realtyItems.onStatus(4, this);" class="disabled">Снятые с публикации</a></span>
    <div class="right"><div class="progress" style="display:none;" id="progress-realty-items"></div></div>
    <div class="clear"></div>
</div>

<form action="" method="get" name="filters" id="realty-items-filters" onsubmit="return false;">
<input type="hidden" name="page" value="<?= $f['page'] ?>" />
<input type="hidden" name="order" value="<?= $f['order'] ?>" />
<input type="hidden" name="status" value="<?= $f['status'] ?>" />
<div class="actionBar">
    <div class="left">
        <? if( ! Geo::cityIsOne() ) { ?><select name="city" style="width: 170px;"><?= Geo::cityOptions($f['city'], 'Все города') ?></select><? } ?>
        <select name="cat" style="width: 200px;"><?= $this->categoriesGet(false, false, array('sel'=>$f['cat'], 'empty'=>'Все разделы')); ?></select>
        <select name="type" style="width:120px;"><?= $this->typesGet(false, false, array('sel'=>$f['type'], 'empty'=>'Все типы')); ?></select>
        <span class="bold" style="margin-left: 3px;">Период:&nbsp;
            <input type="text" name="p_from" value="<?= $f['p_from'] ?>" placeholder="от" style="width: 70px;" id="realty-items-period-from" />&nbsp;<input type="text" name="p_to" value="<?= $f['p_to'] ?>" placeholder="до" style="width: 70px;" id="realty-items-period-to" />
        </span>
        <input type="button" class="btn btn-small button cancel" onclick="realtyItems.submit(true);" value="найти" />
    </div>
    <div class="left" style="margin-right: 8px;">
        <input style="width:250px;" type="text" maxlength="200" name="title" placeholder="Заголовок / ID объявления"  value="<?= HTML::escape($f['title']) ?>" />
        <input style="width:100px;" type="text" maxlength="200" name="company" placeholder="ID организации"  value="<?= $f['company'] ? $f['company'] : '' ?>" />
    </div>
    <div class="left relative" style="margin-right: 8px;">
        <input type="hidden" name="user" id="items-listing-user-id" value="<?= $f['user'] ?>" />
        <input type="text" class="autocomplete" id="items-listing-user-title" style="width: 200px;" placeholder="<?= _t('', 'ID / login / email автора') ?>" value="<?= ($f['user']>0 ? $user_title : '') ?>" />
    </div>

</div>
</form>

<table class="table table-condensed table-hover admtbl tblhover">
<thead>
    <tr class="header">
        <th width="40">ID</th>
        <th class="left" style="padding-left: 18px;">Заголовок</th>
        <th width="135">
            <a href="javascript: realtyItems.onOrder('created');" class="ajax">Создано</a>
            <div class="order-<?= $f['order_dir'] ?>" <? if($f['order_by']!='created') { ?>style="display:none;"<? } ?> id="realty-order-created"></div>
        </th>
        <th width="85">Действие</th>
    </tr>
</thead>
<tbody id="realty-items-list">
<?= $list ?>
</tbody>
</table>
<div id="realty-items-pgn"><?= $pgn ?></div>
<?= tplAdmin::blockStop(); ?>


<script type="text/javascript">
var realtyItems = (function()
{
    var $progress, $list, $listPgn, filters;
    var url = '<?= $this->adminLink('listing'); ?>';
    var orders = <?= func::php2js($orders) ?>;
    var orderby = '<?= $f['order_by'] ?>';
    var status = <?= $f['status'] ?>;
    var _processing = false; 
    
    $(function(){
        $progress = $('#progress-realty-items');
        $list     = $('#realty-items-list');
        $listPgn  = $('#realty-items-pgn');
        filters   = $('#realty-items-filters').get(0);

        $list.on('click', 'a.item-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });

        var urlAjax = '<?= $this->adminLink('ajax').'&act='; ?>';
        $('#items-listing-user-title').autocomplete( urlAjax+'item-users-autocomplete',
            {valueInput: '#items-listing-user-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    setPage(1);
                    updateList();
                }});

        bff.datepicker('#realty-items-period-from', {yearRange: '-3:+3'});
        bff.datepicker('#realty-items-period-to', {yearRange: '-3:+3'});
              
    });
    
    function isProcessing()
    {
        return _processing;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('Удалить?', id, url+'&act=delete&id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    } 

    function updateList()
    {
        if(isProcessing()) return;
        _processing = true;
        $list.addClass('disabled');
        bff.ajax(url, $(filters).serializeArray(), function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                
                var f = $(filters).serialize();
                if(bff.h) {
                    window.history.pushState({}, document.title, url + '&' + f);
                }
            }
            $list.removeClass('disabled');
            _processing = false;
        }, $progress);
    }
    
    function setPage(id)
    {
        filters.page.value = intval(id);
    }

    return {
        submit: function(resetPage){  
            if(isProcessing()) return false;
            if(resetPage === true) {
                setPage(1);
            }
            updateList();
        },
        page: function (id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        },
        onCategory: function(id)
        {
            setPage(1);
            filters.cat.value = intval(id);
            updateList(true);
        },
        onOrder: function(by)
        {
            if(isProcessing() || !orders[by])
                return;
                
            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            //hide prev order direction
            $('#realty-order-'+orderby).hide();
            //show current order direction
            orderby = by;
            $('#realty-order-'+orderby).removeClass('order-asc order-desc').addClass('order-'+orders[by]).show();
                
            filters.order.value = orderby+'-'+orders[by];
            setPage(1);
            
            updateList();
        }, 
        onStatus: function(statusNew, link)
        {
            if(isProcessing() || status == statusNew) return false;
            status = statusNew;
            setPage(1);
            filters.status.value = statusNew;
            updateList();
            bff.onTab(link);
            return false;
        }
    };
}());

</script>
