<?php

class M_Realty
{
    public static function declareAdminMenu(CMenu $menu, Security $security)
    {
        $sMenuTitle = 'Недвижимость';

        if ($security->haveAccessToModuleToMethod('realty','manage')) {
            $menu->assign($sMenuTitle, 'Список объявлений', 'realty', 'listing', true, 1);
        }
        if ($security->haveAccessToModuleToMethod('realty','claims')) {
            $menu->assign($sMenuTitle, 'Жалобы', 'realty', 'claims', true, 2,
                array('counter'=>'realty_claims'));
        }          
        if ($security->haveAccessToModuleToMethod('realty','settings')) {
            $menu->assign($sMenuTitle, 'Разделы', 'realty', 'categories', true, 5);
            $menu->assign($sMenuTitle, 'Типы', 'realty', 'types', true, 6);
        }

        # Услуги
        if ($security->haveAccessToModuleToMethod('realty','svc')) {
            $menu->assign($sMenuTitle, 'Услуги', 'realty', 'svc_services', true, 30);
        }

        # SEO
        if ($security->haveAccessToModuleToMethod('realty', 'seo')) {
            $menu->assign('SEO', $sMenuTitle, 'realty', 'seo_templates_edit', true, 6);
        }
    }
}
