<?php
/**
 * @var $this Publications
 * @var $type integer
 */
 tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('Добавить раздел', false, array('id'=>'pubCatFormBlock', 'style'=>'display:none;')); ?>
<div class="tabsBar" id="pub-cats-tabs" <?= (!empty($inherits) ? 'style="display:none;"' : '') ?>>
    <span class="tab tab-active" onclick="pubCategories.onTab('new', this);" rel="new"><a href="#" onclick="return false;">Создать новый</a></span>
    <? if($inherits){ ?><span class="tab" onclick="pubCategories.onTab('inherit', this);" rel="inherit"><a href="#" onclick="return false;" class="but but-text chain">Прикрепить существующий</a></span><? } ?>
</div>
<div id="pub-cats-tabs-new">
    <form action="" method="post" name="pubCatFormNew">
        <?= $form; ?>
    </form>
</div>
<?if($inherits):?>
<div id="pub-cats-tabs-inherit" style="display:none;">
    <form action="" method="post" name="pubCatFormInherit">
        <input type="hidden" name="act" value="inherit-finish" />
        <input type="hidden" name="type" value="<?= $type ?>" />
        <input type="hidden" name="filter" value="<?= $filter ?>" />
        <table class="admtbl tbledit">
            <tr>
                <td style="width:130px;">Выберите раздел:</td>
                <td><select name="inherit"></select></td>
            </tr>
            <tr>
                <td>Включен:</td>
                <td><label class="checkbox"><input type="checkbox" name="enabled" checked="checked" /></label></td>
            </tr>
            <tr>
                <td colspan="2" class="row1">
                    <input type="submit" class="btn btn-success button submit" value="Сохранить" />
                    <input type="reset" class="btn button cancel" value="Отмена" onclick="pubCategories.toggle('cancel');" />
                </td>
            </tr>
        </table>
    </form>
</div>
<? endif; ?>
<?= tplAdmin::blockStop() ?>

<?= tplAdmin::blockStart(($type ? '<a href="'.$this->adminLink($typeSettings->keyword.':listing').'">'.$typeSettings->title.'</a> / ' : '').'Список разделов', true, array(), array(
    'title' => '+ добавить раздел', 'onclick'=> 'return pubCategories.toggle(\'add\');',
)); ?>

<div class="tabsBar">
    <span class="tab <?= ! $type ? 'tab-active' : '' ?>"><a href="#" onclick="pubCategories.onType(0); return false;">Общие</a></span>
    <? foreach($types as $k => $v): ?>
    <span class="tab <?= $v->id == $type ? 'tab-active' : '' ?>"><a href="#" onclick="pubCategories.onType(<?= $menu_mini ? $v->id : '\''.$v->keyword.'\'' ?>); return false;"><?= $v->title; ?></a></span>
    <? endforeach; ?>
    <div class="right"><div class="progress" style="display:none;" id="progress-pub-cats"></div></div>
</div>

<table class="table table-condensed table-hover admtbl tblhover" id="pub-cats-table">
    <thead>
    <tr class="header nodrag nodrop">
        <th width="30">&nbsp;</th>
        <th class="left">Название</th>
        <? if($type): ?><th width="100">Публикаций</th><? endif; ?>
        <th width="<?= $subcats ? 105 : 85 ?>">Действие</th>
    </tr>
    </thead>
    <?= $list; ?>
</table>

<div>
    <div class="left">

    </div>
    <div class="right desc" style="width:20px;">
        &darr; &uarr;
    </div>
    <br />
</div>
<?= tplAdmin::blockStop() ?>

<script type="text/javascript">
var pubTypeID = <?= $type ?>;
var pubListURL = '<?= $this->adminLink('categories') ?>&act=';
var pubListFilter = '<?= $filter ?>';
var pubCatInherits = <?= $inherits ? 'true' : 'false' ?>;
var pubCategories = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var $tabs, tabsContent = {};

    $(function(){
        form = document.forms.pubCatFormNew;

        fChecker = new bff.formChecker( form );
        formClean = $(form).html();

        $progress = $('#progress-pub-cats');
        $block = $('#pubCatFormBlock');
        $blockCaption = $block.find('span.caption');
        $list = $('#pub-cats-table');
        $tabs = $('#pub-cats-tabs');
        tabsContent = {
            'new': $('#pub-cats-tabs-new'),
            'inherit': $('#pub-cats-tabs-inherit')
        };

        $list.on('click', 'a.cat-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit(id);
            return false;
        });
        $list.on('click', 'a.sub-cat-add', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) add(id);
            return false;
        });
        $list.on('click', 'a.cat-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, pubListURL+'toggle&type='+pubTypeID, {progress: $progress, link: this});
            }
            return false;
        });
        $list.on('click', 'a.cat-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this, $(this).hasClass('inherited') );
            return false;
        });

        bff.rotateTable('#pub-cats-table', pubListURL+'rotate&type='+pubTypeID, $progress);
    });

    function toggle(type, editData)
    {
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Добавить раздел');
                    if(pubCatInherits) $tabs.show();
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                } else {
                    $block.hide();
                }
            } break;
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {
                $tabs.hide();
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
                form.elements['filter'].value = pubListFilter;
            } break;
        }
        fChecker.check(true, true);
        return false;
    }

    function del(id, link, unInherit)
    {
        if(unInherit)
        {
            bff.ajaxDelete('Открепить раздел?', id,
                pubListURL+'uninherit&cat_id='+id+'&type='+pubTypeID,
                link, {progress: $progress, repaint: false});
        } else {
            bff.ajaxDelete('Удалить раздел?', id,
                pubListURL+'delete&cat_id='+id+'&type='+pubTypeID,
                link, {progress: $progress, repaint: false});
        }
        return false;
    }

    function edit(id)
    {
        bff.ajax(pubListURL+'edit&cat_id='+id+'&type='+pubTypeID,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Редактирование раздела'}, data) );
            }
        }, $progress);
        return false;
    }

    function add(id)
    {
        $block.hide();
        toggle('add');
        var $pid = $(form.elements['pid']);
        $pid.find('[value="'+id+'"]').prop('selected', true);
    }

    var inheritInited = false;
    function onTab(tabKey, tabLink)
    {
        for(var i in tabsContent) {
            tabsContent[i].hide();
        }
        bff.onTab(tabLink);

        if(tabKey == 'inherit' && !inheritInited)
        {
            bff.ajax(pubListURL+'get-inherit&type='+pubTypeID, {}, function(data){
                if(data)
                {
                    var $tab = tabsContent[tabKey];
                    $tab.find(':input[name="inherit"]').html( data.opts );
                    $tab.show();
                    inheritInited = true;
                }
            }, $progress);
        } else {
            tabsContent[tabKey].show();
        }
    }

    return {toggle: toggle, onTab: onTab,
        onType: function(sel) {
            <? if($menu_mini): ?>
            bff.redirect( '<?= $this->adminLink('categories') ?>&type=' + intval(sel) );
            <? else: ?>
            bff.redirect( '<?= $this->adminLink('') ?>'+(sel==0 ? '' : sel+':')+'categories' );
            <? endif; ?>
        },
        collapse:function(cid){
            var sub = $('tr[data-pid="'+cid+'"]');
            if(sub.length) {
                sub.toggle();
            } else {
                bff.ajax(pubListURL+'subs-list<?= $type ? '&type='.$type : '' ?>',{category: cid},function(data){
                    if(data) {
                        $('#dnd-'+cid).after(data);
                        $('tr[data-pid="'+cid+'"]').show();
                        $('#pub-cats-table').tableDnDUpdate();
                    }
                }, '#progress-pub-cats');
            }
        }
    };
}());
</script>