<?php

class PublicationsSettings 
{
    /** @var int ID типа */
    var $id = 0;

    /** @var string Ключ типа */
    var $keyword = '';

    var $title = '';
    var $categories = 0;
    var $subcategories = 0;
    var $tags = 0;
    var $comments = 0;
    var $commentsp = array();
    var $regions = 0;
    var $regions_country = 0;
    var $publicate_date = 0;
    var $publicate_time = 0;
    var $author = 0;
    var $img = false;
    var $imgp = array();
    var $content = 0;
    var $content_pub = array();
    var $users_add = 0;
    var $linkout = '';

    var $extra = array();

    function __construct($aData, $bUnpack = true)
    {
        if($bUnpack) self::unpack($aData);
        foreach($aData as $k=>$v) {
            $this->$k = $v;
        }
        if( ! empty($aData['title'][LNG])){
            $this->title = $aData['title'][LNG];
        }
        if( ! empty($aData['title_'.LNG])){
            $this->title = $aData['title_'.LNG];
        }

    }
    
    # категории
    function categoriesEnabled()
    {
        return ($this->categories > 0);
    }
    function categoriesCustomOnly() // только свои
    {
        return ($this->categories == 1); 
    }
    function categoriesCustomAndCommon() // свои + общие (выборочное наследование)
    {
        return ($this->categories == 2); 
    }
    function categoriesCommonOnly() // только общие (полное наследование)
    {
        return ($this->categories == 3); 
    }
    function subcategoriesEnabled() // подкатегории включены
    {
        return ($this->subcategories > 0);
    }

    # теги 
    function tagsEnabled()
    {
        return ($this->tags > 0);
    }
    function tagsCommon() // общие
    {
        return ($this->tags == 2);
    }
    function tagsCustom() // свои
    {
        return ($this->tags == 1);
    }
    
    # комментарии
    # дополнительные настройки: $this->commentsp
    function commentsEnabled()
    {
        return ($this->comments > 0);
    }
    function commentsTree() // древовидные
    {
        return ($this->comments == 1);
    } 
    function commentsTree2Levels() // древовидные, c ограничением в 2 уровня вложенности
    {
        return ($this->commentsTree() && $this->commentsp['tree2lvl'] );
    }     
    function commentsPlain() // недревовидные (без возможности ответить на комментарий)
    {
        return ($this->comments == 2);
    }
    function commentsFacebook() // комментарии через facebook-api
    {
        return ($this->comments == 3);
    }
    function commentsVk() // комментарии через vkontakte-api
    {
        return ($this->comments == 4);
    }
    function commentsManage() // включены, древовидные или недревовидные, т.е. доступна возможность управления в админ панели
    {
        return (in_array($this->comments, array(1,2)));
    }
    function commentsModeratePre() // включена премодерация комментариев
    {
        return ($this->commentsp['mod'] == 1);
    }
    function commentsModeratePost() // включена постмодерация комментариев
    {
        return ($this->commentsp['mod'] == 0);
    }
    
    # регионы
    function regionsEnabled()
    {
        return ($this->regions > 0);
    }
    function regionsCityOnly() // только город
    {
        return ($this->regions == 1);
    }
    function regionsCountryAndCity() // страна и город
    {
        return ($this->regions == 2);
    }
    function regionsCountryID() // id страны, в случае если "только город"
    {
        return $this->regions_country;
    }

    # дата публикации
    function publicatedDateEnabled() // доступно ли управление датой публикации
    {
        return ($this->publicate_date > 0);
    }
    function publicatedDateEditable() // доступно ли редактирование даты публикации
    {
        return ($this->publicate_date == 2);
    }    

    # время публикации
    function publicatedTimeEnabled() // доступно ли управление временем публикации
    {
        return ($this->publicate_time > 0);
    }
    function publicatedTimeEditable() // доступно ли редактирование времени публикации 
    {
        return ($this->publicate_time == 2);
    }

    # автор
    function authorEnabled()
    {
        return ($this->author>0);
    }
    function authorText() // автор указывается текстом
    {
        return ($this->author==1);
    }
    function authorUser() // автором является пользователь
    {
        return ($this->author==2);
    }  

    # изображение:
    # дополнительные настройки: $this->imgp
    function imgEnabled()
    {
        return !empty($this->img);
    }
    
    # контент:
    # дополнительные настройки для публикатора: $this->content_pub
    function contentPublicator() // контент наполняется через bff\db\Publicator
    {
        return ($this->content == 1);
    }
    function contentWysiwyg() // контент наполняется через Wysiwyg
    {
        return ($this->content == 0);
    }
    function contentJWysiwyg() // контент наполняется через jWysiwyg
    {
        return ($this->content == 3);
    }
    function contentTextarea() // контент наполняется через Textarea
    {
        return ($this->content == 2);
    }
    function contentTypesEnabled() // типы контента
    {
        return !empty($this->content_types); 
    }
    function contentShort() // краткий текст
    {
        return !empty($this->content_short);   
    }

    # модерация:
    # "Возможность добавления пользователем"
    function moderationEnabled()
    {
        return ($this->users_add == 1 || $this->users_add == 2);
    }
    function moderationPre() // c премодерацией
    {
        return ($this->users_add == 1);
    }
    function moderationPost() // c постмодерацией
    {
        return ($this->users_add == 2);
    }
    
    # --------------------------------------------------------------------------------

    /**
     * Формирование имени таблицы записей типа
     * @return string название таблицы
     */
    function table()
    {
        return TABLE_PUB_ITEMS_.$this->keyword;
    }

    /**
    * Запаковываем настройки для записи в базу
    * @param array $aData @ref настройки типа публикации
    */
    static function pack(&$aData)
    {
        $aData['imgp'] = serialize( $aData['imgp'] ); 
        $aData['commentsp'] = serialize( $aData['commentsp'] ); 
        $aData['content_pub'] = serialize( $aData['content_pub'] );
        $aData['extra'] = serialize( $aData['extra'] );
        $aData['users_groups'] = serialize( $aData['users_groups'] );
        
        return true;
    }
    
    /**
    * Распаковываем настройки, для использования
    * @param array $aData @ref настройки типа публикации
    */
    static function unpack(&$aData)
    {
        $aData['imgp'] = (!empty($aData['img']) && !empty($aData['imgp']) && is_string($aData['imgp']) ? unserialize($aData['imgp']) : array());
        if (empty($aData['imgp'])) {
            $aData['imgp'] = self::cleanArray(array(), 'imgp');
        }
        $aData['commentsp'] = (!empty($aData['comments']) && !empty($aData['commentsp']) && is_string($aData['commentsp']) ? unserialize($aData['commentsp']) : array());
        if (empty($aData['commentsp'])) {
            $aData['commentsp'] = self::cleanArray(array(), 'commentsp');
        }            
        $aData['content_pub'] = (!empty($aData['content_pub']) && is_string($aData['content_pub']) ? unserialize($aData['content_pub']) : array());
        if (empty($aData['content_pub'])) {
            $aData['content_pub'] = self::cleanArray(array(), 'content_pub');
        }
        $aData['extra'] = (!empty($aData['extra']) && is_string($aData['extra']) ? unserialize($aData['extra']) : array());
        if (empty($aData['extra'])) {
            $aData['extra'] = self::cleanArray(array(), 'extra');
        }
        $aData['users_groups'] = (!empty($aData['users_groups']) && is_string($aData['users_groups']) ? unserialize($aData['users_groups']) : array());
        if (empty($aData['users_groups'])) {
            $aData['users_groups'] = array();
        }  
        
        return true;         
    }
    
    /**
    * Проверка входящих параметров
    * @param array $aData параметры
    * @param string $sKey тип параметров
    */
    static function cleanArray($aData, $sKey)
    {
        $input = bff::input();
        
        switch ($sKey)
        {
            case 'imgp': {
                return $input->clean_array($aData, array(  
                    'required' => TYPE_BOOL,
                    'sizes'    => TYPE_ARRAY,
                    'size_adm' => TYPE_STR,
                    'size_orig'=> TYPE_STR,
                    'orig'     => TYPE_BOOL, 
                    'text'     => TYPE_BOOL,
                    'wm'       => TYPE_UINT,
                    'wm_img'   => TYPE_STR,
                    'wm_text'  => TYPE_STR,
                    'wm_pos_x' => TYPE_STR,
                    'wm_pos_y' => TYPE_STR,
                    'wm_pos_text_x' => TYPE_STR,
                    'wm_pos_text_y' => TYPE_STR,
                    'crop'          => TYPE_BOOL,
                    'crop_sizes'    => TYPE_STR,
                ));
            } break;
            case 'content_pub': {
                return $input->clean_array($aData, array(
                    'use_wysiwyg' => TYPE_BOOL,
                    'title'       => TYPE_BOOL,
                    //изображения
                    'images_original' => TYPE_BOOL,
                    //photos
                    'photo_enabled'    => TYPE_BOOL,
                    'photo_view_width' => TYPE_UINT,
                    'photo_view_height'=> TYPE_UINT,
                    'photo_view_wm'       => TYPE_BOOL, //watermark
                    'photo_view_wm_src'   => TYPE_STR,
                    'photo_view_wm_pos_x' => TYPE_STR,
                    'photo_view_wm_pos_y' => TYPE_STR,
                    'photo_wysiwyg'    => TYPE_BOOL,
                    //gallery
                    'gallery_enabled'      => TYPE_BOOL,
                    'gallery_view_width'   => TYPE_UINT,
                    'gallery_view_height'  => TYPE_UINT,
                    'gallery_view_wm'       => TYPE_BOOL, //watermark
                    'gallery_view_wm_src'   => TYPE_STR,
                    'gallery_view_wm_pos_x' => TYPE_STR,
                    'gallery_view_wm_pos_y' => TYPE_STR,
                    'gallery_photos_limit' => TYPE_UINT,
                    //video
                    'video_enabled' => TYPE_BOOL,
                    'video_width'   => TYPE_UINT,
                    'video_height'  => TYPE_UINT,
                ));
            } break;
            case 'commentsp' : {
                return $input->clean_array($aData, array(
                    'mod' => TYPE_UINT, 
                    'tree2lvl' => TYPE_BOOL,
                ));                
            } break;
            case 'extra': {
                return $input->clean_array($aData, array(
                    'title_link'  => TYPE_BOOL,
                    'title_link_custom' => TYPE_BOOL,
                    'rss'         => TYPE_BOOL,
                    'xml_yandex'  => TYPE_BOOL, 
                    'source_link' => TYPE_BOOL,
                    'main'        => TYPE_BOOL,
                    'video_top'   => TYPE_BOOL,
                ));
            } break;
        }
    }
    
}