<?php
use bff\db\Publicator;
class PubPublicator extends Publicator
{
    function uploadImageQQ($nRecordID)
    {
        $aResponse = false;
        $aResult = $this->initGalleryUploader($nRecordID)->uploadQQ();
        if (!empty($aResult)) {
            $aURL = $this->galleryUploader->getURL($aResult, $this->getGallerySizes(), $nRecordID == 0);
            $aResponse = array_merge($aResult, $aURL);
        }
        return $aResponse;
    }

    function imagesDelete($aPhotos, $nRecordID = 0)
    {
        if (empty($aPhotos)) return false;

        $bTmp = empty($nRecordID);
        $this->initGalleryUploader($nRecordID);
        foreach ($aPhotos as $v) {
            $aImage = array('filename' => $v);
            $this->galleryUploader->deleteFile($aImage, $bTmp);
        }
        return true;
    }

    function imagesUnTemp($aPhotos, $nRecordID, $aPath, $bCopyTmp = false)
    {
        $aSizes = $this->getGallerySizes();
        $sTmp = $this->sett['images_path_tmp'];
        foreach($aPhotos as $v) {
            foreach ($aSizes as $s) {
                if (file_exists($sTmp.'0'.$s.$v)){
                    @rename($sTmp.'0'.$s.$v, $aPath.$nRecordID.$s.$v);
                }
            }
        }
        if($bCopyTmp) {
            $sMax = self::szView;
            if (array_key_exists(self::szOriginal, $aSizes)) {
                $sMax = self::szOriginal;
            }
            $sName = reset($aPhotos);
            if(file_exists($aPath.$nRecordID.$sMax.$sName)){
                @copy($aPath.$nRecordID.$sMax.$sName, $aPath.$nRecordID.$sMax.'tmp'.$sName);
                return $aPath.$nRecordID.$sMax.'tmp'.$sName;
            }
        }
        return false;
    }

    function recropImages($nRecordID, $sContent)
    {
        $aData = $this->unserialize($sContent);
        if ($nRecordID && ! empty($aData['b']))
        {
            $this->photoUploader = false;
            $uploaderPhoto = $this->initPhotoUploader($nRecordID);

            $this->galleryUploader = false;
            $uploaderGallery = $this->initGalleryUploader($nRecordID);

            $photos = array();
            foreach ($aData['b'] as $b) {
                if (!isset($b['type'])) continue;
                # photo
                if ($b['type'] == self::blockTypePhoto && !empty($b['photo'])) {
                    $photos['photo'][] = $b['photo'];
                    $res = $uploaderPhoto->recropImage(array('filename'=>$b['photo']), 'o');
                    if (! $res){
                        $this->errors->set('Ошибка ресайза изображения (photo): '.$b['photo'].', публикация = '.$nRecordID);
                    }
                }
                # gallery
                if ($b['type'] == self::blockTypeGallery && !empty($b['p'])) {
                    foreach ($b['p'] as $p) {
                        $photos['gallery'][] = $p['photo'];
                        $res = $uploaderGallery->recropImage(array('filename'=>$p['photo']), 'o');
                        if (! $res){
                            $this->errors->set('Ошибка ресайза изображения галереи (gallery): '.$p['photo'].', публикация = '.$nRecordID);
                        }
                    }
                }
            }
        }
    }
}