<?php

class PublicationsItemComments extends bff\db\Comments
{
    /** @var string ключ типа публикации */
    protected $typeKeyword = '';

    var $templateDir = '';

    function initSettings()
    {
        $this->tblComments = TABLE_PUB_COMMENTS;
        $this->tblItemsID  = 'id';
        $this->tblCommentsGroupID = 'type_id';
        # config-ключ для хранения общего счетчика непромодерированных комментариев
        $this->counterKey_UnmoderatedAll = 'pub_comments_mod_';
        # имя поля в таблице объявлений - для хранения кол-ва комментариев объявления(видимых пользователю)
        $this->counterKey_ItemComments = 'comments';
        $this->commentHideReasons[self::commentDeletedByModerator]    = _t('pub', 'Комментарий был удален модератором');
        $this->commentHideReasons[self::commentDeletedByCommentOwner] = _t('pub', 'Комментарий был удален автором комментария');
        $this->commentHideReasons[self::commentDeletedByItemOwner]    = _t('pub', 'Комментарий был удален автором публикации');
        $this->commentHideReasons[self::commentFromBlockedUser]       = _t('pub', 'Комментарий от заблокированного пользователя');
        $this->templateDir = $this->module_dir_tpl;
    }

    public function setGroupID($nGroupID = 0)
    {
        $this->groupID = intval($nGroupID);

        /* @var $aSettings PublicationsSettings */
        $aSettings = Publications::i()->getTypeSettings($nGroupID);

        $this->tblItems = $aSettings->table();
        $this->typeKeyword = $aSettings->keyword;

        $this->commentsTree = $aSettings->commentsTree();
        $this->commentsTree2Levels = $aSettings->commentsTree2Levels();
        $this->preModeration = $aSettings->commentsModeratePre();

        $this->urlListing = $this->adminLink($this->typeKeyword.':comments&item_id=', 'publications');
        $this->urlListingAjax = $this->adminLink('comments_ajax', 'publications');
    }

    public function updateUnmoderatedAllCounter($mIncrement = false)
    {
        $sKey = $this->counterKey_UnmoderatedAll;
        $this->counterKey_UnmoderatedAll = $sKey.'all';
        parent::updateUnmoderatedAllCounter($mIncrement);
        $this->counterKey_UnmoderatedAll = $sKey.$this->typeKeyword;
        parent::updateUnmoderatedAllCounter($mIncrement);
        $this->counterKey_UnmoderatedAll = $sKey;
    }

    public function counterPrefix()
    {
        return $this->counterKey_UnmoderatedAll;
    }

    /**
     * Получение данных обо всех комментариях к записи
     * - в случае с frontend'ом и включенной preModeration: исключаем непромодерированные
     * @param integer $nItemID ID записи
     * @param integer $nCommentLastID ID комментария, с которого следует начать выборку
     * @param boolean $bSimpleTree простое дерево (выполняем только transformRowsToTree)
     * @return array
     */
    public function commentsDataFront($nItemID, $nCommentLastID = 0, $bSimpleTree = false)
    {
        $sql = array();
        $bind = array(':itemID'=>$nItemID);
        if( $nCommentLastID > 0 ) {
            $sql[] = 'C.id > :lastID';
            $bind[':lastID'] = $nCommentLastID;
        }
        # в случае с frontend'ом и включенной preModeration: исключаем непромодерированные
        if( ! bff::adminPanel() ) {
            if( $this->preModeration ) {
                $sql[] = 'C.moderated = 1';
            }
        }
        # учитываем ID группы
        if( $this->isGroupUsed() ) {
            $sql[] = 'C.'.$this->tblCommentsGroupID.' = :groupID';
            $bind[':groupID'] = $this->groupID;
        }
        $aData = $this->db->select('SELECT C.*, U.name as uname, U.blocked as ublocked, U.login, U.avatar, U.sex, U.surname
                FROM '.$this->tblComments.' C
                    LEFT JOIN '.TABLE_USERS.' U ON C.user_id = U.user_id
                WHERE C.item_id = :itemID'.( ! empty($sql) ? ' AND '.join(' AND ', $sql) : ' ' ).'
                ORDER BY C.id ASC', $bind);

        if( ! empty($aData) ) {
            foreach ($aData as $k=>$v) {
                if($v['ublocked'] && ! $v['deleted']) {
                    $aData[$k]['deleted'] = self::commentFromBlockedUser;
                }
            }
            if($bSimpleTree) {
                return array(
                    'total' => sizeof($aData),
                    'aComments' => $this->db->transformRowsToTree($aData, 'id', 'pid', 'sub'),
                );
            }
            return $this->buildCommentsRecursive($aData);
        }
        return array('aComments'=>array(), 'nMaxIdComment'=>0, 'total'=>0);
    }

    /**
     * Общий список комментариев (к разным записям) на модерацию
     * @param integer $nLimit кол-во на страницу
     * @param array $aFilter
     * @return mixed
     */
    public function admListingModerate($nLimit = 15, $aFilter = array())
    {
        $nOffset = $aData['offset'] = $aFilter['offset'];

        $sqlWhere = array();
        if (!empty($aFilter['id'])) {
            if(is_numeric($aFilter['id']) && $aFilter['id'] > 0){
                $sqlWhere[] = 'C.item_id = '.$this->db->str2sql($aFilter['id']);
            }
        }

        if (!empty($aFilter['author'])) {
            $sqlWhere[] = 'C.user_id = '.$aFilter['author'];
        }

        if (!empty($aFilter['p_from'])) {
            $p_from = strtotime($aFilter['p_from']);
            if (!empty($p_from)) {
                $sqlWhere[] = 'DATE(C.created) >= ' . $this->db->str2sql(date('Y-m-d', $p_from));
            }
        }
        if (!empty($aFilter['p_to'])) {
            $p_to = strtotime($aFilter['p_to']);
            if (!empty($p_to)) {
                $sqlWhere[] = 'DATE(C.created) <= ' . $this->db->str2sql(date('Y-m-d', $p_to));
            }
        }

        $aData['comments'] = $this->db->select('SELECT C.*, U.name as uname, U.blocked as ublocked
                FROM ' . $this->tblComments . ' C
                    , ' . TABLE_USERS . ' U
                WHERE C.item_id > 0 AND C.user_id = U.user_id AND C.moderated = 0 AND C.deleted = 0
                    ' . ($this->isGroupUsed() ? ' AND C.' . $this->tblCommentsGroupID . ' = ' . $this->groupID : '') . '
                    '.( ! empty($sqlWhere) ? ' AND '.join(' AND ', $sqlWhere) : '' ).'
                ORDER BY C.id DESC
                ' . $this->db->prepareLimit($nOffset, $nLimit + 1)
        );

        # generate pagenation: prev, next
        # TODO: Pagination
        $this->generatePagenationPrevNext(null, $aData, 'comments', $nLimit, 'jCommentsPgn');

        $this->admListingIncludes();

        $aData['list'] = $this->viewPHP($aData, 'admin.comments.mod.ajax', $this->templateDir);

        if (Request::isAJAX()) {
            $this->ajaxResponse(array(
                    'list' => $aData['list'],
                    'pgn'  => $aData['pgn'],
                )
            );
        } else {
            return $this->viewPHP($aData, 'admin.comments.mod', $this->templateDir);
        }
    }

}