<?php

use bff\img\Thumbnail;
use bff\utils\Files;

class PublicationsImages extends Component
{
    var $itemID = 0;
    var $itemData = array();
    var $typeID = 0;

    /** @var PublicationsSettings object */
    var $typeSettings = array();

    var $path = '';
    var $url = '';
    var $tableItems = '';
    var $maxSize = 0;
    var $saveOriginal = false;

    const szNormal = 'n';

    public function __construct(PublicationsSettings $oTypeSettings, $sItemsTable, array $mItemData)
    {
        $this->init();

        $this->setItemData($mItemData);
        $this->setTypeSettings($oTypeSettings);

        $this->tableItems = $sItemsTable;
        $this->maxSize = Publications::imagesMaxSize();

    }

    public function setItemData(array $mItemData)
    {
        $this->itemID = $mItemData['id'];
        $this->itemData = $mItemData;
    }

    public function setTypeSettings(PublicationsSettings $oTypeSettings)
    {
        $this->typeID = $oTypeSettings->id;
        $this->typeSettings = $oTypeSettings;
        $this->saveOriginal = $this->typeSettings->imgp['orig'];
    }

    public function uploadFromFile($sFileName)
    {
        if (!file_exists($sFileName)) {
            return false;
        }
        $sExtension = Files::getExtension($sFileName);
        $aImageSize = getimagesize($sFileName);
        if ($aImageSize === false
            || !in_array($sExtension, array('jpg','png','gif'))
            || !in_array($aImageSize[2], array(IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_GIF))
        ) {
            return false;
        }

        return $this->save(array(
            'ext'      => $sExtension,
            'tmp_name' => $sFileName,
        ));
    }

    public function upload($sFieldName = 'img')
    {
        do {
            if (empty($_FILES[$sFieldName]) || $_FILES[$sFieldName]['error'] == UPLOAD_ERR_NO_FILE) {
                break;
            }

            $oUpload = new CUploader($sFieldName, false);
            if (!$this->errors->no()) {
                break;
            }

            $sFilenameTmp = $oUpload->getFilenameUploaded();
            # проверяем размер файла
            if (!$oUpload->checkSize($this->maxSize)) {
                break;
            }

            # проверяем тип файла
            $aImageSize = getimagesize($sFilenameTmp);
            $sExtension = Files::getExtension($oUpload->getFilename());
            if ($aImageSize === false
                || !in_array($sExtension, array('gif', 'png', 'jpg'))
                || !in_array($aImageSize[2], array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG))
            ) {
                $this->errors->setUploadError(Errors::FILE_WRONG_TYPE);
                break;
            }

            # сохраняем
            $aResult = $this->save(array(
                    'ext'      => $sExtension,
                    'tmp_name' => $sFilenameTmp,
                ), true
            );

            if ($aResult !== false && $this->itemID > 0) {
                $this->delete(false);
                $this->update($aResult);
            }

            return $aResult;

        } while (false);

        return false;
    }

    public function save($aUploadData)
    {
        $sFilename = func::generator(8, true) . '.' . $aUploadData['ext'];

        $th = new Thumbnail($aUploadData['tmp_name'], false);
        $nQuality = 85;
        $nWidth = $th->getOriginalWidth();
        $nHeight = $th->getOriginalHeight();
        $isJPEG = ($aUploadData['ext'] == 'jpg');

        if ($nWidth < 100 && $nHeight < 100) {
            $this->errors->set(_t('pub', 'Слишком маленькая ширина/высота изображения'));

            return false;
        }

        $aSave = array();

        $sett = $this->typeSettings->imgp;

        # глобальные настройки водяного знака
        if( ! bff::adminPanel()) {
            $watermark = Site::i()->watermarkSettings();
            $watermarkSettings = array();
            if (!empty($watermark['file']['path'])) {
                $watermarkSettings = array(
                    'watermark' => true,
                    'watermark_src' => $watermark['file']['path'],
                    'watermark_pos_x' => $watermark['pos_x'],
                    'watermark_pos_y' => $watermark['pos_y'],
                );
            }
        }


        foreach ($sett['sizes'] as $sz) {
            # p, w, h, wm, crop
            $size = array(
                'filename' => $this->buildPath($sz['p'], $sFilename),
                'width'    => ($sz['w'] > 0 ? $sz['w'] : false),
                'height'   => ($sz['h'] > 0 ? $sz['h'] : false),
                'quality'  => $nQuality,
            );
            /**
             * не накладываем watermark на: GIF/PNG изображения
             * только watermark на основе "изображения"
             */
            if ($isJPEG) {
                if ($sz['wm'] && $sett['wm'] == 1) {
                    $size['watermark'] = true;
                    $size['watermark_src'] = PATH_PUBLIC . $sett['wm_img'];
                    $size['watermark_resizable'] = false;
                    $size['watermark_pos_x'] = $sett['wm_pos_x'];
                    $size['watermark_pos_y'] = $sett['wm_pos_y'];
                }else{
                    if(! bff::adminPanel()) {
                        $size += $watermarkSettings;
                    }
                }
            }

            $aSave[] = $size;
        }

        # сохраняем в оригинальных размерах
        if ($this->saveOriginal) {
            copy($aUploadData['tmp_name'], $this->buildPath($sett['size_orig'], $sFilename));
        }

        if (!$th->save($aSave)) {
            return false;
        }

        return array(
            'filename' => $sFilename,
            'preview'  => $this->buildPath($sett['size_adm'], $sFilename, true),
        );
    }

    public function update($aData)
    {
        $this->db->update($this->tableItems,
            array('img' => $aData['filename'], 'img_crop' => ''),
            array('id' => $this->itemID)
        );
    }

    public function untemp($sFilename)
    {
        if (!empty($sFilename)) {
            $aTmp = array();

            $this->itemData['id'] = 0; # tmp path
            $aSizes = $this->typeSettings->imgp['sizes'];
            foreach ($aSizes as $szPrefix => $v) {
                $aTmp[$szPrefix] = $this->buildPath($szPrefix, $sFilename, false);
            }
            if ($this->saveOriginal) {
                $originalPrefix = $this->typeSettings->imgp['size_orig'];
                $aTmp[$originalPrefix] = $this->buildPath($originalPrefix, $sFilename, false);
            }

            $this->itemData['id'] = $this->itemID; # result path
            foreach ($aSizes as $szPrefix => $v) {
                rename($aTmp[$szPrefix], $this->buildPath($szPrefix, $sFilename, false));
            }
            if ($this->saveOriginal) {
                rename($aTmp[$originalPrefix], $this->buildPath($originalPrefix, $sFilename, false));
            }
        }
    }

    public function crop($sFilename, $x, $y, $w, $h)
    {
        $sett = $this->typeSettings->imgp;
        $sOriginalFilepath = $this->buildPath($sett['size_orig'], $sFilename);
        $th = new Thumbnail($sOriginalFilepath, true);
        $aSave = array();

        $isJPEG = (Files::getExtension($sFilename) == 'jpg');
        foreach ($sett['sizes'] as $sz) {
            if (!$sz['crop']) {
                continue;
            }

            $size = array(
                'filename'    => $this->buildPath($sz['p'], $sFilename),
                'width'       => ($sz['w'] > 0 ? $sz['w'] : false),
                'height'      => ($sz['h'] > 0 ? $sz['h'] : false),
                'src_x'       => $x,
                'src_y'       => $y,
                'crop_width'  => $w,
                'crop_height' => $h, # crop
                'autofit'     => true,
            );
            /**
             * не накладываем watermark на: GIF/PNG изображения
             * только watermark на основе "изображения"
             */
            if ($isJPEG && $sz['wm'] && $sett['wm'] == 1) {
                $size['watermark'] = true;
                $size['watermark_src'] = PATH_PUBLIC . $sett['wm_img'];
                $size['watermark_resizable'] = false;
                $size['watermark_pos_x'] = $sett['wm_pos_x'];
                $size['watermark_pos_y'] = $sett['wm_pos_y'];
            }

            $aSave[] = $size;
        }
        if (empty($aSave)) {
            return false;
        }
        if (!$th->save($aSave)) {
            return false;
        }

        return true;
    }

    public function delete($bDoQuery = false)
    {
        if (!$this->itemID) {
            return;
        }

        $sFilename = $this->db->one_data('SELECT img FROM ' . $this->tableItems . '
                WHERE id = :id', array(':id' => $this->itemID)
        );
        if (!empty($sFilename)) {
            $this->deleteFiles($sFilename);
            if ($bDoQuery) {
                $this->db->update($this->tableItems,
                    array('img' => '', 'img_crop' => ''),
                    array('id' => $this->itemID)
                );
            }
        }
    }

    public function deleteFiles($sFilename)
    {
        if (empty($sFilename)) {
            return false;
        }

        if (is_array($sFilename)) {
            foreach ($sFilename as $file) {
                $this->deleteImageFiles($file);
            }

            return;
        }

        $sett = $this->typeSettings->imgp;

        foreach ($sett['sizes'] as $sz) {
            $path = $this->buildPath($sz['p'], $sFilename);
            if (file_exists($path)) {
                unlink($path);
            }
        }

        if ($this->saveOriginal) {
            $path = $this->buildPath($sett['size_orig'], $sFilename);
            if (file_exists($path)) {
                unlink($path);
            }
        }
    }

    public function buildPath($sSizePrefix = false, $sFilename = false, $bURL = false)
    {
        $aItemData = $this->itemData;
        $aItemData['size'] = $sSizePrefix;
        $aItemData['filename'] = $sFilename;

        return Publications::i()->getImagesPath($bURL, $aItemData, $this->typeSettings);
    }

}