<?php

    $typeID = Job::TYPE_RESUME;
?>
<div class="object realty-view" style="margin-left: 0;">
    <div class="relative">
        <span class="cat f12 grey" style="position:absolute;"><?= _t('', 'Резюме') ?></span>
        <h1><?= $title ?></h1>
    </div>
    <div class="left w430">
        <table class="infoTable">
            <tr>
                <td colspan="2"><a href="<?= Job::url('search', array('type'=>$typeID, 'cat'=>$cat_keyword)) ?>"><?= $cat_title ?></a>, <?= tpl::date_format2($created) ?></td>
            </tr>
            <tr>
                <td width="175"><span class="grey"><?= _t('job', 'Опыт работы:'); ?></span></td>
                <td><?= $this->getExperience($experience, 1); ?></td>
            </tr>
            <tr>
                <td width="175"><span class="grey"><?= _t('job', 'Минимальная зарплата:'); ?></span></td>
                <td><?= tpl::formatPrice($price, $price_curr); ?></td>
            </tr>
            <tr>
                <td width="175"><span class="grey"><?= _t('job', 'График работы:'); ?> </span></td>
                <td><?= $this->getSchedule($schedule, 1); ?></td>
            </tr>
            <tr>
                <td width="175"><span class="grey"><?= _t('', 'Город:'); ?></span></td>
                <td><?= $city_title ?><? $cityChecks = array(); if($city_searchwork) $cityChecks[] = _t('job', 'ищу работу в этом городе'); if($city_readytomove) $cityChecks[] = _t('job', 'возможен переезд');  if(!empty($cityChecks)) { ?>, <span class="f12"><?= join(',', $cityChecks) ?></span><? } ?></td>
            </tr>
            <? if($education){ ?>
                <tr>
                    <td width="175"><span class="grey"><?= _t('job', 'Образование:'); ?> </span></td>
                    <td><?= $this->getEducation($education, 1); ?></td>
                </tr>
            <? } ?>
            <? if($pclevel){ ?>
                <tr>
                    <td width="175"><span class="grey"><?= _t('job', 'Знание ПК [start](уровень)[stop]', array(
                                'start' => '<span class="f11">',
                                'stop'  => '<span>',
                            )); ?>: </span>
                    </td>
                    <td><?= $this->getPCLevel($pclevel, 1); ?></td>
                </tr>
            <? } ?>
            <tr>
                <td width="175"><span class="grey"><?= _t('job', 'Профессиональные навыки:'); ?></span></td>
                <td><?= $description ?></td>
            </tr>
            <? if($company_title != '' && $company_post != ''){ ?>
                <tr>
                    <td colspan="2"><span class="grey"><b><?= _t('job', 'Последнее место работы:'); ?></b></span></td>
                </tr>
                <tr>
                    <td width="175"><span class="grey"><?= _t('job', 'Компания:'); ?></span></td>
                    <td><?= $company_title ?></td>
                </tr>
                <tr>
                    <td width="175"><span class="grey"><?= _t('job', 'Должность:'); ?></span></td>
                    <td><?= $company_post ?></td>
                </tr>
                <? if($company_duty!=''){ ?>
                    <tr>
                        <td width="175"><span class="grey"><?= _t('job', 'Служебные обязанности:'); ?></span></td>
                        <td><?= $company_duty ?></td>
                    </tr>
                <? } ?>
                <? if($company_from!=$company_to){ ?>
                    <tr>
                        <td width="175"><span class="grey"><?= _t('job', 'Период работы:'); ?></span></td>
                        <td><?= _t('', 'с'); ?> <?= tpl::date_format2($company_from) ?> <?= _t('', 'по'); ?> <?= tpl::date_format2($company_to) ?></td>
                    </tr>
                <? } ?>
            <? } ?>
        </table>
        <div class="separator"></div>
        <div class="info">
            <?= $description ?>
        </div>
    </div>
    <div class="right w290 mt20">
        <div class="contacts-realty">
            <?= _t('', 'Контакты'); ?>
            <table class="infoTable">
                <tr><td colspan="2"><?= $fio ?>, <?= tpl::declension($years, _t('', 'год;года;лет')) ?></td></tr>
                <tr><td width="85"><span class="grey"><?= _t('', 'Адрес') ?>:</span></td><td><?= _t('', 'г.'); ?><?= $city_title ?></td></tr>
                <? if (!empty ($email)) { ?><tr><td><span class="grey"><?= _t('', 'Email') ?>:</span></td><td><?= HTML::mailto($email); ?></td></tr><? } ?>
                <tr><td><span class="grey"><?= _t('', 'Телефон') ?>:</span></td><td><?= $phones ?></td></tr>
            </table>
        </div>
    </div>
    <div class="clear"></div>
    <div class="mt20 btn left printButton"><input type="button" onclick="window.print();" value="<?= _t('', 'распечатать'); ?>"><i></i></div>
</div>
