<?php

/**
 * Права доступа группы:
 *  - job: Работа
 *      - vacancy-listing: Cписок вакансий
 *      - vacancy-manage: Управление вакансиями
 *      - resume-listing: Cписок резюме
 *      - resume-manage: Управление резюме
 *      - claims - Жалобы
 *      - settings - Настройки (сферы деятельности)
 */

class Job extends JobBase
{
    function vacancy_listing()
    {
        if ( ! $this->haveAccessTo('vacancy-listing'))
            return $this->showAccessDenied();
        $aData = array('f'=>array());
        
        $sqlTable = TABLE_JOB_VACANCY;

        $act = $this->input->get('act');
        if (Request::isAJAX() || ! empty($act))
        {
            switch ($act)
            {
                case 'delete':
                {

                    $nItemID = $this->input->postget('item_id', TYPE_UINT);
                    if ( ! $nItemID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->vacancyDelete($nItemID);
                    if ( $res ) $this->yandexXML();

                    $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
                case 'items-links-rebuild':
                {
                    $this->model->itemsLinksRebuild();

                    $this->adminRedirect(Errors::SUCCESS, bff::$event);
                } break;
            }
        }

        $aData['orders'] = array('created'=>'desc');

        $this->input->postgetm(array(
            'page'     => TYPE_UINT,
            'category' => TYPE_UINT,  
            'city'     => TYPE_UINT,
            'title'  => TYPE_NOTAGS,
            'status'   => TYPE_UINT,
            'p_from'   => TYPE_STR,
            'p_to'     => TYPE_STR,
            'company'  => TYPE_UINT,
        ), $f);

        $sqlWhere = array();
        $sqlWhere[] = 'I.user_id = U.user_id';
        $sqlWhere[] = 'I.cat_id = C.id';

        $bSearch = false;
        
        if ( ! empty($f['title'])) {
            $sql[] = 'I.id = '.intval($f['title']).' OR I.title LIKE '.$this->db->str2sql('%'.$f['title'].'%');
            $bSearch = true;
        }
        
        if ( ! empty($f['p_from']) ) {
            $p_from = strtotime($f['p_from']);
            if ( ! empty($p_from)) {
                $sqlWhere[] = 'DATE(I.created) >= '.$this->db->str2sql( date('Y-m-d', $p_from) );
                //$bSearch = true;
            }
        }
        if ( ! empty($f['p_to']) ) {
            $p_to = strtotime($f['p_to']);
            if ( ! empty($p_to)) {
                $sqlWhere[] = 'DATE(I.created) <= '.$this->db->str2sql( date('Y-m-d', $p_to) );
                //$bSearch = true;
            }
        }

        if ( ! $bSearch) {
            switch ($f['status']) {
                case 2: $sqlWhere[] = 'I.status = '.self::STATUS_BLOCKED; break;
                case 3: $sqlWhere[] = 'I.moderated != 1'; break;
                case 4: $sqlWhere[] = 'I.status = '.self::STATUS_PUBLICATED_OUT; break;
                case 1: default:
                    $f['status'] = 1;
                    $sqlWhere[] = 'I.status = '.self::STATUS_PUBLICATED;
                    if(static::premoderation()){
                        $sqlWhere[] = 'I.moderated > 0';
                    }
                    break;
            } 
        }
      
        if ($f['category']>0) {
            $sqlWhere[] = 'I.cat_id = '.$f['category'];
        }

        if ($f['city']>0) {
            $sqlWhere[] = 'I.city_id = '.$f['city'];
        }

        if ($f['company']>0) {
            $sqlWhere[] = 'I.company_id = '.$f['company'];
        }

        $sqlWhere = ( ! empty($sqlWhere) ? ' WHERE '.join(' AND ', $sqlWhere) : '' );
        
        $nCount = $this->db->one_data('SELECT COUNT(*) FROM '.$sqlTable.' I, '.TABLE_USERS.' U, '.TABLE_JOB_CATEGORIES.' C '.$sqlWhere); 
        $this->prepareOrder($orderBy, $orderDirection, 'created-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy.'-'.$orderDirection;
        
        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'jobItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);

        $aData['items'] = $this->db->select("SELECT I.id, I.link, I.title, I.created, I.moderated,
                I.user_id, U.email as user_email,
                C.title as cat_title, I.cat_id
            FROM $sqlTable I, ".TABLE_USERS." U, ".TABLE_JOB_CATEGORIES." C
            $sqlWhere 
            ORDER BY I.$orderBy $orderDirection $sqlLimit");

        $aData['list'] = $this->viewPHP($aData, 'admin.listing.vacancy');

        if (Request::isAJAX()) {
            $this->ajaxResponse( array(
                'list'   => $aData['list'],
                'pgn'    => $aData['pgn'],
                'filter' => $f,
            ) );
        }

        $aData['f'] = $f;
        $aData['type'] = static::TYPE_VACANCY;
        tpl::includeJS('datepicker', true);
        return $this->viewPHP($aData, 'admin.listing');
    }
    
    function vacancy_edit()
    {
        if ( ! $this->haveAccessTo('vacancy-manage'))
            return $this->showAccessDenied();
        
        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nItemID) $this->adminRedirect(Errors::UNKNOWNRECORD, 'vacancy_listing');

        if (Request::isAJAX())
        {
            $aResponse = array('success'=>false);
            
            do 
            {
                $aData = $this->processVacancyData(false);

                if ($this->errors->no())
                {
                    # обновляем вакансию
                    $aData['modified'] = $this->db->now();
                    $aData['link'] = static::urlViewVacancy($nItemID, $aData['keyword'], $aData['city_id']);
                    
                    $this->db->update(TABLE_JOB_VACANCY, $aData, array('id'=>$nItemID));
                    $this->yandexXML();
                }

            } while(false);
            
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponse($aResponse);   
        }
        
        $aData = $this->db->one_array('SELECT J.*, IL.title AS item_title, I.link AS item_link,
                                    U.email as user_email, U.blocked as user_blocked
                              FROM '.TABLE_JOB_VACANCY.' J
                                    LEFT JOIN '.TABLE_ITEMS.' I ON J.company_id = I.id
                                    LEFT JOIN '.TABLE_ITEMS_LANG.' IL ON '.$this->db->langAnd(false, 'I', 'IL').'
                                , '.TABLE_USERS.' U
                              WHERE J.id = :id
                                AND U.user_id = J.user_id',
                                array(':id'=>$nItemID));
            
        if (empty($aData)) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'vacancy_listing');
        }

        $aData['cats'] = $this->categoriesOptions($aData['cat_id'], false);
        $aData['schedule_html'] = $this->getSchedule($aData['schedule'], 'radio', 'schedule');
        $aData['curr'] = Site::currencyOptions($aData['price_curr']);

        return $this->viewPHP($aData, 'admin.vacancy.edit');
    }
    
    function ajax()
    {
        $sType = $this->input->post('type', TYPE_STR);
        if ( ! $this->haveAccessTo($sType.'-manage'))
            return $this->showAccessDenied();

        if ( ! in_array($sType, array('vacancy','resume'))) {
            return $this->showImpossible();
        }

        list($sqlTable, $isVacancy, $isResume) = ($sType == 'vacancy' ? array(TABLE_JOB_VACANCY, true, false) : array(TABLE_JOB_RESUME, false, true) );

        switch ($this->input->get('act'))
        {
            case 'item-block': // counters=ok
            {   
                $sReason = $this->input->postget('blocked_reason', TYPE_NOTAGS);
                $sReason  = mb_strcut( $sReason, 0, 300);
                
                $nBlocked = $this->input->post('blocked', TYPE_UINT);
                $nItemID  = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) break;
                
                $aData = $this->db->one_array('SELECT id, status, cat_id, moderated
                    FROM '.$sqlTable.' WHERE id = '.$nItemID);
                if (empty($aData)) break;

                $res = $this->db->exec('UPDATE '.$sqlTable.'
                               SET blocked_reason = :reason,
                                   moderated = 1
                                   '.( ! $nBlocked ? ',
                                   blocked_num = blocked_num + 1,
                                   status_prev = status,
                                   status = '.self::STATUS_BLOCKED.'
                                   ':'').'
                               WHERE id = '.$nItemID, array(':reason'=>$sReason)); 
                               
                if ( ! empty($res) && ! $nBlocked && $aData['status'] == self::STATUS_PUBLICATED) {
                    $this->itemsCounterUpdate($aData['cat_id'], $sType, false);
                }
                if ( ! empty($res) && static::premoderation() && ! $aData['moderated']) {
                    $this->moderationCounter(($isVacancy?self::TYPE_VACANCY:self::TYPE_RESUME));
                }

                if ($isVacancy) $this->yandexXML();
                               
                $this->ajaxResponse( Errors::SUCCESS );
            } break;            
            case 'item-approve': // counters=ok
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID) break;
                $aItem = $this->db->one_array('SELECT user_id, cat_id, status, publicated, publicated_to, moderated
                                '.($isVacancy ? ', company_id ' : '' ).'
                            FROM '.$sqlTable.' WHERE id = '.$nItemID);
                if (empty($aItem) || $aItem['status'] == self::STATUS_PUBLICATED_OUT) break;

                $sql = '';
                if ($aItem['status'] == self::STATUS_BLOCKED)
                {
                    $newStatus = self::STATUS_PUBLICATED_OUT;
                    $now = time();
                    $from = strtotime($aItem['publicated']);
                    $to = strtotime($aItem['publicated_to']);
                    if ( ! empty($from) && ! empty($to) && $now>=$from && $now<$to) {
                        # публикуем, если в момент разблокировки срок публикации объявления еще не истек
                        $newStatus = self::STATUS_PUBLICATED;
                    }
                    $sql = ', status_prev = status, status = '.$newStatus;
                }
                elseif ($aItem['status'] == self::STATUS_NEW)
                {
                    $newStatus = self::STATUS_PUBLICATED;
                    $sql = ', status_prev = status, status = '.$newStatus; 
                }
                
                $res = $this->db->exec('UPDATE '.$sqlTable.'
                               SET moderated = 1'.$sql.'
                               WHERE id = '.$nItemID); 

                if ( ! empty($res) && ! empty($newStatus) && $aItem['status']!=$newStatus && $newStatus == self::STATUS_PUBLICATED)
                {
                    # если опубликовали, накручиваем счетчик в категориях
                    if ( static::premoderation()) {
                        $this->itemsCounterUpdate($aItem['cat_id'], $sType, true);
                    }
                    
                    # накручиваем счетчик вакансий компании, если таковая есть
                    if ($isVacancy && $aItem['company_id']>0) {
                        $this->db->exec('UPDATE '.TABLE_ITEMS.' SET vacancy = vacancy + 1 WHERE id = '.$nItemID);
                    }
                }
                if ( ! empty($res) && static::premoderation() && ! $aItem['moderated']) {
                    $this->moderationCounter(($isVacancy?self::TYPE_VACANCY:self::TYPE_RESUME));
                }

                if ($isVacancy) $this->yandexXML();

                $this->ajaxResponse( Errors::SUCCESS );
            } break; 
            case 'item-publicate2': // counters=ok
            {
                $nItemID = $this->input->post('id', TYPE_UINT); 
                if ( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }
                
                $aItem = $this->db->one_array('SELECT id, status, moderated, publicated, publicated_to, cat_id
                        FROM '.$sqlTable.' WHERE id = '.$nItemID.' AND status != '.self::STATUS_NEW);
                if (empty($aItem)) break;
        
                if ($aItem['status'] == self::STATUS_BLOCKED) {
                    if ($aItem['moderated'] == 0) {
                        $this->errors->set( _t('job', 'Невозможно продлить публикацию, поскольку объявление ожидает проверки') );
                    } else {
                        $this->errors->set( _t('job', 'Невозможно продлить публикацию, поскольку объявление отклонено') );
                    }
                    break;
                }
                
                if ($aItem['status'] == self::STATUS_PUBLICATED) {
                    $this->errors->set( _t('job', 'Невозможно продлить публикацию, поскольку объявление опубликовано') );
                    break;
                }
            
                $nPeriod = $this->input->post('period', TYPE_UINT);
                $publicateTo = $this->preparePublicatePeriodTo( $nPeriod, 
                                ( $aItem['status'] == self::STATUS_PUBLICATED_OUT ? time() : strtotime($aItem['publicated_to']) ) );
                if (empty($publicateTo)) {
                    $this->errors->set( _t('job', 'Период публикации указан некорректно') );
                    break;
                }
                    
                if ( $aItem['status'] == self::STATUS_PUBLICATED_OUT )
                {
                    $toOld = strtotime( $aItem['publicated_to'] );
                    /* если разница между датой снятия с публикации и текущей датой
                     * более 3 дней, тогда поднимаем объявление вверх.
                     * в противном случае: оставлем дату старта публикации(pulicated) и дату порядка публикации(publicated_order) прежними
                     */
                    $bUpdatePublicatedOrder = ((time() - $toOld) > 259200); //60*60*24*3
                    $sqlNOW = $this->db->getNOW();

                    $res = $this->db->exec('UPDATE '.$sqlTable.'
                        SET publicated_to = '.$this->db->str2sql( $publicateTo ).',
                            '.($bUpdatePublicatedOrder ? ' publicated = '.$sqlNOW.', publicated_order = '.$sqlNOW.',' : '').'
                            status_prev = status,
                            status = '.self::STATUS_PUBLICATED.',
                            moderated = 1
                        WHERE id = '.$nItemID.'
                    ');
                    
                    if ( ! empty($res)) {
                        # накручиваем счетчики кол-ва опубликованных объявлений:
                        $this->itemsCounterUpdate($aItem['cat_id'], $sType, true);
                        if (static::premoderation() && ! $aItem['moderated']) {
                            $this->moderationCounter(($isVacancy?self::TYPE_VACANCY:self::TYPE_RESUME));
                        }
                        if ($isVacancy) $this->yandexXML();
                        $this->ajaxResponse(Errors::SUCCESS);
                    }

                } else {
                    // продление опубликованных пока НЕ делаем
//                        $res = $this->db->exec('UPDATE '.$sqlTable.'
//                            SET publicated_to = '.$this->db->str2sql( $publicateTo ).'
//                            WHERE id = '.$nItemID.'
//                        '); 
                }
            } break;
            case 'item-unpublicate': // counters=ok
            {
                $nItemID = $this->input->post('id', TYPE_UINT); 
                if ( ! $nItemID) { $this->ajaxResponse(Errors::IMPOSSIBLE); }
                
                $aItem = $this->db->one_array('SELECT id, status, cat_id, moderated
                        FROM '.$sqlTable.' WHERE id = '.$nItemID.' AND status = '.self::STATUS_PUBLICATED);
                if (empty($aItem)) break;
                if ($aItem['status'] != self::STATUS_PUBLICATED) break;

                $res = $this->db->exec('UPDATE '.$sqlTable.'
                            SET status_prev = status, status = '.self::STATUS_PUBLICATED_OUT.', moderated = 1,
                                publicated_to = '.$this->db->getNOW().' 
                        WHERE id='.$nItemID);
                if ( ! empty($res)) {
                    # откручиваем счетчики кол-ва опубликованных объявлений:
                    $this->itemsCounterUpdate($aItem['cat_id'], $sType, false);
                    if (static::premoderation() && ! $aItem['moderated']) {
                        $this->moderationCounter(($isVacancy?self::TYPE_VACANCY:self::TYPE_RESUME));
                    }
                    if ($isVacancy) $this->yandexXML();
                    $this->ajaxResponse(Errors::SUCCESS);
                }
            } break;
            case 'item-users-autocomplete': # autocomplete
            {
                $sQ = $this->input->post('q', TYPE_NOTAGS);
                $aData = Users::model()->autocomplete($sQ);
                $this->autocompleteResponse($aData, 'user_id', 'title');
            }
                break;


        }
        $this->ajaxResponse( Errors::IMPOSSIBLE ); 
    }
    
    # -----------------------------------------------------------------------------------
    # Резюме
    
    function resume_listing()
    {
        if ( ! $this->haveAccessTo('resume-listing'))
            return $this->showAccessDenied();
        $aData = array('f'=>array());
        
        $sqlTable = TABLE_JOB_RESUME;

        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'delete':
                {

                    $nItemID = $this->input->postget('item_id', TYPE_UINT);
                    if ( ! $nItemID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->resumeDelete($nItemID);
                    
                    $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
            }
        }

        $aData['orders'] = array('created'=>'desc');

        $this->input->postgetm(array(
            'page'     => TYPE_UINT,
            'category' => TYPE_UINT,  
            'city'     => TYPE_UINT,
            'title'  => TYPE_NOTAGS,
            'status'   => TYPE_UINT,
            'p_from'   => TYPE_STR,
            'p_to'     => TYPE_STR,
            'user'   => TYPE_UINT,
        ), $f);

        $sqlWhere = array();
        $sqlWhere[] = 'I.user_id = U.user_id';
        $sqlWhere[] = 'I.cat_id = C.id';

        $bSearch = false;
        
        if ( ! empty($f['title'])) {
            $sql[] = 'I.id = '.intval($f['title']).' OR I.title LIKE '.$this->db->str2sql('%'.$f['title'].'%');
            $bSearch = true;
        }
        
        if ( ! empty($f['p_from']) ) {
            $p_from = strtotime($f['p_from']);
            if ( ! empty($p_from)) {
                $sqlWhere[] = 'DATE(I.created) >= '.$this->db->str2sql( date('Y-m-d', $p_from) );
                //$bSearch = true;
            }
        }
        if ( ! empty($f['p_to']) ) {
            $p_to = strtotime($f['p_to']);
            if ( ! empty($p_to)) {
                $sqlWhere[] = 'DATE(I.created) <= '.$this->db->str2sql( date('Y-m-d', $p_to) );
                //$bSearch = true;
            }
        }

        if ( ! $bSearch) {
            switch ($f['status']) {
                case 2: $sqlWhere[] = 'I.status = '.self::STATUS_BLOCKED; break;
                case 3: $sqlWhere[] = 'I.moderated != 1'; break;
                case 4: $sqlWhere[] = 'I.status = '.self::STATUS_PUBLICATED_OUT; break;
                case 1: default:
                $f['status'] = 1;
                $sqlWhere[] = 'I.status = '.self::STATUS_PUBLICATED;
                if(static::premoderation()){
                    $sqlWhere[] = 'I.moderated > 0';
                }
                break;
            } 
        }
      
        if ($f['category']>0) {
            $sqlWhere[] = 'I.cat_id = '.$f['category'];
        }

        if ($f['city']>0) {
            $sqlWhere[] = 'I.city_id = '.$f['city'];
        }

        if($f['user'] > 0){
            $sqlWhere[] = 'I.user_id = '.$f['user'];
        }

        
        $sqlWhere = ( ! empty($sqlWhere) ? ' WHERE '.join(' AND ', $sqlWhere) : '' );
        
        $nCount = $this->db->one_data('SELECT COUNT(*) FROM '.$sqlTable.' I, '.TABLE_USERS.' U, '.TABLE_JOB_CATEGORIES.' C '.$sqlWhere); 
        $this->prepareOrder($orderBy, $orderDirection, 'created-desc', $aData['orders']);
        $this->tplAssigned(array('order_by', 'order_dir', 'order_dir_needed'), $f);
        $f['order'] = $orderBy.'-'.$orderDirection;
        
        $aData['pgn'] = $this->generatePagenation($nCount, 15, 'jobItems.page({pageId})', $sqlLimit, 'pagenation.ajax.tpl', 'page', true);

        $aData['items'] = $this->db->select("SELECT I.id, I.link, I.title, I.created, I.moderated,
                I.user_id, U.email as user_email,
                C.title as cat_title, I.cat_id
            FROM $sqlTable I, ".TABLE_USERS." U, ".TABLE_JOB_CATEGORIES." C
            $sqlWhere 
            ORDER BY I.$orderBy $orderDirection $sqlLimit");

        $aData['list'] = $this->viewPHP($aData, 'admin.listing.resume');

        if (Request::isAJAX()) {
            $this->ajaxResponse(array(
                'list'   => $aData['list'],
                'pgn'    => $aData['pgn'],
                'filter' => $f,
            ));
        }
        if($f['user']){
            $aUser = Users::model()->userData($f['user'], array('login', 'email'));
            $aData['agent_title'] = '#'.$f['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        tpl::includeJS('autocomplete', true);


        $aData['f'] = $f;
        $aData['type'] = static::TYPE_RESUME;
        return $this->viewPHP($aData, 'admin.listing');
    }

    function resume_edit()
    {
        if ( ! $this->haveAccessTo('resume-manage'))
            return $this->showAccessDenied();
        
        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nItemID) $this->adminRedirect(Errors::UNKNOWNRECORD, 'resume_listing');

        if (Request::isAJAX())
        {
            $aResponse = array('success'=>false);
            
            do 
            {
                $aData = $this->processResumeData(false);

                if ($this->errors->no())
                {
                    # обновляем резюме
                    $aData['modified'] = $this->db->now();
                    $aData['link'] = static::urlViewResume($nItemID, $aData['keyword'], $aData['city_id']);
                    
                    $this->db->update(TABLE_JOB_RESUME, $aData, array('id'=>$nItemID));
                }

            } while(false);
            
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponse($aResponse);
        }
        
        $aData = $this->db->one_array('SELECT J.*, U.email as user_email, U.blocked as user_blocked
                              FROM '.TABLE_JOB_RESUME.' J, '.TABLE_USERS.' U
                              WHERE J.id = '.$nItemID.' 
                                AND U.user_id = J.user_id');
            
        if (empty($aData)) {
            $this->adminRedirect(Errors::IMPOSSIBLE, 'resume_listing');
        }

        $aData['experience_html'] = $this->getExperience($aData['experience'], 'options');
        $aData['cats'] = $this->categoriesOptions($aData['cat_id'], false);
        $aData['schedule_html'] = $this->getSchedule($aData['schedule'], 'radio', 'schedule');
        $aData['curr'] = Site::currencyOptions($aData['price_curr']);
        $aData['phones'] = $this->resumePhonesPrepareEdit( $aData['phones'] );

        return $this->viewPHP($aData, 'admin.resume.edit');
    }
    
    function claims()
    {
        if ( ! $this->haveAccessTo('claims') )
            return $this->showAccessDenied();
 
        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'delete':
                {

                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID)
                    {
                        $aData = $this->db->one_array('SELECT id, viewed FROM '.TABLE_JOB_CLAIMS.' WHERE id = :id', array(':id'=>$nClaimID));
                        if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                        
                        $aResponse = array('counter_update'=>false);
                        $res = $this->db->exec('DELETE FROM '.TABLE_JOB_CLAIMS.' WHERE id = :id', array(':id'=>$nClaimID));
                        if ($res && ! $aData['viewed']) {
                            config::saveCount('job_claims', -1, true);
                            $aResponse['counter_update'] = true;
                        }
                        $aResponse['res'] = $res;
                        $this->ajaxResponse( $aResponse );
                    }
                } break; 
                case 'view':
                {
                    $nClaimID = $this->input->post('id', TYPE_UINT);
                    if ($nClaimID) {
                        $res = $this->db->exec('UPDATE '.TABLE_JOB_CLAIMS.' SET viewed = 1 WHERE id = :id', array(':id'=>$nClaimID));
                        if ($res) config::saveCount('job_claims', -1, true);
                        $this->ajaxResponse(Errors::SUCCESS);
                    }
                } break;
            }
            $this->ajaxResponse(Errors::IMPOSSIBLE);
        } 

        $aData = $this->input->getm(array(
            'item'    => TYPE_UINT,
            'type'    => TYPE_UINT,
            'page'    => TYPE_UINT,
            'perpage' => TYPE_UINT,
            'user'    => TYPE_UINT,
        ));

        if ( ! in_array($aData['type'], array(self::TYPE_VACANCY, self::TYPE_RESUME))) {
            $aData['type'] = self::TYPE_VACANCY;
        }

        $sqlWhere = array();
        $sqlWhere[] = 'CL.type_id = '.$aData['type'];
        if ($aData['item']) {
            $sqlWhere[] = 'CL.item_id = '.$aData['item'];
        }
        if($aData['user']) {
            $sqlWhere[] = 'CL.user_id = '.$aData['user'];
        }

        $nCount = $this->db->one_data('SELECT COUNT(CL.id) FROM '.TABLE_JOB_CLAIMS.' CL '.( ! empty($sqlWhere) ? 'WHERE '.join(' AND ', $sqlWhere) : ''));
        $aOrdersAllowed = array('CL.created'=>'desc');
        $this->prepareOrder($orderBy, $orderDirection, 'CL.created-desc', $aOrdersAllowed);

        $aPerpage = $this->preparePerpage($aData['perpage'], array(20,40,60));
        
        $aData['order'] = "$orderBy,$orderDirection";
        $sFilter = http_build_query($aData); unset($aData['page']);
        $aData['pgn'] = $this->generatePagenation($nCount, $aData['perpage'], $this->adminLink("claims&$sFilter&{pageId}"), $sqlLimit);
        $aData['f'] = $sFilter;

        if ($nCount>0) {
            $sqlWhere[] = ' CL.item_id = I.id ';

            $aData['list'] = $this->db->select('SELECT CL.*, 0 as other, I.link
                        FROM '.TABLE_JOB_CLAIMS.' CL,
                             '.($aData['type'] == self::TYPE_RESUME ? TABLE_JOB_RESUME : TABLE_JOB_VACANCY).' I
                        WHERE '.join(' AND ', $sqlWhere).'
                        ORDER BY '.$orderBy.' '.$orderDirection.' '.$sqlLimit);
        } else {
            $aData['list'] = array();
        }
        
        $reasons = $this->getClaimReasons();
        if ( ! empty($aData['list']) && ! empty($reasons))
        {
            foreach($aData['list'] as &$v)
            {
                $v['link'] = Job::url('view', $v['link']);
                $r = $v['reasons'];
                if ($r==0) continue;

                $r_text = array();
                foreach($reasons as $rk=>$rv) {
                    if ($rk!=32 && $rk & $r) {
                        $r_text[] = $rv;
                    }
                }
                $v['reasons_text'] = join(', ', $r_text);
                $v['other'] = $r & 32;
            } unset($v);
        }

        $aData['perpage'] = $aPerpage;
        if($aData['user']){
            $aUser = Users::model()->userData($aData['user'], array('login', 'email'));
            $aData['user_title'] = '#'.$aData['user'].' '.$aUser['login'].' ('.$aUser['email'].')';
        }
        return $this->viewPHP($aData, 'admin.claims.listing');
    }
    
    function categories()
    {
        if ( ! $this->haveAccessTo('settings'))
            return $this->showAccessDenied();

        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_JOB_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langSelect($nCategoryID, $aData, $this->model->langCategories, TABLE_JOB_CATEGORIES_LANG);

                    $aResponse['form'] = $this->viewPHP($aData, 'admin.categories.form');

                    $this->ajaxResponse( $aResponse ); 
                } break;
                case 'toggle':
                {
                    $nCategoryID = $this->input->postget('rec', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->toggleInt(TABLE_JOB_CATEGORIES, $nCategoryID, 'enabled');
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'rotate':
                {
                    $this->db->rotateTablednd(TABLE_JOB_CATEGORIES, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $nCategoryID = $this->input->get('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $res = $this->db->delete(TABLE_JOB_CATEGORIES, $nCategoryID);
                    if ( ! empty($res)) {
                        $this->db->delete(TABLE_JOB_CATEGORIES_LANG, array('id'=>$nCategoryID));
                    }
                    
                    $this->ajaxResponse( ( ! empty($res) ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                } break;
            }
        } 
        else if (Request::isPOST())
        {

            switch ($this->input->postget('act'))
            {
                case 'add-finish': 
                {
                    $aDataAll = $this->categoriesProcessData(0);
                    $aData = array_diff_key($aDataAll, $this->model->langCategories);
                    $aData['title'] = $aDataAll['title'][LNG];

                    
                    $nNum = $this->db->one_data('SELECT MAX(num) FROM '.TABLE_JOB_CATEGORIES);
                    $aData['num'] = intval($nNum) + 1;
                    if ($this->errors->no())
                    {
                        $nCategoryID = $this->db->insert(TABLE_JOB_CATEGORIES, $aData);
                        $this->db->langInsert($nCategoryID, $aDataAll, $this->model->langCategories, TABLE_JOB_CATEGORIES_LANG);
                    }
                    
                } break;
                case 'edit-finish':
                {
                    $nCategoryID = $this->input->post('cat_id', TYPE_UINT);
                    if ( ! $nCategoryID) $this->errors->unknownRecord();
                    
                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_JOB_CATEGORIES.' WHERE id = '.$nCategoryID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();

                    $aDataAll = $this->categoriesProcessData($nCategoryID);
                    $aData = array_diff_key($aDataAll, $this->model->langCategories);
                    $aData['title'] = $aDataAll['title'][LNG];

                    # попытка изменения keyword'a категории
                    if ($aData['keyword'] !== $aDataCur['keyword'])
                    {
                        if ( $this->isKeywordExists($aData['keyword'], TABLE_JOB_CATEGORIES, $nCategoryID) ) {
                            $this->errors->set( _t('job', 'Данный keyword уже используется') );
                        }
                    }

                    if ($this->errors->no())
                    {
                        $this->db->update(TABLE_JOB_CATEGORIES, $aData, array('id'=>$nCategoryID));
                        $this->db->langUpdate($nCategoryID, $aDataAll, $this->model->langCategories, TABLE_JOB_CATEGORIES_LANG);
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event);
        }
        
        $aData = $this->categoriesProcessData(false);
        $aData['id'] = 0;
        $aData['cats'] = $this->db->select('
            SELECT C.id, CL.title, C.enabled
            FROM '.TABLE_JOB_CATEGORIES.' C,
                 '.TABLE_JOB_CATEGORIES_LANG.' CL
            WHERE '.$this->db->langAnd(false, 'C', 'CL').'
            ORDER BY C.num');

        $aData['form'] = $this->viewPHP($aData, 'admin.categories.form');
        return $this->viewPHP($aData, 'admin.categories.listing');
    }

    //-------------------------------------------------------------------------------------------------------------------------------
    // Услуги

    public function svc_services()
    {
        if ( ! $this->haveAccessTo('svc'))
            return $this->showAccessDenied();

        $svc = $this->svc()->model;

        if (Request::isAJAX())
        {
            $aResponse = array();

            switch ( $this->input->getpost('act') )
            {
                case 'update':
                {
                    $nSvcID = $this->input->post('id', TYPE_UINT);
                    if ( ! $nSvcID) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $aData = $svc->svcData( $nSvcID, array('id','type','keyword') );
                    if (empty($aData) || $aData['type'] != Svc::TYPE_SERVICE) {
                        $this->errors->unknownRecord();
                        break;
                    }

                    $this->svcValidateData($nSvcID, Svc::TYPE_SERVICE, $aDataSave);

                    if ( $this->errors->no() ) {
                        $svc->svcSave( $nSvcID, $aDataSave);
                        $aResponse['modified'] = tpl::date_format2(BFF_NOW, true).', <a class="bold desc" href="#" onclick="return bff.userinfo('.User::id().');">'.User::data('login').'</a>';
                    }

                } break;
                default: {
                $this->errors->impossible();
                } break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aData = array(
            'svc' => $svc->svcListing(Svc::TYPE_SERVICE, $this->module_name),
        );

        foreach($aData['svc'] as $k => $v){
            $aData['svc'][$k]['typeBySvc'] = $this->typeBySvc($v['id']);
        }

        tpl::includeJS(array('wysiwyg'), true);
        return $this->viewPHP($aData, 'admin.services');
    }

    /**
     * Проверка данных услуги / пакета услуг
     * @param integer $nSvcID ID услуги / пакета услуг
     * @param integer $nType тип Svc::TYPE_
     * @param array $aData @ref проверенные данные
     */
    function svcValidateData($nSvcID, $nType, &$aData)
    {
        $aParams = array(
            'price' => TYPE_PRICE
        );

        if ($nType == Svc::TYPE_SERVICE)
        {
            $aSettings = array(
                'on' => TYPE_BOOL, // включена
            );
            $aSettingsLang = array(
                'description' => TYPE_STR, // описание
            );

            switch ($nSvcID)
            {
                case self::SERVICE_RESUME_UP:
                {

                } break;
                case self::SERVICE_RESUME_MARK:
                {

                } break;
                case self::SERVICE_RESUME_FIX:
                {

                } break;
                case self::SERVICE_VACANCY_UP:
                {

                } break;
                case self::SERVICE_VACANCY_MARK:
                {

                } break;
                case self::SERVICE_VACANCY_FIX:
                {

                } break;
            }

            $aData = $this->input->postm($aParams);
            $aData['settings'] = $this->input->postm($aSettings);
            $this->input->postm_lang($aSettingsLang, $aData['settings']);

            if (Request::isPOST())
            {
                //
            }
        }
    }

}