<?php
    if( ! bff::servicesEnabled()) return;
    $svc = Svc::model()->svcListing(Svc::TYPE_SERVICE, $this->module_name);
    $vip = $svc['vip'];
    $psystems = Bills::getPaySystems(false);
    $currency = Site::currencyDefault();
    $balance  = User::balance();

    $paySystemsBlock = function($nSvcPrice) use ($balance, $psystems)
    {
        if ($balance >= $nSvcPrice || empty($psystems)) {
            return;
        }

        reset($psystems);
        ?><input type="hidden" name="ps" value="<?= key($psystems); ?>" /><?
        if (sizeof($psystems) > 1) {
            ?>
            <div class="pay-systems mb15">
                <? $i = 0; foreach($psystems as $k=>$v) { ?>
                <div class="item<? if(!$i++){ ?> active<? } ?> <?= $v['class'] ?>" data-ps="<?= HTML::escape($k) ?>">
                    <div class="text"><a href="javascript:void(0);"><?= $v['title'] ?></a></div>
                </div>
                <? } ?>
                <div class="clear"></div>
            </div>
            <?
        }
    };
?>
<script type="text/javascript">
<? js::start(); ?>
var jItemsPromote = (function(){
    var popup;

    $(function(){
        // promote
        popup = app.popup('items-vip', '#popup-items-vip', false, { onInit: function($popup)
        {
            var processing = false;
            var $err = $('div.error', $popup), $progress = $('.progress', $popup), $btn = $('input.submit', $popup);
            $('form:first', $popup).submit(function(){
                if(processing) return false;
                processing = true;
                var $form = $(this);
                $btn.prop('disabled', true).val('<?= _t('', 'подождите...') ?>');
                bff.ajax('/user/profile?t=items&act=vip', $form.serialize(), function(data, errors){
                    if(data && data.success) {
                        if( data.pay ) {
                            app.pay(data.form);
                        } else {
                            location.reload();
                        }
                    } else {
                        app.showError($err, errors);
                        $btn.prop('disabled', false).val('<?= _t('', 'оплатить') ?>');
                    }
                    processing = false;
                }, $progress);
                return false;
            });

            $popup.on('click', '.pay-systems .item', function(e){
                nothing(e);
                var $form = $(this).closest('form');
                $form.find('[name="ps"]').val( $(this).data('ps') );
                $(this).addClass('active').siblings().removeClass('active');
            });
        } } );
    });

    return {
        vip: function(id, date, activate, $link, e)
        {
            var $popup = popup.getPopup();
            $('#item-vip-id', $popup).val(id);
            $('#item-vip-period', $popup).text(date);
            popup.show(e);
        }
    };
}());
<? js::stop(); ?>
</script>

<div class="popup displaynone" id="popup-items-vip" style="width: 600px; margin-left: -270px;">
    <div class="popup-title"><?= _t('items', 'Приоритетное размещение') ?></div>
    <div class="error" style="display: none;"></div>
    <div class="close"><span>x</span> <a href="#" class="close"><?= _t('', 'закрыть') ?></a></div>
    <div class="content-popup">
        <form method="get">
        <input type="hidden" name="id" value="0" id="item-vip-id" />
        <input type="hidden" name="svc" value="<?= Items::SERVICE_VIP ?>" />
        <input type="hidden" name="ps" value="0" id="item-vip-ps" />
        <input type="hidden" name="hash" value="<?= $this->security->getToken(); ?>" />
        <table class="t-popup" style="margin-left: 35px;">
            <tr>
                <td colspan="2">
                    <div class="mb15"><?= $vip['descr'][LNG] ?></div>
                    <? $paySystemsBlock($vip['price']); ?>
                    <?= _t('items', 'Оплатить приоритетное размещение до') ?> <b class="vip_date_to" id="item-vip-period"></b>
                    <br />
                    <?= _t('', 'Стоимость: [price]', array('price'=>' <b class="red">'.$vip['price'].' '.$currency.'</b>')) ?>
                    <br />
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <div class="btn mr10 left"><input type="submit" value="<?= _t('', 'оплатить') ?>" tabindex="2" /><i></i></div>
                    <div class="left"><a href="#" class="close"><?= _t('', 'отмена') ?></a></div>
                </td>
            </tr>
        </table>
        </form>
    </div>
</div>