<?php

    $vipActivateDate = tpl::date_format2( strtotime('+1 year'));
?>

<ul class="val-sp u-sub-menu mb20" id="j-items-user-menu">
    <li class="active"><a href="#" class="ajax" onclick="return itemsUserItems.listFilter(0, this);"><?= _t('', 'Все') ?></a></li>
    <li><a href="#" class="ajax" onclick="return itemsUserItems.listFilter(1, this);"><?= _t('', 'На карте') ?></a></li>
    <li><a href="#" class="ajax" onclick="return itemsUserItems.listFilter(2, this);"><?= _t('items', 'Заявки') ?></a></li>
</ul>

<div class="error" style="display: none;"></div>
<div class="realty">
    <div class="realty-list">
        <table id="j-items-user-list" width="100%" >
        <? foreach($items as $v){
            $itemUrl = Items::url('view', $v['link']);
            ?>
            <tr class="item <?= ($v['request']? 'j-r' : 'j-a') ?>">
                <td class="image">
                    <img alt="" src="<?= $v['img_list'] ?>" class="left" width="150" />
                </td>
                <td>
                    <a href="<?= $itemUrl ?>"><b><?= $v['title'] ?></b></a>
                    <div class="f12 mt5">
                        <span class="grey"><?= $v['address']; ?></span><br/>
                        <span class="grey"><?= $v['cats']; ?></span>
                    </div>
                </td>
                <td class="manage" style="width: 250px !important;">
                    <? if($v['request']) { ?>
                        <span class="grey"><?= _t('items', 'Заявка находится на рассмотрении') ?></span>
                    <? } else {
                        if($v['vip']) {
                        ?>
                            <? if(!empty($vip['on'])){ ?><span><?= _t('items', 'Приоритетное размещение до') ?> <b><?= tpl::date_format_pub($v['vip_expire'], 'd.m.Y') ?></b></span> (<a href="#"  onclick="jItemsPromote.vip(<?= $v['id'] ?>, '<?= tpl::date_format2( strtotime('+1 year', strtotime($v['vip_expire'])) ) ?>', 0, this, event);"><?= _t('', 'продлить') ?></a>)<br /><? } ?>
                            <? if($v['vacancy'] > 0){ ?><a href="<?= Items::url('view', array('link'=>$v['link'],'tab'=>'vacancy')); ?>"><?= _t('job', 'Вакансии') ?></a><? } ?><br />
                            <a href="#" onclick="return itemsUserItems.edit(<?= $v['id'] ?>, true);"><i class="iconlink fa fa-edit grey"></i><?= _t('', 'Редактировать') ?></a>
                        <? } else { ?>
                            <? if(!empty($vip['on'])){ ?><a href="#" onclick="jItemsPromote.vip(<?= $v['id'] ?>, '<?= $vipActivateDate ?>', 1, this, event);"><?= _t('items', 'Приоритетное размещение') ?></a><br />
                            <span class="grey"><?= $vip['descr_listing'][LNG] ?></span><br /><? } ?>
                            <? if($v['vacancy'] > 0){ ?><a href="<?= Items::url('view', array('link'=>$v['link'],'tab'=>'vacancy')); ?>"><?= _t('job', 'Вакансии') ?></a><br /><br /><? } ?>
                    <? } } ?>
                </td>
            </tr>
        <? } ?>
        </table>
        <div id="j-items-user-edit"></div>
    </div>
</div>

<script type="text/javascript">
<? js::start(); ?>
var itemsUserItems = (function(){
    var $itemMenu, $itemsBlock, $items, $editBlock, $err, processing = false;
    $(function(){
        $itemMenu = $('#j-items-user-menu');
        $itemsBlock = $('#j-items-user-list');
        $items = $itemsBlock.find('tr');
        $err = $itemsBlock.prev();
        $editBlock = $('#j-items-user-edit');
    });

    function initContacts($block, fieldname, index, lmt) {
        var total = index;
        var $plus  = $('a.contact-add', $block.parent());

        $plus.click(function(){
            if(lmt>0 && total>=lmt) { return false; }
            index++; total++;
            $block.append('<div class="contact-item"><div class="inp inp-w3 left mr10"><input type="text" maxlength="200" name="'+fieldname+'['+index+']" value="" /><i></i></div><a href="#" class="ajax f12 contact-remove">- <?= _t('', 'Удалить') ?></a><div class="clear"></div></div>');
            return false;
        });
        
        $block.delegate('a.contact-remove', 'click', function(){
            $(this).parent().remove(); total--;
            return false;
        });
    }
    
    return {
        edit: function(id, init)
        {
            if(id === false) {
                 $err.hide();
                 $editBlock.hide().html('');
                 $itemMenu.show();
                 $items.show();
                 return false;
            }
            
            if(processing) return false;
            processing = true;
            
            if(init)
            {
                bff.ajax('/user/profile?t=items&act=edit', {save: 0, id: id, hash: app.csrf_nonce}, function(data, errors){
                    if(data && data.success) {
                        $editBlock.html(data.form);
                        initContacts( $('.item_edit_phones', $editBlock), 'phones', data.phones, 3);
                        initContacts( $('.item_edit_sites', $editBlock),  'sites', data.sites, 3);
                        initContacts( $('.item_edit_emails', $editBlock), 'emails', data.emails, 3);                                 
                        $editBlock.show();
                        $itemMenu.hide();
                        $items.hide();
                    } else {
                        if(errors) {
                            app.showError($err, errors);
                        }
                    }
                    processing = false;
                });       
            } else {
                bff.ajax('/user/profile?t=items&act=edit', $('form:first', $editBlock).serialize(), function(data, errors){
                    if(data && data.success) {
                        app.showError($err, '<?= _t('', 'Данные были успешно сохранены') ?>', true);
                        setTimeout(function(){
                            itemsUserItems.edit(false);
                        }, 1500);                        
                    } else {
                        if(errors) {
                            app.showError($err, errors);
                        }
                    }
                    processing = false;
                }, function(show) {
                    $editBlock.toggleClass('disabled');
                });
            }
            return false;
        },
        listFilter: function(type, link)
        {
            var cl = false;
            switch(type) {
                case 0: cl = false; break; // все
                case 1: cl = '.j-a'; break; // на карте
                case 2: cl = '.j-r'; break; // заявки
            }
            $(link).parent().addClass('active').siblings().removeClass('active');
            if(cl===false) $items.show(); else $items.hide().filter(cl).show();
            
            return false;
        }
    };
}());
<? js::stop(); ?>
</script>

<?
    if( ! empty($vip['on'])) {
        $aDataPromote = array();
        echo $this->viewPHP($aDataPromote, 'promote.popup');
    }
?>