<?php
    tpl::includeJS(array('history'), false);
    $urlPhones = Items::url('phones');
    $cat_pid = ($cat_id > 0 ? $cat['pid'] : 0);
?>
<div class="h1-wrap">
    <h1><?= ( $cat_id > 0 && ! empty($cat['titleh1']) ? $cat['titleh1'] : ( ! empty($titleh1) ? $titleh1 : _t('items', 'Телефоны') ) ) ?></h1>
</div>
<div class="information mb10">
    <div class="inform-nav" style="width: 330px;">
        <p class="inform-att mb15"><?= _t('items', 'Воспользуйтесь категориями, чтобы найти телефоны нужных вам организаций') ?><i></i></p>
        <ul class="inform-nav-in" id="items_phones_cats">
            <? foreach($cats as $v){ ?>
                <li <? if($v['id']==$cat_pid){?>class="active"<? } ?>>
                    <span onclick="$(this).next().toggle().end().parent().toggleClass('active');"><?= $v['title'] ?> <i></i></span>
                    <ul class="sub" <? if($v['id']!=$cat_pid){ ?>style="display: none;"<? } ?>>
                        <? foreach($v['sub'] as $v2){ ?>
                            <li data-id="<?= $v2['id'] ?>" <? if($v2['a']){?>class="active"<?} ?>><a href="<?= $v2['url'] ?>"><?= $v2['title'] ?></a></li>
                        <? } ?>
                    </ul>
                </li>
            <? } ?>
        </ul>
        <br />
        <div class="search">
            <ul><li><?= _t('items', 'Поиск телефона') ?></li></ul>
            <form action="" method="get">
                <div class="inp"><input type="text" placeholder="<?= _t('items', 'я ищу ...') ?>" value="<?= HTML::escape($q) ?>" name="q" maxlength="30" id="items_phones_search" /><i></i></div>
                <div class="btn"><input type="submit" value="<?= _t('', 'найти') ?>" onclick="return itemsPhones.onSearch(this);" /><i></i></div>
            </form>
        </div>
    </div>
    <div class="inform-map relative">
        <div class="phones left" id="items_phones_list">
            <?= $items; ?>
        </div>
        <div class="right" style="width: 685px;" id="items_phones_pgn">
            <?= $pgn; ?>
        </div>
    </div>
    <div class="clear"></div>
</div>

<script type="text/javascript">
<? js::start(); ?>
var itemsPhones = (function(){
    var $cats, $list, $pgn, $q;
    var cat_id = '<?= $cat_id ?>';
    var h = window.History, h4 = h.emulated.pushState, $doc = document;  
    if(h4) { var hash = h.getHash(); if(hash && hash.length>0 ) { $doc.location = '/' + hash; } }
    
    $(function(){
        $cats = $('#items_phones_cats ul.sub li');
        $list = $('#items_phones_list');
        $pgn  = $('#items_phones_pgn');
        $q    = $('#items_phones_search');
        
        $(window).bind('statechange', function(e) {
            var state = h.getState();  
            if(!state.data || $.isEmptyObject(state.data)) {
                var url = (h4 ? h.getHash() : state.hash);
                return ( url == '' ? $doc.location.reload() : $doc.location = url );
            }
            itemsPhones.onFilter( state.data, false );
        });
    });

    return {
        onFilter: function(f, hist)
        {
            var catID = intval(f.cat) + f.q;
            if(catID == cat_id) return false;
            cat_id = catID;
            $cats.removeClass('active').filter('[data-id="'+f.cat+'"]').addClass('active');
            if(hist!==false) {
                var url = '<?= $urlPhones ?>' + ( f.cat==-1 ? '?q=' + f['q'] : '');
                h.pushState(f, document.title, url);
            }
            
            bff.ajax('<?= $urlPhones ?>', {cat: catID, q: f.q}, function(data){
                if(data) {
                    $list.html( data.items );
                    $pgn.html( data.pgn );
                }
            }, function(show){
                $list.toggleClass('disabled');
                $pgn.toggleClass('disabled');
            });
            
            return false;
        },
        onSearch: function(btn)
        {
            var q = $.trim($q.val());
            if(q.length < 3) {
                $q.focus();
                return false;
            } else {
                this.onFilter({cat:-1,'q':q});
            }
            return false;
        }
}}());
<? js::stop(); ?>
</script>