<?php
    /**
     * Карта объектов
     * @var $this Items
     * @var $cat_id integer
     */
    Geo::mapsAPI(true);
    if (Geo::mapsType() == Geo::MAPS_TYPE_GOOGLE){
        tpl::includeJS('markerclusterer/markerclusterer', false);
    }
    tpl::includeJS('history', false);

    $cat_pid = ($cat_id > 0 ? $cat['pid'] : 0);
    $searchResults = ( ( $cat_id > 0 && $cat_pid > 0 ) || $cat_id == -1 );
    if(!$cat_pid) $cat_pid = $cat_id;
?>
<? if($full){ ?>
<div class="mainmap">
<? } ?>
    <div class="h1-wrap relative mb30">
        <h1 class="left" id="items_map_h1"><?= ( $cat_id > 0 && ! empty($cat['titleh1']) ? $cat['titleh1'] : ( ! empty($titleh1) ? $titleh1 : _t('items', 'Карта города') ) ) ?></h1>
        <div class="<? if($full){ ?>right mt20<? } else { ?>add-org-btn<? } ?>">
            <?= _t('items', 'Не нашли себя на карте?') ?>
            <div class="btn ml10"><input type="button" onclick="location = '<?= Items::url('add') ?>'" value="<?= _t('items', 'добавить организацию') ?>"><i></i></div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
        <? if($full){ ?>
            <div class="f11" style="position: absolute; top:50px;"><span class="grey">&larr;</span> <a href="<?= Items::url('map', array('cat'=>($cat_id > 0 ? $cat['keyword'] : ''), 'full'=>false)) ?>" class="grey"><?= _t('items', 'Вернуться в стандартный режим') ?></a></div>
        <? } else { ?>
            <div class="f11" style="position: absolute; top:50px;"><a href="<?= Items::url('map', array('cat'=>($cat_id > 0 ? $cat['keyword'] : ''), 'full'=>true)) ?>" class="grey"><?= _t('items', 'Полноэкранный режим') ?></a> <span class="grey">&rarr;</span></div>
        <? } ?>
    </div>
    <div class="information mb10">
        <? if($full){ ?><table><tr><td width="390"><? } else { ?><? } ?>
        <div class="inform-nav" id="items_map_block" style="width: 330px;">
            <div class="inform-att mb15 mt10">
                <div class="items_map_inform cat0"<? if($searchResults){ ?> style="display: none;"<? } ?>><?= _t('items', 'Воспользуйтесь категориями, чтобы вывести на карту нужные вам организации') ?></div>
                <div class="items_map_inform cat1"<? if(!$searchResults){ ?> style="display: none;"<? } ?>>
                    <span><a href="<?= Items::url('map') ?>" onclick="return itemsMap.onFilter({cat:0,q:'',h1:'<?= HTML::escape((!empty($titleh1) ? $titleh1 : _t('items', 'Карта города')), 'js') ?>'});" class="ajax"><?= _t('items', 'Все категории') ?></a></span>
                    <br /><span class="f14"><?= ($searchResults ? $informer : '') ?></span>
                </div>
                <i></i>
            </div>
            <div class="map-items" id="items_map_items"<? if(!$searchResults){ ?> style="display: none;"<? } ?>>
                 <? if($searchResults){ echo $this->viewPHP($aData, 'listing.map.ajax'); } ?>
            </div>
            
            <div id="items_map_cats"<? if($searchResults){ ?> style="display: none;"<? } ?>>
                <ul class="inform-nav-in">
                    <? if( ! empty($cats) ) foreach($cats as $v): ?>
                    <li <? if($v['id']==$cat_pid){?>class="active"<? } ?>>
                        <span onclick="$(this).next().toggle().end().parent().toggleClass('active');"><?= $v['title'] ?> <i></i></span>
                        <ul <? if($v['id']!=$cat_pid){ ?>style="display: none;"<? } ?>>
                            <? foreach($v['sub'] as $v2){ ?>
                            <li><a href="<?= $v2['url'] ?>"><?= $v2['title'] ?></a></li>
                            <? } ?>
                        </ul>
                    </li>
                    <? endforeach; ?>
                </ul>
                <br />
                <div class="search">
                    <form action="" method="get">
                        <ul><li><?= _t('items', 'Поиск организации') ?></li></ul>
                        <div class="inp"><input type="text" placeholder="<?= _t('items', 'я ищу ...') ?>" name="q" maxlength="30" id="items_map_search" /><i></i></div>
                        <div class="btn"><input type="submit" value="<?= _t('items', 'Найти') ?>" onclick="return itemsMap.onSearch(this);" /><i></i></div>
                    </form>
                </div>
            </div>
            
        </div>
        <? if($full){ ?></td>
            <td>
                <div class="inform-map relative">
                    <div style="height:730px;" id="items_map_map"></div>
                </div>
                <? if ( ! empty($cat['seotext'])) { ?>
                    <div class="ml10"><?= $cat['seotext'] ?></div>
                <? } ?>
            </td>
        </tr>
        </table>
        <? } else { ?>
        <div class="inform-map relative">
            <div style="width: 705px; height:601px;" id="items_map_map"></div>
        </div>
        <? if ( ! empty($cat['seotext'])) { ?>
            <div class="ml10"><?= $cat['seotext'] ?></div>
        <? } ?>
        <div class="clear"></div>
        <? } ?>
    </div>


<script type="text/javascript">
<? js::start(); ?>
var itemsMap = (function(){
    var $b, $informs, $cats, $items, $q;
    var $map, map, mapClusterer = null, mapMarkers, mapInfoWindow, itemsLoad = <?= func::php2js($items) ?>;
    var cat_id = <?= $cat_id ?>;
    var h = window.History, h4 = h.emulated.pushState, $doc = document;  
    if(h4) { var hash = h.getHash(); if(hash && hash.length>0 ) { $doc.location = '/' + hash; } }
    
    $(function(){
        $b = $('#items_map_block');
        $cats  = $('#items_map_cats', $b); 
        $informs = $('.items_map_inform', $b);
        $items = $('#items_map_items', $b); 
        $q = $('#items_map_search', $b);
        $map = $('#items_map_map');

        // init map
        map = app.map($map.get(0), '<?= HTML::escape(Geo::mapsDefaultCoords(), 'js'); ?>', function(){
            if (this.isYandex()) {
                mapClusterer = new ymaps.Clusterer({
                    preset: 'islands#blueClusterIcons',
                    clusterBalloonContentLayoutWidth: 400,
                    clusterBalloonContentLayoutHeight: 150,
                    clusterBalloonLeftColumnWidth:50,
                    clusterDisableClickZoom: false,
                    clusterBalloonItemContentLayout: ymaps.templateLayoutFactory.createClass('<div class="ballon_body" style="line-height: 20px;">{{ properties.balloonContentBody|raw }}</div>'),
                    zoomMargin: 15
                });
            } else if (this.isGoogle()) {
                mapInfoWindow = new google.maps.InfoWindow({maxWidth:300});
            }
            showItems(itemsLoad);
        }, {constrols:'search', zoom:13});

        $items.delegate('div.item', 'click', function(e){
            var t = $(e.target);
            if(t.length && !t.is('a')) {
                itemsMap.popupMarker(intval($(this).data('id')), false);
                return false;
            }
        });

        $(window).bind('statechange', function(e){
            var state = h.getState();
            if(!state.data || $.isEmptyObject(state.data)) {
                var url = (h4 ? h.getHash() : state.hash);
                return (url == '' ? $doc.location.reload() : $doc.location = url);
            }
            itemsMap.onFilter(state.data, false);
        });
    });
    
    function showItems(items)
    {
        if (map.isYandex())
        {
            var mapY = map.getMap();
            var itemsToCluster = [];

            mapClusterer.removeAll();
            mapY.geoObjects.remove(mapClusterer);
            mapMarkers = {};

            var j = 0;
            for(var i in items){
                var v = items[i];
                var n = (intval(i)+1);
                var balloonHtml=
                    '<a href="'+v.link+'"><b>'+v.t+'</b></a><br />'+
                    '<div class="mt5">'+ v.cttl+', '+v.adr+'</div>'+
                    (v.site ? '<div><a href="'+v.site_link+'" target="_blank" rel="nofollow">'+v.site+'</a></div>' : '')+
                    (v.ph ? '<div>'+v.ph+'</div>' : '')+
                    '<div>'+v.d+'</div>'+
                    '<div class="grey f11 mb5">'+v.cats.join(', ')+'</div>'+
                    '<span class="grey"><a href="'+v.link+'" class="grey"><?= _t('', 'Подробнее') ?></a> &rarr;</span>';

                mapMarkers[intval(v.id)] = itemsToCluster[j++] = new ymaps.Placemark([parseFloat(v.lat),parseFloat(v.lng)], {
                    iconContent: v.num,
                    clusterCaption: v.num,
                    balloonContentBody: balloonHtml
                }, {preset: (v.vip==1 ? 'islands#redIcon' : 'islands#blueIcon')});
            }

            if (itemsToCluster.length) {
                mapClusterer.add(itemsToCluster);
                mapY.geoObjects.add(mapClusterer);
                if (itemsToCluster.length > 1) {
                    var pos = ymaps.util.bounds.getCenterAndZoom(
                        mapClusterer.getBounds(), mapY.container.getSize(), mapY.options.get('projection')
                    );
                    mapY.setCenter(pos.center, pos.zoom);
                } else {
                    if (itemsToCluster.length) {
                        mapY.setCenter(itemsToCluster[0].geometry.getCoordinates());
                    }
                }
            }

            map.refresh();
            mapClusterer.events.once('objectsaddtomap', function(){
                mapY.setBounds(mapClusterer.getBounds(), {checkZoomRange: true});
            });
        }
        else if (map.isGoogle())
        {
            if (mapClusterer) {
                mapClusterer.clearMarkers();
            }
            var mapG = map.getMap();
            mapMarkers = {};
            var mapMarkersToCluster = [];
            mapInfoWindow.close();

            for(var i in items){
                var v = items[i];
                var id = intval(v.id);
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(parseFloat(v.lat),parseFloat(v.lng))
                });
                marker.itemID = id;
                mapMarkers[id] = {
                    position: marker.getPosition(),
                    balloon: '<div>'+
                        '<a href="'+v.link+'">'+v.t+'</a><br />'+
                        '<div class="mt5">'+ v.cttl+', '+v.adr+'</div>'+
                        (v.site ? '<div><a href="'+v.site_link+'" target="_blank" rel="nofollow">'+v.site+'</a></div>' : '')+
                        (v.ph ? '<div>'+v.ph+'</div>' : '')+
                        '<div>'+v.d+'</div>'+
                        '<div class="grey f11 mb5">'+v.cats.join(', ')+'</div>'+
                        '<a href="'+v.link+'" class="f11"><?= _t('', 'Подробная информация') ?></a>'+
                    '</div>'
                };
                mapMarkersToCluster.push(marker);
                google.maps.event.addListener(marker, 'click', function() {
                    itemsMap.popupMarker(this.itemID, true);
                });
            }

            mapClusterer = new MarkerClusterer(mapG, mapMarkersToCluster, {
                imagePath: '<?= SITEURL_STATIC ?>/js/markerclusterer/images/m'
            });
            if (mapMarkersToCluster.length > 1) {
                mapClusterer.fitMapToMarkers();
            }
            map.refresh();
        }
    }

    function mapBalloonOpenY(point)
    {
        var state = mapClusterer.getObjectState(point),
            cluster = state.isClustered && state.cluster;
        if(cluster) {
            cluster.state.set('activeObject', point);
            mapClusterer.balloon.open(state.cluster);
        } else {
            if( ! point.balloon.isOpen() ) point.balloon.open();
        }
    }

    return {
        onFilter: function(f, hist)
        {
            var catID = intval(f.cat);
            if(catID == cat_id) return false;
            cat_id = catID;
            if(hist!==false) {
                var url = '<?= Items::url('map', array('full'=>$full)) ?>' + ( f.cat==-1 ? '?q=' + f['q'] : '');
                h.pushState(f, document.title, url);
                if (f.hasOwnProperty('h1')) {
                    $('#items_map_h1').html(f.h1);
                }
            }
            if(catID == 0) {
                $cats.show();
                $items.hide();
                $informs.hide().filter('.cat0').show();
                showItems({});
            } else {
                bff.ajax('<?= Items::url('map') ?>', {cat: catID, q: f.q}, function(data){
                    if(data) {
                        $cats.hide();
                        $items.html(data.items_html).show();
                        $informs.hide().filter('.cat1').find('span:last').html(data.informer).parent().show();
                        showItems( data.items );
                    }
                }, function(show) {
                    $b.toggleClass('disabled');
                });
            }
            return false;
        },
        onSearch: function(btn)
        {
            var q = $.trim($q.val());
            if(q.length < 3) {
                $q.focus();
                return false;
            } else {
                this.onFilter({cat:-1,'q':q});
            }
            return false;
        },
        popupMarker: function(itemID, markerClick)
        {
            if (map.isYandex()) {
                if (mapMarkers.hasOwnProperty(itemID)) {
                    var itemPoint = mapMarkers[itemID];
                    var state = mapClusterer.getObjectState(itemPoint), cluster = state.cluster;
                    if ((itemPoint.getMap() || (cluster && cluster.getMap()))) {
                        mapBalloonOpenY(itemPoint);
                    } else {
                        map.panTo(itemPoint.geometry.getCoordinates(), {duration:400, delay:0, callback:function(){
                            mapClusterer.events.once('objectsaddtomap', function(){
                                mapBalloonOpenY(itemPoint);
                            });
                        }});
                    }
                }
            } else if (map.isGoogle()) {
                if (mapMarkers.hasOwnProperty(itemID)) {
                    var m = mapMarkers[itemID];
                    if (markerClick!==true) {
                        map.getMap().panTo(m.position);
                    }
                    mapInfoWindow.close();
                    mapInfoWindow.setPosition(m.position);
                    mapInfoWindow.setContent(m.balloon);
                    mapInfoWindow.open(map.getMap());
                }
            }
            return false;
        }
}}());
<? js::stop(); ?>
</script>