<?php
?>

<div class="tabsBar">
    <span class="tab"><a href="<?= $this->adminLink('agents') ?>">Представители</a></span>
    <span class="tab tab-active"><a href="<?= $this->adminLink('agents_requests') ?>">Заявки</a></span>
    <div class="right"><div class="progress" style="display:none;" id="progress-items-agents"></div></div>
    <div class="clear"></div>
</div>

<div class="actionBar">
    <form action="" name="filter">
        <input type="hidden" name="s" value="<?= bff::$class ?>"/>
        <input type="hidden" name="ev" value="<?= bff::$event ?>"/>
        <div class="left" style="margin-right: 5px;">
            <label for="filter_id_title" class="placeholder inline">ID объекта</label>
            <input type="text" name="item" style="width:170px;" id="filter_id_title" placeholder="ID объекта" value="<?= ($f['item'] > 0 ? $f['item'] : '' ) ?>" />
        </div>
        <div class="left relative" style="margin-right: 5px;">
            <input type="hidden" name="user" id="items-agents-user-id" value="<?= $f['user'] ?>" />
            <input type="text" class="autocomplete" id="items-agents-user-title" style="width: 200px;" placeholder="<?= _t('pub', 'ID / login / e-mail пользователя') ?>" value="<?= ($f['user']>0 ? HTML::escape($user_title) : '') ?>" />
        </div>
        <div class="left">
            <input type="submit" class="btn btn-small button submit" value="найти" />
        </div>
        <div class="right" style="margin:5px 0 0 5px;">
        </div>
        <div class="clear-all"></div>
    </form>
</div>

<div class="comments" id="j-item-requests">
    <?

    foreach($requests as $v)
    {
        $id = $v['id'];
        ?>
        <div class="comment" id="request_id_<?= $id ?>">
            <a class="but opinion3" href="#" onclick="return false;" style="margin-top: 10px;"></a>
            <a name="request<?= $id ?>" ></a>
            <div class="ccontent<? if($v['blocked']){ ?> del<? } ?>" style="margin-left:30px;">
                <div class="tb"><div class="tl"><div class="tr"></div></div></div>
                <div class="ctext">
                    <div class="request-view">
                        <span class="desc">Имя: </span><?= $v['name'] ?><br />
                        <span class="desc">Телефон: </span><?= $v['phone'] ?><br />
                        <span class="desc">E-mail: </span><?= $v['email'] ?><br />
                        <span class="desc">Объект: </span><a href="<?= Items::url('view', $v['item_link']) ?>" class="but linkout" target="_blank"></a><a target="_blank" href="<?= $this->adminLink('items_edit&item_id='.$v['item_id']); ?>"><?= $v['item_title'] ?></a>
                    </div>
                </div>
                <div class="bl"><div class="bb"><div class="br"></div></div></div>
            </div>
            <div class="info">
                <ul>
                    <? if($v['user_id']>0){ ?><li><p><a href="#" onclick="return bff.userinfo(<?= $v['user_id'] ?>);" class="author<? if($v['blocked']){ ?> block_s<? } ?>"><?= $v['uemail'] ?></a></p></li><? } else { ?>
                        <li class="desc"><?= $v['ip'] ?></li>
                    <? } ?>
                    <li class="date"><?= tpl::date_format2($v['created'], true); ?></li>
                    <li><a href="#" class="ajax" onclick="jItemRequests.edit(<?= $id; ?>, 1); return false;">Подробнее</a></li>
                    <li><a href="#" class="delete ajax" onclick="jItemRequests.act(<?= $id ?>, 'd', this); return false;">Удалить</a></li>
                </ul>
            </div>
        </div>
    <?
    }

    if (empty($requests))
    { ?>
     <div class="alignCenter valignMiddle" style="height:30px; padding-top:15px;">
        <span class="desc">нет заявок</span>
     </div>
    <? } ?>
</div>
        
<script type="text/javascript">
var jItemRequests = (function()
{
    var $progress;
    var _processing = false;
    var requestEdit = {}; 
    var ajax_url = '<?= $this->adminLink('agents_requests&act='); ?>';
    
    $(function(){
        $progress = $('#progress-items-agents');

        var urlAjax = '<?= $this->adminLink('ajax').'&action='; ?>';
        $('#items-agents-user-title').autocomplete( urlAjax+'item-users-autocomplete',
            {valueInput: '#items-agents-user-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    if(val){
                        document.forms.filter.submit();
                    }
                }});
    });
    
    return {
        act: function(id, act, link)
        {
            if(_processing) return false;
            _processing = true;
            
            switch(act) {
                case 'd': { if(!bff.confirm('sure')) { _processing = false; return false; } act = 'delete';   } break;
                case 'm': { act = 'moderate'; } break;
            }
            
            bff.ajax(ajax_url + act, {'id': id}, function(data) {
                if(data) {
                    $(link).closest('.comment').slideUp();
                }
                _processing = false;
            }, $progress);
        }, 
        edit: function(id, act)
        {
            var $block = $('#request_id_'+id);
            var edit = $block.find('.request-edit');
            var view = $block.find('.request-view');
            switch(act)
            {
                case 1: //show
                {
                    if(!edit.length) {
                        bff.ajax(ajax_url + 'edit_start&id='+id, {}, function(data, errors){
                            if(data) {      
                                $block.find('.ctext').append( data.form );
                                var edit = $block.find('.request-edit');
                                edit.find('.userlogin').autocomplete( ajax_url + 'agent-autocomplete', 
                                    {valueInput: edit.find('.userid'), width: 200, placeholder: 'Укажите пользователя', minChars: 3});
                                view.hide();
                                edit.show();
                            }
                        }, $progress);
                    } else {
                        view.hide();
                        edit.show();
                    }
                } break;
                case 2: //save
                {
                    var form = $('#request'+id+'-edit-form');
                    if(edit.length)
                    {             
                        edit.addClass('disabled');
                        bff.ajax(ajax_url + 'edit_finish&id='+id, form.serialize(), function(data, errors){
                            if(data && data.res) {
                                $block.slideUp();
                                bff.error('Представитель был успешно зареплен за объектом', {success: true});
                            }
                            edit.removeClass('disabled');
                        }, $progress);    
                    }
                } break;
                case 0: //hide
                {
                    if(edit.length) {
                        edit.hide().removeClass('disabled');
                        $block.find('div.request-view').show();
                    }
                } break;
            }
        }
    };
}());
</script>
