<?php 
    $requests_cnt = config::get('items_agents', 0);
    tpl::includeJS('autocomplete', true);
?>
<div class="tabsBar">
    <span class="tab tab-active"><a href="<?= $this->adminLink('agents') ?>">Представители</a></span>
    <span class="tab"><a href="<?= $this->adminLink('agents_requests') ?>">Заявки<? if($requests_cnt>0){ ?> (<span class="bold"><?= $requests_cnt ?></span>)<? } ?></a></span>
    <div class="right"><div class="progress" style="display:none;" id="progress-items-agents"></div></div>
    <div class="clear"></div>
</div>

<div class="actionBar">
    <form action="" name="filter">
        <input type="hidden" name="s" value="<?= bff::$class ?>"/>
        <input type="hidden" name="ev" value="<?= bff::$event ?>"/>
        <div class="left" style="margin-right: 5px;">
            <label for="filter_id_title" class="placeholder inline">ID объекта</label>
            <input type="text" name="item" style="width:170px;" id="filter_id_title" placeholder="ID объекта" value="<?= ($f['item'] > 0 ? $f['item'] : '' ) ?>" />
        </div>
        <div class="left relative" style="margin-right: 5px;">
            <input type="hidden" name="user" id="items-agents-user-id" value="<?= $f['user'] ?>" />
            <input type="text" class="autocomplete" id="items-agents-user-title" style="width: 200px;" placeholder="<?= _t('pub', 'ID / login / email пользователя') ?>" value="<?= ($f['user']>0 ? HTML::escape($user_title) : '') ?>" />
        </div>
        <div class="left">
            <input type="submit" class="btn btn-small button submit" value="найти" />
        </div>
        <div class="right" style="margin:5px 0 0 5px;">
        </div>
        <div class="clear-all"></div>
    </form>
</div>

<table class="table table-condensed table-hover admtbl tblhover">
<thead>
    <tr class="header">
        <th width="60">ID</th>
        <th width="200" class="left">E-mail</th>
        <th class="left">ФИО</th>
        <th width="125">Объекты</th>
    </tr>
</thead>
<? foreach($agents as $k=>$v): ?>
<tr class="row<?= ($k%2) ?>">
    <td class="small"><?= $v['id'] ?></td>
    <td class="left"><a href="#" onclick="return bff.userinfo(<?= $v['id'] ?>);" class="ajax"><?= $v['email'] ?></a><? if(!empty($v['login'])){ ?><span class="desc"> (<?= $v['login'] ?>)</span><? } ?></td>
    <td class="left"><?= $v['name'].' '.$v['surname'] ?></td>
    <td><a href="<?= $this->adminLink('items_listing&agent='.$v['id']) ?>"><?= $v['items'] ?></a></td>
</tr>
<? endforeach;
if( ! $agents){ ?>
<tr class="norecords">
    <td colspan="4">нет представителей</td>
</tr>
<? } ?>
</table>
<?= $pgn; ?>

<script type="text/javascript">
    $(function(){
        var urlAjax = '<?= $this->adminLink('ajax').'&action='; ?>';
        $('#items-agents-user-title').autocomplete( urlAjax+'item-users-autocomplete',
            {valueInput: '#items-agents-user-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    if(val){
                        document.forms.filter.submit();
                    }
                }});
    });
</script>