<?php
    $aData = HTML::escape($aData, 'html', array('title', 'name', 'phone', 'email'));
?>
<div class="h1-wrap">
    <h1><?= _t('items', 'Новая организация') ?></h1>
     <div class="form-box object-add ml10 mt20">
        <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="hash" value="<?= $this->security->getToken() ?>" />
            <div class="error mb20"<? if($this->errors->no()){ ?> style="display:none;"<? } ?>><?= join('<br />', $this->errors->get(true)); ?></div>
            <table width="100%"> 
            <tr><td colspan="2"><h3><?= _t('items', 'Общая информация') ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('items', 'Название фирмы') ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input type="text" name="title" value="<?= $title ?>" maxlength="200" tabindex="1" /><i></i></div></td>
            </tr>                                 
            <tr>
                <td class="td1"><?= _t('items', 'Чем занимается?') ?><span class="z-att">*</span><br /><span class="f11 grey"><?= _t('items', 'Сфера деятельности фирмы.') ?><br /> <?= _t('', 'Не более 500 символов.') ?></span></td>
                <td>
                    <div class="textarea"><textarea cols="25" rows="7" name="descshort" tabindex="2"><?= $descshort ?></textarea><i></i></div>
                </td>
            </tr>    
            <tr>
                <td class="td1"><?= _t('items', 'Логотип или фотография') ?></td>
                <td>                      
                    <input type="file" name="img" size="25" tabindex="3" /> 
                    <input type="hidden" name="MAX_FILE_SIZE" value="<?= Items::imagesMaxSize() ?>" />
                </td>
            </tr>                             
            <tr><td colspan="2"><br /><h3><?= _t('', 'Контакты') ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('', 'Город') ?><span class="z-att">*</span></td>
                <td><?= Geo::cityOptionsSelect($city_id, true, 'city_id'); ?></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Адрес') ?><span class="z-att">*</span></td>
                <td><div class="inp inp-w1"><input type="text" name="address" value="<?= $address ?>" tabindex="4" maxlength="200" /><i></i></div></td>
            </tr>
            <tr>
                <td class="td1"><?= _t('', 'Телефон') ?><span class="z-att">*</span></td>
                <td>    
                    <div id="item_add_phones">
                        <? if (empty($phones)){ $phones = array(0=>''); }
                           foreach($phones as $k=>$v) { ?>
                            <div class="contact-item"><div class="inp inp-w3 left mr10"><input type="tel" maxlength="40" name="phones[<?= $k+1 ?>]" value="<?= HTML::escape($v) ?>" tabindex="5" /><i></i></div><? if(!$k){ ?><a href="#" class="ajax f12 contact-add">+ Добавить</a><? } else { ?><a href="#" class="ajax f12 contact-remove">- Удалить</a><? } ?><div class="clear"></div></div>
                        <? } ?>
                    </div>
                </td>
            </tr>                  
            <tr>
                <td class="td1"><?= _t('', 'Сайт') ?></td>
                <td>
                    <div id="item_add_sites">
                        <? if (empty($sites)){ $sites = array(0=>''); }
                           foreach($sites as $k=>$v) { ?>
                            <div class="contact-item"><div class="inp inp-w3 left mr10"><input type="text" maxlength="200" name="sites[<?= $k+1 ?>]" value="<?= HTML::escape($v) ?>" tabindex="6" /><i></i></div><? if(!$k){ ?><a href="#" class="ajax f12 contact-add">+ Добавить</a><? } else { ?><a href="#" class="ajax f12 contact-remove">- Удалить</a><? } ?><div class="clear"></div></div>
                        <? } ?>                    
                    </div>
                </td>
            </tr>    
            <tr>
                <td class="td1"><?= _t('', 'Email') ?></td>
                <td>
                    <div id="item_add_emails">
                        <? if (empty($emails)){ $emails = array(0=>''); }
                           foreach($emails as $k=>$v) { ?>
                            <div class="contact-item"><div class="inp inp-w3 left mr10"><input type="text" maxlength="40" name="emails[<?= $k+1 ?>]" value="<?= HTML::escape($v) ?>"  tabindex="7"/><i></i></div><? if(!$k){ ?><a href="#" class="ajax f12 contact-add">+ Добавить</a><? } else { ?><a href="#" class="ajax f12 contact-remove">- Удалить</a><? } ?><div class="clear"></div></div>
                        <? } ?>
                    </div>
                </td>
            </tr>     
            <tr><td colspan="2"><br /><h3><?= _t('items', 'О себе') ?></h3></td></tr>
            <tr>
                <td class="td1"><?= _t('items', 'Кто вы?') ?></td>
                <td>
                    <label><input type="radio" name="user_type" value="<?= Items::USERTYPE_AGENT ?>" <? if(!$user_type || $user_type == Items::USERTYPE_AGENT){ ?>checked="checked"<? } ?> onclick="$('#items_add_contacts').show();" /> Представитель организации</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="user_type" value="<?= Items::USERTYPE_MEMBER ?>" <? if($user_type == Items::USERTYPE_MEMBER){ ?>checked="checked"<? } ?> onclick="$('#items_add_contacts').hide();" /> Пользователь</label>
                </td>
            </tr>
            <tbody id="items_add_contacts" <? if($user_type == Items::USERTYPE_MEMBER){?> style="display: none;"<?} ?>>
                <tr>
                    <td class="td1"><?= _t('', 'Ваше имя') ?><span class="z-att">*</span></td>
                    <td><div class="inp inp-w3"><input type="text" name="name" value="<?= $name ?>"  maxlength="150" /><i></i></div></td>
                </tr>                
                <tr>
                    <td class="td1"><?= _t('', 'Контактный телефон') ?><span class="z-att">*</span></td>
                    <td><div class="inp inp-w3"><input type="tel" name="phone" value="<?= $phone ?>"  maxlength="150" /><i></i></div></td>
                </tr>                
                <tr>
                    <td class="td1"><?= _t('', 'Email') ?><span class="z-att">*</span></td>
                    <td><div class="inp inp-w3"><input type="text" name="email" value="<?= $email ?>"  maxlength="150" /><i></i></div></td>
                </tr>
            </tbody>                    
            <? if(!User::id()) { ?>
            <tr id="item-captcha-block">
                <? $urlCaptcha = tpl::captchaURL(); ?>
                <td class="td1"><?= _t('', 'Введите код с картинки') ?><span class="z-att">*</span></td>
                <td><img title="<?= _t('', 'обновить') ?>" alt="<?= _t('', 'код') ?>" src="<?= $urlCaptcha ?>" id="item-captcha" onclick="$(this).attr('src', '<?= $urlCaptcha ?>&r='+Math.random(1));" class="capth" style="cursor: pointer;" /> <div class="inp inp-w4"><input type="text" name="captcha" pattern="[0-9]*" /><i></i></div></td>
            </tr>            
            <? } ?>
            <tr>
                <td></td>
                <td colspan="2">
                    <div class="btn mr10 left"><input type="submit" value="<?= _t('items', 'добавить организацию') ?>" /><i></i></div>
                </td>
            </tr>       
            </table>
        </form>
     </div>
</div>

<script type="text/javascript">
<? js::start(); ?>
    var itemAdd = (function(){
        
        $(function(){
            itemAddContacts('#item_add_phones', 'phones', <?= sizeof($phones) ?>, 3);
            itemAddContacts('#item_add_sites',  'sites', <?= sizeof($sites) ?>, 3);
            itemAddContacts('#item_add_emails', 'emails', <?= sizeof($emails) ?>, 3);
        });
        
    }());

    var itemAddContacts = function(block, fieldname, index, lmt) {
        var total = index;
        var $block = $(block);
        var $plus  = $('a.contact-add', $block.parent());
        
        $plus.click(function(){
            if(lmt>0 && total>=lmt) { return false; }
            index++; total++;
            $block.append('<div class="contact-item"><div class="inp inp-w3 left mr10"><input type="text" maxlength="200" name="'+fieldname+'['+index+']" value="" /><i></i></div><a href="#" class="ajax f12 contact-remove">- <?= _t('', 'Удалить') ?></a><div class="clear"></div></div>');
            return false;
        });

        $block.on('click', 'a.contact-remove', function(){
            $(this).parent().remove(); total--;
            return false;
        });
    };
<? js::stop(); ?>
</script>