<?php

class Geo extends GeoBase
{
    function ajax()
    {
        $aResponse = array();

        switch ($this->input->getpost('act', TYPE_STR))
        {
            case 'districts-list':
            {
                $nCityID = $this->input->postget('city', TYPE_UINT);
                $bOptions = $this->input->postget('opts', TYPE_BOOL);
                if ( ! $nCityID) {
                    $this->errors->impossible();
                    break;
                }

                if ($bOptions) {
                    $aResponse['districts'] = self::districtOptions($nCityID, 0, _t('geo','Все районы'));
                } else {
                    $aResponse['districts'] = self::districtList($nCityID);
                }

            } break;
            default: {
                $this->errors->impossible();
            }
        }

        $this->ajaxResponseForm($aResponse);
    }
}