<?php

class BusinessModel extends Model
{
    public $langBanks = array(
        'title' => TYPE_STR, # заголовок
    );

    /**
     * Получение данных об отделениях банка
     * @param int|bool $nBankID ID банка или false (список отделений не закрепленный ни за одним банком)
     * @param bool $bOptions
     * @return mixed|string
     */
    public function getBankDeps($nBankID = false, $bOptions = false)
    {
        if($nBankID === false)
        {
            # берем свободные отделения (не закрепленные ни за одним банком)
            $categoryID = config::sys('business.banks.departments.category', 117);
            $aData = $this->db->select('SELECT I.id, IL.title
                        FROM '.TABLE_ITEMS.' I
                            LEFT JOIN '.TABLE_BUSINESS_BANKS_DEPS.' D ON D.item_id = I.id
                            , '.TABLE_ITEMS_LANG.' IL
                        WHERE I.cat_id = :cat AND D.item_id IS NULL '.$this->db->langAnd(true, 'I', 'IL').'
                        ORDER BY IL.title', array(':cat'=>$categoryID));
            return ( $bOptions ? HTML::selectOptions($aData, 0, false, 'id', 'title') : $aData );
        }
        else
        {
            # берем закрепленные за банком отделения
            $aData = $this->db->select('SELECT I.id, IL.title
                        FROM '.TABLE_BUSINESS_BANKS_DEPS.' D,
                             '.TABLE_ITEMS.' I,
                             '.TABLE_ITEMS_LANG.' IL
                        WHERE D.bank_id = :id AND D.item_id = I.id '.$this->db->langAnd(true, 'I', 'IL').'
                        ORDER BY IL.title', array(':id'=>$nBankID));

            return ( $bOptions ? HTML::selectOptions($aData, 0, false, 'id', 'title') : $aData );
        }
    }

    /**
     * Сохранение данных об отделениях банка
     * @param int $nBankID ID банка
     * @param int $nMainID
     * @return int кол-во
     */
    public function saveBankDeps($nBankID, $nMainID = 0)
    {
        $aDeps = $this->input->post('deps', TYPE_ARRAY_UINT);
        $this->db->delete(TABLE_BUSINESS_BANKS_DEPS, array('bank_id'=>$nBankID));
        $aInsert = array();
        foreach ($aDeps as $v) {
            if ($v > 0) {
                $aInsert[] = array(
                    'bank_id' => $nBankID,
                    'item_id' => $v,
                    'main'    => ($v == $nMainID ? 1 : 0),
                );
            }
        }

        if (!empty($aInsert)) {
            $this->db->multiInsert(TABLE_BUSINESS_BANKS_DEPS, $aInsert);
        }

        return sizeof($aInsert);
    }

    /**
     * Получение данных о банкоматах
     * @param int|bool $nBankID ID банка или false (список банкоматов незакрепленный ни за одним банком)
     * @param bool $bOptions
     * @return mixed|string
     */
    public function getBankMats($nBankID = false, $bOptions = false)
    {
        if($nBankID === false)
        {
            # берем свободные банкоматы (незакрепленные ни за одним банком)
            $categoryID = config::sys('business.banks.atm.category', 118);
            $aData = $this->db->select('
                SELECT I.id, IL.title
                FROM '.TABLE_ITEMS.' I
                    LEFT JOIN '.TABLE_BUSINESS_BANKS_MATS.' M ON M.item_id = I.id
                    , '.TABLE_ITEMS_LANG.' IL
                WHERE I.cat_id = :cat AND M.item_id IS NULL '.$this->db->langAnd(true, 'I', 'IL').'
                ORDER BY IL.title', array(':cat'=>$categoryID));
            return ( $bOptions ? HTML::selectOptions($aData, 0, false, 'id', 'title') : $aData );
        }
        else
        {
            # берем закрепленные за банком банкоматы
            $aData = $this->db->select('
                SELECT I.id, IL.title
                FROM '.TABLE_BUSINESS_BANKS_MATS.' M,
                     '.TABLE_ITEMS.' I,
                     '.TABLE_ITEMS_LANG.' IL
                WHERE M.bank_id = :id AND M.item_id = I.id '.$this->db->langAnd(true, 'I', 'IL').'
                ORDER BY IL.title', array(':id'=>$nBankID));

            return ( $bOptions ? HTML::selectOptions($aData, 0, false, 'id', 'title') : $aData );
        }
    }

    /**
     * Сохранение данных о банкоматах
     * @param int $nBankID ID банка
     * @return int кол-во
     */
    public function saveBankMats($nBankID)
    {
        $aDeps = $this->input->post('mats', TYPE_ARRAY_UINT);
        $this->db->delete(TABLE_BUSINESS_BANKS_MATS, array('bank_id'=>$nBankID));
        $aInsert = array();
        foreach ($aDeps as $v) {
            if ($v > 0) {
                $aInsert[] = array(
                    'bank_id' => $nBankID,
                    'item_id' => $v,
                );
            }
        }

        if (!empty($aInsert)) {
            $this->db->multiInsert(TABLE_BUSINESS_BANKS_MATS, $aInsert);
        }

        return sizeof($aInsert);
    }
}