<?php

/**
 * Права доступа группы:
 *  - business: Бизнес
 *      - banks: Управление банками
 */

class Business extends BusinessBase
{
    function banks()
    {
        if ( ! $this->haveAccessTo('banks'))
            return $this->showAccessDenied();

        if (Request::isAJAX())
        {
            switch ($this->input->get('act'))
            {
                case 'edit':
                {
                    $nBankID = $this->input->get('id', TYPE_UINT);
                    if ( ! $nBankID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $aData = $this->db->one_array('SELECT * FROM '.TABLE_BUSINESS_BANKS.' WHERE id = '.$nBankID);
                    if (empty($aData)) $this->ajaxResponse(Errors::IMPOSSIBLE);
                    $this->db->langFieldsSelect($aData, $this->model->langBanks);

                    $aData['deps_free'] = $this->model->getBankDeps(false, true);
                    $aData['deps_sel']  = $this->model->getBankDeps($nBankID, true);
                    $aData['mats_free'] = $this->model->getBankMats(false, true);
                    $aData['mats_sel']  = $this->model->getBankMats($nBankID, true);
                    $aData['item_title'] = ( $aData['item_id'] > 0 ? $this->db->one_data('SELECT title FROM '.TABLE_ITEMS_LANG.' WHERE id = '.$aData['item_id'].' AND lang = '.$this->db->str2sql(LNG)) : 'Не указано' );

                    $aData['form'] = $this->viewPHP($aData, 'admin.form');

                    $this->ajaxResponse( $aData ); 
                } break;
                case 'rotate':
                {
                    $this->db->rotateTablednd(TABLE_BUSINESS_BANKS, '', 'id', 'num');
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'toggle':
                {
                    $nBankID = $this->input->postget('rec', TYPE_UINT);
                    if ( ! $nBankID) $this->ajaxResponse(Errors::UNKNOWNRECORD);

                    $this->model->toggleInt(TABLE_BUSINESS_BANKS, $nBankID, 'enabled', 'id');
                    
                    $this->ajaxResponse(Errors::SUCCESS);
                } break;
                case 'delete':
                {
                    $nBankID = $this->input->get('id', TYPE_UINT);
                    if ( ! $nBankID) $this->ajaxResponse(Errors::UNKNOWNRECORD);
                    
                    $res = $this->db->delete(TABLE_BUSINESS_BANKS, $nBankID);
                    if ($res) {
                        $this->db->delete(TABLE_BUSINESS_BANKS_DEPS, array('bank_id'=>$nBankID));
                        $this->db->delete(TABLE_BUSINESS_BANKS_MATS, array('bank_id'=>$nBankID));
                        $this->ajaxResponse(Errors::SUCCESS);
                    } else {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                } break;
            }
        } 
        else if (Request::isPOST())
        {

            switch ($this->input->postget('act'))
            {
                case 'add-finish': 
                {
                    $aData = $this->bankProcessData();
                    
                    if ($aData && $this->errors->no()) {
                        $aData['num'] = ((int)$this->db->one_data('SELECT MAX(num) FROM '.TABLE_BUSINESS_BANKS))+1;
                        $aData['created'] = $this->db->now();
                        $this->db->langFieldsModify($aData, $this->model->langBanks, $aData);
                        $nBankID = $this->db->insert(TABLE_BUSINESS_BANKS, $aData);
                        if ($nBankID) {
                            $sqlUpdate = array();
                            $sqlUpdate['deps_cnt'] = $this->model->saveBankDeps($nBankID, $aData['item_id']);
                            $sqlUpdate['mats_cnt'] = $this->model->saveBankMats($nBankID);
                            if (!empty($sqlUpdate)) {
                                $this->db->update(TABLE_BUSINESS_BANKS, $sqlUpdate, array('id'=>$nBankID));
                            }
                        }
                    }
                    
                } break;
                case 'edit-finish':
                {
                    $nBankID = $this->input->post('id', TYPE_UINT);
                    if ( ! $nBankID) $this->errors->unknownRecord();
                    
                    $aDataCur = $this->db->one_array('SELECT * FROM '.TABLE_BUSINESS_BANKS.' WHERE id = '.$nBankID);
                    if (empty($aDataCur)) $this->errors->unknownRecord();
                    
                    $aData = $this->bankProcessData();
                        
                    if ($this->errors->no())
                    {
                        $aData['deps_cnt'] = $this->model->saveBankDeps($nBankID, $aData['item_id']);
                        $aData['mats_cnt'] = $this->model->saveBankMats($nBankID);

                        $this->db->langFieldsModify($aData, $this->model->langBanks, $aData);
                        $this->db->update(TABLE_BUSINESS_BANKS, $aData, array('id'=>$nBankID));
                    }
                } break;
            }

            $this->adminRedirect(Errors::SUCCESS, bff::$event);
        }
        
        $aData = $this->bankProcessData();
        $aData['deps_free'] = $this->model->getBankDeps(false, true);
        $aData['deps_sel'] = '';
        $aData['mats_free'] = $this->model->getBankMats(false, true);
        $aData['mats_sel'] = '';
        $aData['id'] = 0;
        $aData['item_title'] = 'Не указано'; 
        $aData['banks'] = $this->db->select('SELECT *, title_'.LNG.' AS title FROM '.TABLE_BUSINESS_BANKS.' ORDER BY num');

        $aData['form'] = $this->viewPHP($aData, 'admin.form');
        return $this->viewPHP($aData, 'admin.listing');
    }
    
    /**
     * Обрабатываем параметры банка
     */
    protected function bankProcessData()
    {
        $aParams = array(
            'enabled' => TYPE_BOOL, # включен
            'item_id' => TYPE_UINT, # основное отделение
        );
        $aData = $this->input->postm($aParams);
        $this->input->postm_lang($this->model->langBanks, $aData);

        if (Request::isPOST())
        {
        }
        return $aData;
    }

}