<?php
    
?>
<?= tplAdmin::blockStart('Объявления / Добавление объявления', false, array('id'=>'BbsItemsFormBlock', 'style'=>'display:none;')) ?>
<div id="BbsItemsFormContainer"></div>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Объявления / Список', true, array('id'=>'BbsItemsListBlock', 'class'=>( ! empty($act) ? 'hidden' : '')), array(
    'title'=>'+ добавить объявление', 'class'=>'ajax', 'onclick'=>'return jBbsItemsFormManager.action(\'add\',0);'
), array(
    array('title'=>'обновление ссылок всех объявлений', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=items-links-rebuild')."'})", 'icon'=>'icon-check'),
)); ?>
<?
    $aTabs = array(
        0 => array('t'=>'Опубликованные'),
        1 => array('t'=>'Снятые с публикации'),
        2 => array('t'=>'На модерации'),
        3 => array('t'=>'Заблокированные'),
    );
    if( $this->deleteByUser == 1 ) {
        $aTabs[6] = array('t'=>'Удаленные пользователем');
    }
    $aTabs[4] = array('t'=>'Все');
?>
<div class="tabsBar" id="BbsItemsListTabs">
    <? foreach($aTabs as $k=>$v) { ?>
        <span class="tab <? if($f['tab']==$k) { ?>tab-active<? } ?>"><a href="#" onclick="return jBbsItemsList.onTab(<?= $k ?>,this);"><?= $v['t'] ?></a></span>
    <? } ?>
    <div id="BbsItemsProgress" class="progress" style="display: none;"></div>
</div>
<form method="get" action="<?= $this->adminLink(null) ?>" id="BbsItemsListFilters" onsubmit="return false;">
    <input type="hidden" name="s" value="<?= bff::$class ?>" />
    <input type="hidden" name="ev" value="<?= bff::$event ?>" />
    <input type="hidden" name="page" value="<?= $f['page'] ?>" />
    <input type="hidden" name="tab" value="<?= $f['tab'] ?>" />
    <input type="hidden" name="order" value="<?= $f['order'] ?>" />

    <div class="actionBar">
        <div class="left" style="margin-right: 8px;">
            <? if( ! Geo::cityIsOne() ) { ?>
                 <select name="city" style="width: 150px;" onchange="jBbsItemsList.submit(true);"><?= Geo::cityOptions($f['city'], _t('','Все города')) ?></select>
            <? } ?>
            <select name="cat" onchange="jBbsItemsList.refresh();"><?= $cats ?></select>
            <input style="width:130px;" type="text" maxlength="150" name="title" placeholder="Название / ID объявления" value="<?= HTML::escape($f['title']) ?>" />
        </div>
        <div class="left relative" style="margin-right: 8px;">
            <input type="hidden" name="user" id="bbs-items-user-id" value="<?= $f['user'] ?>" />
            <input type="text" class="autocomplete" id="bbs-items-user-title" style="width: 130px;" placeholder="<?= _t('', 'ID / login / email пользователя') ?>" value="<?= ($f['user']>0 ? $user_title : '') ?>" />
        </div>
        <div class="left" style="margin-right: 8px;">
            <input style="width:70px;" type="text" maxlength="150" name="company" placeholder="ID организации" value="<?= $f['company'] ? $f['company'] : '' ?>" />
            <input type="button" class="btn btn-small button" onclick="jBbsItemsList.submit(false);" value="найти" />
            <a href="#" onclick="jBbsItemsList.submit(true); return false;"><i class="icon icon-refresh disabled"></i></a>
        </div>
        <div class="right">

        </div>
        <div class="clear"></div>
    </div>
</form>

<table class="table table-condensed table-hover admtbl tblhover" id="BbsItemsListTable">
<thead>
    <tr class="header nodrag nodrop">
        <th width="50">ID</th>
        <th class="left">Название</th>
        <th width="130">
            <a href="javascript: jBbsItemsList.onOrder('created');" class="ajax">Создано</a>
            <div class="order-<?= $f['order_dir'] ?>" <? if($f['order_by']!='created') { ?>style="display:none;"<? } ?> id="items-order-created"></div>
        </th>
        <th width="105">Действие</th>
    </tr>
</thead>
<tbody id="BbsItemsList">
    <?= $list ?>
</tbody>
</table>
<div id="BbsItemsListPgn"><?= $pgn ?></div>
<?= tplAdmin::blockStop(); ?>

<div>
    <div class="left">
        
    </div>
    <div class="right desc" style="width:60px; text-align:right;">
        
    </div>
</div>

<script type="text/javascript">
var jBbsItemsFormManager = (function(){
    var $progress, $block, $blockCaption, $formContainer;
    var ajaxUrl = '<?= $this->adminLink(bff::$event); ?>';

    $(function(){
        $formContainer = $('#BbsItemsFormContainer');
        $progress = $('#BbsItemsProgress');
        $block = $('#BbsItemsFormBlock');
        $blockCaption = $block.find('span.caption');

        <? if(!empty($act)) { ?>action('<?= $act ?>',<?= $id ?>);<? } ?>
    });

    function onFormToggle(visible)
    {
        if(visible) {
            jBbsItemsList.toggle(false);
            if(jBbsItemsForm) jBbsItemsForm.onShow();
        } else {
            jBbsItemsList.toggle(true);
        }
    }

    function initForm(type, id, params)
    {
        bff.ajax(ajaxUrl,params,function(data){
            if(data && (data.success || intval(params.save)===1)) {
                $blockCaption.html((type == 'add' ? 'Объявления / Добавление объявления' : 'Объявления / Редактирование объявления'));
                $formContainer.html(data.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                onFormToggle(true);
                if(bff.h) {
                    window.history.pushState({}, document.title, ajaxUrl + '&act='+type+'&id='+id);
                }
            } else {
                jBbsItemsList.toggle(true);
            }
        }, $progress);
    }

    function action(type, id, params)
    {
        params = $.extend(params || {}, {act:type});
        switch(type) {
            case 'add':
            {
                if( id > 0 ) return action('edit', id, params);
                if($block.is(':hidden')) {
                    initForm(type, id, params);
                } else {
                    action('cancel');
                }
            } break;
            case 'cancel':
            {
                $block.hide();
                onFormToggle(false);
            } break;
            case 'edit':
            {
                if( ! (id || 0) ) return action('add', 0, params);
                params.id = id;
                initForm(type, id, params);
            } break;
        }
        return false;
    }

    return {
        action: action
    };
}());

var jBbsItemsList =
(function()
{
    var $progress, $block, $list, $listTable, $listPgn, filters, processing = false, tab = <?= $f['tab'] ?>;
    var ajaxUrl = '<?= $this->adminLink(bff::$event.'&act='); ?>';
    var orders = <?= func::php2js($orders) ?>, orderby = '<?= $f['order_by'] ?>';

    $(function(){
        $progress  = $('#BbsItemsProgress');
        $block     = $('#BbsItemsListBlock');
        $list      = $block.find('#BbsItemsList');
        $listTable = $block.find('#BbsItemsListTable');
        $listPgn   = $block.find('#BbsItemsListPgn');
        filters    = $block.find('#BbsItemsListFilters').get(0);

        $list.delegate('a.item-edit', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) jBbsItemsFormManager.action('edit',id);
            return false;
        });

        $list.delegate('a.item-toggle', 'click', function(){
            var id = intval($(this).attr('rel'));
            var type = $(this).data('type');
            if(id>0) {
                var params = {progress: $progress, link: this};
                bff.ajaxToggle(id, ajaxUrl+'toggle&type='+type+'&id='+id, params);
            }
            return false;
        });

        $list.delegate('a.item-del', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del(id, this);
            return false;
        });

        $('#bbs-items-user-title').autocomplete( ajaxUrl+'item-user-autocomplete',
            {valueInput: '#bbs-items-user-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    setPage(1); updateList();
                }});


    });

    function isProcessing()
    {
        return processing;
    }

    function del(id, link)
    {
        bff.ajaxDelete('Удалить?', id, ajaxUrl+'delete&id='+id, link, {progress: $progress, repaint: false});
        return false;
    }

    function updateList(updateUrl)
    {
        if(isProcessing()) return;
        var f = $(filters).serialize();
        bff.ajax(ajaxUrl, f, function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                if(updateUrl !== false && bff.h) {
                    window.history.pushState({}, document.title, $(filters).attr('action') + '?' + f);
                }
            }
        }, function(p){ $progress.toggle(); processing = p; $list.toggleClass('disabled'); });
    }

    function setPage(id)
    {
        filters.page.value = intval(id);
    }

    return {
        submit: function(resetForm)
        {
            if(isProcessing()) return false;
            setPage(1);
            if(resetForm) {
                filters['cat'].value = 0;
                filters['title'].value = '';
                //
            }
            updateList();
        },
        page: function (id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        },
        onOrder: function(by)
        {
            if(isProcessing() || !orders.hasOwnProperty(by))
                return;

            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            $('#items-order-'+orderby).hide();
            orderby = by;
            $('#items-order-'+orderby).removeClass('order-asc order-desc').addClass('order-'+orders[by]).show();

            filters.order.value = orderby+'-'+orders[by];
            setPage(1);

            updateList();
        },
        onTab: function(tabNew, link)
        {
            if(isProcessing() || tabNew == tab) return false;
            setPage(1);
            tab = filters.tab.value = tabNew;
            updateList();
            $(link).parent().addClass('tab-active').siblings().removeClass('tab-active');
            return false;
        },
        refresh: function(resetPage,updateUrl)
        {
            if(resetPage) setPage(0);
            updateList(updateUrl);
        },
        toggle: function(show)
        {
            if(show === true) {
                $block.show();
                if(bff.h) window.history.pushState({}, document.title, $(filters).attr('action') + '?' + $(filters).serialize());
            }
            else $block.hide();
        }
    };
}());
</script>