<?php
    $aData = HTML::escape($aData, 'html', array('cat_id','title','addr_addr'));
    $edit = !empty($id);
    if (!$edit) {
        Geo::mapsDefaultCoordsCorrect($addr_lat, $addr_lng);
    }

    $tab = (!empty($_GET['tab']) ? $_GET['tab'] : false);
    $aTabs = array(
        'info' => 'Описание',
        'images' => 'Фото',
    );
    if($edit) {
        if (BBS::commentsEnabled()) {
            $aTabs['comments'] = 'Комментарии';
        }
        $aTabs['claims'] = 'Жалобы ('.$claims_cnt.')';
        $aTabs['svc'] = 'Услуги';
    }
    if( ! isset($aTabs[$tab])) {
        $tab = 'info';
    }
?>

<div class="tabsBar" id="BbsItemsFormTabs">
    <? $i = 0; foreach($aTabs as $k=>$v) { ?>
        <span class="tab<? if(!$i++){ ?> tab-active<? } ?>" onclick="return jBbsItemsForm.onTab('<?= $k ?>', this);"><?= $v ?></span>
    <? } ?>
    <div class="progress" style="display:none;" id="BbsItemsFormProgress"></div>
</div>

<div id="item-form-block-info" class="hidden">
<form name="BbsItemsForm" id="BbsItemsForm" action="<?= $this->adminLink(null) ?>" method="get" onsubmit="return false;">
<input type="hidden" name="act" value="<?= ($edit ? 'edit' : 'add') ?>" />
<input type="hidden" name="save" value="1" />
<input type="hidden" name="id" value="<?= $id ?>" />
<input type="hidden" name="cat_id" id="item-cat_id" value="<?= $cat_id ?>" />
<table class="admtbl tbledit">
<tr class="required check-select">
    <td class="row1 field-title" width="100">Категория<span class="required-mark">*</span>:</td>
    <td class="row2">
        <?
            foreach($cats as $lvl=>$v) {
                ?><select class="cat-select" style="margin-right: 5px;<? if (empty($v['categories'])){ ?>display: none; <? } ?>" onchange="jBbsItemsForm.onCategory($(this))"><?= $v['categories'] ?></select><?
            }
        ?>
    </td>
</tr>
<tr id="item-types" <? if(!$edit || ($edit && empty($types))){ ?>style="display: none;"<? } ?>>
    <td class="row1" width="115"><span class="field-title">Тип</span>:</td>
    <td class="row2">
        <select name="cat_type" id="item-types-select"><?= (!empty($types) ? $types : '') ?></select>
    </td>
</tr>
<tr class="required">
    <td class="row1"><span class="field-title">Заголовок<span class="required-mark">*</span>:</span></td>
    <td class="row2">
        <input class="stretch" type="text" id="item-title" name="title" value="<?= $title ?>" />
    </td>
</tr>
<tbody id="item-dynprops"><?= (!empty($dp) ? $dp : '') ?></tbody>
<tr id="item-price" <? if(!$edit || ($edit && !$cat['prices'])){ ?>style="display: none;"<? } ?>>
    <td class="row1"><span class="field-title">Цена</span><span class="required-mark">*</span>:</td>
    <td class="row2">
        <input type="text" maxlength="9" name="price" class="req" value="<?= $price; ?>" style="width:120px;" pattern="[0-9]*" />&nbsp;
        <select name="price_curr"><?= $curr ?></select>
        <? foreach($this->getPriceParams() as $ppKey=>$ppTitle) {
            ?><label class="checkbox inline"><input type="checkbox" <?= ($price_params & $ppKey ?'checked':'') ?> name="price_params[]" value="<?= $ppKey ?>" /><?= $ppTitle ?></label><?
        } ?>
    </td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Местоположение:</span></td>
    <td class="row2">
        <?= Geo::cityOptionsSelect($city_id, true, 'city_id', array('onchange'=>'jBbsItemsForm.onCity(this.value);','id'=>'item-addr-city')); ?>
        <div id="item-addr" <? if(!$edit || ($edit && !$cat['addr'])){ ?>style="display: none;"<? } ?>>
            <input type="hidden" name="addr_lat" id="item-addr_lat" value="<?= $addr_lat ?>" />
            <input type="hidden" name="addr_lng" id="item-addr_lng" value="<?= $addr_lng ?>" />

        <span id="item-addr-view"<? if(!$edit){ ?> style="display: none;"<? } ?>>
            <strong><?= $addr_addr ?></strong>
            <a href="#" id="item-addr-edit-link" class="ajax desc" onclick="jBbsItemsForm.addrEdit(); return false;">- изменить</a>
        </span>
            <div id="item-addr-edit"<? if($edit){ ?> style="display: none;"<? } ?>>
                <input type="text" name="addr_addr" value="<?= $addr_addr ?>" id="item-addr-addr" style="width: 300px; margin: 5px 5px 5px 0;" />
                <a href="#" class="ajax" id="item-addr-map-link" onclick="jBbsItemsForm.onMapSearch(); return false;">найти на карте</a><br/>
                <div id="item-addr-map-block">
                    <div id="item-addr-map" class="map" style="width:466px; height: 300px;"></div>
                    <span class="desc small">Переместите маркер на карте чтобы указать точное местоположение</span>
                </div>
            </div>
        </div>
    </td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Описание:</span></td>
    <td class="row2">
        <textarea class="short" id="item-descr" name="descr"><?= $descr ?></textarea>
    </td>
</tr>
<? if($edit) { if(!empty($aCompanyInfo)) { ?>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Компания:</td>
    <td>
        <a href="<?= Items::url('view', $aCompanyInfo['link']) ?>" class="but linkout" target="_blank"></a><a href="<?= $this->adminLink('items_edit&item_id='.$company_id, 'items') ?>"><?= $aCompanyInfo['title'] ?></a>
    </td>
</tr>
<? } ?>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Пользователь:</td>
    <td class="row2"><a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_email ?></a></td>
</tr>
<? } ?>
<tr>
    <td class="row1 field-title">Имя:</td>
    <td class="row2"><input type="text" name="user_name" value="<?= $user_name ?>" class="text-field" /></td>
</tr>
<tr>
    <td class="row1 field-title">Телефон:</td>
    <td class="row2"><input type="tel" name="user_phone" value="<?= $user_phone ?>" class="text-field" /></td>
</tr>
<? if($edit) { ?>
<tr>
    <td class="row1" colspan="2">
        <?= $this->viewPHP($aData, 'admin.items.form.status'); ?>
    </td>
</tr>
<? } else {
?>
    <tr>
        <td class="row1"><span class="field-title">Публикация</span>:</td>
        <td class="row2">
            <span>от <?= date('d.m.Y') ?> до <b><?= $this->getItemPublicationPeriod(false, 'd.m.Y') ?></b></span>
        </td>
    </tr>
<? } ?>
</table>

<table class="admtbl tbledit">
    <tr>
        <td colspan="2" class="row1">
            <input type="submit" class="btn btn-success button submit" value="Сохранить" onclick="jBbsItemsForm.save(false);" />
            <? if($edit) { ?><input type="button" class="btn btn-success button submit" value="Сохранить и вернуться" onclick="jBbsItemsForm.save(true);" /><? } ?>
            <? if($edit) { ?><input type="button" onclick="jBbsItemsForm.del(); return false;" class="btn btn-danger button delete" value="Удалить" /><? } ?>
            <input type="button" class="btn button cancel" value="Отмена" onclick="jBbsItemsFormManager.action('cancel');" />
        </td>
    </tr>
</table>

</form>
</div>

<div id="item-form-block-images" class="hidden"><? include 'admin.items.form.images.php'; ?></div>
<div id="item-form-block-comments" class="hidden"></div>
<div id="item-form-block-claims" class="hidden"></div>
<div id="item-form-block-svc" class="hidden"><? if($edit) { include 'admin.items.form.svc.php'; } ?></div>

<script type="text/javascript">
var jBbsItemsForm =
(function(){
    var $form, formChk, $progress, id = <?= $id ?>, blocksPrefix = 'item-form-block-';
    var $types, $typesSel, $dp, $price, $addr;
    var addr = {i:false,addr:0,lat:0,lng:0}, city = {id:0,title:'',$sel:false};


    var ajaxUrl = '<?= $this->adminLink(bff::$event.'&act='); ?>';
    var catCache = {};

    $(function(){
        $progress = $('#BbsItemsFormProgress');
        $form = $('#BbsItemsForm');
        initBlock('<?= $tab ?>', false);
    });

    function initBlock(key, $block)
    {
        if($block === false) {
            $block = $('#'+blocksPrefix+key);
        }
        switch(key)
        {
            case 'info':
            {
                $form = $block.find('form:first');
                $types = $form.find('#item-types');
                $typesSel = $types.find('#item-types-select');
                $dp = $form.find('#item-dynprops');
                $price = $form.find('#item-price');
                $addr = $form.find('#item-addr');
                city.$sel = $form.find('#item-addr-city');
                onCity(city.$sel.val());
            } break;
            case 'images':
            {
                <? if(!$edit) { ?>
                var lostProcessed = false;
                $(window).bind('beforeunload', function(){
                    if(!lostProcessed && id===0) {
                        var $fn = $('#item-images input.imgfn');
                        if($fn.length > 0) {
                            lostProcessed = true;
                            var fn = [];
                            $fn.each(function(){
                                fn.push($(this).val());
                            });
                            jItemImages.delAll(false, fn);
                        }
                    }
                });
                <? } ?>
            } break;
            case 'comments':
            {
                bff.ajax(ajaxUrl+'comments-init', {id:id}, function(data){
                    if(data) {
                        $block.html(data.html);
                    }
                }, $progress);
            } break;
            case 'claims':
            {
                bff.ajax(ajaxUrl+'claims-init', {id:id}, function(data){
                    if(data) {
                        $block.html(data.html);
                    }
                }, $progress);
            } break;
        }
        $block.addClass('inited').removeClass('hidden');
    }

    function catView(data, $select)
    {
        if(data === 'empty') {
            $types.hide();
            $price.hide();
            $addr.hide();
            $dp.empty();
            return;
        }

        if(data.subs>0) {
            $price.hide();
            $addr.hide();
            $dp.empty();
            $select.after('<select class="cat-select" style="margin-right: 5px;" onchange="jBbsItemsForm.onCategory($(this))">'+data.cats+'</select>').show();
            return;
        }

        if(data.types) { $typesSel.html( data.types ); $types.show(); }
        else { $types.hide(); $typesSel.html(''); }

        if(intval(data.prices)!=0) { $price.show(); }
        else { $price.hide(); }

        if(intval(data.addr)!=0) { $addr.show(); addrEdit(); }
        else { $addr.hide(); }

        $dp.html( data.dp );

        formChk.check(false, true);
    }

    function initAddr()
    {
        if( addr.i === true ) {
            addr.map.refresh();
            return;
        }

        addr.addr = $form.find('#item-addr-addr');
        addr.lat  = $form.find('#item-addr_lat');
        addr.lng  = $form.find('#item-addr_lng');
        addr.i    = true;

        addr.map = bff.map.init('item-addr-map', [addr.lat.val(), addr.lng.val()], function(map){
            addr.mapEditor = bff.map.editor();
            addr.mapEditor.init({
                map: map, version: '2.1',
                coords: [addr.lat, addr.lng],
                address: addr.addr,
                addressKind: 'house',
                updateAddressIgnoreClass: 'typed'
            });

            addr.addr.bind('change keyup input', $.debounce(function(){
                if( ! $.trim(addr.addr.val()).length ) {
                    addr.addr.removeClass('typed');
                } else {
                    addr.addr.addClass('typed');
                    jBbsItemsForm.onMapSearch();
                }
            }, 700));
        }, {zoom: 12});
    }

    function addrEdit()
    {
        $('#item-addr-view', $addr).remove();
        $('#item-addr-edit', $addr).show();
        initAddr();
    }

    function onCity(cityID)
    {
        var opt = city.$sel.find('option:selected');
        city.title = opt.text();
        city.ycoords = opt.data('ycoords');
        city.id = intval(cityID);
    }

    return {
        onTab: function(key, tabLink)
        {
            if(key == 'services') return false;
            $('[id^="'+blocksPrefix+'"]').addClass('hidden');
            var $block = $('#'+blocksPrefix+key).removeClass('hidden');
            if(!$block.hasClass('inited')) {
                initBlock(key, $block);
            }
            bff.onTab(tabLink);
            if(bff.h) {
                window.history.pushState({}, document.title, '<?= $this->adminLink(bff::$event.'&act='.($edit?'edit':'add').'&id='.$id.'&tab=') ?>' + key);
            }
        },
        del: function()
        {
            if( id > 0 ) {
                bff.ajaxDelete('sure', id, ajaxUrl+'delete&id='+id,
                    false, {progress: $progress, repaint: false, onComplete:function(){
                        bff.success('Запись успешно удалена');
                        jBbsItemsFormManager.action('cancel');
                        jBbsItemsList.refresh();
                    }});
            }
        },
        save: function(returnToList)
        {
            if( ! formChk.check(true) ) return;
            // check selected cats
            var catsEmpty = $form.find('select.cat-select[value="0"]:visible');
            if(catsEmpty.length > 0) {
                bff.error('Выберите категорию');
                return false;
            }

            bff.ajax(ajaxUrl, $form.serialize()+'&'+$('#item-form-images').serialize(), function(data,errors){
                if(data && data.success) {
                    bff.success('Данные успешно сохранены');
                    if(returnToList || ! id) {
                        jBbsItemsFormManager.action('cancel');
                        jBbsItemsList.refresh( ! id);
                    }
                }
            }, $progress);
        },
        onShow: function ()
        {
            formChk = new bff.formChecker( $form );
            if( $addr.is(':visible') && addr.i ) {
                initAddr();
            }
        },
        onCategory: function($select)
        {
            catView('empty');

            var catID = intval($select.val());
            $form.find('#item-cat_id').val(catID);
            $select.nextAll().remove();

            if( ! catID) return;

            if(catCache.hasOwnProperty(catID)) {
                catView( catCache[catID], $select );
            } else {
                bff.ajax(ajaxUrl+'category-data', {cat_id: catID}, function(data){
                    if(data && data.success) {
                        catView( (catCache[catID] = data), $select );
                    }
                }, $progress);
            }
        },
        addrEdit: addrEdit,
        onCity: onCity,
        onMapSearch: function()
        {
            var q = [city.title];
            q.push( $.trim( addr.addr.val() ) );
            addr.mapEditor.search( q.join(', ') );
            return false;
        }

    };
}());
</script>