<?php
    tpl::includeJS(array('tablednd'), true);
    $bRotate = true;
?>
<?= tplAdmin::blockStart('Доска объявлений / Добавление категории', false, array('id'=>'BbsCategoriesFormBlock', 'style'=>'display:none;')) ?>
    <div id="BbsCategoriesFormContainer"></div>
<?= tplAdmin::blockStop(); ?>

<?= tplAdmin::blockStart('Доска объявлений / Список категорий', true, array('id'=>'BbsCategoriesListBlock', 'class'=>( ! empty($act) ? 'hidden' : '')), array(
    'title'=>'+ добавить', 'class'=>'ajax', 'onclick'=>'return jBbsCategoriesFormManager.action(\'add\',0);'
), array(
    array('title'=>'валидация treeNestedSets', 'onclick'=>"return bff.confirm('sure', {r:'".$this->adminLink(bff::$event.'&act=dev-ns-valid')."'})", 'icon'=>'icon-check'),
)); ?>
<form method="get" action="<?= $this->adminLink(null) ?>" id="BbsCategoriesListFilters" onsubmit="return false;">
    <input type="hidden" name="s" value="<?= bff::$class ?>" />
    <input type="hidden" name="ev" value="<?= bff::$event ?>" />
    <input type="hidden" name="page" value="<?= $f['page'] ?>" />

    <div class="actionBar" style="min-height: 14px;">
        <div class="left">
        </div>
        <div class="right">
            <div id="BbsCategoriesProgress" class="progress" style="display: none;"></div>
        </div>
        <div class="clear"></div>
    </div>
</form>

<table class="table table-condensed table-hover admtbl tblhover" id="BbsCategoriesListTable">
<thead>
    <tr class="header nodrag nodrop">
        <th width="70">ID</th>
        <th class="left">Название</th>
        <th width="110">Точка на карте</th>
        <th width="70">Цена</th>
        <th width="135">Действие</th>
    </tr>
</thead>
<tbody id="BbsCategoriesList">
    <?= $list ?>
</tbody>
</table>
<?= tplAdmin::blockStop(); ?>

<div>
    <div class="left"></div>
    <div class="right desc" style="width:60px; text-align:right;">
        <? if($bRotate){ ?>&darr; &uarr;<? } ?>
    </div>
</div>

<script type="text/javascript">
var jBbsCategoriesFormManager = (function(){
    var $progress, $block, $blockCaption, $formContainer;
    var ajaxUrl = '<?= $this->adminLink(bff::$event); ?>';

    $(function(){
        $formContainer = $('#BbsCategoriesFormContainer');
        $progress = $('#BbsCategoriesProgress');
        $block = $('#BbsCategoriesFormBlock');
        $blockCaption = $block.find('span.caption');

        <? if(!empty($act)) { ?>action('<?= $act ?>',<?= $id ?>,<?= func::php2js($_POST) ?>);<? } ?>
    });

    function onFormToggle(visible)
    {
        if(visible) {
            jBbsCategoriesList.toggle(false);
            if(jBbsCategoriesForm) jBbsCategoriesForm.onShow();
        } else {
            jBbsCategoriesList.toggle(true);
        }
    }

    function initForm(type, id, params)
    {
        bff.ajax(ajaxUrl,params,function(data){
            if(data && (data.success || intval(params.save)===1)) {
                $blockCaption.html('Доска объявлений / '+(type == 'add' ? 'Добавление категории' : 'Редактирование категории'));
                $formContainer.html(data.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                onFormToggle(true);
                if(bff.h) {
                    window.history.pushState({}, document.title, ajaxUrl + '&act='+type+'&id='+id);
                }
            } else {
                jBbsCategoriesList.toggle(true);
            }
        }, $progress);
    }

    function action(type, id, params)
    {
        params = $.extend(params || {}, {act:type});
        switch(type) {
            case 'add':
            {
                if( id > 0 ) return action('edit', id, params);
                if($block.is(':hidden')) {
                    initForm(type, id, params);
                } else {
                    action('cancel');
                }
            } break;
            case 'cancel':
            {
                $block.hide();
                onFormToggle(false);
            } break;
            case 'edit':
            {
                if( ! (id || 0) ) return action('add', 0, params);
                params.id = id;
                initForm(type, id, params);
            } break;
        }
        return false;
    }

    return {
        action: action
    };
}());

var jBbsCategoriesList =
(function()
{
    var $progress, $block, $list, $listTable, $listPgn, filters, processing = false;
    var ajaxUrl = '<?= $this->adminLink(bff::$event.'&act='); ?>';
    
    $(function(){
        $progress  = $('#BbsCategoriesProgress');
        $block     = $('#BbsCategoriesListBlock');
        $list      = $block.find('#BbsCategoriesList');
        $listTable = $block.find('#BbsCategoriesListTable');
        $listPgn   = $block.find('#BbsCategoriesListPgn');
        filters    = $block.find('#BbsCategoriesListFilters').get(0);

        $list.delegate('a.category-edit', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) jBbsCategoriesFormManager.action('edit',id);
            return false;
        });

        $list.delegate('a.category-toggle', 'click', function(){
            var id = intval($(this).attr('rel'));
            var type = $(this).data('type');
            if(id>0) {
                var params = {progress: $progress, link: this};
                bff.ajaxToggle(id, ajaxUrl+'toggle&type='+type+'&id='+id, params);
            }
            return false;
        });

        $list.delegate('a.category-del', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del(id, this);
            return false;
        });

        $list.delegate('a.category-expand', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.expandNS(id, ajaxUrl+'expand&id=', {cookie:app.cookiePrefix+'bbs_categories_expand', progress:$progress});
            }
            return false;
        });

        $list.delegate('a.category-dynprops', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.redirect('<?= $this->adminLink('dynprops_listing&owner='); ?>'+id);
            }
            return false;
        });

        $list.delegate('a.category-types', 'click', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.redirect('<?= $this->adminLink('types&cat_id='); ?>'+id);
            }
            return false;
        });

        $(window).bind('popstate',function(e){
            var loc = document.location;
            var actForm = /act=(add|edit)&id=([\d]+)/.exec( loc.search.toString() );
            if( actForm!=null ) {
                jBbsCategoriesFormManager.action(actForm[1], actForm[2]);
            } else {
                jBbsCategoriesFormManager.action('cancel');
                updateList(false);
            }
        });

        <? if($bRotate) { ?>bff.rotateTable($list, ajaxUrl+'rotate', $progress);<? } ?>
    });

    function isProcessing()
    {
        return processing;
    }

    function del(id, link)
    {
        bff.ajaxDelete('Удалить?', id, ajaxUrl+'delete&id='+id, link,
            {progress: $progress, repaint: false, onComplete: function(){
                bff.success('Категория была успешно удалена');
            }});
        return false;
    }

    function updateList(updateUrl)
    {
        if(isProcessing()) return;
        var f = $(filters).serialize();
        bff.ajax(ajaxUrl, f, function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                if(updateUrl !== false && bff.h) {
                    window.history.pushState({}, document.title, $(filters).attr('action') + '?' + f);
                }
                <? if($bRotate) { ?>$list.tableDnDUpdate();<? } ?>
            }
        }, function(p){ $progress.toggle(); processing = p; $list.toggleClass('disabled'); });
    }

    function setPage(id)
    {
        // нет постраничности
    }

    return {
        submit: function(resetForm)
        {
            if(isProcessing()) return false;
            setPage(1);
            if(resetForm) {
                //
            }
            updateList();
        },
        page: function(id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        },
        refresh: function(resetPage,updateUrl)
        {
            if(resetPage) setPage(0);
            updateList(updateUrl);
        },
        toggle: function(show)
        {
            if(show === true) {
                $block.show();
                if(bff.h) window.history.pushState({}, document.title, $(filters).attr('action') + '?' + $(filters).serialize());
            }
            else $block.hide();
        }
    };
}());
</script>