<?php
    $aData = HTML::escape($aData, 'html', array('keyword'));
    $edit = ! empty($id);
    $aTabs = array(
        'info' => 'Основные',
        'seo' => 'SEO',
    );
?>
<form name="BbsCategoriesForm" id="BbsCategoriesForm" action="<?= $this->adminLink(bff::$event.'&id='.$id) ?>" method="post" enctype="multipart/form-data">
<input type="hidden" name="act" value="<?= ($edit ? 'edit' : 'add') ?>" />
<input type="hidden" name="save" value="1" />
<input type="hidden" name="id" value="<?= $id ?>" />
<input type="hidden" name="return" value="0" />
<div class="tabsBar">
    <? foreach($aTabs as $k=>$v) { ?>
        <span class="tab<? if($k == 'info') { ?> tab-active<? } ?>"><a href="#" class="j-tab-toggler" data-key="<?= $k ?>"><?= $v ?></a></span>
    <? } ?>
</div>
<div class="j-tab j-tab-info">
<table class="admtbl tbledit">
<tr class="required check-select">
    <td class="row1 field-title" width="110">Основной раздел<span class="required-mark">*</span>:</td>
    <td class="row2">
        <? if( $edit ) { ?>
            <input type="hidden" name="pid" id="category-pid" value="<?= $pid ?>" />
            <span class="bold"><?= $pid_path ?></span>
        <? } else { ?>
            <select name="pid" id="category-pid"><?= $this->model->categoriesOptions($pid, false, 1) ?></select>
        <? } ?>
    </td>
</tr>
<?= $this->locale->buildForm($aData, 'categories-item','
<tr class="required">
    <td class="row1"><span class="field-title">Название<span class="required-mark">*</span>:</span></td>
    <td class="row2">
        <input class="stretch <?= $key ?> category-title" type="text"  name="title[<?= $key ?>]" value="<?= HTML::escape($aData[\'title\'][$key]); ?>" />
    </td>
</tr>
'); ?>
<tr>
    <td class="row1"><span class="field-title">Точка на карте:</span></td>
    <td class="row2">
        <label class="checkbox"><input type="checkbox" id="category-addr" name="addr"<? if($addr){ ?> checked="checked"<? } ?> /></label>
    </td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Цена:</span></td>
    <td class="row2">
        <label class="checkbox"><input type="checkbox" id="category-prices" name="prices"<? if($prices){ ?> checked="checked"<? } ?> /></label>
    </td>
</tr>
<? if( ! $edit || empty($keyword) ) { ?>
<tr>
    <td class="row1"><span class="field-title">URL-Keyword:</span><br /><a href="#" onclick="return bff.generateKeyword('.category-title:visible', '#category-keyword');" class="ajax desc small">сгенерировать</a></td>
    <td class="row2">
        <input class="stretch" type="text" id="category-keyword" name="keyword" value="<?= $keyword ?>" />
    </td>
</tr>
<? } ?>
</table>
</div>
<div class="j-tab j-tab-seo hidden">
    <?= SEO::i()->form($this, $aData, 'search'); ?>
</div>
<div style="margin-top: 10px;">
    <input type="submit" class="btn btn-success button submit" value="Сохранить" onclick="jBbsCategoriesForm.save(false);" />
    <? if($edit) { ?><input type="button" class="btn btn-success button submit" value="Сохранить и вернуться" onclick="jBbsCategoriesForm.save(true);" /><? } ?>
    <? if($edit) { ?><input type="button" onclick="jBbsCategoriesForm.del(); return false;" class="btn btn-danger button delete" value="Удалить" /><? } ?>
    <input type="button" class="btn button cancel" value="Отмена" onclick="jBbsCategoriesFormManager.action('cancel');" />
</div>
</form>

<script type="text/javascript">
var jBbsCategoriesForm =
(function(){
    var $progress, $form, formChk, id = <?= $id ?>;
    var ajaxUrl = '<?= $this->adminLink(bff::$event); ?>';

    $(function(){
        $progress = $('#BbsCategoriesFormProgress');
        $form = $('#BbsCategoriesForm');

        $form.on('click', '.j-tab-toggler', function(e){ nothing(e);
            var key = $(this).data('key');
            $form.find('.j-tab').addClass('hidden');
            $form.find('.j-tab-'+key).removeClass('hidden');
            $(this).parent().addClass('tab-active').siblings().removeClass('tab-active');
        });
    });
    return {
        del: function()
        {
            if( id > 0 ) {
                bff.ajaxDelete('sure', id, ajaxUrl+'&act=delete&id='+id,
                    false, {progress: $progress, repaint: false, onComplete:function(){
                        bff.success('Категория успешно удалена');
                        jBbsCategoriesFormManager.action('cancel');
                        jBbsCategoriesList.refresh();
                    }});
            }
        },
        save: function(returnToList)
        {
            if( ! formChk.check(true) ) return;
            $form.find('input[name="return"]').val((returnToList?1:0));
            $form.submit();
        },
        onShow: function ()
        {
            formChk = new bff.formChecker( $form );
        }
    };
}());
</script>