<?php

class BBSItemComments extends bff\db\Comments
{
    function initSettings()
    {
        $this->tblComments = TABLE_BBS_ITEMS_COMMENTS;
        $this->tblItems    = TABLE_BBS_ITEMS;
        $this->tblItemsID  = 'id';
        $this->preModeration = false; # постмодерация
        $this->commentsTree = true; # древовидные
        $this->commentsTree2Levels = 2; # не более двух уровней
        # config-ключ для хранения общего счетчика непромодерированных комментариев
        $this->counterKey_UnmoderatedAll = 'bbs_comments_mod';
        # имя поля в таблице объявлений - для хранения кол-ва комментариев объявления(видимых пользователю)
        $this->counterKey_ItemComments = 'comments_cnt';
        $this->commentHideReasons[self::commentDeletedByModerator]    = _t('bbs', 'Комментарий был удален модератором');
        $this->commentHideReasons[self::commentDeletedByCommentOwner] = _t('bbs', 'Комментарий был удален автором комментария');
        $this->commentHideReasons[self::commentDeletedByItemOwner]    = _t('bbs', 'Комментарий был удален автором объявления');
        $this->commentHideReasons[self::commentFromBlockedUser]       = _t('bbs', 'Комментарий от заблокированного пользователя');
        $this->urlListing = $this->adminLink('items&act=edit&tab=comments&id=', 'bbs');
        $this->urlListingAjax = $this->adminLink('comments_ajax', 'bbs');
    }
}