<?php

class BBS extends BBSBase
{
    public function route()
    {
        $prefix = ( ! bff::subdomainsEnabled('bbs') ? 'board/' : '' );
        $res = bff::route(array(
            $prefix.'(.*)\-([\d]+)\.html'      => 'bbs/view/id=\\2',
            $prefix.'search/(.*)'              => 'bbs/search/cat=\\1',
            $prefix.'(add|edit|fav|search|promote)(.*)' => 'bbs/\\1',
        ), true);

        if ($res['event'] === false || !method_exists($this, $res['event']))
            $res['event'] = 'index';

        return $this->$res['event']();
    }

    /**
     * Блок "Доска объявлений" на главной
     */
    public function indexBlock()
    {
        # категории
        $aData['cats'] = $this->model->categoriesList(1, $this->regionsFilterEnabled());
        return $this->viewPHP($aData, 'index.block');
    }

    /**
     * Главная страница раздела "Доска объявлений"
     */
    public function index()
    {
        $aData = array();

        # vip блок
        $aData['vipBlock'] = $this->vipBlock();

        # список категории
        $nSubSlice = 5; # максимально допустимое видимое кол-во подкатегорий
        $nCols = 2; # кол-во столбцов
        $aCats = $this->model->categoriesList(2, $this->regionsFilterEnabled());
        if ( ! empty($aCats))
        {
            $aCats = $this->db->transformRowsToTree($aCats, 'id', 'pid', 'sub');
            foreach ($aCats as &$c)
            {
                $c['l'] = static::url('search', $c['keyword']);
                foreach ($c['sub'] as &$cc) {
                    $cc['l'] = static::url('search', $cc['keyword']);
                }
                $c['subn'] = sizeof($c['sub']);
                $c['sub'] = array_slice($c['sub'], 0, $nSubSlice);
            }
        }

        # делим на столбцы
        $aResult = array();
        $nCatsCnt = sizeof($aCats);
        $nCatsCnt = ( ! $nCatsCnt % $nCols ? ($nCatsCnt/$nCols) : round($nCatsCnt/$nCols) );
        if ( $nCols == 2 ) {
            if ( $nCatsCnt > 0 ) {
                list($aResult['left'], $aResult['right']) = array_chunk($aCats, $nCatsCnt);
            } else {
                $aResult = array('left'=>array(), 'right'=>array());
            }
        } elseif ($nCols == 3) {
            $aResult = array_chunk($aCats, $nCatsCnt);
        }
        $aData['cats'] = $aResult;

        # последние добавленные
        $aLatestFilter = array('status'=>self::STATUS_PUBLICATED);
        if ( $this->regionsFilterEnabled() ) {
            $aLatestFilter['city_id'] = Geo::cityID();
        }
        $aData['latest'] = $this->model->itemsList($aLatestFilter,
                                false,
                                $this->db->prepareLimit(0,3),
                                'id DESC');

        # SEO: Главная страница
        $this->urlCorrection(static::url('index'));
        $this->seo()->canonicalUrl(static::url('index', array(), true));
        $this->setMeta('index', array(
            'region' => Geo::filter('title'),
        ), $aData);

        bff::setActiveMenu('//bbs/search', false);
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'index');
    }

    /**
     * Поиск объявлений
     */
    public function search()
    {
        $aData = array();
        $f = $this->input->postgetm(array(
            'rc' => TYPE_INT,   # регион: город
            'c'  => TYPE_UINT,  # категория
            'cl' => TYPE_UINT,  # категория: уровень (level)
            't'  => TYPE_UINT,  # тип категории
            'f'  => TYPE_ARRAY, # дин. свойства
            'fc' => TYPE_ARRAY, # дин. свойства (child)
            'pf' => TYPE_PRICE, # цена, от
            'pt' => TYPE_PRICE, # цена, до
            'ph' => TYPE_BOOL,  # есть фотографии
            'cnt' => TYPE_BOOL, # просто считаем
        )); $aData['f'] =& $f;

        $sql = array('status'=>self::STATUS_PUBLICATED);
        $seoNoIndex = false;

        # категория
        if (Request::isAJAX()) {
            $sql['cat_id'.$f['cl']] = $nCatID = $f['c'];
        } else {
            # получаем данные категории по keyword
            $sCatKey = $this->input->get('cat', TYPE_STR);
            $sCatKey = rtrim($sCatKey, '/ ');
            $aCat = $this->model->categoryDataSearch($sCatKey);
            if (empty($sCatKey) || empty($aCat)) {
                $this->errors->error404();
            }
            $sql['cat_id'.$aCat['lvl']] = $nCatID = $f['c'] = $aCat['id'];
            $aData['cat'] = &$aCat;
            if($aCat['lvl'] > 1 && empty($aCat['subs'])){
                $aData['parent'] = $this->model->categoryData($aCat['pid']);
            }else{
                $aData['parent'] = $aCat;
            }
        }
        if ( ! Geo::cityIsOne() ) {
            if ( $f['rc'] === 0 ) {
                $f['rc'] = ( $this->regionsFilterEnabled() ? Geo::cityID() : -1 );
            }
            if ($f['rc'] > 0) { # регион: город
                $sql['city_id'] = $f['rc'];
            }
            if (Geo::filterUrl('id') != $f['rc']) {
                $seoNoIndex = true;
            }
        }
        $seoResetCounter = sizeof($sql); # всю фильтрацию ниже скрываем от индексации

        $nTypeID = $f['t'];
        if ($nTypeID) { # тип категории
            $sql['cat_type'] = $nTypeID;
        }
        # Цена (в основной валюте)
        if ($f['pf'] > 0 || $f['pt'] > 0)
        {
            if ($f['pf'] > 0) { # от
                $sql[] = array('price_search >= :priceFrom', ':priceFrom'=>$f['pf']);
                if ($f['pt'] > 0 && $f['pt'] > $f['pf']) { # если ДО, и ДО больше ОТ
                    $sql[] = array('price_search <= :priceTo', ':priceTo'=>$f['pt']);
                }
            } else if ($f['pt'] > 0) { # до
                $sql[] = array('price <= :priceTo', ':priceTo'=>$f['pt']);
            }
        }
        if ($f['ph']) { # есть фотографии
            $sql[] = 'imgcnt > 0';
        }

        # фильтр по дин. свойствам
        $sqlDP = $this->dp()->prepareSearchQuery($f['f'], $f['fc'], $this->dpSettings($nCatID), '');
        if ( ! empty($sqlDP)) {
            $sql[':dp'] = $sqlDP;
        }

        # считаем
        $nPerpage = config::sys('bbs.search.perpage', 10);
        $nTotal = $this->model->itemsList($sql, true);
        if (Request::isAJAX()) {
            # возвращаем кол-во
            $this->ajaxResponseForm(array('total'=>$nTotal));
        }

        $aRequestURI = parse_url(Request::uri());
        $sQuery = ( ! empty($aRequestURI['query']) ? trim( preg_replace('/&?page=(\d+)/', '', $aRequestURI['query']), '&') : '' );
        $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('search', $sCatKey."?{$sQuery}&page={page}"), $sqlLimit);
        $nPage = $this->input->get('page', TYPE_UINT); if (!$nPage) $nPage = 1;

        $aData['items'] = $this->model->itemsList($sql, false, $sqlLimit, 'fixed DESC, I.fixed_order DESC, I.publicated_order DESC');

        # Vip блок
        $aData['vipBlock'] = $this->vipBlock($nCatID, $f['t'], $f['rc']);

        # категории
        $aParentsID = $this->model->categoryParentsID($nCatID);
        # есть уровень глубже - помечаем для вывода подкатегорий
        if ($aCat['subs']) $aParentsID[$aCat['lvl']+1] = 0;
        $aData['cats'] = $this->model->categoriesOptionsByLevel($aParentsID);
        # типы
        $aData['types'] = $this->model->cattypesByCategory($nCatID);
        # дин. свойства
        $aData['dp'] = $this->dpForm($nCatID, true, $f, array('f'=>$f['f']));

        # SEO: Поиск объявлений
        $this->seo()->robotsIndex(!(sizeof($sql) - $seoResetCounter) && !$seoNoIndex);
        $this->urlCorrection(static::url('search', array('cat'=>$aCat['keyword'])));
        $this->seo()->canonicalUrl(static::url('search', array('cat'=>$aCat['keyword']), true), array(
            'page' => $nPage
        ));
        $this->setMeta('search', array(
            'category' => $aCat['title'],
            'region'   => Geo::filter('title'),
            'page'     => $nPage,
        ), $aCat);
        $aData['filter'] = $this->viewPHP($aData, 'search.filter');
        bff::setActiveMenu('//bbs/search', true, false);
        $this->initRightblock(__FUNCTION__, array('filter'=>&$aData['filter']));
        return $this->viewPHP($aData, 'search');
    }

    /**
     * Просмотр объявления
     * @param integer::get 'id' ID объявления
     */
    function view()
    {
        if (Request::isAJAX())
        {
            $aResponse = array();

            switch ($this->input->post('act', TYPE_STR))
            {
                # подробный просмотр фотографий ОБ
                case 'photo_view':
                {
                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    $aResponse = $this->itemImages($nItemID)->processImagesView($nItemID);
                    $aResponse['res'] = $this->errors->no();
                } break;
            }
            $this->ajaxResponseForm($aResponse);
        }

        bff::setActiveMenu('//bbs/search', true);

        $isPrint = $this->input->get('print', TYPE_BOOL);
        $nUserID = User::id();
        $nItemID = $this->input->get('id', TYPE_UINT);
        if ( ! $nItemID) {
            $this->errors->error404();
        }
        $aData = $this->model->itemDataView($nItemID);
        if (empty($aData)) {
            $this->errors->error404();
        }

        if ($aData['status'] == self::STATUS_BLOCKED) {
            return $this->showForbidden(_t('','Объявление №[id]', array('id'=>$nItemID)), _t('bbs','Заблокировано по причине:<br/><b>[reason]</b>', array('reason'=>nl2br($aData['blocked_reason']))));
        } else if ($aData['status'] == self::STATUS_PUBLICATED_OUT) {
            return $this->showForbidden(_t('','Объявление №[id]', array('id'=>$nItemID)), _t('bbs','Срок публикации объявления истек'));
        }

        if ( ! $nUserID || ($aData['user_id'] > 0 && $aData['user_id']!=$nUserID)) {
            $this->model->itemSave($nItemID, array('views = views + 1'));
        }

        # дин свойства
        $aData['dynprops'] = $this->dpView($aData['cat_id'], $aData);
        $aData['img'] = $this->itemImages($nItemID);

        # SEO: Просмотр объявления
        $aData['url'] = static::url('view', $aData['link']);
        $this->urlCorrection($aData['url']);
        $this->seo()->robotsIndex(!$isPrint);
        $this->seo()->canonicalUrl($aData['link']);
        $this->setMeta('view', array(
            'title'       => $aData['title'],
            'description' => tpl::truncate($aData['descr'], 150),
            'region'      => Geo::filter('title'),
        ), $aData);
        if ( ! $isPrint) {
            $this->seo()->setSocialMetaOG($aData['share_title'], $aData['share_description'], array($aData['img_m']), $aData['url'], $aData['share_sitename']);
        }

        if ($isPrint) {
            View::setLayout('print');
            return $this->viewPHP($aData, 'view.print');
        }

        $aData['from_history'] = (strpos(Request::referer(), static::url('search')) !== false ? 1 : 0);
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'view');
    }

    /**
     * Добавление объявления
     */
    public function add()
    {
        bff::setActiveMenu('//bbs/search', true);

        if ( ! empty($_GET['finish'])) {
            # страница успешной публикации ОБ
            $nItemID = $this->input->get('id', TYPE_UINT);
            $aData = $this->model->itemData($nItemID, array('id','title','link'));
            bff::setMeta(_t('bbs', 'Добавление объявления'));
            return $this->viewPHP($aData, 'add.finish');
        }

        # ID категории, в которую добавляем (необязательно)
        if ( ! empty($_GET['c']) ) {
            $_POST['cat_id'] = intval($_GET['c']);
        }

        $aData = $this->validateItemData(0, Request::isAJAX());

        if (Request::isAJAX()) # submit
        {
            $p = $this->input->postm(array(
                'user_email'   => TYPE_NOTAGS, # user: email
                'member'       => TYPE_BOOL,   # уже зарегистрирован
                'pass'         => TYPE_NOTRIM, # пароль для авторизации: user_email/pass
                'captcha'      => TYPE_STR,    # капча
            ));

            $aResponse = array('status'=>0, 'user'=>false, 'captcha'=>false);

            do
            {
                $sEmail = $p['user_email'];
                $nUserStatus = false;

                if ( ! User::id())
                {
                    # для неавторизованного пользователя - email обязателен
                    if ( ! $this->input->isEmail($sEmail, false)) {
                        $this->errors->set( _t('', 'E-mail адрес указан некорректно'), 'user_email' );
                    }
                    if ($p['member']) {
                        # авторизуем
                        if (empty($p['pass'])) {
                            $this->errors->set( _t('', 'Укажите пароль'), 'pass' );
                        } else {
                            $res = $this->users()->userAuth($sEmail, 'email', $p['pass'], false, true);
                            if ($res === true) {
                                # успешно авторизовали
                                $aResponse['user'] = User::id();
                            } elseif ($res === 1) {
                                # пользователь не активирован
                                $aUserData = config::get('__user_preactivate_data', array());
                                $aResponse['user'] = $aUserData['id'];
                                $nUserStatus = 'na';
                            }
                        }
                    } else {
                        $aUser = $this->users()->model->userDataByFilter(array('email'=>$sEmail), array('user_id', 'blocked', 'activated'));
                        if ( ! empty($aUser)) {
                            $this->errors->set( _t('', 'Пользователь с указанным email адресом уже зарегистрирован') );
                            $aResponse['user'] = -1; # пользователь с указанным email адресом уже существует
                        } else {
                            # проверяем капчу
                            $oProtection = new CCaptchaProtection();
                            if (empty($p['captcha']) || ! $oProtection->valid($this->input->cookie('c2'), $p['captcha']) ) {
                                $this->errors->set( _t('', 'Результат с картинки указан некорректно'), 'captcha' );
                                $aResponse['captcha'] = true;
                            } else {
                                $aResponse['user'] = 1;
                                $nUserStatus = 'new';
                            }
                        }
                    }

                    if ( ! $this->errors->no()) {
                        break;
                    }
                } else {
                    $aResponse['user'] = User::id();
                    $nUserStatus = 'ok';
                    if ( ! $this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }
                }

                if (empty($aData['user_name'])) {
                    $this->errors->set( _t('bbs', 'Укажите ваше имя'), 'user_name' );
                }
                if (empty($aData['user_phone'])) {
                    $this->errors->set( _t('bbs', 'Укажите ваше телефон'), 'user_phone' );
                }

                if ( ! $this->errors->no()) break;

                if ($nUserStatus == 'new')
                {
                    # регистрируем нового пользователя
                    $this->users()->getActivationInfo($sActivateCode, $sActivateLink, $sActivateExpire);
                    $sPassword = func::generator(10);
                    $sPasswordSalt = $this->security->generatePasswordSalt();
                    $nUserID = $this->users()->model->userCreate(array(
                        'login'=>'', # будет сгенерирован уникальный
                        'email'=>$sEmail,
                        'password'=> $this->security->getUserPasswordMD5($sPassword, $sPasswordSalt),
                        'password_salt'=> $sPasswordSalt,
                        'name'=>$aData['user_name'],
                        'phone'=>$aData['user_phone'],
                        'activated'=>0,
                        'activate_key'=>$sActivateCode,
                        'activate_expire'=>$sActivateExpire,
                        ), Users::GROUPID_MEMBER);
                    if ($nUserID)
                    {
                        # добавляем возможность получить повторное email-уведомление
                        $this->users()->setRegisterSecondEnotifyFlag($nUserID);
                        # отправляем email уведомление
                        bff::sendMailTemplate(
                            array('name'=>$aData['user_name'], 'password'=>$sPassword, 'email'=>$sEmail, 'activate_link'=>$sActivateLink),
                            'member_registration', $sEmail);
                    } else {
                        $nUserID = 0;
                        $this->errors->set( _t('bbs', 'Ошибка регистрации') );
                        break;
                    }
                } else {
                    $nUserID = User::id();
                }
                $aResponse['user'] = $nUserStatus;

                $sNOW = $this->db->now();

                if ( ! User::id() ) {
                    # объявление будет активировано при активации пользователя (onUserActivated)
                    $aData['status'] = self::STATUS_NOTACTIVATED;
                    $aData['activate_expire'] = $this->getActivateExpireDate();
                } else {
                    $aData['status'] = self::STATUS_PUBLICATED;
                }

                $aData['publicated'] = $sNOW;
                $aData['publicated_order'] = $sNOW;
                # период публикации
                $aData['publicated_to'] = $this->getItemPublicationPeriod();
                $aData['moderated'] = 0;
                $aData['user_id'] = $nUserID;

                # сохраняем объявление + публикуем
                $nItemID = $this->model->itemSave(0, $aData, 'd');

                if ( ! $nItemID) {
                    $this->errors->set( _t('bbs', 'Не удалось опубликовать объявление, возникла системная ошибка, сообщите администрации.') );
                    break;
                } else {
                    $this->itemImages($nItemID)->saveTmp('img');
                    $this->security->userCounter('bbs', 1, (User::id() > 0 ? false : $nUserID) );
                    if ( $aData['status'] == self::STATUS_PUBLICATED && ! static::premoderation()) {
                        # накручиваем счетчики кол-ва опубликованных объявлений:
                        # в категориях и типах:
                        $aCats = array();
                        for($i = 1; $i<=3; $i++) { if ( ! empty($aData['cat_id'.$i]) ) $aCats[] = $aData['cat_id'.$i]; }
                        $this->model->itemsCounterUpdate($aCats, array($aData['cat_type']), true, true);
                    }
                    $aResponse['status'] = 2; # объявление добавлено в базу
                }
                $aResponse['id'] = $nItemID;

                if ($nUserStatus == 'new') {
                    Request::deleteCOOKIE('c2');
                }

            } while(false);

            $this->ajaxResponseForm($aResponse);
        }

        $aData['id'] = 0;
        $aData['images'] = array();
        if (User::id()) {
            $aUser = $this->security->getUserInfo(array('name','surname','email','phone'));
            $aData['user_name'] = $aUser['name'].' '.$aUser['surname'];
            $aData['user_phone'] = $aUser['phone'];
            $aData['user_email'] = $aUser['email'];
            $aData['user_type'] = 1;
        }

        # SEO: Добавление объявления
        $this->urlCorrection(static::url('add'));
        $this->seo()->canonicalUrl(static::url('add', array(), true));
        $this->setMeta('add', array('region' => Geo::filter('title')), $aData);

        bff::showInstruction('bbs_add');
        $this->initRightblock(__FUNCTION__);
        return $this->form(0, $aData);
    }

    /**
     * Редактирование объявления
     */
    public function edit()
    {
        bff::setActiveMenu('//bbs/search', true);
        bff::setMeta(_t('bbs', 'Редактирование объявления'));

        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nItemID ) {
            if (Request::isAJAX()) $this->ajaxResponse(Errors::RELOAD_PAGE);
            $this->errors->error404();
        }

        $aData = $this->model->itemData($nItemID);

        if (empty($aData)) {
            if (Request::isAJAX()) $this->ajaxResponse(Errors::RELOAD_PAGE);
            $this->errors->error404();
        }

        $nUserID = User::id();
        if ( ! $nUserID || ($nUserID && $nUserID != $aData['user_id'])) {
            if (Request::isAJAX()) $this->ajaxResponse(Errors::RELOAD_PAGE);
            return $this->showForbidden(_t('bbs', 'Редактирование объявления'), _t('', 'Вы не явлетесь владельцем данного объявления'));
        }

        if (User::isCurrent($aData['user_id']))
        {
            if ($aData['status'] == self::STATUS_BLOCKED && ! $aData['moderated']) {
                if (Request::isAJAX()) $this->ajaxResponse(Errors::RELOAD_PAGE);
                if ( ! empty($_GET['success'])) {
                    $this->redirect( Users::url('my.profile.tab', array('tab'=>'adv', 'subtab'=>'board')) );
                }
                return $this->showForbidden(_t('', 'Объявление заблокировано'), _t('', 'Причина:<br/><b>[reason]</b>
                    <br/> <span class="red">Объявление ожидает проверки модератора</span>', array('reason'=>nl2br($aData['blocked_reason']))));
            }
        }

        if (Request::isAJAX())
        {
            $aDataSave = $this->validateItemData($nItemID, Request::isAJAX());

            $aResponse = array('status'=>0, 'user'=>false, 'captcha'=>false);

            do
            {
                if ( ! $this->security->validateToken()) {
                    $this->errors->reloadPage();
                    break;
                }

                if (empty($aDataSave['user_name'])) {
                    $this->errors->set( _t('bbs', 'Укажите ваше имя'), 'user_name' );
                }
                if (empty($aDataSave['user_phone'])) {
                    $this->errors->set( _t('bbs', 'Укажите ваше телефон'), 'user_phone' );
                }

                if ( ! $this->errors->no()) break;

                if ($aData['status'] == self::STATUS_BLOCKED) {
                    $aDataSave['moderated'] = 0;
                }

                # помечаем на модерацию при изменении: названия, описания
                if ($aDataSave['title'] != $aData['title'] || $aDataSave['descr'] != $aData['descr']) {
                    if ($aDataSave['moderated']) {
                        $aDataSave['moderated'] = 2;
                    }
                }

                # сохраняем объявление
                $nItemID = $this->model->itemSave($nItemID, $aDataSave, 'd');

            } while(false);

            $this->ajaxResponseForm($aResponse);
        }

        # помечаем на модерацию при изменении: фотографий todo

        $aData['images'] = $this->itemImages($nItemID)->getData($aData['imgcnt']);
        $aData['user_type'] = ($aData['company_id'] > 0 ? 2 : 1);

        bff::showInstruction('bbs_edit');
        $this->initRightblock(__FUNCTION__);
        return $this->form($nItemID, $aData);
    }

    /**
     * Форма добавления/редактирования ОБ
     * @param integer $nItemID ID объявления
     * @param array $aData
     * @return HTML
     */
    public function form($nItemID = 0, $aData = array())
    {
        $nUserID = User::id();

        if (Request::isAJAX())
        {
            $aResponse = array();
            switch ($this->input->getpost('act'))
            {
                case 'category-data': # данные о категории
                {
                    $nCategoryID = $aResponse['id'] = $this->input->post('cat_id', TYPE_UINT);
                    if (empty($nCategoryID)) { $this->errors->impossible(); break; }
                    $bSearch = $this->input->post('search', TYPE_BOOL);

                    $aResponse = $this->model->categoryData($nCategoryID, false);
                    if ( $aResponse['subs'] > 0 ) {
                        $aResponse['cats'] = $this->model->categorySubOptions($nCategoryID, array('sel'=>0, 'empty'=>_t('','Выбрать')));
                    } else {
                        // формируем форму дин. свойств
                        $aResponse['dp'] = $this->dpForm($nCategoryID, $bSearch);
                        // формируем список типов
                        $aResponse['types'] = $this->model->cattypesByCategory($nCategoryID, ( $bSearch ? false : array('sel'=>0,'empty'=>false) ) );
                        if (empty($aResponse['types'])) $aResponse['types'] = false;
                    }
                } break;
                case 'img-upload': # загрузка изображений
                {
                    $nItemID = $this->input->get('item_id', TYPE_UINT);

                    if ($nItemID > 0)
                    {
                        $aData = $this->model->itemData($nItemID, array('user_id', 'imgcnt', 'status', 'moderated'));
                        if (empty($aData)) {
                            $this->errors->set( _t('bbs','Редактируемое объявление не найдено') );
                            break;
                        }

                        if ($aData['status'] == self::STATUS_BLOCKED && $aData['moderated']==0) {
                            $this->errors->set( _t('bbs','Объявление ожидает проверки модератора') );
                            break;
                        }

                        // автор объявления = загеристрированный пользователь
                        if ( ! $nUserID // незарегистрированный пытается добавить фото к чужому объявлению
                        || ($nUserID > 0 && $aData['user_id'] != $nUserID) // текущий зарегистрированный пользователь не является владельцем объявления
                          ) {
                            $this->errors->set( _t('bbs','Вы не является владельцем данного объявления') );
                            break;
                        }
                    } else {
                        # грузить новые фотографии(без привязки к объявлению) можно с ограничением qquploader'a :)
                    }

                    if ( ! $this->security->validateReferer() ) {
                        $this->errors->set( _t('bbs','Ошибка загрузки фотографии') );
                        break;
                    }

                    $aResponse = $this->itemImages($nItemID)->uploadQQ();
                    if ( ! is_array($aResponse)) {
                        $aResponse = array();
                        break;
                    }

                    $aResponse['sz'] = BBSItemImages::url($nItemID, $aResponse, array(BBSItemImages::szMini, BBSItemImages::szView), !$nItemID);
                } break;
                case 'img-delete': # удаление изображений
                {
                    $nItemID = $this->input->post('item_id', TYPE_UINT);
                    $nUserID = User::id();

                    if ($nItemID > 0)
                    {
                        $aData = $this->model->itemData($nItemID, array('user_id', 'imgcnt', 'status', 'moderated'));
                        if (empty($aData)) {
                            $this->errors->set( _t('bbs','Редактируемое объявление не найдено') );
                            break;
                        }

                        if ($aData['status'] == self::STATUS_BLOCKED && $aData['moderated']==0) {
                            $this->errors->set( _t('bbs','Объявление ожидает проверки модератора') );
                            break;
                        }

                        # автор объявления = зарегистрированный пользователь
                        if ( ! $nUserID # незарегистрированный пытается удалить фото чужого объявлению
                        || ($nUserID > 0 && $aData['user_id'] != $nUserID) # текущий зарегистророванный пользователь не является владельцем объявления
                          ) {
                            $this->errors->set( _t('bbs', 'Вы не является владельцем данного объявления') );
                            break;
                        }

                        $nImageID = $this->input->post('image_id', TYPE_UINT);
                        $this->itemImages($nItemID)->deleteImage($nImageID);
                    } else {
                        # удалять фотографии(без привязки к объявлению) можно без ограничений
                        $mFilename = $this->input->post('filename', ($this->input->post('bulk', TYPE_BOOL) ? TYPE_ARRAY_NOTAGS : TYPE_NOTAGS) );
                        $this->itemImages(0)->deleteTmpFile($mFilename);
                    }
                } break;
            }

            $this->ajaxResponseForm($aResponse);
        }

        $aParentCatsID = $this->model->categoryParentsID( $aData['cat_id'] );

        if ( ! empty($aData['cat_id']) ) {
            $aData['cat'] = $this->model->categoryData($aData['cat_id']);
            $aData['dp'] = $this->dpForm($aData['cat_id'], false, $aData);
            $aData['types'] = $this->model->cattypesByCategory($aData['cat_id'], array('sel'=>$aData['cat_type'],'empty'=>false) );
            if ( ! $nItemID) {
                #  есть уровень глубже - помечаем для вывода подкатегорий
                if ($aData['cat']['subs']) $aParentCatsID[$aData['cat']['numlevel']+1] = 0;
            }
        }

        $aData['edit'] = ($nItemID > 0);
        $aData['cats'] = $this->model->categoriesOptionsByLevel($aParentCatsID, array('empty'=>_t('','Выбрать')), $aData['edit']);
        $aData['curr'] = Site::currencyOptions($aData['price_curr'], false);
        $aData['img']  = $this->itemImages($aData['id']);
        $aData['hash'] = $this->security->getToken();
        $aData['agentCompanies'] = array();
        if ($nUserID) {
            $aData['agentCompanies'] = Users::model()->agentCompanies($nUserID);
        }

        if (!$nItemID) {
            $aData['city_id'] = Geo::cityID(true);
            list($aData['addr_lat'], $aData['addr_lng']) = Geo::mapsDefaultCoords(true);
        }

        tpl::includeJS(array('qquploader','fancybox'), true); # images
        Geo::mapsAPI(true);
        bff::setActiveMenu('//bbs');
        return $this->viewPHP($aData, 'form');
    }

    /**
     * Список объявлений пользователя
     */
    public function profile()
    {
        if ( ! ($userID = User::id()))
            return '';

        $nPerpage = config::sys('bbs.profile.perpage', 10);
        $nTotal = $this->model->itemsListProfile($userID, true);
        $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 3, Users::url('my.profile.tab', array('tab'=>'adv','subtab'=>'board')).'&page={page}', $sqlLimit);

        $aData['items'] = $this->model->itemsListProfile($userID, false, $sqlLimit);

        $this->security->userCounterCheck('bbs', $nTotal);
        bff::setMeta(_t('', 'Мои объявления - Кабинет'));
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'profile');
    }

    /**
     * Список объявлений компании (Объявления)
     * @param integer $companyID ID компании
     * @param array $companyData @ref данные о компании
     */
    public function company_items($companyID = 0, array &$companyData)
    {
        $perpage = config::sys('bbs.company.perpage', 10);
        $total = $this->model->itemsListCompany($companyID, true);
        $sqlLimit = '';
        $data['pgn'] = $this->generatePagenationDots($total, $perpage, 3,
            Items::url('view', array('link'=>$companyData['link'], 'tab'=>'board', 'q'=>$companyData['st'].'&page={page}')),
            $sqlLimit);

        $data['items'] = $this->model->itemsListCompany($companyID, false, $sqlLimit);
        return $this->viewPHP($data, 'company');
    }

    /**
     * Страница успешной активации услуги
     */
    public function promote()
    {
        if( ! bff::servicesEnabled()) return false;

        $nItemID = $this->input->get('id', TYPE_UINT);
        $nSvcID = $this->input->get('svc', TYPE_UINT);

        $aSvc = $this->svc()->model->svcData($nSvcID);
        if ( $nItemID && ! empty($aSvc) && $aSvc['module'] == $this->module_name )
        {
            bff::setMeta(_t('svc', 'Активация услуги'));
            $this->seo()->robotsIndex(false);
            bff::setActiveMenu('//bbs/search', true);
            $aItem = $this->model->itemData($nItemID, array('id','link','title'));
            if (empty($aItem)) {
                $this->errors->error404();
            }
            $this->initRightblock(__FUNCTION__);
            return $this->showSuccess(
                _t('svc', 'Активация услуги'),
                _t('bbs', 'Для вашего объявления "[item_link]"<br />была успешно активирована услуга "[svc_title]"', array(
                    'item_link'=>'<a href="'.static::url('view', $aItem['link']).'">'.$aItem['title'].'</a>',
                    'svc_title'=>$aSvc['title']))
            );
        } else {
            $this->redirect( static::url('index') );
        }
    }

    /**
     * Список избранных объявлений пользователя
     */
    public function fav()
    {
        bff::setActiveMenu('//bbs/fav');
        bff::setMeta(_t('bbs','Избранные объявления'));
        if ( ! ($userID = User::id())) {
            return $this->showForbidden(_t('bbs','Избранные объявления'), _t('bbs','Возможность добавлять объявления в избранные доступна только после авторизации.'), true);
        }

        $aData['items'] = $this->model->itemsListFav($userID);

        $this->security->userCounterCheck('bbs_fav', sizeof($aData['items']));
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'fav');
    }

    /**
     * Ajax запросы
     */
    public function ajax()
    {
        $aResponse = array();
        $nUserID = User::id();

        switch ($this->input->get('act'))
        {
            case 'fav': # добавления/удаление из избранных
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID || ! $nUserID) {
                    $this->errors->impossible(); break;
                }

                if ( ! $this->security->validateToken()) {
                    $this->errors->impossible(); break;
                }

                $bAdded = false;
                $bExists = $this->db->one_data('SELECT item_id FROM '.TABLE_BBS_ITEMS_FAV.'
                                WHERE user_id = :userID AND item_id = :itemID LIMIT 1', array(
                                    ':userID' => $nUserID, ':itemID'=>$nItemID
                                ));
                if (empty($bExists)) {
                    $res = $this->db->insert(TABLE_BBS_ITEMS_FAV, array('user_id'=>$nUserID, 'item_id'=>$nItemID), false);
                    if (empty($res)) {
                        $this->errors->impossible(); break;
                    }
                    $bAdded = true;
                } else {
                    $this->db->delete(TABLE_BBS_ITEMS_FAV, array('user_id'=>$nUserID, 'item_id'=>$nItemID));
                }

                $aResponse['added'] = $bAdded;
                $aResponse['n'] = $this->security->userCounter('bbs_fav', ($bAdded ? 1 : -1) );

            } break;
            case 'dp-child': # child дин. свойства
            {
                $p = $this->input->postm(array(
                    'dp_id'    => TYPE_UINT,
                    'dp_value' => TYPE_UINT,
                    'name_prefix' => TYPE_NOTAGS,
                    'search' => TYPE_BOOL,
                ));

                $aResponse['form'] = $this->dp()->formChildByParentIDValue($p['dp_id'], $p['dp_value'], array('name'=>$p['name_prefix']), $p['search']);

            } break;
            case 'item-del': # удаление ОБ
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID || ! $nUserID || ! $this->deleteByUser) {
                    $this->errors->impossible(); break;
                }

                if ( ! $this->security->validateToken()) {
                    $this->errors->impossible(); break;
                }

                $aItem = $this->model->itemData($nItemID, array('id','user_id','status','deleted'));
                if ( empty($aItem)
                    || ! User::isCurrent($aItem['user_id'])
                    || $aItem['deleted']) {
                    $this->errors->impossible(); break;
                }

                if ( $this->deleteByUser == 2 ) { // полное удаление
                    $this->itemDelete($nItemID);
                } else if ( $this->deleteByUser == 1 ) { // только помечаем на удаление
                    $this->model->itemSave($nItemID, array('deleted'=>1));
                } else {
                    $this->errors->impossible();
                }

            } break;
            case 'item-publicate2': # продление публикации ОБ
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                $nPeriod = $this->input->post('period', TYPE_UINT);

                if ( ! $nItemID || ! $nUserID || empty($nPeriod)) {
                    $this->errors->impossible(); break;
                }
                if ( ! $this->security->validateToken()) {
                    $this->errors->impossible(); break;
                }

                $aData = $this->model->itemData($nItemID, array('id', 'user_id', 'status',
                            'moderated', 'publicated', 'publicated_to',
                            'cat_id1', 'cat_id2', 'cat_id3', 'cat_type'));
                if (empty($aData)) break;

                # продление доступно только для владельца
                if ( ! User::isCurrent($aData['user_id']) ) {
                    $this->errors->impossible(); break;
                }

                if ($aData['status'] == self::STATUS_BLOCKED) {
                    if ($aData['moderated'] == 0) {
                        $this->errors->set( _t('bbs', 'Невозможно продлить публикацию, поскольку объявление ожидает проверки') );
                    } else {
                        $this->errors->set( _t('bbs', 'Невозможно продлить публикацию, поскольку объявление отклонено') );
                    }
                    break;
                } else if ($aData['status'] == self::STATUS_PUBLICATED) {
                    $this->errors->set( _t('bbs', 'Невозможно продлить публикацию, поскольку объявление опубликовано') );
                    break;
                } else if ($aData['status'] != self::STATUS_PUBLICATED_OUT) {
                    $this->errors->impossible(); break;
                }

                $aUpdate = array(
                    'publicated_to' => $this->getItemRefreshPeriod($aData['publicated_to']),
                    'status_prev' => $aData['status'],
                    'status' => self::STATUS_PUBLICATED,
                );
                /**
                 * Если разница между датой снятия с публикации и текущей датой
                 * более 3 дней, тогда поднимаем объявление вверх.
                 * в противном случае: оставлем дату старта публикации(pulicated)
                 *   и дату порядка публикации(publicated_order) прежними
                 */
                if ((BFF_NOW - strtotime($aData['publicated_to'])) > 259200){ //3 суток
                    $aUpdate['publicated'] = $this->db->now();
                    $aUpdate['publicated_order'] = $this->db->now();
                }
                $res = $this->model->itemSave($nItemID, $aUpdate);
                if ( ! empty($res)) {
                    # накручиваем счетчики кол-ва опубликованных объявлений:
                    # в категориях и типах:
                    $this->model->itemsCounterUpdate(array($aData['cat_id1'], $aData['cat_id2'], $aData['cat_id3']),
                                              (!empty($aData['cat_type']) ? array($aData['cat_type']) : array()),
                                              true, true);
                } else {
                    $this->errors->impossible();
                }

            } break;
            case 'item-claim': # обработка жалобы на ОБ
            {
                $p = $this->input->postm(array(
                    'id'      => TYPE_UINT,
                    'reasons' => TYPE_ARRAY_UINT,
                    'comment' => TYPE_NOTAGS,
                    'captcha' => TYPE_STR,
                ));

                do{
                    if ( ! $p['id']) { $this->errors->impossible(); break; }
                    if (empty($p['reasons']) && $p['comment'] == '') { $this->errors->set( _t('bbs', 'Укажите причину и/или описание') ); break; }

                    if ( ! $nUserID) {
                        if ( ! $this->security->validateReferer()) {
                            $this->errors->impossible();
                            break;
                        }
                        $oProtection = new CCaptchaProtection();
                        if ( ! $oProtection->valid($this->input->cookie('c2'), $p['captcha']) ) {
                            $aResponse['captcha'] = 1;
                            $this->errors->set( _t('', 'Результат с картинки указан некорректно'), 'captcha' );
                            break;
                        }
                    } else {
                        if ( ! $this->security->validateToken()) {
                            $this->errors->impossible();
                            break;
                        }
                        # получаем дату последней добавленной пользователем жалобы
                        # ограничиваем частоту добавления жалобы раз в X минут
                        $sLastClaim = $this->model->claimLastByUser($nUserID);
                        if ( ! empty($sLastClaim)) {
                            $nMinutesTimeout = 3;
                            if ( (time() - strtotime($sLastClaim)) < $nMinutesTimeout * 60 )
                            {
                                $this->errors->set( _t('bbs', 'Повторите попытку через 3 минуты') );
                                break;
                            }
                        }

                    }

                    $nClaimID = $this->model->claimSave(0, array(
                        'item_id' => $p['id'],
                        'message' => $p['comment'],
                        'reasons' => array_sum($p['reasons']),
                    ));
                    if ($nClaimID > 0) {
                        if ( ! $nUserID) Request::deleteCOOKIE('c2');
                        config::saveCount('bbs_claims', 1, true); # счетчик жалоб в админ. панели
                        $this->model->itemSave($p['id'], array(
                            'claims_cnt = claims_cnt + 1'
                        ));
                    }

                } while(false);

            } break;
            case 'item-promote': # продвижение ОБ
            {
                $nItemID = $this->input->post('id', TYPE_UINT); # ID Объявления
                $nSvcID = $this->input->post('svc', TYPE_UINT); # ID Услуги BBS::SERVICE_
                $sPaySystem = $this->input->post('ps', TYPE_NOTAGS); # Ключ способа оплаты
                if (empty($sPaySystem)) $sPaySystem = Bills::PS_BALANCE;

                if ( ! $nItemID || ! $nSvcID || ! $nUserID || ! $this->security->validateToken() ) {
                    $this->errors->reloadPage();
                    break;
                }

                $aItem = $this->model->itemData($nItemID, array('id','user_id','deleted','status'));
                if (empty($aItem) || $aItem['deleted'] || $aItem['status'] == self::STATUS_NOTACTIVATED) {
                    $this->errors->reloadPage();
                    break;
                }
                if ($aItem['status'] == self::STATUS_BLOCKED) {
                    $this->errors->set( _t('', 'Невозможно продвинуть заблокированное объявление') );
                    break;
                }
                if ( ! User::isCurrent($aItem['user_id'])) {
                    $this->errors->reloadPage();
                    break;
                }

                # проверяем способ оплаты
                $aPaySystems = Bills::getPaySystems(true);
                if (!isset($aPaySystems[$sPaySystem]) || empty($aPaySystems[$sPaySystem]['enabled'])) {
                    $this->errors->set( _t('bills', 'Выбранный способ оплаты на текущий момент недоступен') );
                    break;
                }
                # получаем стоимость услуги
                $aSvc = Svc::model()->svcData($nSvcID);
                if (empty($aSvc)) {
                    $this->errors->reloadPage();
                    break;
                }
                $nSvcPrice = $aSvc['price'];

                $aPayAmount = Bills::getPayAmount($nSvcPrice, $sPaySystem);

                $aResponse = $this->svc()->activateOrPay($this->module_name, $nSvcID, $nItemID,
                    $aPaySystems[$sPaySystem]['id'], $aPaySystems[$sPaySystem]['way'],
                    $nSvcPrice, $aPayAmount['amount'], $aPayAmount['currency']);
                if ($aResponse['activated']) {
                    $aResponse['redirect'] = static::url('promote', array('success'=>1,'id'=>$nItemID,'svc'=>$nSvcID));
                }

            } break;
            case 'item-promote-data': # данные о текущих активированных услугах ОБ
            {
                $nItemID = $this->input->post('item_id', TYPE_UINT);

                if ( ! $nItemID || ! $nUserID ) {
                    $this->errors->reloadPage();
                    break;
                }

                $aItem = $this->model->itemData($nItemID, array('id','user_id','deleted','status',
                         'svc', 'marked_to', 'fixed_to', 'vip_to'));
                if ( empty($aItem) || $aItem['deleted']
                    || $aItem['status'] == self::STATUS_NOTACTIVATED
                    || $aItem['status'] == self::STATUS_BLOCKED
                    || ! User::isCurrent($aItem['user_id'])
                    || ! $this->security->validateReferer() ) {
                    $this->errors->reloadPage();
                    break;
                }
                $aResponse['marked'] = ($aItem['svc'] & self::SERVICE_MARK);
                $aResponse['marked_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['marked_to'], false)));
                $aResponse['fixed'] = ($aItem['svc'] & self::SERVICE_FIX);
                $aResponse['fixed_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['fixed_to'], false)));
                $aResponse['vip'] = ($aItem['svc'] & self::SERVICE_VIP);
                $aResponse['vip_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['vip_to'], false)));
            } break;
            default: {
                $this->errors->impossible();
            } break;
        }

        $this->ajaxResponseForm($aResponse);
    }

    /**
     * Формируем правый блок
     * @param string $sPage ключ страницы, на которой формируем
     * @param array $aData доп. данные
     */
    function initRightblock($sPage, array $aData = array())
    {
        $bAfterBanner = false;

        switch ($sPage)
        {
            case 'index':
            {

            } break;
        }
        bff::setRightblock($this->viewPHP($aData, 'common.rightblock'), $bAfterBanner);
    }

    /**
     * Формируем VIP блок
     * @param int $nCatID ID категории
     * @param int $nTypeID ID типа категории
     * @param int $nCityID ID города
     * @return string
     */
    protected function vipBlock($nCatID = 0, $nTypeID = 0, $nCityID = 0)
    {
        $aData['items'] = $this->model->itemsListVIP($nCatID, $nTypeID, $nCityID);
        $oImages = $this->itemImages();
        foreach($aData['items'] as $k => $v){
            if($v['imgcnt']){
                $oImages->setRecordID($v['id']);
                $aImage = $oImages->getImageData($v['imgfav']);
                $aData['items'][$k]['img_'.BBSItemImages::szSmall] = $oImages->url($v['id'], $aImage, BBSItemImages::szSmall);
            }
        }

        return $this->viewPHP($aData, 'vip.block');
    }


    /**
     * Cron задачи модуля
     * Рекомендуемая периодичность: каждые 5 минут
     */
    public function cronItems()
    {
        if ( ! bff::cron() ) return;
        $this->model->itemsCron();
    }
}