<?php
/**
 * @var $this Auto
 */
?>
<h3 class="mt20"><?= _t('auto', 'Поиск объявлений'); ?></h3>
<div class="param">
    <form id="auto-search" method="get" action="<?= Auto::url('search') ?>" class="relative">
        <div id="auto-search-counter" style="display: none; position: absolute; left: -115px; border: 1px solid #DADADA; background-color: #fff; padding: 5px 10px; width: 105px;">
            <span class="found-no f12"><?= _t('', 'ничего не найдено'); ?></span>
            <span class="found-yes f12"><span class="num">0</span> - <a href="#" onclick="return autoSearch.submit();"><?= _t('', 'показать'); ?></a></span>
        </div>
        <? if( ! Geo::cityIsOne() ) { ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Город'); ?></p>
            <select name="rc"><?= Geo::cityOptions($f['rc'], array(-1,  _t('', 'Все города'))) ?></select>
        </div>
        <? } ?>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Тип'); ?></p>
            <select class="inp-w2" name="c" onchange="autoSearch.onCat(intval(this.value));">
                <? $sel = false; $sel_gr = false;
                foreach($cats as $v) {
                    if($v['node']>1) { 
                        if($sel_gr){ ?></optgroup>
                        <? } $sel_gr = true; ?>
                        <optgroup label="<?= $v['title'] ?>">
                    <? } else { ?>
                        <option value="<?= $v['id'] ?>" data-keyword="<?= HTML::escape($v['keyword']) ?>" <? if($v['id']==$f['c']){ ?> selected="selected"<? $sel = true; } ?>><?= $v['title'] ?></option>
                    <? } 
                } if($sel_gr){ ?></optgroup><? } unset($sel, $sel_gr); ?>
            </select>            
        </div>
        <div class="b-param"<? if( ! $f['c']){ ?> style="display: none;"<? } ?> id="auto-search-mm">
            <p class="param-name"><?= _t('auto', 'Марка и модель'); ?></p>
            <select name="mk" id="auto-search-marks" onchange="autoSearch.onMark(intval(this.value), this);"><?= $marks ?></select>
            <select name="md" id="auto-search-models"><?= $models ?></select>
        </div>
        <div id="auto-search-dp"><?= ( ! empty($dp) ? $dp : '') ?></div>
        <div class="b-param">
            <p class="param-name"><?= _t('', 'Цена'); ?>, <?= Site::currencyDefault() ?></p>
            <div class="num-area"><?= _t('', 'от'); ?> <input type="text" name="pf" value="<?= $f['pf'] ?>" pattern="[0-9]*" /> <?= _t('', 'до'); ?> <input type="text" name="pt" value="<?= $f['pt'] ?>" pattern="[0-9]*" /></div>
        </div>
        <div class="b-param">
            <ul>
                <li><label><input type="checkbox" value="1" name="ph" <? if($f['ph']){ ?>checked="checked"<? } ?> /><?= _t('', 'есть фотографии'); ?></label></li>
            </ul>
        </div>
        <div class="param-btn"><div class="btn"><input type="submit" value="<?= _t('auto', 'Найти'); ?>" /><i></i></div></div>
    </form>
</div>
<script type="text/javascript">
<? js::start(); ?>
var autoSearch = (function(){
    var $form, $mm, $marks, $models, cats = {}, models = {}, cnt = false, $dp;
    
    $(function(){ 
        $form   = $('#auto-search');
        $dp     = $('#auto-search-dp', $form);
        $mm     = $('#auto-search-mm', $form);
        $marks  = $('#auto-search-marks', $form);
        $models = $('#auto-search-models', $form);

        $form.delegate(':checkbox, :radio', 'click', function(){
            updateCounter( $(this).position() );
        }).delegate(':text, select', 'change',function(){
            updateCounter( $(this).position() );
        });
        <? if($isIndex): ?>
            var c = intval($form.find('[name="c"]').val());
            if(c){
                autoSearch.onCat(c);
            }
        <? endif; ?>
    });
    
    function updateCounter(pos)
    {
        if(cnt === false) {
            cnt = {};
            cnt.block = $('#auto-search-counter', $form);
            cnt.num = $('.num', cnt.block); 
            cnt.yes = $('.found-yes', cnt.block);
            cnt.no = $('.found-no', cnt.block);
            cnt.timer = false; 
        }
        
        bff.ajax('<?= Auto::url('search') ?>', $form.serialize()+'&cnt=1', function(data){
            if(data) {
                var num = intval(data.total);
                cnt.num.html( num );
                if( num>0 ) {
                    cnt.yes.show();
                    cnt.no.hide();
                } else {
                    cnt.yes.hide();
                    cnt.no.show();
                }
                cnt.block.css({top:pos.top-5}).fadeIn();
                if(cnt.timer) clearTimeout(cnt.timer);
                cnt.timer = setTimeout(function(){ cnt.block.fadeOut(); }, 5000);
            }
        });
    }
    
    return {
        onCat: function(id)
        {
            if( ! id) {
                $mm.hide();
                $marks.html('<option value="0"><?= _t('auto', 'Выберите тип'); ?></option>');
                $models.hide().html('<option value="0"><?= _t('auto', 'Выберите марку'); ?></option>');
                $dp.hide().html('');
            }
            else if(cats[id] !== undefined) {
                $marks.html(cats[id].marks);
                $dp.html( cats[id].dp ).show();
                $models.hide().html('<option value="0"><?= _t('auto', 'Выберите марку'); ?></option>');
                $mm.show();
            }
            else {
                bff.ajax('<?= bff::urlAjax('auto','cat-data') ?>', {cat:id,form:0}, function(data){
                    if(data) {
                        cats[id] = {marks: data.marks, dp: data.dp};
                        $marks.html( cats[id].marks );
                        $dp.html( cats[id].dp );
                        $models.hide().html('<option value="0"><?= _t('auto', 'Выберите марку'); ?></option>');
                        $mm.show();
                    }
                });
            }
        },
        onMark: function(id, sel)
        {
            if( ! id) $models.html('<option value="0"><?= _t('auto', 'Все модели'); ?></option>');
            else if(models[id] !== undefined) $models.html(models[id]).show();
            else {
                bff.ajax('<?= bff::urlAjax('auto','models-options') ?>', {mark: id}, function(data){
                    if(data) {
                        $models.html( (models[id] = data.models) ).show();
                    }
                });
            }
        },
        submit: function()
        {                 
            $form.submit();
            return false;
        }        
    };
}());
<? js::stop(); ?>
</script>