<?php

    $blocked = ($status == Auto::STATUS_BLOCKED);
?>

<script type="text/javascript">                   
//<![CDATA[    

    var autoEdit = (function()
    {
        var $form, $progress, id = 0, $models, models = {}, urlAjax = '<?= $this->adminLink('ajax&act=') ?>';
                
        $(function(){ init(); });
        
        function init()
        {
            id = <?= $id ?>;
            $form = $('#auto-form');
            $progress = $('#auto-form-progress', $form);
            $models   = $('#auto-models', $form);
                
            $form.submit(function () {
                var error = false;
                $('input.req, select.req', this).each(function() {
                    var val = $(this).val();
                    if( $.trim(val) == '' || val == 0 || val === undefined || val == $(this).attr('placeholder')) {
                        error = true;
                    }
                });            
                
                if(error) { 
                    bff.error('Заполните все необходимые поля');   
                } else {
                    bff.ajax(document.location, $form.serialize(), function(data, errors) {  
                        if(data && data.res) { 
                            history.back();
                        } else {
                            if(errors) {
                                bff.error( errors );
                            }
                        }
                    }, $progress); 
                }
                return false;
            }); 
        }
        
        return {
            onMark: function(id, sel)
            {
                if( ! id) $models.html('<option value="0">все модели</option>');
                else if(models[id] !== undefined) $models.html(models[id]);
                else {
                    bff.ajax(urlAjax+'models-options', {mark: id, form:1}, function(data){
                        if(data) {
                            $models.html( (models[id] = data.models) );
                        }
                    });
                }
            },  
            changeBlocked: function(step, block)
            {
                var form = $form.get(0);
                if(step==1){//заблокировать/изменить блокировку
                    $('#i_blocked', $form).hide();
                    $('#i_blocked_error, #i_blocking, #i_blocking_warn', $form).show(0, function(){
                        form['blocked_reason'].focus();    
                    }); 
                } else if(step==2) {//отменить
                    if(form['blocked'].value == 1){
                        $('#i_blocking, #i_blocking_warn', $form).hide();
                        $('#i_blocked', $form).show(); 
                    } else {
                        $('#i_blocked_error, #i_blocking_warn', $form).hide(); 
                    }
                } else if(step==3) {//сохранить
                    bff.ajax(urlAjax+'item-block', $form.serializeArray(), function(data){
                        if(data)
                        {
                            if(!block){                                                  
                                $('#i_blocked_error, #i_blocking_warn', $form).hide();
                            } else {
                                $('#i_blocking_warn', $form).hide();
                                $('#i_blocked_text', $form).html(form['blocked_reason'].value);
                                $('#i_blocked_error', $form).show();
                                autoEdit.changeBlocked(2);
                            }
                            history.back();
                        }
                    }, $progress);
                }
                return false;
            },
            approve: function()
            {
                bff.ajax(urlAjax+'item-approve', $form.serializeArray(), function(data){
                    if(data) { 
                       history.back();
                    }
                }, $progress);
            },
            unpublicate: function()
            {
                if(!bff.confirm('sure')) return false;
                
                bff.ajax(urlAjax+'item-unpublicate', $form.serializeArray(), function(data){
                    if(data) {                               
                        history.back();
                    }
                }, $progress);
            },
            publicate2: function(step)
            {             
                var $block = $('#i_publicate2', $form);
                if(step==0)
                {
                    $block.show();
                }
                else if(step==1) //сохранить
                {
                    bff.ajax(urlAjax+'item-publicate2', $form.serializeArray(), function(data){
                        if(data) { 
                           history.back();
                        }
                    }, $progress);
                }
                else if(step==2) //отмена
                {
                    $block.hide();
                }
                return false;
            }
        };
                
    }());

    var autoPhotos = (function()
    {

        var uploader, url = '<?= $this->adminLink('ajax&act=') ?>', path = '<?= $this->initImages()->getUrl() ?>';
        var $form, $block, $progress;
        var itemID = <?= $id ?>;
        $(function(){

            $form     = $('#auto-form');
            $block    = $('#auto-form-images', $form);
            $progress = $('#auto-form-images-progress', $form);

            // init uploader
            uploader = new qq.FileUploaderBasic({
                button: $('#auto-form-images-button', $form).get(0),
                action: url+'item-img-upload&id='+itemID,
                limit: <?= Auto::imagesLimit() ?>,
                uploaded: <?= $imgcnt ?>,
                multiple: true,
                onSubmit: function(id, fileName) {
                    $progress.show();
                },
                onComplete: function(id, fileName, data) {
                    if(data && data.success) {
                        $block.append('<div class="left" style="margin-right: 5px;">\
                            <input type="hidden" name="filename[]" value="'+data.filename+'" />\
                            <a href="'+ path + itemID + data.filename + '" rel="auto_photos" target="_blank">\
                                <img src="' + path + itemID + 's' + data.filename + '" />\
                            </a> <br /> \
                            <a href="#" class="txt del ajax but but-text" rel="'+data.filename+'">Удалить</a>\
                        </div>');
                        $('a[rel="auto_photos"]', $block).fancybox();
                    } else {
                        if(data.errors) {
                            app.showError($('#auto-error'), data.errors, false);
                        }
                    }
                    if( ! uploader.getInProgress()) {
                        $progress.hide();
                    }
                    return true;
                }
            });

            $block.on('click', 'a.del', function (e) {
                nothing(e);
                var lnk = $(this);
                if(confirm('Удалить фото?')) {
                    var fn = lnk.attr('rel');
                    bff.ajax(url+'item-img-delete', {filename:fn, id:itemID}, function(data) {
                        if(data) {
                            lnk.parent().remove();
                            uploader.decrementUploaded();
                        }
                    });
                } return false;
            });

            $('a[rel="auto_photos"]', $block).fancybox();
        });

        return {};

    }());

//]]>
</script>

<form method="post" action="" id="auto-form" name="autoItemEditForm">
<input type="hidden" name="id" value="<?= $id; ?>" />
<input type="hidden" name="cat_id" value="<?= $cat_id; ?>" />
<input type="hidden" name="blocked" value="<?= ($blocked?1:0) ?>" />
<table class="admtbl tbledit dp">
<tr>
    <td class="row1" width="90"><span class="field-title">Раздел</span>:</td>
    <td class="row2 bold"><b><?= $cat_title ?></b></td>
</tr>
<tr>
    <td class="row1" width="90"><span class="field-title">Марка / модель</span>:</td>
    <td class="row2 bold">
        <select name="mark_id" onchange="autoEdit.onMark(intval(this.value), this);"><?= $marks ?></select>
        <select name="model_id" id="auto-models"><?= $models ?></select>
    </td>
</tr>
<tr>
    <td class="row1"><span class="field-title">Цена</span><span class="required-mark">*</span>:</td>
    <td class="row2">
        <input type="text" maxlength="9" name="price" class="req" value="<?= $price; ?>" style="width:120px;" pattern="[0-9]*" /> &nbsp;&nbsp;
        <select name="price_curr"><?= $curr ?></select>
        <? foreach($this->getPriceParams() as $ppKey=>$ppTitle) {
            ?><label class="checkbox inline"><input type="checkbox" <?= ($price_params & $ppKey ?'checked':'') ?> name="price_params[]" value="<?= $ppKey ?>" /> <?= $ppTitle ?></label>&nbsp;<?
        } ?>
    </td>
</tr>
<? if( ! empty($dp)) { ?>
    <tr><td colspan="2"><hr class="cut"></td></tr>
    <?= $dp;
} ?>
<tr><td colspan="2"><hr class="cut"></td></tr> 
<tr>
    <td class="row1"><span class="field-title">Дополнительно</span>: </td>
    <td class="row2"><textarea name="info" style="height: 110px;" class="stretch"><?= $info; ?></textarea></td>
</tr>
<? if($user_id > 0) { if(!empty($aCompanyInfo)) { ?>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Компания:</td>
    <td>
        <a href="<?= Items::url('view', $aCompanyInfo['link']) ?>" class="but linkout" target="_blank"></a><a href="<?= $this->adminLink('items_edit&item_id='.$company_id, 'items') ?>"><?= $aCompanyInfo['title'] ?></a>
    </td>
</tr>
<? } ?>
<tr><td colspan="2"><hr class="cut"></td></tr>
    <tr>
    <td class="row1 field-title">Пользователь:</td>
    <td class="row2"><a href="#" class="ajax<? if($user_blocked){ ?> block_s<? } ?>" onclick="return bff.userinfo(<?= $user_id ?>);"><?= $user_email ?></a></td>
</tr>
<? } ?>
<tr>
    <td class="row1 field-title">Город<span class="required-mark">*</span>:</td>
    <td class="row2"><?= Geo::cityOptionsSelect($city_id, true, 'city_id'); ?></td>
</tr>
<tr>
    <td class="row1 field-title">Имя:</td>
    <td class="row2"><?= ( ! empty($user_name) ? $user_name : 'нет') ?></td>
</tr>
<tr>
    <td class="row1 field-title">Телефон:</td>
    <td class="row2"><?= ( ! empty($user_phone) ? $user_phone : 'нет') ?></td>
</tr>
<tr>
    <td class="row1 field-title">Email:</td>
    <td class="row2"><?= ( ! empty($user_email) ? $user_email : 'нет') ?></td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr>
    <td class="row1 field-title">Изображения:<div class="progress" style="margin-top: 4px; display:none;" id="auto-form-images-progress"></div></td>
    <td class="left">
        <div style="margin-top: 5px;" id="auto-form-images">
                <?
                    if($imgcnt>0)
                    {
                        $img = explode(',',$img);
                        $img_url = $this->initImages()->getUrl();
                        foreach($img as $i) 
                        { if($i) { ?>
                        <div class="left" style="margin-right: 5px;">
                            <input type="hidden" name="filename[]" value="<?= $i ?>" />
                            <a href="<?= $img_url.$id.$i; ?>" rel="auto_photos" target="_blank"><img src="<?= $img_url.$id.'s'.$i ?>" /></a><br />
                            <a href="#" class="but del ajax but-text" rel="<?= $i ?>" style="margin-top:2px;">Удалить</a>
                        </div>
                    <?  } }
                    }
                ?>
        </div>
        <div class="clear"></div>
        <div id="auto-form-images-button" style="height: 20px; width: 160px"><a href="javascript:void(0);" class="ajax"><?= _t('', 'Загрузить фотографии'); ?></a></div>

        <div class="clear"></div>
    </td>
</tr>
<tr><td colspan="2"><hr class="cut"></td></tr>
<tr class="row1">
    <td class="field-title">Статус:</td>
    <td class="left"><b><?
        switch ($status) {
            case Auto::STATUS_NEW:           { echo 'Новое'; } break;
            case Auto::STATUS_PUBLICATED:    { echo 'Публикуется'; } break;
            case Auto::STATUS_PUBLICATED_OUT: { echo 'Период публикации завершился'; } break;
            case Auto::STATUS_BLOCKED:       { echo ($moderated == 0?'Заблокировано (ожидает проверки)':'Заблокировано'); } break;
        }
    ?></b></td>
</tr>
<? if($status != Auto::STATUS_NEW) { ?>
<tr class="row1">
    <td class="field-title">Период публикации:</td>
    <td class="left"><b><?= tpl::date_format2($publicated, true).' - '.tpl::date_format2($publicated_to, true); ?></b></td>
</tr>
<? } ?>
<tr>
    <td class="row1"></td>
    <td class="row2">
        <div class="warnblock<?= ( ! $blocked ? ' hidden':'') ?>" id="i_blocked_error" style="margin-bottom:10px;">
            <div class="warnblock-content">  
                <div><b>Причина блокировки</b>: <div class="right description" id="i_blocking_warn" style="display:none;"></div></div>
                <div class="clear"></div> 
                <div id="i_blocked">
                    <span id="i_blocked_text"><?= ( ! empty($blocked_reason) ? $blocked_reason :'?') ?></span> - <a href="#" onclick="autoEdit.changeBlocked(1,0); return false;" class="ajax description">изменить</a>
                </div>
                <div id="i_blocking" style="display: none;">
                    <textarea name="blocked_reason" id="i_blocking_text" class="autogrow" style="height:60px; min-height:60px;"
                        onkeyup="checkTextLength(300, this.value, $('#i_blocking_warn').get(0));"><?= $blocked_reason; ?></textarea>
                    <a onclick="return autoEdit.changeBlocked(3,1);" class="ajax" href="#"><?= ( ! $blocked ? 'продолжить':'изменить причину') ?></a>&nbsp;&nbsp;<a onclick="return autoEdit.changeBlocked(2);" class="ajax desc" href="#">отмена</a>
                </div> 
            </div>
        </div> 
        
        <div class="warnblock hidden" id="i_publicate2" style="margin-bottom:10px;">
            <div class="warnblock-content">                                 
                <table class="admtbl tbledit">
                <tr class="row1">
                    <td width="115" class="field-title">Период публикации:</td>
                    <td>
                    <script type="text/javascript"> 
                    <?  
                        $periods = $this->getPublicatePeriods();
                    ?>                        
                    var iPublicatePeriods = <?= func::php2js( $periods );  ?>;
                    </script>
                    <select class="inputText2" tabindex="1" name="period" onchange="$('#publicated2-till').html( iPublicatePeriods['dates'][this.value] );">
                        <?= $periods['options'] ?>
                    </select>
                    </td>
                </tr>
                <tr class="row1"><td class="field-title">Срок публикации:</td><td class="bold"><?= ($status == Auto::STATUS_PUBLICATED_OUT ? 'с '.date('d.m.Y').' по ' : ' до ' ) ?><span id="publicated2-till"><?= $periods['dates'][1]; ?></span></td></tr>
                <tr class="row1"><td style="margin-bottom:10px;" colspan="2">
                    <a onclick="return autoEdit.publicate2(1);" class="ajax" href="#">опубликовать</a>&nbsp;&nbsp;<a onclick="return autoEdit.publicate2(2);" class="ajax desc" href="#">отмена</a>
                </td></tr>
                </table>   
            </div>
        </div>
    </td>
</tr>
<tr>
    <td class="row1" colspan="2">
        <input type="submit" class="btn btn-success button submit" value="сохранить" />
       <?
       if($moderated == 0 || $blocked) { ?>
            <input class="success button" type="button" onclick="autoEdit.approve();" value="<?= ($status == Auto::STATUS_BLOCKED ? 'проверено, все впорядке' : 'проверено') ?>" />
       <? } else {
           if($status == Auto::STATUS_PUBLICATED_OUT) {
                ?><input class="btn submit button" type="button" onclick="autoEdit.publicate2(0);" value="опубликовать" /><?
           } else if($status == Auto::STATUS_PUBLICATED) {
                ?><input class="btn submit button" type="button" onclick="autoEdit.unpublicate();" value="снять с публикации" /><?
           }
       }
       if( ! $blocked) { ?>
           <input class="btn clr-error delete button" onclick="autoEdit.changeBlocked(1,0,0); return false;" id="i_block_lnk" type="button" value="заблокировать" />
       <? } ?>
        <input type="button" class="btn button cancel" value="отмена" onclick="history.back();" />
        <div class="progress" style="margin: 8px 8px 0; display: none;" id="auto-form-progress"></div>
    </td>
</tr>
</table>

</form>