<?php

class AutoModel extends Model
{
    /** @var AutoBase */
    var $controller;

    var $langCategories = array(
        'title'             => TYPE_STR,    # название
        'titleh1'           => TYPE_NOTAGS, # заголовок h1
        'title_popular'     => TYPE_STR,    # заголовок для списка популярных марок
        'description'       => TYPE_STR,    # описание
        'description_title' => TYPE_STR,    # описание: заголовок
        'mtitle'            => TYPE_NOTAGS, # meta title
        'mkeywords'         => TYPE_NOTAGS, # meta keywords
        'mdescription'      => TYPE_NOTAGS, # meta description
        'tpl_title_view'    => TYPE_STR,    # шаблон заголовка при просмотре
        'tpl_title_lists'   => TYPE_STR,    # шаблон заголовка в списках
        'tpl_descshort'     => TYPE_STR,    # шаблон для краткого описания
        'tpl_descfull'      => TYPE_STR,    # шаблон для подробного описания
        'tpl_vip_header'    => TYPE_STR,    # шаблон заголовка в VIP блоке
    );

    var $langMarksModels = array(
        'title'             => TYPE_STR,    # название
        'titleh1'           => TYPE_NOTAGS, # заголовок h1
        'description'       => TYPE_STR,    # описание
        'description_title' => TYPE_STR,    # описание: заголовок
        'mtitle'            => TYPE_NOTAGS, # meta title
        'mkeywords'         => TYPE_NOTAGS, # meta keywords
        'mdescription'      => TYPE_NOTAGS, # meta description
    );

    /**
     * Получение данных объявления
     * @param integer $nItemID ID объявления
     * @param array|string $aFields требуемые поля объявления
     * @param array|string $aUserFields требуемые данные о пользователе (авторе объявления)
     * @return array
     */
    function itemData($nItemID, $aFields = '*', $aUserFields = array())
    {
        if ( empty($nItemID) ) return array();

        $aParams = array();
        # item params
        if (empty($aFields)) $aFields = '*';
        if (!is_array($aFields)) $aFields = array($aFields);
        foreach ($aFields as $v) {
            $aParams[] = 'I.'.$v;
        }
        # user params
        $bJoinUsers = false;
        if ( ! empty($aUserFields) ) {
            if ( is_string($aUserFields) ) $aUserFields = array($aUserFields);
            foreach ($aUserFields as $v) {
                $aParams[] = 'U.'.$v;
            }
            $bJoinUsers = true;
        }

        return $this->db->one_array('SELECT '.join(',', $aParams).'
                                  FROM '.TABLE_AUTO_ITEMS.' I
                                       '.($bJoinUsers ? ', '.TABLE_USERS.' U' : '').'
                                  WHERE I.id = :id '.($bJoinUsers ? 'AND I.user_id = U.user_id' : ''),
                                  array(':id'=>$nItemID));
    }

    /**
     * Сохранение объявления
     * @param integer $nItemID ID объявления
     * @param array $aData данные объявления
     * @param mixed $sDynpropsDataKey ключ данных дин. свойств, например 'd' или FALSE
     * @return boolean|integer
     */
    function itemSave($nItemID, array $aData, $sDynpropsDataKey = false)
    {
        if (empty($aData)) return false;
        if ( ! empty($sDynpropsDataKey) && ! empty($aData['cat_id'])) {
            $aDataDP = $this->controller->dpSave( $aData['cat_id'], $aData, $sDynpropsDataKey );
            $aData = array_merge($aData, $aDataDP);
        }

        $aData['modified'] = $this->db->now();

        if ( isset($aData['filename']) )
        {
            reset($aData['filename']);
            $aData['imgfav'] = current($aData['filename']);
            $aData['img'] = join(',', $aData['filename']);
            $aData['imgcnt'] = sizeof($aData['filename']);
            unset($aData['filename']);
        }

        if ( isset($aData['price_params']) ) {
            $aData['price_params'] = array_sum($aData['price_params']);
        }

        if ( isset($aData['title2']) ) {
            $aData['title_alt'] = HTML::escape(strip_tags($aData['title2']));
            $aData['keyword'] = mb_strtolower(func::translit($aData['title_alt']));
        }

        if ($nItemID > 0)
        {
            $res = $this->db->update(TABLE_AUTO_ITEMS, $aData, array('id'=>$nItemID));
        } else {
            $aData['created'] = $this->db->now();
            $res = $nItemID = $this->db->insert(TABLE_AUTO_ITEMS, $aData);
        }

        if ( ! $res) return $res;

        # формируем URL просмотра
        $aData = $this->itemData($nItemID, array('keyword', 'city_id'));
        $this->db->update(TABLE_AUTO_ITEMS, array(
            'link' => Auto::urlView($nItemID, $aData['keyword'], $aData['city_id']),
        ), array('id'=>$nItemID));

        return $res;
    }

    /**
     * Список объявлений пользователя в профиле (фронтенд)
     * @param integer $nUserID ID пользователя
     * @param bool $bCount только подсчет кол-ва объявлений
     * @param string $sqlLimit
     * @return array
     */
    function itemsListProfile($nUserID, $bCount = false, $sqlLimit = '') # frontend
    {
        $aBind = array(':user'=>$nUserID);

        if ($bCount) {
            return $this->db->one_data('SELECT COUNT(I.id) FROM '.TABLE_AUTO_ITEMS.' I WHERE I.user_id = :user', $aBind);
        }

        return $this->db->select('SELECT I.id, I.link, I.status, I.status_prev,
                                    I.moderated, I.blocked_num, I.blocked_reason, I.publicated_to,
                                    I.svc, (I.svc & '.Auto::SERVICE_FIX.') as fixed, (I.svc & '.Auto::SERVICE_VIP.') as vip, (I.svc & '.Auto::SERVICE_MARK.') as marked,
                                    I.imgfav, I.title, I.descshort, I.price, I.price_curr, I.price_params as pricep
                                FROM '.TABLE_AUTO_ITEMS.' I
                                WHERE I.user_id = :user
                                ORDER BY I.id DESC
                            '.$sqlLimit, $aBind);
    }

    /**
     * Список объявлений кампании (фронтенд)
     * @param integer $nCompanyID ID кампании
     * @param bool $bCount только подсчет кол-ва объявлений
     * @param string $sqlLimit
     * @return array
     */
    function itemsListCompany($nCompanyID, $bCount = false, $sqlLimit = '') # frontend
    {
        $sqlFilter = array(
            'I.company_id = :company',
            'I.status = '.Auto::STATUS_PUBLICATED,
        );
        if(Auto::premoderation()){
            $sqlFilter[] = 'I.moderated > 0';
        }

        $aBind = array(':company'=>$nCompanyID);

        if ($bCount) {
            return $this->db->one_data('SELECT COUNT(I.id) FROM '.TABLE_AUTO_ITEMS.' I WHERE '.join(' AND ', $sqlFilter), $aBind );
        }

        return $this->db->select('SELECT I.id, I.link, I.status, I.status_prev,
                                    I.moderated, I.blocked_num, I.blocked_reason, I.publicated_to,
                                    I.svc, (I.svc & '.Auto::SERVICE_FIX.') as fixed, (I.svc & '.Auto::SERVICE_VIP.') as vip, (I.svc & '.Auto::SERVICE_MARK.') as marked,
                                    I.imgfav, I.title, I.descshort, I.price, I.price_curr, I.price_params as pricep
                                FROM '.TABLE_AUTO_ITEMS.' I
                                WHERE '.join(' AND ', $sqlFilter).'
                                ORDER BY fixed DESC, I.fixed_order DESC, I.publicated_order DESC
                            '.$sqlLimit, $aBind);
    }

    function itemsListVIP($nCatID = 0, $nMarkID = 0, $nModelID = 0)
    {
        $isServiceOn = $this->controller->svcIsVIPEnabled($aVipSettings);
        if ( ! $isServiceOn ) return array();

        $sqlFilter = array('(I.svc & '.Auto::SERVICE_VIP.')', 'I.vip_to >= :now', 'I.status = '.Auto::STATUS_PUBLICATED);
        if ( false ) {
            if ( $nCatID > 0 ) {
                $sqlFilter[] = 'I.cat_id = '.$nCatID;
            }
            if ( $nMarkID > 0 ) {
                $sqlFilter[] = 'I.mark_id = '.$nMarkID;
            }
            if ( $nModelID > 0 ) {
                $sqlFilter[] = 'I.model_id = '.$nModelID;
            }
        }

        $aData = $this->db->select('SELECT I.id, I.link, I.imgfav, I.title, I.title_alt, I.price, I.price_curr, I.price_params as pricep, I.vip_header
                FROM '.TABLE_AUTO_ITEMS.' I
                WHERE '.join(' AND ', $sqlFilter).'
                ORDER BY RAND()
                '. $this->db->prepareLimit(0, $aVipSettings['cnt']),
                array(':now'=>$this->db->now()));
        if ( empty($aData) ) $aData = array();
        return $aData;
    }

    /**
     * Перестраивание ссылок во всех записях
     */
    public function itemsLinksRebuild()
    {
        $model = $this;
        $this->db->select_rows_chunked(TABLE_AUTO_ITEMS, array('id','keyword','city_id'),
                                       array(),'id',array(), function ($items) use ($model) {
            foreach ($items as $v) {
                $model->db->update(TABLE_AUTO_ITEMS, array(
                    'link' => Auto::urlView($v['id'], $v['keyword'], $v['city_id'])
                ), array('id'=>$v['id']));
            }
        }, 100);
    }

    function getLocaleTables()
    {
        return array(
            TABLE_AUTO_CATEGORIES => array('type'=>'table','fields'=>$this->langCategories),
            TABLE_AUTO_MARKSMODELS => array('type'=>'table','fields'=>$this->langMarksModels),
            TABLE_AUTO_DYNPROPS => array('type'=>'fields','fields'=>array('title'=>TYPE_NOTAGS, 'description' => TYPE_NOTAGS)),
            TABLE_AUTO_DYNPROPS_MULTI => array('type'=>'fields','fields'=>array('name'=>TYPE_NOTAGS)),
        );
    }

    function categoryIDByKeyword($sKeyword)
    {
        return (int)$this->db->select_data(TABLE_AUTO_CATEGORIES, 'id', array('keyword'=>$sKeyword));
    }

    function categoryDataSearch($nCategoryID)
    {
        return $this->db->one_array('SELECT C.id, C.keyword,
                CL.title, CL.titleh1, CL.mtitle, CL.mkeywords, CL.mdescription, C.mtemplate
            FROM '.TABLE_AUTO_CATEGORIES.' C,
                 '.TABLE_AUTO_CATEGORIES_LANG.' CL
            WHERE C.id = :id'.$this->db->langAnd(true, 'C', 'CL'),
            array(':id' => $nCategoryID));
    }

    function markIDByKeyword($sKeyword)
    {
        return (int)$this->db->select_data(TABLE_AUTO_MARKSMODELS, 'id', array('keyword'=>$sKeyword));
    }

    function markDataSearch($nMarkID)
    {
        return $this->db->one_array('SELECT M.id, M.keyword,
                ML.title, ML.titleh1, ML.mtitle, ML.mkeywords, ML.mdescription, M.mtemplate
            FROM '.TABLE_AUTO_MARKSMODELS.' M,
                 '.TABLE_AUTO_MARKSMODELS_LANG.' ML
            WHERE M.id = :id'.$this->db->langAnd(true, 'M', 'ML'),
            array(':id' => $nMarkID));
    }

}