<?php

class Auto extends AutoBase
{
    public function route()
    {
        $prefix = ( ! bff::subdomainsEnabled('auto') ? 'auto/' : '' );
        $res = bff::route(array(
            $prefix.'(.*)-([\d]+)\.html'                => 'auto/view/id=\\2',
            $prefix.'search/(.*)/(.*)/(.*)(\/|)'        => 'auto/search/cat=\\1&mark=\\2&model=\\3',
            $prefix.'search/(.*)/(.*)(\/|)'             => 'auto/search/cat=\\1&mark=\\2',
            $prefix.'search/(.*)(\/|)'                  => 'auto/search/cat=\\1',
            $prefix.'(add|edit|search|fav|promote)(.*)' => 'auto/\\1',
            $prefix.'salons(.*)'                        => 'auto/salons',
        ), true);

        if ($res['event'] === false || ! method_exists($this, $res['event']))
            $res['event'] = 'index';

        return $this->$res['event']();
    }

    /**
     * Главная: блок "Авто"
     * @return array
     */
    public function indexBlock()
    {
        # Избранные марки легковых автомобилей
        $marks = $this->db->select('SELECT ML.title, M.keyword as key_mark, C.keyword as key_cat,
                        COUNT(I.id) as i
                    FROM '.TABLE_AUTO_MARKSMODELS.' M
                        LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON
                            I.mark_id = M.id AND I.status = '.self::STATUS_PUBLICATED.'
                            '.( $this->regionsFilterEnabled() ? ' AND I.city_id = '.Geo::cityID() : '' ).',
                        '.TABLE_AUTO_MARKSMODELS_LANG.' ML,
                        '.TABLE_AUTO_CATEGORIES.' C
                    WHERE M.fav = 1 AND M.cat_id = :cat AND M.enabled = 1 AND M.pid = 0 '.$this->db->langAnd(true, 'M', 'ML').'
                      AND C.id = M.cat_id
                    GROUP BY M.id
                    ORDER BY M.num
                    LIMIT 10
        ', array(':cat' => 2));
        if ( ! empty($marks)) {
            foreach ($marks as &$v) {
                $v['url'] = static::url('search', array('cat'=>$v['key_cat'], 'mark'=>$v['key_mark']));
                unset($v['key_mark'], $v['key_cat']);
            } unset($v);
            $marks = array_chunk($marks, 5); if ( ! isset($marks[1])) $marks[] = array();
        } else {
            $marks = array(array(),array());
        }
        $aData['marks'] = &$marks;

        # Последние объявления
        $aData['items'] = $this->db->select('SELECT I.id, I.link, I.title2, I.title_alt, I.imgfav, I.imgcnt,
                    I.price, I.price_curr
                FROM '.TABLE_AUTO_ITEMS.' I
                WHERE I.status = '.self::STATUS_PUBLICATED.'
                '.( $this->regionsFilterEnabled() ? ' AND I.city_id = '.Geo::cityID() : '' ).'
                ORDER BY I.id DESC
                LIMIT 3');
        if ( ! empty($aData['items'])) {
            foreach ($aData['items'] as &$v) {
                $v['url'] = static::url('view', $v['link']);
                $v['img'] = AutoImages::url($v['id'], $v['imgfav'], AutoImages::szSmall);
                unset($v['imgfav'], $v['link']);
            } unset($v);
        } else {
            $aData['items'] = array();
        }

        # Ссылки на категории "Авто"
        $aData['links'] = Items::model()->categoriesLinks(16, array(93));
        foreach ($aData['links'] as &$v) {
            $v['url'] = Items::url('map', array('cat'=>$v['keyword'])); unset($v['keyword']);
        } unset($v);
        array_unshift($aData['links'], array(
            'title' => _t('auto', 'Автосалоны'),
            'url'   => static::url('salons'),
        ));

        return $this->viewPHP($aData, 'index.block');
    }
    
    /**
     * Главная страница раздела "Авто"
     */
    public function index()
    {
        $aData = $this->search_filter(true);

        # получаем марки
        $aData['marks'] = $this->db->select('SELECT M.id, ML.title as t, M.cat_id as cid, COUNT(I.id) as i, M.keyword
                    FROM '.TABLE_AUTO_MARKSMODELS.' M
                        LEFT JOIN '.TABLE_AUTO_ITEMS.' I ON
                            I.mark_id = M.id AND I.status = '.self::STATUS_PUBLICATED.'
                            '.( $this->regionsFilterEnabled() ? ' AND I.city_id = '.Geo::cityID() : '' ).'
                            '.(static::premoderation() ? ' AND I.moderated > 0' : '').'
                        , '.TABLE_AUTO_MARKSMODELS_LANG.' ML
                    WHERE M.enabled = 1 AND M.pid = 0 '.$this->db->langAnd(true, 'M', 'ML').'
                    GROUP BY M.id
                    HAVING i>0
                    ORDER BY M.cat_id, i DESC, ML.title
        ');

        # раскладываем по категориям
        foreach ($aData['cats'] as $id=>$v) {
            $aData['cats'][$id]['marks'] = array();
        }
        foreach ($aData['marks'] as $v) {
            if (isset($aData['cats'][$v['cid']]))
                $aData['cats'][$v['cid']]['marks'][$v['id']] = array('t'=>$v['t'], 'i'=>$v['i'], 'k'=>$v['keyword']);
        } unset($aData['marks']);

        foreach ($aData['cats'] as $k=>$v) {
            if ( ! empty($v['marks'])) {
                $aData['cats'][$k]['marks'] = array_slice($v['marks'], 0, 12, true);
            }
        }
        # vip блок
        $aData['vipBlock'] = $this->vipBlock();

        # получаем последние добавленные ОБ
        $aData['latest'] = $this->db->select('SELECT I.id, I.link, I.title2, I.title_alt, I.imgfav, I.imgcnt, I.price, I.price_curr
                        FROM '.TABLE_AUTO_ITEMS.' I 
                        WHERE I.status = '.self::STATUS_PUBLICATED.'
                        '.( $this->regionsFilterEnabled() ? ' AND I.city_id = '.Geo::cityID() : '' ).'
                        ORDER BY I.id DESC
                        LIMIT 3');
        if ( ! empty($aData['latest'])) {
            foreach ($aData['latest'] as &$v) {
                $v['url'] = static::url('view', $v['link']);
                $v['img'] = AutoImages::url($v['id'], $v['imgfav'], AutoImages::szSmall);
                unset($v['imgfav'], $v['link']);
            } unset($v);
        } else {
            $aData['latest'] = array();
        }

        $aData['news'] = Publications::i()->indexCompaniesInCatNewsBlock(static::salonsCategory());

        # SEO: Главная страница
        $this->urlCorrection(static::url('index'));
        $this->seo()->canonicalUrl(static::url('index', array(), true));
        $this->setMeta('index', array(
            'region' => Geo::filter('title'),
        ), $aData);

        $this->initRightblock(__FUNCTION__, array('filter'=>&$aData['filter']));
        return $this->viewPHP($aData, 'index');
    }

    /**
     * Поиск объявлений
     */
    public function search()
    {
        $aData = $this->search_filter(false);
        $f = &$aData['f'];
        
        $nCatID = $f['c'];
        $nMarkID = $f['mk'];
        $nModelID = $f['md'];

        $sql = array();
        $sql[] = 'I.status = '.self::STATUS_PUBLICATED;
        $sql[] = 'I.price_curr = CURR.id';
        $sql[] = 'I.cat_id = '.$nCatID;
        $seoNoIndex = false;

        # марка
        if ($nMarkID) {
            $sql[] = 'I.mark_id = '.$nMarkID;
        }
        # модель
        if ($nModelID) {
            $sql[] = 'I.model_id = '.$nModelID;
        }

        # регион: город
        if ( ! Geo::cityIsOne() ) {
            if ($f['rc'] > 0) {
                $sql[] = 'I.city_id = '.$f['rc'];
            }
            if (Geo::filterUrl('id') != $f['rc']) {
                $seoNoIndex = true;
            }
        }

        $seoResetCounter = sizeof($sql); # всю фильтрацию ниже скрываем от индексации

        # Цена (в основной валюте)
        if ($f['pf'] > 0 || $f['pt'] > 0)
        {
            if ($f['pf'] > 0) { # от
                $sql[] = '(I.price * CURR.rate) >= '.$f['pf'];
                if ($f['pt'] > 0 && $f['pt'] > $f['pf']) {
                    $sql[] = '(I.price * CURR.rate) <= '.$f['pt']; # если до, и до больше от
                }
            } else if ($f['pt'] > 0) { # до
                $sql[] = '(I.price * CURR.rate) <= '.$f['pt'];
            }
        }
        if ($f['ph']) { # есть фотографии
            $sql[] = 'I.imgcnt > 0';
        }

        if(static::premoderation()){
            $sql[] = 'I.moderated > 0';
        }


        # фильтр по дин. свойствам
        $sqlDP = $this->dp()->prepareSearchQuery($f['f'], false, $this->dpSettings($nCatID), 'I.');
        if ( ! empty($sqlDP)) {
            $sql[] = $sqlDP;
        }

        $nPerpage = config::sys('auto.search.perpage', 10);;
        $nTotal = $this->db->one_data('SELECT COUNT(I.id) FROM '.TABLE_AUTO_ITEMS.' I, '.TABLE_CURRENCIES.' CURR WHERE '.join(' AND ', $sql));
        if ($f['cnt']) {
            $this->ajaxResponse(array('total'=>$nTotal));
        }

        # SEO: Подготовка данных
        $aCategory = $this->model->categoryDataSearch($nCatID);
        if (empty($aCategory)) $this->errors->error404();
        $nPage = $this->input->get('page', TYPE_UINT); if (!$nPage) $nPage = 1;
        $seo = array('page'=>'search', 'url'=>array('cat'=>$aCategory['keyword']), 'macros'=>array(
            'category' => $aCategory['title'],
            'region'   => Geo::filter('title'),
            'page'     => $nPage,
        ), 'data'=>&$aCategory);
        if ($nMarkID) { # Марка
            $aMark = $this->model->markDataSearch($nMarkID);
            if (empty($aMark)) $this->errors->error404();
            $seo['page'] = 'search-mark';
            $seo['url']['mark'] = $aMark['keyword'];
            $seo['macros']['mark'] = $aMark['title'];
            $seo['data'] = &$aMark;
        }
        if ($nModelID) { # Модель
            $aModel = $this->model->markDataSearch($nModelID);
            if (empty($aModel)) $this->errors->error404();
            $seo['page'] = 'search-model';
            $seo['url']['model'] = $aModel['keyword'];
            $seo['macros']['model'] = $aModel['title'];
            $seo['data'] = &$aModel;
        }

        $aRequestURI = parse_url(Request::uri());
        $sQuery = ( ! empty($aRequestURI['query']) ? trim( preg_replace('/&?page=(\d+)/', '', $aRequestURI['query']), '&') : '' );
        $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('search', $seo['url'])."/?{$sQuery}&page={page}", $sqlLimit);

        $nUserID = $this->security->getUserID();
        $aData['items'] = $this->db->select('SELECT I.id, I.link, I.title, I.descshort, I.imgcnt, I.imgfav, I.price, I.price_curr, I.price_params as pricep,
                                    I.svc, (I.svc & '.self::SERVICE_FIX.') as fixed, (I.svc & '.self::SERVICE_MARK.') as marked,
                                    '.($nUserID ? ' (F.item_id)' : '0').' as fav
                                FROM '.TABLE_AUTO_ITEMS.' I
                                       '.($nUserID ? ' LEFT JOIN '.TABLE_AUTO_FAV.' F ON I.id = F.item_id AND F.user_id = '.$nUserID : '').',
                                     '.TABLE_CURRENCIES.' CURR
                                WHERE '.join(' AND ', $sql).'
                                ORDER BY fixed DESC, I.fixed_order DESC, I.publicated_order DESC
                                '.$sqlLimit);

        # Vip блок
        $aData['vipBlock'] = $this->vipBlock($nCatID, $nMarkID, $nModelID);

        # SEO: Поиск объявлений
        $this->seo()->robotsIndex(!(sizeof($sql) - $seoResetCounter) && !$seoNoIndex);
        $this->urlCorrection(static::url('search', $seo['url']));
        $this->seo()->canonicalUrl(static::url('search', $seo['url'], true), array(
            'page' => $nPage
        ));
        $this->setMeta($seo['page'], $seo['macros'], $seo['data']);
        $aData['titleh1'] = $seo['data']['titleh1'];

        $this->initRightblock(__FUNCTION__, array('filter'=>&$aData['filter']));
        return $this->viewPHP($aData, 'search');
    }
    
    protected function search_filter($isIndex = false)
    {
        $f = $this->input->postgetm(array(
            'c'  => TYPE_UINT,  # тип
            'rc' => TYPE_INT,   # регион: город
            'mk' => TYPE_UINT,  # марка
            'md' => TYPE_UINT,  # модель
            'f'  => TYPE_ARRAY, # дин. свойства
            'pf' => TYPE_PRICE, # цена, от
            'pt' => TYPE_PRICE, # цена, до
            'ph' => TYPE_BOOL,  # есть фотографии
            'cnt' => TYPE_BOOL, # только подсчет кол-ва
        ));

        if ($f['cnt']) {
            return array('f' => $f);
        }

        if ( ! $f['c']) {
            $f['c'] = $this->model->categoryIDByKeyword($this->input->get('cat', TYPE_NOTAGS));
        }
        if ( ! $f['mk'] && ! $isIndex) {
            $f['mk'] = $this->model->markIDByKeyword($this->input->get('mark', TYPE_NOTAGS));
        }
        if ( ! $f['md'] && ! $isIndex) {
            $f['md'] = $this->model->markIDByKeyword($this->input->get('model', TYPE_NOTAGS));
        }

        $nCatID = $f['c'];
        $nMarkID  = $f['mk'];
        $nModelID = $f['md'];

        if ($f['rc'] === 0) {
            $f['rc'] = ($this->regionsFilterEnabled() ? Geo::cityID() : -1);
        }
        
        $aData = array();
        $aData['f'] = &$f;
        $aData['isIndex'] = $isIndex;

        # типы
        $aCatFields = array('C.id','CL.title','(C.numright - C.numleft) as node','C.numlevel as lvl', 'C.keyword');
        if ($isIndex) $aCatFields[] = 'CL.title_popular';
        $aData['cats'] = $this->categoriesGet(true, $aCatFields, false, false);
        
        # марки
        $aData['marks'] = ( $nCatID > 0 ? $this->getMarksOptions($nCatID, $nMarkID, _t('auto','Все марки')) : '');

        # модели
        $aData['models'] = ( $nMarkID > 0 ? $this->getModelsOptions($nMarkID, $nModelID, _t('auto','Все модели')) : '<option value="0">'._t('auto','Все модели').'</option>' );
        
        # дин. свойства
        $aData['dp'] = $this->dpForm($nCatID, true, array(), array('f'=>&$f['f']));

        # активируем меню
        bff::setActiveMenu('//auto/search', !$isIndex, false);

        return array('filter' => $this->viewPHP($aData, 'search.filter'),
                     'cats' => $aData['cats'],
                     'f' => $f);
    }

    /**
     * Просмотр объявления
     */
    public function view()
    {
        bff::setActiveMenu('//auto/search', true);

        if (Request::isAJAX())
        {
            $aResponse = array();
            
            switch ($this->input->post('act', TYPE_STR)) {
                case 'photo_view': { # подробный просмотр фотографий ОБ
                    $aRes = $this->initImages()->processImagesView('');
                    $aResponse = array_merge($aRes, $aResponse);
                } break;
            }
            $aResponse['res'] = $this->errors->no();
            $this->ajaxResponse($aResponse);
        }

        $nItemID = $this->input->get('id', TYPE_UINT);
        $nUserID = User::id();
        $isPrint = $this->input->get('print', TYPE_BOOL);

        if ( ! $nItemID) {
            $this->errors->error404();
        }
        $aData = $this->db->one_array('SELECT I.id, I.link, I.title, I.title_alt, I.descfull, I.imgcnt, I.imgfav, I.img,
                                I.blocked_reason, I.cat_id, I.mark_id, I.model_id, I.company_id,
                                I.info, I.status, '.($nUserID ? ' (F.item_id)' : '0').' as fav,
                                I.user_id, I.user_name, I.user_email, I.user_phone,
                                I.price, I.price_curr, I.price_params, R.title_'.LNG.' as city_title, I.views
                        FROM '.TABLE_AUTO_ITEMS.' I
                               '.($nUserID > 0 ? ' LEFT JOIN '.TABLE_AUTO_FAV.' F ON F.item_id = I.id AND F.user_id = '.$nUserID : '').',
                             '.TABLE_REGIONS.' R
                        WHERE I.id = :id AND I.city_id = R.id
                        ', array(':id'=>$nItemID));
        if (empty($aData) || $aData['status'] == self::STATUS_NEW) {
            $this->errors->error404();
        }

        switch ($aData['status']) {
            case self::STATUS_BLOCKED: {
                return $this->showForbidden(_t('','Объявление #[id]', array('id'=>$nItemID)), _t('', 'Заблокировано по причине:<br/><b>[reason]</b>', array('reason'=>nl2br($aData['blocked_reason']))));
            } break;
            case self::STATUS_PUBLICATED_OUT: {
                return $this->showForbidden(_t('','Объявление #[id]', array('id'=>$nItemID)), _t('','Срок публикации объявления истек'));
            } break;
        }

        # Изображения
        $aData['img'] = $this->initImages()->prepareView($nItemID, $aData['imgcnt'], $aData['img']);

        # SEO: Просмотр объявления
        $aData['url'] = static::url('view', $aData['link']);
        $this->urlCorrection($aData['url']);
        $this->seo()->robotsIndex(!$isPrint);
        $this->seo()->canonicalUrl($aData['link']);
        $this->setMeta('view', array(
            'title'       => $aData['title_alt'],
            'description' => tpl::truncate(strtr(strip_tags($aData['descfull']), array("\r\n"=>', ',"\n"=>', ')), 150),
            'region'      => Geo::filter('title'),
        ), $aData);
        if ( ! $isPrint) {
            $seoShareImages = array();
            foreach ($aData['img'] as $v) {
                $seoShareImages[] = $v['view'];
            }
            $this->seo()->setSocialMetaOG($aData['share_title'], $aData['share_description'], $seoShareImages, $aData['url'], $aData['share_sitename']);
        }

        if ($isPrint) {
            # печать ОБ
            View::setLayout('print');
            return $this->viewPHP($aData, 'view.print');
        }
        
        if ( ! $nUserID || ($aData['user_id'] > 0 && $aData['user_id']!=$nUserID)) {
            $this->model->itemSave($nItemID, array('views = views + 1'));
        }
        if ($aData['company_id'] > 0) {
            $aData['company_data'] = Items::model()->companyData($aData['company_id']);
        }
        $aData['others'] = $this->db->select('SELECT I.id, I.link, I.imgcnt, I.imgfav, I.title, I.title_alt, I.descshort, I.price, I.price_curr, I.price_params
                            FROM '.TABLE_AUTO_ITEMS.' I
                            WHERE I.status = '.self::STATUS_PUBLICATED.' AND I.id != :id
                                AND I.mark_id = :mark AND I.model_id = :model
                            ORDER BY I.publicated_order DESC
                            LIMIT 4', array(':id'=>$nItemID, ':mark'=>$aData['mark_id'], ':model'=>$aData['model_id']));
        if ( ! empty($aData['others'])) {
            foreach ($aData['others'] as &$v) {
                $v['imgfav'] = $this->initImages()->getUrl($v['id'], $v['imgfav'], AutoImages::szSmall);
                $v['link'] = static::url('view', $v['link']);
            } unset($v);
        }

        $aData['from_history'] = (strpos(Request::referer(), static::url('search')) !== false ? 1 : 0);
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'view');
    }
    
    /**
     * Добавление объявления
     */
    public function add()
    {
        bff::setActiveMenu('//auto/search', true);

        # Результат добавления объявления
        if ( ! empty($_GET['finish'])) {
            $aData['id'] = $this->input->get('id', TYPE_UINT);
            $aItemData = $this->model->itemData($aData['id'], 'link');
            $aData['url_view'] = static::url('view', $aItemData['link']);
            bff::setMeta(_t('auto', 'Добавление объявления'));
            $this->initRightblock(__FUNCTION__);
            return $this->viewPHP($aData, 'add.finish');
        }
        
        $aData = $this->input->postm(array(
            'cat_id'   => TYPE_UINT, # тип
            'mark_id'  => TYPE_UINT, # марка
            'model_id' => TYPE_UINT, # модель
            'price'        => TYPE_PRICE, # цена
            'price_params' => TYPE_ARRAY_UINT, # цена: параметры; торг...
            'price_curr'   => TYPE_UINT, # цена: валюта
            'city_id'      => TYPE_UINT, # город
            'filename'     => TYPE_ARRAY_NOTAGS, # фотографии
            'info'         => array(TYPE_NOTAGS, 'len'=>10000), # доп. информация
            'user_name'    => array(TYPE_NOTAGS, 'len'=>100), # user: имя
            'user_phone'   => array(TYPE_NOTAGS, 'len'=>100), # user: телефон
            'user_email'   => array(TYPE_NOTAGS, 'len'=>100), # user: email
            'member'       => TYPE_BOOL,   # уже зарегистрирован
            'pass'         => TYPE_NOTRIM, # пароль для авторизации: user_email/pass
            'captcha'      => TYPE_STR,    # капча
            'period'       => TYPE_UINT,   # период публикации
            'company_id' => TYPE_UINT, # объявление компании
            'user_type' => TYPE_UINT,  # частное лицо/организация
        ));

        if (Request::isAJAX())
        {
            $aResponse = array('status'=>0, 'user'=>false, 'captcha'=>false);
            
            do 
            {
                $nCatID = $aData['cat_id'];
                
                if ( ! $nCatID) {
                    $this->errors->set( _t('auto', 'Выберите тип') );
                }
                if ( ! $aData['mark_id']) {
                    $this->errors->set( _t('auto', 'Укажите марку') );
                }
                if ( ! $aData['model_id']) {
                    $this->errors->set( _t('auto', 'Укажите модель') );
                }
                if ( ! $aData['price']) {
                    $this->errors->set( _t('auto', 'Укажите цену'), 'price' );
                }
                if ( ! $aData['price_curr']) {
                    $this->errors->set( _t('auto', 'Укажите валюту') );
                }
                if ( ! Geo::cityIsValid($aData['city_id']) ) {
                    $this->errors->set( _t('auto', 'Укажите ваш город') );
                }
                if (empty($aData['user_name'])) {
                    $this->errors->set( _t('auto', 'Укажите ваше имя'), 'user_name' );
                }
                if (empty($aData['user_phone'])) {
                    $this->errors->set( _t('auto', 'Укажите ваше телефон'), 'user_phone' );
                }

                if ( ! $this->errors->no()) break;

                $oUsers = $this->users();

                $sEmail = $aData['user_email'];
                
                $nUserStatus = false;
                            
                if ( ! User::id()) {
                    // для неавторизованного пользователя - email обязателен
                    if ( ! $this->input->isEmail($sEmail) ) {
                        $this->errors->set( _t('', 'E-mail адрес указан некорректно'), 'user_email' );
                    }
                    if ($aData['member']) {
                        //авторизуем
                        if (empty($aData['pass'])) {
                            $this->errors->set( _t('', 'Укажите пароль'), 'pass' );
                        } else {
                            $res = $oUsers->userAuth($sEmail, 'email', $aData['pass'], false, true);
                            if ($res === true) {
                                // успешно авторизовали
                                $aResponse['user'] = User::id();
                            } elseif ($res === 1) {
                                // пользователь не активирован
                                $aUserData = config::get('__user_preactivate_data', array());
                                $aResponse['user'] = $aUserData['id'];
                                $nUserStatus = 'na';
                            }
                        }
                    } else {
                        $aUser = $this->db->one_array('SELECT user_id, blocked, activated FROM '.TABLE_USERS.' WHERE email = :email', array(':email'=>$sEmail));
                        if ( ! empty($aUser)) {
                            $this->errors->set( _t('auto', 'Пользователь с указанным email адресом уже зарегистрирован') );
                            $aResponse['user'] = -1; // пользователь с указанным email адресом уже существует
                        } else {
                            // проверяем капчу
                            $oProtection = new CCaptchaProtection();
                            if (empty($aData['captcha']) || ! $oProtection->valid($this->input->cookie('c2'), $aData['captcha']) ) {
                                $this->errors->set( _t('', 'Результат с картинки указан некорректно'), 'captcha' );
                                $aResponse['captcha'] = true;
                            } else {
                                $aResponse['user'] = 1;
                                $nUserStatus = 'new'; 
                            }
                        }
                    }

                    if ( ! $this->errors->no()) {
                        break;
                    }
                } else {
                    $aResponse['user'] = User::id();
                    $nUserStatus = 'ok';
                    if ( ! $this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }
                }
            
                if ( ! $this->errors->no()) break;

                $aData['status'] = self::STATUS_PUBLICATED;
                $aData['status_prev'] = self::STATUS_NEW;

                if ($nUserStatus == 'new')
                {
                    // регистрируем нового пользователя
                    $oUsers->getActivationInfo($sActivateCode, $sActivateLink, $sActivateExpire);
                    $sPassword = func::generator(10);
                    $sPasswordSalt = $this->security->generatePasswordSalt();
                    $nUserID = $oUsers->model->userCreate(array(
                        'login'=>'', // будет сгенерирован уникальный
                        'email'=>$sEmail,
                        'password'=> $this->security->getUserPasswordMD5($sPassword, $sPasswordSalt), 
                        'password_salt'=> $sPasswordSalt,
                        'name'=>$aData['user_name'],
                        'phone'=>$aData['user_phone'],
                        'activated'=>0,
                        'activate_key'=>$sActivateCode,
                        'activate_expire'=>$sActivateExpire,
                        ), Users::GROUPID_MEMBER);

                    if ($nUserID)
                    {
                        // добавляем возможность получить повторное email-уведомление
                        $oUsers->setRegisterSecondEnotifyFlag($nUserID);
                        // отправляем email уведомление
                        $res = bff::sendMailTemplate(
                            array('name'=>$aData['user_name'], 'password'=>$sPassword, 'email'=>$sEmail, 'activate_link'=>$sActivateLink), 
                            'member_registration', $sEmail);

                        // переносим публикацию объявления на момент активации пользователя
                        $aData['status'] = self::STATUS_NEW;
                    } else {
                        $this->errors->set( _t('auto', 'Ошибка регистрации') );
                        break;
                    }
                } else {
                    $nUserID = User::id();
                }
                $aResponse['user'] = $nUserStatus;

                $sNOW = $this->db->now();
                $sPublicateTo = $this->preparePublicatePeriodTo($aData['period'], time());

                # проверим company_id
                if (User::id() && $aData['user_type'] == Items::USERTYPE_AGENT && $aData['company_id'] > 0) {
                    $aComp = Users::model()->companyInfo(User::id(), $aData['company_id']);
                    if (empty($aComp)) {
                        $aData['company_id'] = 0;
                    }
                } else {
                    $aData['company_id'] = 0;
                }


                # сохраняем объявление + публикуем
                $nItemID = $this->model->itemSave(0, array(
                    'user_id'  => $nUserID,
                    'cat_id'   => $nCatID,
                    'mark_id'  => $aData['mark_id'],
                    'model_id' => $aData['model_id'],
                    'city_id'  => $aData['city_id'],
                    'info'     => $aData['info'],
                    'price'    => $aData['price'],
                    'price_params' => $aData['price_params'],
                    'price_curr' => $aData['price_curr'],
                    'filename'   => $aData['filename'],
                    'user_name'  => $aData['user_name'],
                    'user_email' => $sEmail,
                    'user_phone' => $aData['user_phone'],
                    'status'      => $aData['status'],
                    'status_prev' => $aData['status_prev'],
                    'publicated'  => $sNOW,
                    'publicated_order' => $sNOW,
                    'publicated_to'    => $sPublicateTo,
                    'moderated'        => 0,
                    'company_id'       => $aData['company_id'],
                ), 'd');

                if ( ! $nItemID) {
                    $this->errors->set( _t('auto', 'Не удалось опубликовать объявление, возникла системная ошибка, сообщите администрации.') );
                    break;
                } else {
                    $this->initImages()->renameImageFileCustom($nItemID, $aData['filename']);
                    $this->security->userCounter('auto', 1, (User::id() > 0 ? false : $nUserID) );
                    $aResponse['status']  = 2; # объявление обновлено в базе
                    if ( $aData['status'] == self::STATUS_PUBLICATED && ! static::premoderation()) {
                        $this->itemsCounterUpdate($nCatID, $aData['mark_id'], $aData['model_id'], true);
                    }
                }
                $aResponse['id'] = $nItemID;
                
                if ($nUserStatus == 'new') {
                    Request::deleteCOOKIE('c2');
                }

            } while(false);

            $this->ajaxResponseForm($aResponse);
        }
        
        # категории
        $aData['cats'] = $this->categoriesGet(true, array('C.id','CL.title','C.numlevel','(C.numright - C.numleft) as node'), false, false);
        $nCatID = 0;
        foreach ($aData['cats'] as $v) {
            if ( ($v['node']) == 1 ) {
                $nCatID = $v['id']; // получаем первую категорию, без вложенности
                break;
            }
        } reset($aData['cats']);
        $aData['cat_id'] = $nCatID;

        # марки / модели
        $aData['marks']  = $this->getMarksOptions($nCatID, 0, _t('', 'Выбрать'));
        $aData['models'] = '<option value="0">'._t('auto', 'Выберите марку').'</option>';
        
        # валюты
        $aData['curr'] = Site::currencyOptions($aData['price_curr'], false);
        # dp
        $aData['dp'] = $this->dpForm($nCatID, false, array());
        
        $aData['hash'] = $this->security->getToken();
        $aData['user_type'] = Items::USERTYPE_MEMBER;
        if (User::id()) {
            $aData['agentCompanies'] = Users::model()->agentCompanies(User::id());
        } else {
            $aData['agentCompanies'] = array();
        }

        # SEO: Добавление объявления
        $this->urlCorrection(static::url('add'));
        $this->seo()->canonicalUrl(static::url('add', array(), true));
        $this->setMeta('add', array('region' => Geo::filter('title')), $aData);

        bff::showInstruction('auto_add');
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'add');
    }

    /**
     * Редактирование объявления
     * @param getpost::integer ID объявления
     */
    public function edit()
    {
        $isAjax = Request::isAJAX();
        
        bff::setActiveMenu('//auto/search', true);

        $nUserID = User::id();
        $nItemID = $this->input->getpost('id', TYPE_UINT);
        if ( ! $nItemID) {
            if ($isAjax) $this->ajaxResponse(Errors::IMPOSSIBLE);
            $this->errors->error404();
        }
        
        $aData = $this->db->one_array('SELECT I.*, CL.title as cat1_title, CL2.title as cat0_title
                              FROM '.TABLE_AUTO_ITEMS.' I,
                                   '.TABLE_AUTO_CATEGORIES.' C
                                        LEFT JOIN '.TABLE_AUTO_CATEGORIES.' C2
                                            LEFT JOIN '.TABLE_AUTO_CATEGORIES_LANG.' CL2 ON '.$this->db->langAnd(false, 'C2', 'CL2').'
                                        ON C.pid = C2.id
                                   , '.TABLE_AUTO_CATEGORIES_LANG.' CL
                              WHERE I.id = '.$nItemID.' AND I.cat_id = C.id '.$this->db->langAnd(true, 'C', 'CL'));
 
        if (empty($aData) || $aData['status'] == self::STATUS_NEW) {
            if ($isAjax) $this->ajaxResponse(Errors::IMPOSSIBLE);
            $this->errors->error404();
        }

        if ( ! User::isCurrent($aData['user_id']) ) {
            if ($isAjax) $this->ajaxResponse(Errors::ACCESSDENIED);
            return $this->showForbidden(_t('', 'Редактирование объявления') , _t('', 'Вы не являетесь владельцем данного объявления'));
        }

        if ($aData['status'] == self::STATUS_BLOCKED && !$aData['moderated']) {
            if (Request::isAJAX()) $this->ajaxResponse(Errors::ACCESSDENIED);
            if ( ! empty($_GET['success'])) {
                $this->redirect( Users::url('my.profile.tab', array('tab'=>'adv','subtab'=>'auto')) );
            }
            return $this->showForbidden(_t('', 'Объявление заблокировано'), _t('', 'Причина:').'<br/><b>'.nl2br($aData['blocked_reason']).'</b>
                <br/> <span class="red">'._t('', 'Объявление ожидает проверки модератора').'</span>');
        }
        
        $nCatID = $aData['cat_id'];
        
        $aData['ch'] = crc32($aData['img'] . $aData['info']);
        
        if (Request::isAJAX())
        {
            $this->input->postm(array(
                'mark_id'      => TYPE_UINT, // марка
                'model_id'     => TYPE_UINT, // модель
                'price'        => TYPE_PRICE, // цена
                'price_params' => TYPE_ARRAY_UINT, // цена: параметры; торг...
                'price_curr'   => TYPE_UINT, // цена: валюта
                'city_id'      => TYPE_UINT, // город
                'filename'     => TYPE_ARRAY_NOTAGS, // фотографии
                'info'         => array(TYPE_NOTAGS, 'len'=>10000), // доп. информация
                'user_name'    => array(TYPE_NOTAGS, 'len'=>100), // user: имя
                'user_phone'   => array(TYPE_NOTAGS, 'len'=>100), // user: телефон
                'user_email'   => array(TYPE_NOTAGS, 'len'=>100), // user: email
                'ch'           => TYPE_STR,    // crc данных, для проверки изменений
                'company_id'   => TYPE_UINT, //Объявление кампании
                'user_type'    => TYPE_UINT,   //частное лицо/организация
            ), $p); extract($p, EXTR_REFS);
            
            do {
                
                if ( ! $mark_id) {
                    $this->errors->set( _t('auto', 'Укажите марку') );
                }
                if ( ! $model_id) {
                    $this->errors->set( _t('auto', 'Укажите модель') );
                }
                if ( ! $price) {
                    $this->errors->set( _t('auto', 'Укажите цену'), 'price' );
                }
                if ( ! $price_curr) {
                    $this->errors->set( _t('auto', 'Укажите валюту') );
                }
                if ( ! Geo::cityIsValid($city_id) ) {
                    $this->errors->set( _t('auto', 'Укажите ваш город') );
                }
                if (empty($user_name)) {
                    $this->errors->set( _t('auto', 'Укажите ваше имя'), 'user_name' );
                }
                if (empty($user_phone)) {
                    $this->errors->set( _t('auto', 'Укажите ваше телефон'), 'user_phone' );
                }
                
                if ( ! $this->security->validateToken()) {
                    $this->errors->reloadPage();
                }

                if ( ! $this->errors->no()) break;

                # проверим company_id
                if ($nUserID && $user_type == 2 && $company_id > 0) {
                    $aComp = Users::model()->companyInfo($nUserID, $company_id);
                    if (empty($aComp)) {
                        $company_id = 0;
                    }
                } else {
                    $company_id = 0;
                }

                $sqlUpdate = array(
                    'cat_id'  => $nCatID, // для сохранения дин. свойств
                    'mark_id'  => $mark_id,
                    'model_id' => $model_id,
                    'city_id'  => $city_id,
                    'info'   => $info,
                    'price'        => $price,
                    'price_params' => $price_params,
                    'price_curr'   => $price_curr,
                    'filename'   => $filename,
                    'user_name'  => $user_name,
                    'user_email' => $user_email,
                    'user_phone' => $user_phone,
                    'company_id' => $company_id,
                );

                # сверяем с даннными до редактирования, если есть изменения
                # отправляем на модерацию
                if (crc32(join(',',$filename) . $info) != $aData['ch']) {
                    if ($aData['moderated']) {
                        $sqlUpdate['moderated'] = 2;
                    }
                }

                // обновляем объявление
                $this->model->itemSave($nItemID, $sqlUpdate, 'd');
            
            } while(false);

            $this->ajaxResponseForm();
        }

        $aData['curr'] = Site::currencyOptions($aData['price_curr'], false);

        $aData['marks'] = $this->getMarksOptions($nCatID, $aData['mark_id'], false);
        $aData['models'] = $this->getModelsOptions($aData['mark_id'], $aData['model_id'], false);

        $aData['dp'] = $this->dpForm($nCatID, false, $aData);
        $aData = HTML::escape($aData, 'html', array('user_name', 'user_phone', 'user_email'));

        $aData['hash'] = $this->security->getToken();
        if ($nUserID) {
            $aData['agentCompanies'] = Users::model()->agentCompanies($nUserID);
        }
        $aData['user_type'] = $aData['company_id'] > 0 ? 2 : 1;

        bff::showInstruction('auto_edit');
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'edit');
    }
    
    /**
     * Список избранных объявлений пользователя
     */
    public function fav()
    {
        bff::setActiveMenu('//auto/fav');
        bff::setMeta(_t('','Избранные объявления'));
        if ( ! ($userID = User::id())) {
            return $this->showForbidden(_t('','Избранные объявления'), _t('','Возможность добавлять объявления в избранные доступна только после авторизации.'), true);
        }
        
        $aData['items'] = $this->db->select('SELECT I.id, I.link, I.imgfav, I.title, I.descshort, I.price, I.price_curr, I.price_params as pricep
            FROM '.TABLE_AUTO_ITEMS.' I, '.TABLE_AUTO_FAV.' F
            WHERE F.user_id = '.$userID.' AND F.item_id = I.id
                AND I.status = '.self::STATUS_PUBLICATED.'
        ');

        $this->security->userCounterCheck('auto_fav', sizeof($aData['items']));
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'fav');
    }
    
    /**
     * Список объявлений пользователя
     */
    public function profile()
    {
        if ( ! ($userID = User::id()))
            return '';

        $nPerpage = config::sys('auto.profile.perpage', 10);
        $nTotal = $this->model->itemsListProfile($userID, true);
        $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 3, Users::url('my.profile.tab', array('tab'=>'adv','subtab'=>'auto')).'&page={page}', $sqlLimit);

        $aData['items'] = $this->model->itemsListProfile($userID, false, $sqlLimit);
        if (!empty($aData['items'])) {
            foreach ($aData['items'] as &$v) {
                $v['url'] = static::url('view', $v['link']);
                $v['img'] = AutoImages::url($v['id'], $v['imgfav'], AutoImages::szList);
            } unset($v);
        }

        $this->security->userCounterCheck('auto', $nTotal);
        bff::setMeta(_t('', 'Мои объявления - Кабинет'));
        $this->initRightblock(__FUNCTION__);
        return $this->viewPHP($aData, 'profile');
    }

    /**
     * Список объявлений компании (Авто)
     * @param integer $nCompanyID ID компании
     * @param array $aData @ref данные о компании
     */
    public function company_items($companyID = 0, array &$companyData)
    {
        $perpage = config::sys('auto.company.perpage', 10);
        $total = $this->model->itemsListCompany($companyID, true);
        $sqlLimit = '';
        $data['pgn'] = $this->generatePagenationDots($total, $perpage, 3,
            Items::url('view', array('link'=>$companyData['link'], 'tab'=>'board', 'q'=>$companyData['st'].'&page={page}')),
            $sqlLimit);

        $data['items'] = $this->model->itemsListCompany($companyID, false, $sqlLimit);
        if (!empty($data['items'])) {
            foreach ($data['items'] as &$v) {
                $v['url'] = static::url('view', $v['link']);
                $v['img'] = AutoImages::url($v['id'], $v['imgfav'], AutoImages::szList);
            } unset($v);
        }
        return $this->viewPHP($data, 'company');
    }

    /**
     * Странице успешной активации услуги
     */
    public function promote()
    {
        if( ! bff::servicesEnabled()) return false;
        $nItemID = $this->input->get('id', TYPE_UINT);
        $nSvcID = $this->input->get('svc', TYPE_UINT);

        $aSvc = $this->svc()->model->svcData($nSvcID);
        if ($nItemID && ! empty($aSvc) && $aSvc['module'] == $this->module_name)
        {
            $this->seo()->robotsIndex(false);
            bff::setMeta(_t('svc', 'Активация услуги'));
            bff::setActiveMenu('//auto/search', true);
            $aItem = $this->model->itemData($nItemID, array('id','title', 'link'));
            if ( empty($aItem) ) {
                $this->errors->error404();
            }
            $this->initRightblock(__FUNCTION__);
            return $this->showSuccess(
                _t('svc', 'Активация услуги'),
                _t('auto', 'Для вашего объявления "[item_link]"<br />была успешно активирована услуга "[svc_title]"', array(
                    'item_link'=>'<a href="'.static::url('view', $aItem['link']).'">'.$aItem['title'].'</a>',
                    'svc_title'=>$aSvc['title']))
            );
        } else {
            $this->redirect( static::url('index') );
        }
    }

    /**
     * Список "Автосалонов"
     */
    public function salons()
    {
        $categoryID = static::salonsCategory();
        $sql = 'I.id = C.item_id AND C.category_id = '.$categoryID.' AND I.id = IA.item_id AND I.enabled = 1 AND I.moderated = 1';
        if ( $this->regionsFilterEnabled() ) $sql .= ' AND IA.city_id = '.Geo::cityID();

        $nPerpage = config::sys('auto.salons.perpage', 10);
        $nTotal = $this->db->one_data('SELECT COUNT(I.id)
            FROM '.TABLE_ITEMS.' I,
                 '.TABLE_ITEMS_ADDR.' IA,
                 '.TABLE_ITEMS_IN_CATEGORIES.' C WHERE '.$sql);
        $aData['pgn'] = $this->generatePagenationDots($nTotal, $nPerpage, 2, static::url('salons').'?page={page}', $sqlLimit);
        $nPage = $this->input->get('page', TYPE_UINT); if (!$nPage) $nPage = 1;

        $aData['items'] = $this->db->select('
                SELECT I.id, I.link, IL.title, IL.descshort as description,
                       IA.address, IA.phonesq as phones, IA.site,
                       I.img_list as img, I.imgcnt
                FROM '.TABLE_ITEMS.' I,
                     '.TABLE_ITEMS_ADDR.' IA,
                     '.TABLE_ITEMS_LANG.' IL,
                     '.TABLE_ITEMS_IN_CATEGORIES.' C
                WHERE '.$sql.$this->db->langAnd(true, 'I', 'IL').'
                GROUP BY I.id 
                ORDER BY I.vip DESC, C.num_order
                '.$sqlLimit);
        
        if ( ! empty($aData['items']))
        {
            foreach ($aData['items'] as &$v)
            {
                if ( ! empty($v['phones'])) {
                    $v['phones'] = join('<br/>', explode(', ', $v['phones']));
                }
                $v['link'] = Items::url('view', $v['link']);
            } unset($v);
        } else {
            $aData['items'] = array();
        }

        # SEO: Автосалоны
        $this->urlCorrection(static::url('salons'));
        $this->seo()->canonicalUrl(static::url('salons', array(), true), array(
            'page' => $nPage
        ));
        $this->setMeta('salons', array(
            'region' => Geo::filter('title'),
            'page'   => $nPage
        ), $aData);

        $this->initRightblock(__FUNCTION__);
        bff::setActiveMenu('//auto/salons');
        return $this->viewPHP($aData, 'salons');
    }
    
    public function ajax()
    {
        $nUserID = User::id();
        $aResponse = array();
        switch ($this->input->get('act'))
        {
            case 'cat-data': # данные о категории
            {
                $nCatID = $this->input->post('cat', TYPE_UINT);
                $bForm = $this->input->post('form', TYPE_BOOL);
                
                # дин. свойства
                if ( ! $bForm) {
                    $aData['dp'] = $this->dpForm($nCatID, true, array(), array('f'=>array()));
                } else {
                    $aData['dp'] = $this->dpForm($nCatID, false, array());
                }
                
                # марки
                $aData['marks'] = ( $nCatID > 0 ? $this->getMarksOptions( $nCatID, 0, ($bForm ? _t('','Выбрать') : 'Все марки')) : '<option value="0">'._t('auto','Все марки').'</option>' );
                
                $this->ajaxResponse($aData);
            } break;
            case 'models-options': # выпадающий список моделей
            {
                $nMarkID = $this->input->post('mark', TYPE_UINT);
                $bForm = $this->input->post('form', TYPE_BOOL);
                $aData['models'] = ( $nMarkID > 0 ? $this->getModelsOptions( $nMarkID, 0, ($bForm ? _t('auto','Выберите модель') : _t('auto','Все модели'))) : '<option value="0">'._t('auto','Все модели').'</option>' );
                $this->ajaxResponse($aData);
            } break;
            case 'fav': # добавления/удаление из избранных
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID || ! User::id()) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                if ( ! $this->security->validateToken()) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $bAdded = false;
                $bExists = $this->db->one_data('SELECT item_id FROM '.TABLE_AUTO_FAV.'
                            WHERE user_id = :user_id AND item_id = :item_id
                            LIMIT 1', array(':user_id'=>User::id(), ':item_id'=>$nItemID));
                if (empty($bExists)) {
                    $res = $this->db->insert(TABLE_AUTO_FAV, array('user_id'=>User::id(), 'item_id'=>$nItemID), false);
                    if (empty($res)) {
                        $this->ajaxResponse(Errors::IMPOSSIBLE);
                    }
                    $bAdded = true;
                } else {
                    $this->db->delete(TABLE_AUTO_FAV, array('user_id'=>User::id(), 'item_id'=>$nItemID));
                }
                
                $nCurrent = $this->security->userCounter('auto_fav', ($bAdded ? 1 : -1) );
                
                $this->ajaxResponse(array('res'=>$this->errors->no(), 'added'=>$bAdded, 'n'=>$nCurrent));

            } break;
            case 'item-img-upload': # загрузка изображения
            {
                $nItemID = $this->input->postget('id', TYPE_UINT);
                do{
                    if ($nItemID > 0)
                    {
                        $aData = $this->db->one_array('SELECT user_id, img, imgcnt, status, moderated FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID);
                        if (empty($aData)) {
                            $this->errors->set(_t('','Редактируемое объявление не найдено'));
                            break;
                        }

                        if ($aData['status'] == self::STATUS_BLOCKED && $aData['moderated']==0) {
                            $this->errors->set(_t('','Объявление ожидает проверки модератора'));
                            break;
                        }

                        // автор объявления = загеристрированный пользователь
                        if ( ! $nUserID // незарегистрированный пытается добавить фото к чужому объявлению
                            || ($nUserID > 0 && $aData['user_id'] != $nUserID) // текущий зарегистрированный пользователь не является владельцем объявления
                        ) {
                            $this->errors->set(_t('','Вы не является владельцем данного объявления'));
                            break;
                        }
                    } else {
                        // грузить новые фотографии(без привязки к объявлению) можно с ограничениями QQ uploadera
                    }

                    if ( ! $this->security->validateReferer() ) {
                        $this->errors->set(_t('','Ошибка загрузки фотографии'));
                        break;
                    }

                    $oImages = $this->initImages();
                    $aResult = $oImages->uploadImageQQ();
                    $aResponse['success'] = ($aResult !== false && $this->errors->no());
                    $aResponse['filename'] = $oImages->saveImageFileCustom($nItemID, $aResult);

                }while(false);

                $aResponse['errors'] = $this->errors->get(true);
                $this->ajaxResponse($aResponse, true, false, true);

            } break;
            case 'item-img-delete': # удаление изображения
            {
                $nItemID = $this->input->post('id', TYPE_UINT); 
                
                if ($nItemID > 0)
                {
                    $aData = $this->db->one_array('SELECT user_id, img, imgcnt, status, moderated FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID);
                    if (empty($aData)) {
                        $aFailResponse['error'] = _t('','Редактируемое объявление не найдено');
                        $this->ajaxResponse( $aFailResponse );
                    }
                    
                    if ($aData['status'] == self::STATUS_BLOCKED && $aData['moderated']==0) {
                        $aFailResponse['error'] = _t('','Объявление ожидает проверки модератора');
                        $this->ajaxResponse( $aFailResponse );
                    }
                    
                    # автор объявления = загеристрированный пользователь
                    if ( ! $nUserID # незарегистрированный пытается удалить фото чужого объявлению
                    || ($nUserID > 0 && $aData['user_id'] != $nUserID) # текущий зарегистророванный пользователь не является владельцем объявления
                      ) {
                        $aFailResponse['error'] = _t('','Вы не является владельцем данного объявления.');
                        $this->ajaxResponse( $aFailResponse );
                    } 
                } else {
                    # удалять фотографии(без привязки к объявлению) можно без ограничений
                }
                
                $aFilename = $this->input->post('filename', TYPE_ARRAY_NOTAGS);
                if (empty($aFilename)) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $oImages = $this->initImages();
                foreach ($aFilename as $file) {
                    $oImages->deleteImageFileCustom($nItemID, $file);
                }
                
                $this->ajaxResponse(Errors::SUCCESS);
            } break;
            case 'item-del': # удаление ОБ
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                if ( ! $nItemID || ! User::id()) $this->ajaxResponse(Errors::IMPOSSIBLE);
                
                if ( ! $this->security->validateToken()) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }

                $res = $this->deleteItem($nItemID, User::id());
                $this->ajaxResponse( ($res ? Errors::SUCCESS : Errors::IMPOSSIBLE) );
                
            } break;
            case 'item-publicate2': # продление публикации ОБ
            {
                $nItemID = $this->input->post('id', TYPE_UINT);
                $nPeriod = $this->input->post('period', TYPE_UINT);
                
                if ( ! $nItemID || ! User::id() || empty($nPeriod)) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                if ( ! $this->security->validateToken()) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $aData = $this->db->one_array('SELECT id, user_id, status, moderated, publicated, publicated_to, cat_id, mark_id, model_id
                        FROM '.TABLE_AUTO_ITEMS.' WHERE id = '.$nItemID.' AND status != '.self::STATUS_NEW);
                if (empty($aData)) break;
                
                if (!User::isCurrent($aData['user_id'])) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                 
                if ($aData['status'] == self::STATUS_BLOCKED) {
                    if ($aData['moderated'] == 0) {
                        $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление ожидает проверки') );
                    } else {
                        $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление отклонено') );
                    }
                    break;
                } else if ($aData['status'] == self::STATUS_PUBLICATED) {
                    $this->errors->set( _t('auto', 'Невозможно продлить публикацию, поскольку объявление опубликовано') );
                    break;
                } else if ($aData['status'] != self::STATUS_PUBLICATED_OUT) {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
            
                $publicateTo = $this->preparePublicatePeriodTo( $nPeriod, time() );
                if (empty($publicateTo)) {
                    $this->errors->set( _t('auto', 'Период публикации указан не корректно') );
                    break;
                }
            
                $toOld = strtotime( $aData['publicated_to'] );
                /* если разница между датой снятия с публикации и текущей датой
                 * более 3 дней, тогда поднимаем объявление вверх.
                 * в противном случае: оставлем дату старта публикации(pulicated) и дату порядка публикации(publicated_order) прежними
                 */
                $bUpdatePublicatedOrder = ((time() - $toOld) > 259200); //60*60*24*3
                $sqlNOW = $this->db->getNOW();
                $res = $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                    SET publicated_to = '.$this->db->str2sql( $publicateTo ).',
                        '.($bUpdatePublicatedOrder ? ' publicated = '.$sqlNOW.', publicated_order = '.$sqlNOW.',' : '').'
                        status_prev = status,
                        status = '.self::STATUS_PUBLICATED.'
                    WHERE id = '.$nItemID.'
                ');
                
                if ( ! empty($res)) {
                    # накручиваем счетчики кол-ва опубликованных объявлений:
                    # в категории и типе категории:
                    $this->itemsCounterUpdate($aData['cat_id'], $aData['mark_id'], $aData['model_id'], true);
                    $this->ajaxResponse(Errors::SUCCESS);
                } else {
                    $this->ajaxResponse(Errors::IMPOSSIBLE);
                }
                
                $this->ajaxResponse(NULL);
            } break;
            case 'item-claim': # обработка жалобы на ОБ
            {
                $p = $this->input->postm(array(
                    'id'      => TYPE_UINT,
                    'reasons' => TYPE_ARRAY_UINT,  
                    'comment' => TYPE_NOTAGS,
                    'captcha' => TYPE_STR,
                ));

                do{
                    if ( ! $p['id']) { $this->errors->impossible(); break; }
                    if (empty($p['reasons']) && $p['comment'] == '') { $this->errors->set( _t('auto', 'Укажите причину и/или описание') ); break; }
                    
                    if ( ! $nUserID) {
                        if ( ! $this->security->validateReferer()) {
                            $this->errors->impossible();
                            break;
                        }
                        $oProtection = new CCaptchaProtection();
                        if ( !$oProtection->valid($this->input->cookie('c2'), $p['captcha']) ) {
                            $aResponse['captcha'] = 1;
                            $this->errors->set( _t('', 'Результат с картинки указан некорректно'), 'captcha' );
                            break;
                        }
                    } else {
                        if ( ! $this->security->validateToken()) {
                            $this->errors->impossible();
                            break;
                        }
                        // получаем дату последней добавленной пользователем жалобы
                        $sLastClaim = $this->db->one_data('SELECT created FROM '.TABLE_AUTO_CLAIMS.' WHERE user_id = '.$nUserID.' ORDER BY created DESC LIMIT 1');
                        if ( ! empty($sLastClaim)) {
                            $nMinutesTimeout = 3;
                            if ( (time() - strtotime($sLastClaim)) < $nMinutesTimeout * 60 )
                            {
                                $this->errors->set( _t('auto', 'Повторите попытку через 3 минуты') );
                                break;
                            }
                        }
                    }
                    
                    $nReasons = array_sum($p['reasons']);
                    $res = $this->db->insert(TABLE_AUTO_CLAIMS, array(
                        'item_id' => $p['id'],
                        'user_id' => $nUserID,
                        'comment' => $p['comment'],
                        'reasons' => $nReasons,
                        'ip' => Request::remoteAddress(),
                        'created' => $this->db->now(),
                    ));

                    if ($res) {
                        if ( ! $nUserID) Request::deleteCOOKIE('c2');
                        config::saveCount('auto_claims', 1, true);
                    }

                } while(false);

                $aResponse['res'] = $this->errors->no();
                $this->ajaxResponse($aResponse);
            } break;
            case 'item-promote': # продвижение ОБ
            {
                do
                {
                    $nItemID = $this->input->post('id', TYPE_UINT); # ID Объявления
                    $nSvcID = $this->input->post('svc', TYPE_UINT); # ID Услуги Auto::SERVICE_
                    $sPaySystem = $this->input->post('ps', TYPE_NOTAGS); # Ключ способа оплаты
                    if (empty($sPaySystem)) $sPaySystem = Bills::PS_BALANCE;

                    if ( ! $nItemID || ! $nSvcID || ! $nUserID || ! $this->security->validateToken()) {
                        $this->errors->reloadPage();
                        break;
                    }

                    $aItem = $this->model->itemData($nItemID, array('id','user_id','status'));
                    if (empty($aItem) || $aItem['status'] == self::STATUS_NEW) {
                        $this->errors->reloadPage();
                        break;
                    }
                    if ($aItem['status'] == self::STATUS_BLOCKED) {
                        $this->errors->set( _t('', 'Невозможно продвинуть заблокированное объявление') );
                        break;
                    }

                    if ( ! User::isCurrent($aItem['user_id']) ) {
                        $this->errors->reloadPage();
                        break;
                    }

                    # проверяем способ оплаты
                    $aPaySystems = Bills::getPaySystems(true);
                    if (!isset($aPaySystems[$sPaySystem]) || empty($aPaySystems[$sPaySystem]['enabled'])) {
                        $this->errors->set( _t('bills', 'Выбранный способ оплаты на текущий момент недоступен') );
                        break;
                    }
                    # получаем стоимость услуги
                    $aSvc = Svc::model()->svcData($nSvcID);
                    if (empty($aSvc)) {
                        $this->errors->reloadPage();
                        break;
                    }
                    $nSvcPrice = $aSvc['price'];

                    $aPayAmount = Bills::getPayAmount($nSvcPrice, $sPaySystem);

                    $aResponse = $this->svc()->activateOrPay($this->module_name, $nSvcID, $nItemID,
                        $aPaySystems[$sPaySystem]['id'], $aPaySystems[$sPaySystem]['way'],
                        $nSvcPrice, $aPayAmount['amount'], $aPayAmount['currency']);
                    if ($aResponse['activated']) {
                        $aResponse['redirect'] = static::url('promote', array('success'=>1, 'id'=>$nItemID, 'svc'=>$nSvcID));
                    }

                } while(false);

                $this->ajaxResponseForm($aResponse);
            } break;
            case 'item-promote-data': # данные о текущих активированных услугах ОБ
            {
                do
                {
                    $nItemID = $this->input->post('item_id', TYPE_UINT);

                    if ( ! $nItemID || ! $nUserID) {
                        $this->errors->reloadPage();
                        break;
                    }

                    $aItem = $this->model->itemData($nItemID, array('id','user_id','status',
                             'svc', 'marked_to', 'fixed_to', 'vip_to'));
                    if ( empty($aItem)
                        || $aItem['status'] == self::STATUS_NEW
                        || $aItem['status'] == self::STATUS_BLOCKED
                        || ! User::isCurrent($aItem['user_id'])
                        || ! $this->security->validateReferer() ) {
                        $this->errors->reloadPage();
                        break;
                    }
                    $aResponse['marked'] = ($aItem['svc'] & self::SERVICE_MARK);
                    $aResponse['marked_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['marked_to'], false)));
                    $aResponse['fixed'] = ($aItem['svc'] & self::SERVICE_FIX);
                    $aResponse['fixed_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['fixed_to'], false)));
                    $aResponse['vip'] = ($aItem['svc'] & self::SERVICE_VIP);
                    $aResponse['vip_to'] = _t('svc', 'Услуга уже активирована до <b>[date]</b>', array('date'=>tpl::date_format2($aItem['vip_to'], false)));
                } while(false);

                $this->ajaxResponseForm($aResponse);
            } break;
        }         
        $this->ajaxResponse( Errors::IMPOSSIBLE ); 
    }

    /**
     * Формируем правый блок
     * @param string $sPage ключ страницы, на которой формируем
     * @param array $aData доп. данные
     */
    protected function initRightblock($sPage, array $aData = array())
    {
        $bAfterBanner = false;

        switch ($sPage)
        {
            case 'index':
            case 'search':
            {

            } break;
        }
        bff::setRightblock($this->viewPHP($aData, 'common.rightblock'), $bAfterBanner);
    }

    /**
     * Формируем VIP блок
     * @param int $nCatID ID категории
     * @param int $nMarkID ID марки
     * @param int $nModelID ID модели
     * @return string
     */
    protected function vipBlock($nCatID = 0, $nMarkID = 0, $nModelID = 0)
    {
        $aData['items'] = $this->model->itemsListVIP($nCatID, $nMarkID, $nModelID);
        if ( ! empty($aData['items']) ) {
            $oImages = $this->initImages();
            foreach ($aData['items'] as $k=>$v) {
                $aData['items'][$k]['img'] = $oImages->getUrl($v['id'], $v['imgfav'], AutoImages::szThumbnail);
            }
        }
        return $this->viewPHP($aData, 'vip.block');
    }

    /**
     * Cron задачи модуля
     * Рекомендуемая периодичность: раз в час
     */
    public function cron()
    {
        if ( ! bff::cron()) return;


        # снимаем с публикации объявления, у которых закончился срок публикации
        $this->db->exec('UPDATE '.TABLE_AUTO_ITEMS.'
                         SET status_prev = status, status = :status_new
                         WHERE status = :status_prev AND publicated_to <= :now', array(
                            ':status_new' => self::STATUS_PUBLICATED_OUT,
                            ':status_prev' => self::STATUS_PUBLICATED,
                            ':now' => $this->db->now(),
                       ));

        # формируем YandexXML
        $this->yandexXML();

        # Выполняем пересчет счетчиков:
        # Типы
        $this->db->exec('UPDATE '.TABLE_AUTO_CATEGORIES.' C
               LEFT JOIN (SELECT I.cat_id as id, COUNT(I.id) as items
                            FROM '.TABLE_AUTO_ITEMS.' I, '.TABLE_USERS.' U
                            WHERE I.status = :status AND I.user_id = U.user_id AND U.blocked = 0
                                  '.(static::premoderation() ? ' AND I.moderated > 0' : '').'
                            GROUP BY I.cat_id) as X ON C.id = X.id
                SET C.items = IF(X.id IS NOT NULL, X.items, 0)
        ', array(':status'=>self::STATUS_PUBLICATED));
        
        # Марки
        $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' M
               LEFT JOIN (SELECT I.mark_id as id, COUNT(I.id) as items
                            FROM '.TABLE_AUTO_ITEMS.' I, '.TABLE_USERS.' U
                            WHERE I.status = :status AND I.user_id = U.user_id AND U.blocked = 0
                                 '.(static::premoderation() ? ' AND I.moderated > 0' : '').'
                            GROUP BY I.mark_id) as X ON M.id = X.id
                SET M.items = IF(X.id IS NOT NULL, X.items, 0)
            WHERE M.pid = 0
        ', array(':status'=>self::STATUS_PUBLICATED));

        # Модели
        $this->db->exec('UPDATE '.TABLE_AUTO_MARKSMODELS.' M
               LEFT JOIN (SELECT I.model_id as id, COUNT(I.id) as items
                            FROM '.TABLE_AUTO_ITEMS.' I, '.TABLE_USERS.' U
                            WHERE I.status = :status AND I.user_id = U.user_id AND U.blocked = 0
                                  '.(static::premoderation() ? ' AND I.moderated > 0' : '').'
                            GROUP BY I.model_id) as X ON M.id = X.id
                SET M.items = IF(X.id IS NOT NULL, X.items, 0)
            WHERE M.pid != 0
        ', array(':status'=>self::STATUS_PUBLICATED));
    }
}