<?php
    /**
     * @var $this Afisha
     * @var $type AfishaSettings
     */
    tpl::includeJS('datepicker', true);
    tpl::includeJS('autocomplete', true);
    $bCategories = $type->categoriesEnabled();
    $bModeration = $type->moderationEnabled();
?>
<?= tplAdmin::blockStart($type->title.' / Список событий', true, array(), array(
    'title' => '+ добавить событие', 'href'=> $this->adminLink($type->keyword.':add')
)) ?>
<? if($bModeration) { ?>
        <div class="tabsBar" id="afisha-mod-tabs">
            <span class="tab <? if( ! $f['mod']) { ?>tab-active<? } ?>"><a href="#" onclick="return afishaItems.onMod(0, this);">Опубликованные</a></span>
            <span class="tab <? if($f['mod']) { ?>tab-active<? } ?>"><a href="#" onclick="return afishaItems.onMod(1, this);">На модерацию</a></span>
        </div>
    <? } ?>

    <form action="" method="get" name="filters" id="afisha-items-filters" onsubmit="return false;">
    <input type="hidden" name="page" value="<?= $f['page'] ?>" />
    <input type="hidden" name="order" value="<?= $f['order'] ?>" />
    <input type="hidden" name="mod" value="<?= $f['mod'] ?>" />
    <div class="actionBar">
        <div class="left" style="margin-right: 8px;">
            <input type="text" style="width:50px;" name="id" placeholder="<?= _t('', 'ID') ?>" value="<?= $f['id'] ? $f['id'] : '' ?>" />
        </div>
        <div class="left relative" style="margin-right: 8px;">
            <? if( ! Geo::cityIsOne()) { ?>
                 <select name="city" onchange="afishaItems.update();" style="width: 150px;"><?= Geo::cityOptions($f['city'], _t('','Все города')) ?></select>
            <? } ?>
            <? if($bCategories){ ?><select name="category" style="width:150px;" onchange="afishaItems.onCategory(this.value);"><?= $this->categoriesGet($type, false, array('sel'=>$f['category'], 'empty'=>'Все разделы')); ?></select><? } ?>
            <? if($type->tagsEnabled()) { ?>
            <span class="relative">
                 <input type="hidden" name="tag" id="afisha-items-tag-id" value="<?= $f['tag'] ?>" />
                 <input type="text" class="autocomplete tag_title" id="afisha-items-tag-title" style="width: 140px;" placeholder="тег" value="<?= ($f['tag']>0 ? $tag['tag'] : '') ?>" />
            </span>
            <? } ?>
        </div>
        <div class="left relative" style="margin-right: 8px;">
            <input type="hidden" name="user" id="afisha-items-user-id" value="<?= $f['user'] ?>" />
            <input type="text" class="autocomplete" id="afisha-items-user-title" style="width: 200px;" placeholder="<?= _t('', 'ID / login / email пользователя') ?>" value="<?= ($f['user']>0 ? $user_title : '') ?>" />
        </div>
        <div class="left" style="margin-right: 8px;">
            <span class="bold hidden" style="margin-right: 8px;">Период:&nbsp;
                <input type="text" name="p_from" value="<?= $f['p_from'] ?>" placeholder="от" style="width: 60px;" id="afisha-items-period-from" />  - <input type="text" name="p_to" value="<?= $f['p_to'] ?>" placeholder="до" style="width: 60px;" id="afisha-items-period-to" />
            </span>
        </div>
        <div class="left">
            <input type="button" class="btn btn-small button submit" onclick="afishaItems.submit(true);" value="найти" />
        </div>
        <div class="right">
            <div class="progress" style="display:none;" id="progress-afisha-items"></div>
        </div>
        <div class="clear"></div>
    </div>
    </form>

    <table class="table table-condensed table-hover admtbl tblhover">
        <thead>
            <tr class="header">
                <th width="40">ID</th>
                <th class="left" style="padding-left: 18px;">Заголовок</th>
                <th width="137">
                    <a href="javascript: afishaItems.onOrder('created');" class="ajax">Создано</a>
                    <div class="order-<?= $f['order_dir'] ?>" <? if($f['order_by']!='created') { ?>style="display:none;"<? } ?> id="afisha-order-created"></div>
                </th>
                <th width="110">Действие</th>
            </tr>
        </thead>
            <tbody id="afisha-items-list">
        <?= $list ?>
        </tbody>
    </table>
    <div id="afisha-items-pgn"><?= $pgn; ?></div>
<?= tplAdmin::blockStop(); ?>

<script type="text/javascript">
var afishaItems = (function()
{
    var $progress, $list, $listPgn, filters;
    var url = '<?= $this->adminLink($type->keyword.':listing'); ?>';
    var urlAjax = '<?= $this->adminLink('ajax').'&type='.$this->type->id.'&act='; ?>';
    var orders = <?= func::php2js($orders) ?>;
    var orderby = '<?= $f['order_by'] ?>';
    var is_mod = <?= ($f['mod']?1:0) ?>;
    var _processing = false; 
    
    $(function(){
        $progress = $('#progress-afisha-items');
        $list     = $('#afisha-items-list');
        $listPgn  = $('#afisha-items-pgn');
        filters   = $('#afisha-items-filters').get(0);

        $list.on('click', 'a.item-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this );
            return false;
        });  
        
        <? if($type->tagsEnabled()) {
             tpl::includeJS('autocomplete', true);
             ?>
                $('#afisha-items-tag-title').autocomplete( url+'&act=tags-autocomplete', 
                    {valueInput: '#afisha-items-tag-id', width: 144, placeholder: 'Тег', minChars: 2,
                     onSelect: function(val, text){ setPage(1); updateList(); }});
             <?       
        } ?>

        $('#afisha-items-user-title').autocomplete( urlAjax+'item-user-autocomplete',
            {valueInput: '#afisha-items-user-id', minChars: 2, width:250,
                onSelect: function(val, text){
                    setPage(1); updateList();
                }});

        bff.datepicker('#afisha-items-period-from', {yearRange: '-3:+3'});
        bff.datepicker('#afisha-items-period-to', {yearRange: '-3:+3'});
              
    });
    
    function isProcessing()
    {
        return _processing;
    }
    
    function del(id, link)
    {
        bff.ajaxDelete('sure', id, url+'&act=delete&item_id='+id,
            link, {progress: $progress, repaint: false});
        return false;
    } 

    function updateList()
    {
        if(isProcessing()) return;
        _processing = true;
        $list.addClass('disabled');
        bff.ajax(url, $(filters).serializeArray(), function(data){
            if(data) {
                $list.html( data.list );
                $listPgn.html( data.pgn );
                
                var f = $(filters).serialize();
                if(bff.h) {
                    window.history.pushState({}, document.title, url + '&' + f);
                }
            }
            $list.removeClass('disabled');
            _processing = false;
        }, $progress);
    }
    
    function setPage(id)
    {
        filters.page.value = intval(id);
    }

    return {
        submit: function(resetPage)
        {
            if(isProcessing()) return false;
            if(resetPage === true) {
                setPage(1);
            }
            updateList();
        },
        page: function (id)
        {
            if(isProcessing()) return false;
            setPage(id);
            updateList();
        }, 
        onCategory: function(id)
        {
            if(isProcessing()) return false;
            filters.category.value = id;
            setPage(1);
            updateList();
            return false;
        }, 
        onOrder: function(by)
        {
            if(isProcessing() || !orders[by])
                return;
                
            orders[by] = (orders[by] == 'asc' ? 'desc' : 'asc');
            //hide prev order direction
            $('#afisha-order-'+orderby).hide();
            //show current order direction
            orderby = by;
            $('#afisha-order-'+orderby).removeClass('order-asc order-desc').addClass('order-'+orders[by]).show();
                
            filters.order.value = orderby+'-'+orders[by];
            setPage(1);
            
            updateList();
        }, 
        onMod: function(state, link) 
        {
            if(isProcessing() || is_mod == state) return false;
            is_mod = state;
            setPage(1);
            filters.mod.value = state;
            updateList();
            bff.onTab(link);
            return false;
        }, 
        toggle: function(id, $link)
        {
            bff.ajaxToggle(id, url+'&act=toggle&item_id='+id, {progress: $progress, link:$link});
            return false;
        },
        update: updateList
    };
}());
</script>