<?php
/**
 * @var $this Afisha
 * @var $type integer
 */
 tpl::includeJS('tablednd', true);
?>
<?= tplAdmin::blockStart('Добавить раздел', false, array('id'=>'afishaCatFormBlock', 'style'=>'display:none;')); ?>
<div class="tabsBar" id="afisha-cats-tabs" <?= (!empty($inherits) ? 'style="display:none;"' : '') ?>>
    <span class="tab tab-active" onclick="afishaCategories.onTab('new', this);" rel="new"><a href="#" onclick="return false;">Создать новый</a></span>
    <span class="tab" onclick="afishaCategories.onTab('inherit', this);" rel="inherit"><a class="but but-text chain">Прикрепить существующий</a></span>
</div>
<div id="afisha-cats-tabs-new">
    <form action="" method="post" name="afishaCatFormNew">
        <?= $form ?>
    </form>
</div>
<?if($inherits):?>
<div id="afisha-cats-tabs-inherit" style="display:none;">
    <form action="" method="post" name="afishaCatFormInherit">
        <input type="hidden" name="act" value="inherit-finish" />
        <input type="hidden" name="type" value="<?= $type ?>" />
        <input type="hidden" name="filter" value="<?= $filter ?>" />
        <table class="admtbl tbledit">
            <tr>
                <td style="width:100px;">Выберите раздел:</td>
                <td><select name="inherit"></select></td>
            </tr>
            <tr>
                <td>Включен:</td>
                <td><label class="checkbox"><input type="checkbox" name="enabled" checked="checked" /></label></td>
            </tr>
            <tr>
                <td colspan="2" class="row1">
                    <input type="submit" class="btn btn-success button submit" value="Сохранить" />
                    <input type="reset" class="btn button cancel" value="Отмена" onclick="afishaCategories.toggle('cancel');" />
                </td>
            </tr>
        </table>
    </form>
</div>
<? endif; ?>
<?= tplAdmin::blockStop() ?>

<?= tplAdmin::blockStart(($type ? '<a href="'.$this->adminLink($typeSettings->keyword.':listing').'">'.$typeSettings->title.'</a> / ' : '').'Список разделов', true, array(), array(
    'title' => '+ добавить раздел', 'onclick'=> 'return afishaCategories.toggle(\'add\');',
)); ?>
<div class="tabsBar">
    <span class="tab <?= ! $type ? 'tab-active' : '' ?>"><a href="#" onclick="afishaCategories.onType(0); return false;">Общие</a></span>
    <? foreach ($types as $k => $v): if(!$v->categoriesEnabled()) continue; ?>
    <span class="tab <?= $v->id == $type ? 'tab-active' : '' ?>"><a href="#" onclick="afishaCategories.onType(<?= $menu_mini ? $v->id : '\''.$v->keyword.'\'' ?>); return false;"><?= $v->title; ?></a></span>
    <? endforeach; ?>
    <div class="right"><div class="progress" style="display:none;" id="progress-afisha-cats"></div></div>
</div>

<table class="table table-condensed table-hover admtbl tblhover" id="afisha-cats-table">
<thead>
    <tr class="header nodrag nodrop">
        <th width="30">&nbsp;</th>
        <th class="left">Название</th>
        <? if($type){ ?><th width="100">Cобытий</th><? } ?>
        <th width="85">Действие</th>
    </tr>
</thead>
<? foreach ($cats as $k => $v) { $id = $v['id']; ?>
<tr class="row<?= $k%2 ?>" id="dnd-<?= $id ?>">
    <td><? if($v['inherited']): ?><a class="but chain"></a><? endif; ?></td>
    <td class="left"><?= $v['title'] ?></td>
    <? if($type){ ?><td><a href="<?= $this->adminLink($typeSettings->keyword.':listing&category='.$id) ?>"><?= $v['items'] ?></a></td><? } ?>
    <td><? if(!$v['inherited']) { ?>
        <a class="but <? if($v['enabled']){?>un<? } ?>block cat-toggle" title="Вкл/Выкл" href="#" rel="<?= $id ?>"></a>
        <a class="but edit cat-edit" title="Редактировать" href="#" rel="<?= $id ?>"></a>
        <a class="but del cat-del" title="Удалить" href="#" rel="<?= $id ?>"></a>
        <? } else { ?>
        <a class="but del <? if($v['enabled']){?>un<? } ?>block cat-toggle" title="Вкл/Выкл" href="#" rel="<?= $id ?>"></a>
        <a class="but del cat-del inherited" title="Открепить" href="#" rel="<?= $id ?>"></a>
        <? } ?>
    </td>
</tr>
<? } if (empty($cats)): ?>
<tr class="norecords">
    <td colspan="<?= ($type ? 4 : 3) ?>">нет разделов (<a href="#" class="ajax" onclick="return afishaCategories.toggle('add');">добавить</a>)</td>
</tr>
<? endif; ?>
</table>
<div style="height:15px;">
    <div class="left"></div>
    <div class="right desc" style="width:20px;">
        &darr; &uarr;
    </div> 
</div>
<?= tplAdmin::blockStop() ?>

<script type="text/javascript">
var afishaTypeID = intval(<?= $type ?>);
var afishaListURL = '<?= $this->adminLink(bff::$event.'&act='); ?>';
var afishaListFilter = '<?= $filter ?>';
var afishaCatInherits = <?= ($inherits ? 'true' : 'false') ?>;
var afishaCategories = (function(){
    var $progress, $block, $blockCaption, form, formClean, $list, fChecker;
    var $tabs, tabsContent = {}; 
    
    $(function(){
        form = document.forms.afishaCatFormNew;
        
        fChecker = new bff.formChecker(form);
        formClean = $(form).html();
        
        $progress = $('#progress-afisha-cats');
        $block = $('#afishaCatFormBlock');
        $blockCaption = $block.find('span.caption'); 
        $list = $('#afisha-cats-table');
        $tabs = $('#afisha-cats-tabs'); 
        tabsContent = {
            'new': $('#afisha-cats-tabs-new'), 
            'inherit': $('#afisha-cats-tabs-inherit')
        };
        
        $list.on('click', 'a.cat-edit', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) edit( id );
            return false;
        });
        $list.on('click', 'a.cat-toggle', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) {
                bff.ajaxToggle(id, afishaListURL+'toggle&type='+afishaTypeID, {progress: $progress, link: this});
            }
            return false;
        });        
        $list.on('click', 'a.cat-del', function(){
            var id = intval($(this).attr('rel'));
            if(id>0) del( id, this, $(this).hasClass('inherited') );
            return false;
        });
        
        bff.rotateTable('#afisha-cats-table', afishaListURL+'rotate&type='+afishaTypeID, $progress);
    });

    function toggle(type, editData)
    {                                           
        switch(type) {
            case 'add': {
                if($block.is(':hidden')) {
                    $block.show();
                    $(form).html(formClean);
                    $blockCaption.html('Добавить раздел');
                    if(afishaCatInherits) $tabs.show();
                    $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                } else {
                    $block.hide();   
                }
            } break; 
            case 'cancel': {
                $block.hide();
            } break;
            case 'edit': {                           
                $tabs.hide();
                $blockCaption.html(editData.caption);
                $(form).html(editData.form);
                $block.show();
                $.scrollTo( $blockCaption, { duration:500, offset:-300 } );
                form.elements['act'].value = 'edit-finish';
                form.elements['filter'].value = afishaListFilter;
            } break;
        }
        fChecker.check(true, true);
        return false;
    }
    
    function del(id, link, unInherit)
    {
        if(unInherit)
        {
            bff.ajaxDelete('Открепить раздел?', id, 
                afishaListURL+'uninherit&cat_id='+id+'&type='+afishaTypeID, 
                link, {progress: $progress, repaint: false});
        } else {
            bff.ajaxDelete('Удалить раздел?', id, 
                afishaListURL+'delete&cat_id='+id+'&type='+afishaTypeID, 
                link, {progress: $progress, repaint: false});
        }
        return false;
    }
    
    function edit(id)
    {                          
        bff.ajax(afishaListURL+'edit&cat_id='+id+'&type='+afishaTypeID,{},function(data){
            if(data) {
                toggle('edit', $.extend({caption: 'Редактирование раздела'}, data) );
            }                  
        }, $progress);
        return false;
    }
                              
    var inheritInited = false;
    function onTab(tabKey, tabLink)
    {
        for(var i in tabsContent) {
            tabsContent[i].hide();
        }
        bff.onTab(tabLink);
        
        if(tabKey == 'inherit' && !inheritInited)
        {
            bff.ajax(afishaListURL+'get-inherit&type='+afishaTypeID, {}, function(data){
                if(data)
                {
                    var $tab = tabsContent[tabKey];
                    $tab.find(':input[name="inherit"]').html( data.opts );
                    $tab.show();
                    inheritInited = true;
                }
            }, $progress);
        } else {
            tabsContent[tabKey].show();
        }
    }
    
    return {
        toggle: toggle, onTab: onTab,
        onType: function(sel) {
            <? if($menu_mini): ?>
            bff.redirect('<?= $this->adminLink('categories&type=') ?>' + intval(sel) );
            <? else: ?>
            bff.redirect('<?= $this->adminLink('') ?>'+(sel==0 ? '' : sel+':')+'categories' );
            <? endif; ?>
        }
    };
}());
</script>