<?php

use bff\utils\Files;

class AfishaVideo extends Component
{
    var $itemID = 0;
    var $itemData = array();
    var $typeID = 0;
    var $tableItems = '';

    /** @var AfishaSettings object */
    var $typeSettings = array();
    /** @var Afisha object */
    var $oAfisha = null;

    protected $maxSize = 52428800; # 50мб
    var $blockWidth = 470;

    const typeNone = 0;
    const typeCode = 1;
    const typeFile = 2;

    public function __construct(AfishaSettings $oTypeSettings, array $mItemData)
    {
        $this->init();

        $this->itemID = $mItemData['id'];
        $this->itemData = $mItemData;

        $this->typeID = $oTypeSettings->id;
        $this->typeSettings = $oTypeSettings;
        $this->tableItems = $oTypeSettings->tableName();

        $this->oAfisha = Afisha::i();
    }

    function processData($bEdit)
    {
        if (!$this->typeSettings->videoEnabled()) {
            return false;
        }

        $aData = $this->input->post('video', TYPE_ARRAY);
        $this->input->clean_array($aData, array(
                'type'       => TYPE_UINT,
                'code_url'   => TYPE_STR,
                'code_src'   => TYPE_STR,
                'code_valid' => TYPE_BOOL,
                'code_type'  => TYPE_STR,
                'file'       => TYPE_STR,
                'frame'      => TYPE_STR,
                'frame_time' => TYPE_NOTAGS,
            )
        );

        $status = $aData['type'];
        if (!in_array($status, array(self::typeNone, self::typeCode, self::typeFile))) {
            $status = self::typeNone;
        }

        if (empty($aData['file']) && $status = self::typeFile) {
            $status = self::typeNone;
        }

        # загружаем видео, если необходимо
        if (!empty($_FILES['video_file'])) {
            $aResult = $this->uploadQQ('video_file', $bEdit, $aData['frame_time'], false);
            if ($aResult !== false) {
                $aData = array_merge($aData, $aResult);
                if ($status == self::typeNone) {
                    $status = self::typeFile;
                }
            }
        }

        # проверяем флаг валидности видео кода "code_valid"
        if (empty($aData['code_url']) || empty($aData['code_src']) || empty($aData['code_type']) || !$aData['code_valid']) {
            $aData['code_valid'] = 0;
            if ($status == self::typeCode) {
                $status = self::typeNone;
            }
        }

        if ($status == self::typeNone) {
            if ($aData['code_valid']) {
                $status = self::typeCode;
            } elseif (!empty($aData['file'])) {
                $status = self::typeFile;
            }
        }

        return $this->updateVideoData($aData, $status, false);
    }

    function updateVideoData($aData, $nStatus = false, $mergeCurrentVideoData = false)
    {
        if ($nStatus !== false) {
            $aData['type'] = $nStatus;
        }

        if ($mergeCurrentVideoData !== false) {
            if (is_array($mergeCurrentVideoData)) {
                $aDataCur = $mergeCurrentVideoData;
            } else {
                $aDataCur = $this->getVideoData();
            }
            if (!empty($aDataCur)) {
                $aData = array_merge($aDataCur, $aData);
            }
        }

        $aUpdate = array(
            'video_data' => serialize($aData),
        );
        if ($nStatus !== false) {
            $aUpdate['video'] = $nStatus;
        }

        return $this->db->update($this->tableItems, $aUpdate, array('id'=>$this->itemID));
    }

    function getVideoData()
    {
        $aDataCur = $this->db->one_data('SELECT video_data FROM ' . $this->tableItems . ' WHERE id = ' . $this->itemID);
        $aDataCur = unserialize($aDataCur);

        return (!empty($aDataCur) ? $aDataCur : array());
    }

    /**
     * Загрузка файла при помощи qqFileUploader
     * @param string $sFieldName имя FILE поля
     * @param bool $bDeletePrev удалить предыдущий видео файл
     * @param string $sFrameTime время для фрейма, формат: HH:MM:SS
     * @param bool $qq выполнять загрузку
     * @return array|bool
     */
    function uploadQQ($sFieldName = 'video_file', $bDeletePrev = true, $sFrameTime = '00:00:00', $qq = false)
    {
        if ($this->itemID <= 0) {
            return false;
        }

        $allowedExtensions = array('flv', 'mp4', 'mpeg4');
        $sFilename = func::generator(8, true);

        do {
            if ($qq) {
                include PATH_CORE . 'external/qquploader.php';

                $oUploadQQ = new qqFileUploader($allowedExtensions, $this->maxSize);
                $sExtension = $oUploadQQ->getFilenameExtension();

                # генерируем имя файла
                $sFilename = $sFilename . '.' . $sExtension;
                $sFilepath = $this->buildPath($sFilename, false);

                if ($oUploadQQ->upload($sFilepath) !== true) {
                    break;
                }

            } else {

                if (empty($_FILES[$sFieldName]) || $_FILES[$sFieldName]['error'] == UPLOAD_ERR_NO_FILE) {
                    break;
                }

                $oUpload = new CUploader($sFieldName, false);
                if (!$this->errors->no()) {
                    break;
                }

                $sFilenameTmp = $oUpload->getFilenameUploaded();
                # проверяем размер файла
                if (!$oUpload->checkSize($this->maxSize)) {
                    $this->errors->setUploadError(Errors::FILE_MAX_SIZE);
                    break;
                }

                # проверяем тип файла
                $sExtension = Files::getExtension($oUpload->getFilename());
                if (!in_array($sExtension, $allowedExtensions)) {
                    $this->errors->setUploadError(Errors::FILE_WRONG_TYPE);
                    break;
                }

                # генерируем имя файла
                $sFilename = $sFilename . '.' . $sExtension;
                $sFilepath = $this->buildPath($sFilename, false);

                # сохраняем файл
                if (!move_uploaded_file($sFilenameTmp, $sFilepath)) {
                    break;
                }
            }

            if ($bDeletePrev) {
                $this->delete(false);
            }

            if (extension_loaded('ffmpeg')) {
                $ffmpeg = new \ffmpeg_movie($sFilepath, false);
                $width = $ffmpeg->getFrameWidth();
                $height = $ffmpeg->getFrameHeight();
                $heightProp = round($height * ((($this->blockWidth * 100) / $width) / 100));
                $frameFilename = $this->makeVideoFrame($sFilepath, $this->blockWidth, $heightProp, $sFrameTime);
            } else {
                $heightProp = 360;
                $frameFilename = '';
            }

            return array('file'       => $sFilename,
                         'height'     => $heightProp,
                         'frame'      => $frameFilename,
                         'frame_time' => $sFrameTime
            );

        } while (false);

        return false;
    }

    function makeVideoFrame($sVideoFilepath, $nWidth, $nHeight, $sTime = '00:00:00')
    {
        $sFrameFilename = func::generator(8) . '.jpg';
        $sFrameFilepath = $this->buildFramePath($sFrameFilename, false);

        if (false) //extension_loaded('imagick'))
        {
            $nTime = 0;
            if (!empty($sTime) && $sTime != '00:00:00' && strpos($sTime, ':') !== false) {
                list($h, $m, $s) = array_map('intval', explode(':', $sTime));
                $nTime = ($h > 0 ? $h * 60 * 60 : 0) + ($m > 0 ? $m * 60 : 0) + ($s > 0 ? $s : 0);
            }

            try {
                $im = new \Imagick();
                $im->newPseudoImage($nHeight, $nWidth, 'ffmpeg:' . $sVideoFilepath . '[' . $nTime . ']');
                $im->cropThumbnailImage($nWidth, $nHeight);
                $im->setFormat('JPG');
                $im->setCompressionQuality(85);
                $im->writeImage($sFrameFilepath);
            } catch (\Exception $e) {
                $this->errors->set($e->getMessage());
                $sFrameFilename = '';
            }
        } else {
            exec('ffmpeg -i ' . $sVideoFilepath . ' -an -ss ' . $sTime . ' -r 1 -vframes 1 -s ' . $nWidth . 'x' . $nHeight . ' -y -f mjpeg ' . $sFrameFilepath);
        }

        return $sFrameFilename;
    }

    function validate_code($sCode)
    {
        $aResult = array('correct' => true);
        do {
            if (empty($sCode)) {
                $aResult['correct'] = false;
                break;
            }

            # vkontakte
            //<iframe src="http://vkontakte.ru/video_ext.php?oid=4566296&id=160374244&hash=1d5c4f9eeaaabb37&hd=1" width="607" height="360" frameborder="0"></iframe>
            preg_match('/<iframe\ssrc=\"https?:\/\/(?:[a-zA_Z]{2,3}.)?(vk\.com|vkontakte\.ru)\/video\_ext\.php\?([^"]+)\"(.*)><\/iframe>/iu', $sCode, $res);
            if ($res) {
                $aResult['type'] = 'vk';
                $aResult['url'] = $res[2];
                break;
            } else {
                # youtube, vimeo, rutube
                $parser = new \bff\utils\VideoParser();
                $res = $parser->embed($sCode);
                if (!empty($res['flash_url'])) {
                    $aResult['type'] = $res['provider_name'];
                    $aResult['url'] = $res['flash_url'];
                    break;
                }
            }

            $aResult['correct'] = false;
        } while (false);

        return $aResult;
    }

    function show_video_block($videoType, $videoData)
    {
        if ($videoType == self::typeNone || empty($videoData)) {
            return '';
        }

        $video = unserialize($videoData);
        if (empty($video)) {
            return '';
        }

        $width = $this->blockWidth;
        $height = 280;

        if ($videoType == self::typeCode) {
            $url = $video['code_url'];
            if ($video['code_type'] == 'vk') {
                return '<div class="video"><iframe src="http://vkontakte.ru/video_ext.php?' . $url . '" width="' . $width . '" height="' . $height . '" frameborder="0"></iframe></div>';
            } else {
                return '<div class="video"><object width="' . $width . '" height="' . $height . '">
                                <param name="allowfullscreen" value="true" />
                                <param name="allowscriptaccess" value="always" />
                                <param name="wmode" value="transparent" />
                                <param name="movie" value="' . $url . '" />
                                <embed src="' . $url . '" type="application/x-shockwave-flash" allowfullscreen="true" allowscriptaccess="always" wmode="transparent" width="' . $width . '" height="' . $height . '"></embed>
                            </object></div>';
            }
        } elseif ($videoType == self::typeFile) {
            //$height = ( ! empty($video['height']) ? $video['height'] : false);
            $height = 260;

            tpl::includeJS('jwplayer/jwplayer', false);

            return '<div class="video" id="afishaMovieVideo"></div>
                    <script type="text/javascript"> jwplayer("afishaMovieVideo").setup({ 
                        flashplayer: "/js/jwplayer/player.swf", 
                        file: "' . $this->buildPath($video['file'], true) . '",
                        ' . (!empty($video['frame']) ? 'image:"' . $this->buildFramePath($video['frame'], true) . '",' : '') . '
                        skin: "/js/jwplayer/skins/beelden.zip",
                        width: ' . $width . ', ' . ($height !== false ? 'height: ' . $height . ', ' : '') . '
                        logo: {file: "/img/logo.png", position: "top-right", timeout:10},
                        stretching: "uniform" }); </script>';
        }
    }

    function delete($bDoQuery = false)
    {
        if (!$this->itemID) {
            return false;
        }

        $aData = $this->db->one_array('SELECT video, video_data FROM ' . $this->tableItems . ' WHERE id = ' . $this->itemID);
        if (empty($aData) || empty($aData['video_data'])) {
            return false;
        }

        $aVideoData = unserialize($aData['video_data']);
        if (empty($aVideoData)) {
            return false;
        }

        $deleted = 0;
        $statusNew = false;
        if (!empty($aVideoData['file'])) {
            $this->deleteFiles($aVideoData['file'], false);
            $aVideoData['file'] = '';
            if ($aData['video'] == self::typeFile) {
                $statusNew = self::typeNone;
            }
            $deleted++;
        }
        if (!empty($aVideoData['frame'])) {
            $this->deleteFiles($aVideoData['frame'], true);
            $aVideoData['frame'] = '';
            $aVideoData['frame_time'] = '00:00:00';
            $deleted++;
        }

        if ($deleted > 0 && $bDoQuery) {
            $this->updateVideoData($aVideoData, $statusNew, $aVideoData);
        }

        return ($deleted > 0);
    }

    function deleteFiles($sFilename, $bFrame = false)
    {
        if (empty($sFilename)) {
            return false;
        }

        if (is_array($sFilename)) {
            foreach ($sFilename as $file) {
                $this->deleteFiles($file, $bFrame);
            }

            return;
        }

        $sFilepath = ($bFrame ? $this->buildFramePath($sFilename, false) : $this->buildPath($sFilename, false));
        if (file_exists($sFilepath)) {
            unlink($sFilepath);
        }
    }

    function buildPath($sFilename = false, $bURL = false)
    {
        $aItemData = $this->itemData;
        $aItemData['filename'] = $sFilename;

        return $this->oAfisha->getVideoPath($bURL, $aItemData, $this->typeSettings);
    }

    function buildFramePath($sFilename = false, $bURL = false)
    {
        $aItemData = $this->itemData;
        $aItemData['filename'] = $sFilename;

        return $this->oAfisha->getVideoFramePath($bURL, $aItemData, $this->typeSettings);
    }

    function getMaxSize()
    {
        return $this->maxSize;
    }
}