<?php

class AfishaModel extends Model
{
    /** @var AfishaBase */
    var $controller;

    var $langTypes = array(
        'title'        => TYPE_STR, # название
    );

    var $langItems = array(
        'title'          => TYPE_STR,    # заголовок
        'title_alt'      => TYPE_NOTAGS, # подпись для изображений
        'author'         => TYPE_NOTAGS, # имя автора
        'img_text'       => TYPE_STR,    # подпись к изображению
        'content_short'  => TYPE_STR,    # краткое описание
        'content'        => TYPE_STR,    # описание
        'content_search' => TYPE_STR,    # Publicator-поиск
        'mtitle'         => TYPE_NOTAGS, # meta-title
        'mkeywords'      => TYPE_NOTAGS, # meta-keywords
        'mdescription'   => TYPE_NOTAGS, # meta-description
        'share_title'    => TYPE_NOTAGS, # meta-share-title
        'share_description' => TYPE_NOTAGS, # meta-share-description
        'share_sitename'    => TYPE_NOTAGS, # meta-share-sitename
    );

    var $langCategories = array(
        'title'        => TYPE_NOTAGS,  # название
        'mtitle'       => TYPE_NOTAGS,  # meta-title
        'mkeywords'    => TYPE_NOTAGS,  # meta-keywords
        'mdescription' => TYPE_NOTAGS,  # meta-description
    );

    /**
     * Сохранение события
     * @param integer $nItemID ID
     * @param array $aData данные
     * @param integer $nTypeID ID типа или 0 (текущий)
     * @return bool|int
     */
    function itemSave($nItemID, array $aData, $nTypeID = 0)
    {
        if (empty($aData)) return false;

        $aData['modified'] = $this->db->now();
        $aData['modified_uid'] = User::id();

        if ($nItemID > 0)
        {
            $res = $this->db->update($this->itemsTable($nTypeID), array_diff_key($aData, $this->langItems), array('id'=>$nItemID));
            if ($res) {
                $this->db->langUpdate(array('id' => $nItemID, 'type_id' => $this->itemsType($nTypeID)), $aData, $this->langItems, TABLE_AFISHA_ITEMS_LANG);
            }
            return $res;
        } else {
            $aData['created'] = $this->db->now();
            $nItemID = $this->db->insert($this->itemsTable($nTypeID), array_diff_key($aData, $this->langItems));
            if ($nItemID) {
                $this->db->langInsert(array('id' => $nItemID, 'type_id' => $this->itemsType($nTypeID)), $aData, $this->langItems, TABLE_AFISHA_ITEMS_LANG);
            }
            return $nItemID;
        }
    }

    /**
     * Данные о событии по ID
     * @param integer $nItemID ID записи
     * @param array $aFields список полей
     * @param integer $nTypeID ID типа или 0 (текущий)
     * @return mixed
     */
    public function itemData($nItemID, array $aFields = array(), $nTypeID = 0)
    {
        return $this->itemDataByFilter(array('id'=>$nItemID), $aFields, $nTypeID);
    }

    /**
     * Накручиваем счетчик просмотров
     * @param integer $nItemID ID записи
     * @param integer $nTypeID ID типа или 0 (текущий)
     */
    public function itemViewsUpdate($nItemID, $nTypeID = 0)
    {
        return $this->db->update($this->itemsTable($nTypeID), array('views = views + 1'), array('id'=>$nItemID));
    }

    /**
     * Данные о записи по фильтру
     * @param array $aFilter фильтр
     * @param array $aFields список полей
     * @param integer $nTypeID ID типа или 0 (текущий)
     * @return mixed
     */
    public function itemDataByFilter(array $aFilter = array(), array $aFields = array('*'), $nTypeID = 0)
    {
        $aFilter = $this->prepareFilter($aFilter, 'I');

        if (empty($aFields)) {
            $aFields = array('I.*');
        }

        $aData = $this->db->one_array('SELECT I.' . join(', I.', $aFields) . '
               FROM ' . $this->itemsTable($nTypeID) . ' I
               ' . $aFilter['where'] . '
               LIMIT 1', $aFilter['bind']
        );
        if (empty($aData)) $aData = array();

        return $aData;
    }

    /**
     * Перестраивание ссылок во всех записях
     */
    public function itemsLinksRebuild()
    {
        $controller = $this->controller;
        $typesData = $controller->getTypes();
        foreach ($typesData as $typeKey=>$v) {
            $typeID = $controller->getTypeIDByKeyword($typeKey);
            $controller->type = $controller->getTypeSettings($typeID);
            $this->db->select_rows_chunked($this->itemsTable($typeID), array('id','category_id','city_id','title_params'),
                                           array(),'id',array(), function ($items) use ($typeID, $controller) {
                foreach ($items as $v) {
                    $title_params = func::unserialize($v['title_params']);
                    if (!isset($title_params['title'])) continue;
                    $v['title'] = $title_params['title'];
                    $v['link']  = $title_params['link'];
                    if ($controller->prepareItemTitle($v['id'], $v)) {
                        $controller->model->itemSave($v['id'], array(
                                'link'  => $v['link'],
                                'title' => $v['title'],
                            ), $typeID
                        );
                    }
                }
            }, 50);
        }
    }

    /**
     * Название таблицы записей типа
     * @param int $typeID ID типа или 0 (текущий тип)
     * @return string
     */
    public function itemsTable($typeID = 0)
    {
        if (empty($typeID) || $typeID < 0) {
            return $this->controller->type->tableName();
        } else {
            return $this->controller->getTypeSettings($typeID)->tableName();
        }
    }

    /**
     * ID типа
     * @param int $typeID или 0 (ID текущего)
     * @return int
     */
    public function itemsType($typeID = 0)
    {
        if (empty($typeID) || $typeID < 0) {
            return $this->controller->type->id;
        } else {
            return $typeID;
        }
    }

    /**
     * Формирование "AND связки" с языковой таблицей
     * @param integer $nTypeID ID типа
     * @param boolean $bAnd добавлять "AND"
     * @param string $sTablePrefix префикс таблицы с которой связываем
     * @param string $sLangPrefix префикс языковой таблицы
     * @param mixed $sLang keyword языка или FALSE (текущий)
     * @return string
     */
    public function langAnd($nTypeID, $bAnd = true, $sTablePrefix = 'I', $sLangPrefix = 'L', $sLang = false)
    {
        return ($bAnd ? ' AND ' : '').$sTablePrefix.'.id = '.$sLangPrefix.'.id AND '.$sLangPrefix.'.lang = '.$this->db->str2sql( ($sLang===false ? LNG : $sLang) ).' AND '.$sLangPrefix.'.type_id = '.$this->db->str2sql($nTypeID);
    }

    function getLocaleTables()
    {
        return array(
            TABLE_AFISHA_TYPES => array('type'=>'fields','fields'=>$this->langTypes),
            TABLE_AFISHA_DYNPROPS => array('type'=>'fields','fields'=>array('title'=>TYPE_NOTAGS, 'description' => TYPE_NOTAGS)),
            TABLE_AFISHA_DYNPROPS_MULTI => array('type'=>'fields','fields'=>array('name'=>TYPE_NOTAGS)),
            TABLE_AFISHA_CATEGORIES => array('type'=>'table','fields'=>$this->langCategories),
        );
    }

}