<?php

class AfishaComments extends bff\db\Comments
{
    /** @var string ключ типа публикации */
    protected $typeKeyword = '';

    function initSettings()
    {
        $this->tblComments = TABLE_AFISHA_COMMENTS;
        $this->tblItemsID  = 'id';
        $this->tblCommentsGroupID = 'type_id';
        # config-ключ для хранения общего счетчика непромодерированных комментариев
        $this->counterKey_UnmoderatedAll = 'afisha_comments_mod_';
        # имя поля в таблице объявлений - для хранения кол-ва комментариев объявления(видимых пользователю)
        $this->counterKey_ItemComments = 'comments';
        $this->commentHideReasons[self::commentDeletedByModerator]    = _t('afisha', 'Комментарий был удален модератором');
        $this->commentHideReasons[self::commentDeletedByCommentOwner] = _t('afisha', 'Комментарий был удален автором комментария');
        $this->commentHideReasons[self::commentDeletedByItemOwner]    = _t('afisha', 'Комментарий был удален автором публикации');
        $this->commentHideReasons[self::commentFromBlockedUser]       = _t('afisha', 'Комментарий от заблокированного пользователя');
    }

    public function setGroupID($nGroupID = 0)
    {
        $this->groupID = intval($nGroupID);

        /* @var $aSettings AfishaSettings */
        $aSettings = Afisha::i()->getTypeSettings($nGroupID);

        $this->tblItems = $aSettings->tableName();
        $this->typeKeyword = $aSettings->keyword;

        $this->commentsTree = $aSettings->commentsTree();
        $this->commentsTree2Levels = $aSettings->commentsTree2Levels();
        $this->preModeration = $aSettings->commentsModeratePre();

        $this->urlListing = $this->adminLink($this->typeKeyword.':comments&item_id=', 'afisha');
        $this->urlListingAjax = $this->adminLink('comments_ajax', 'afisha');
    }

    public function updateUnmoderatedAllCounter($mIncrement = false)
    {
        $sKey = $this->counterKey_UnmoderatedAll;
        $this->counterKey_UnmoderatedAll = $sKey.'all';
        parent::updateUnmoderatedAllCounter($mIncrement);
        $this->counterKey_UnmoderatedAll = $sKey.$this->typeKeyword;
        parent::updateUnmoderatedAllCounter($mIncrement);
        $this->counterKey_UnmoderatedAll = $sKey;
    }

    public function counterPrefix()
    {
        return $this->counterKey_UnmoderatedAll;
    }

    /**
     * Получение данных обо всех комментариях к записи
     * - в случае с frontend'ом и включенной preModeration: исключаем непромодерированные
     * @param integer $nItemID ID записи
     * @param integer $nCommentLastID ID комментария, с которого следует начать выборку
     * @param boolean $bSimpleTree простое дерево (выполняем только transformRowsToTree)
     * @return array
     */
    public function commentsDataFront($nItemID, $nCommentLastID = 0, $bSimpleTree = false)
    {
        $sql = array();
        $bind = array(':itemID'=>$nItemID);
        if ( $nCommentLastID > 0 ) {
            $sql[] = 'C.id > :lastID';
            $bind[':lastID'] = $nCommentLastID;
        }
        # в случае с frontend'ом и включенной preModeration: исключаем непромодерированные
        if ( ! bff::adminPanel() ) {
            if ( $this->preModeration ) {
                $sql[] = 'C.moderated = 1';
            }
        }
        # учитываем ID группы
        if ( $this->isGroupUsed() ) {
            $sql[] = 'C.'.$this->tblCommentsGroupID.' = :groupID';
            $bind[':groupID'] = $this->groupID;
        }
        $aData = $this->db->select('SELECT C.*, U.name as uname, U.blocked as ublocked, U.login, U.avatar, U.sex, U.surname
                FROM '.$this->tblComments.' C
                    LEFT JOIN '.TABLE_USERS.' U ON C.user_id = U.user_id
                WHERE C.item_id = :itemID'.( ! empty($sql) ? ' AND '.join(' AND ', $sql) : ' ' ).'
                ORDER BY C.id ASC', $bind);

        if ( ! empty($aData) ) {
            foreach ($aData as $k=>$v) {
                if ($v['ublocked'] && ! $v['deleted']) {
                    $aData[$k]['deleted'] = self::commentFromBlockedUser;
                }
            }
            if ($bSimpleTree) {
                return array(
                    'total' => sizeof($aData),
                    'aComments' => $this->db->transformRowsToTree($aData, 'id', 'pid', 'sub'),
                );
            }
            return $this->buildCommentsRecursive($aData);
        }
        return array('aComments'=>array(), 'nMaxIdComment'=>0, 'total'=>0);
    }

}