<?php

require_once PATH_CORE.'utils/sitemap.php';

$oDb = \bff::database();

/**
 * Директории для сохранения xml файлов
 */
$sitemapPath = PATH_PUBLIC.'seo'.DS; # xml файлы модулей
$sitemapPathIndex = PATH_PUBLIC; # основной sitemap.xml

/**
 * Список модулей, для которых необходимо выполнить формирование XML файлов
 * @param 'module' - название модуля в системе
 */
$sitemapModules = array(
    'news'   => array('module'=>'publications'), # новости
    'afisha' => array('module'=>'afisha'), # афиша
    'board'  => array('module'=>'bbs'), # доска объявлений (общая)
    'auto'   => array('module'=>'auto'), # авто
    'realty' => array('module'=>'realty'), # недвижимость
    'map'    => array('module'=>'items'), # справочник
    'job-vacancy'=> array('module'=>'job'), # работа: вакансии
    'job-resume' => array('module'=>'job'), # работа: резюме
);

$sitemap = new CSitemapXML();
$sitemapIndexData = array();
foreach($sitemapModules as $key=>$sett)
{
    if( ! bff::moduleExists($sett['module']) ) continue;
    $module = bff::module($sett['module']);
    $subdomain = bff::subdomainsEnabled($sett['module']);

    switch($key)
    {
    # -----------------------------------------------------------------------------------
    case 'news': # новости
    {
        # страницы новостей
        $sql = array();
        $aTypes = Publications::i()->getTypes();
        if (empty($aTypes)) break;
        foreach ($aTypes as $type) {
            $sql[] = '(SELECT link as l, DATE(modified) as m
                FROM '.$type->table().'
                WHERE enabled = 1 AND moderated = 1 ORDER BY created DESC)';
        }

        $aItems = $oDb->select(join(' UNION ', $sql));
        foreach ($aItems as &$v) {
            $v['l'] = Publications::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', PATH_PUBLIC, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'afisha': # афиша
    {
        # страницы событий
        $sql = array();
        $aTypes = Afisha::i()->getTypes();
        if (empty($aTypes)) break;
        foreach ($aTypes as $type) {
            $sql[] = '(SELECT link as l, DATE(modified) as m, '.$type->id.' as type
                FROM '.$type->tableName().'
                WHERE enabled = 1 AND moderated = 1 ORDER BY created DESC)';
        }

        $aItems = $oDb->select(join(' UNION ', $sql));
        foreach ($aItems as &$v) {
            $v['l'] = Afisha::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'board': # доска объявлений
    {
        # страницы объявлений
        $aItems = $oDb->select('
            SELECT link as l, DATE(modified) as m FROM '.TABLE_BBS_ITEMS.'
            WHERE status = '.BBS::STATUS_PUBLICATED.' AND deleted = 0 ORDER BY created DESC
        ');
        foreach($aItems as &$v) {
            $v['l'] = BBS::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'auto': # авто
    {
        # страницы объявлений
        $aItems = $oDb->select('
            SELECT link as l, DATE(modified) as m FROM '.TABLE_AUTO_ITEMS.'
            WHERE status = '.Auto::STATUS_PUBLICATED.' AND moderated > 0 ORDER BY created DESC
        ');
        foreach ($aItems as &$v) {
            $v['l'] = Auto::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'realty': # недвижимость
    {
        # страницы объявлений
        $aItems = $oDb->select('
            SELECT link as l, DATE(modified) as m FROM '.TABLE_REALTY_ITEMS.'
            WHERE status = '.Realty::STATUS_PUBLICATED.' AND moderated > 0 ORDER BY created DESC
        ');
        foreach ($aItems as &$v) {
            $v['l'] = Realty::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'map': # справочник
    {
        # страницы объектов
        $aItems = $oDb->select('
            SELECT id, link as l, DATE(modified) as m FROM '.TABLE_ITEMS.'
            WHERE enabled = 1 AND moderated!=0 ORDER BY created DESC
        ');
        foreach ($aItems as &$v) {
            $v['l'] = Items::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items', $sitemapPath.$key.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = $key.'/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'job-vacancy': # работа - вакансии
    {
        $aItems = $oDb->select('
            SELECT link as l, DATE(modified) as m
            FROM '.TABLE_JOB_VACANCY.'
            WHERE moderated > 0 AND status = '.Job::STATUS_PUBLICATED.' ORDER BY created DESC
        ');
        foreach ($aItems as &$v) {
            $v['l'] = Job::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items_vacancy', $sitemapPath.'job'.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items_vacancy', $sitemapPath.'job'.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = 'job/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    # -----------------------------------------------------------------------------------
    case 'job-resume': # работа - резюме
    {
        $aItems = $oDb->select('
            SELECT link as l, DATE(modified) as m
            FROM '.TABLE_JOB_RESUME.'
            WHERE moderated > 0 AND status = '.Job::STATUS_PUBLICATED.' ORDER BY created DESC
        ');
        foreach($aItems as &$v) {
            $v['l'] = Job::url('view', $v['l']);
        } unset($v);

        if ($subdomain) {
            $sitemap->build($aItems, 'sitemap_items_resume', $sitemapPath.'job'.DS, SITEURL);
        } else {
            $res = $sitemap->build($aItems, 'sitemap_items_resume', $sitemapPath.'job'.DS, SITEURL);
            if( ! empty($res) ) { $res['url'] = 'job/'; $sitemapIndexData[] = $res; }
        }
        unset($aItems);
    } break;
    } # switch:end
}

# -----------------------------------------------------------------------------------
# результирующий sitemap.xml (sitemap-index)
if( ! empty($sitemapIndexData) ) {
    $sitemap->buildIndex($sitemapIndexData, $sitemapPathIndex.'sitemap.xml', SITEURL.'/xml');
}